/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.model.complexobj.paging;

import java.io.Serializable;
import kd.hr.hbp.common.model.complexobj.paging.AlgoXPagingConstants;

public class Partition
implements AlgoXPagingConstants,
Serializable {
    private static final long serialVersionUID = 7777744980229827315L;
    private String entityNumber;
    private String entityAlias;
    private int mainEntityStart = -1;
    private int mainLimit = -1;
    private Integer dataCount;
    private boolean isMainEnd;

    public Partition() {
    }

    public Partition(String entityNumber, String entityAlias, int mainEntityStart, int mainLimit) {
        this.entityNumber = entityNumber;
        this.entityAlias = entityAlias;
        this.mainEntityStart = mainEntityStart;
        this.mainLimit = mainLimit;
    }

    public Integer getDataCount() {
        return this.dataCount;
    }

    public void setDataCount(Integer dataCount) {
        this.dataCount = dataCount;
    }

    public void setMainEntityStart(int mainEntityStart) {
        this.mainEntityStart = mainEntityStart;
    }

    public void setMainLimit(int mainLimit) {
        this.mainLimit = mainLimit;
    }

    public int getMainEntityStart() {
        return this.mainEntityStart;
    }

    public int getMainLimit() {
        return this.mainLimit;
    }

    public int getEntityStart(String entityAlias) {
        if (this.entityAlias.equals(entityAlias)) {
            return this.mainEntityStart;
        }
        return -1;
    }

    public int getEntityLimit(String entityAlias) {
        if (this.entityAlias.equals(entityAlias)) {
            return this.mainLimit;
        }
        return -1;
    }

    public boolean isMainEnd() {
        return this.isMainEnd;
    }

    public void setMainEnd(boolean mainEnd) {
        this.isMainEnd = mainEnd;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(String entityAlias) {
        this.entityAlias = entityAlias;
    }

    public Partition createNextPartition(int limit) {
        return new Partition(this.entityNumber, this.entityAlias, this.mainEntityStart + this.mainLimit, limit);
    }

    public String getUniqueKey() {
        return this.entityAlias + "_" + this.mainEntityStart + "_" + this.mainLimit;
    }

    public String toString() {
        return "Partition{entityNumber='" + this.entityNumber + '\'' + ", entityAlias='" + this.entityAlias + '\'' + ", mainEntityStart=" + this.mainEntityStart + ", mainLimit=" + this.mainLimit + ", dataCount=" + this.dataCount + ", isMainEnd=" + this.isMainEnd + '}';
    }
}

