/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.function.Supplier;

public class Conditional {
    private Supplier<Boolean> condition;
    private String option;
    private Boolean notFlag;
    private Conditional next;
    private Conditional in;
    private Conditional tail;

    public static Conditional getNew(Supplier<Boolean> condition) {
        return new Conditional(condition);
    }

    private Conditional(Supplier<Boolean> condition) {
        this.condition = condition;
        this.tail = this;
        this.notFlag = false;
    }

    private Conditional(String option, Supplier<Boolean> condition) {
        this.option = option;
        this.condition = condition;
        this.notFlag = false;
    }

    public Conditional or(Supplier<Boolean> condition) {
        this.tail = this.tail.next = new Conditional("or", condition);
        return this;
    }

    public Conditional or(Conditional conditional) {
        this.tail.in = conditional;
        this.tail.in.option = "or";
        return this;
    }

    public Conditional and(Supplier<Boolean> condition) {
        this.tail = this.tail.next = new Conditional("and", condition);
        return this;
    }

    public Conditional and(Conditional conditional) {
        this.tail.in = conditional;
        this.tail.in.option = "and";
        return this;
    }

    public Conditional not() {
        this.tail.notFlag = true;
        return this;
    }

    public Conditional notAll() {
        this.tail = this.tail.next = new Conditional("not", this.condition);
        return this;
    }

    public boolean getValue() {
        boolean currentResult = this.condition.get();
        if (this.notFlag.booleanValue()) {
            boolean bl = currentResult = !currentResult;
        }
        if (this.in != null) {
            boolean inResult = this.in.getValue();
            currentResult = this.doOption(currentResult, this.in.option, inResult);
        }
        Conditional nextCon = this.next;
        while (nextCon != null) {
            if (nextCon.option.equals("not")) {
                currentResult = !currentResult;
            } else if (currentResult && nextCon.option.equals("and")) {
                currentResult = nextCon.getValue();
            } else if (!currentResult && nextCon.option.equals("or")) {
                currentResult = nextCon.getValue();
            }
            nextCon = nextCon.next;
        }
        return currentResult;
    }

    private boolean doOption(boolean resultA, String option, boolean resultB) {
        return option.equals("and") ? resultA && resultB : resultA || resultB;
    }
}

