/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DatePattern {
    YYYY("yyyy"),
    YYYY_MM("yyyy-MM"),
    YY_MM("yy-MM"),
    YY_MM_DD("yy-MM-dd"),
    YYYY_MM_DD("yyyy-MM-dd"),
    YYYY_MM_DD_HH_MM("yyyy-MM-dd HH:mm"),
    YY_MM_DD_HH_MM_SS("yy-MM-dd HH:mm:ss"),
    YYYY_MM_DD_HH_MM_SS("yyyy-MM-dd HH:mm:ss"),
    YY_MM_DD_HH_MM_MS("yy-MM-dd HH:mm:ss.SSS"),
    YYYY_MM_DD_HH_MM_MS("yyyy-MM-dd HH:mm:ss.SSS"),
    YYYY_MM_EN("yyyy/MM"),
    YYYY_MM_DD_EN("yyyy/MM/dd"),
    YY_MM_DD_EN2("yy-MM/dd"),
    YYYY_MM_DD_HH_MM_EN("yyyy/MM/dd HH:mm"),
    YYYY_MM_DD_HH_MM_SS_EN("yyyy/MM/dd HH:mm:ss"),
    YY_MM_DD_HH_MM_SS_EN("yy/MM/dd HH:mm:ss"),
    YY_MM_DD_HH_MM_SS_EN2("yy/MM/dd HH-mm-ss"),
    YYYY_MM_DD_HH_MM_MS_EN("yyyy/MM/dd HH:mm:ss.SSS"),
    YYYY_MM_PURE("yyyyMM"),
    YYYY_MM_DD_PURE("yyyyMMdd"),
    YYYY_MM_DD_HH_MM_PURE("yyyyMMddHHmm"),
    YYYY_MM_DD_HH_MM_SS_PURE("yyyyMMddHHmmss"),
    YYYY_MM_DD_HH_MM_MS_PURE("yyyyMMddHHmmssSSS"),
    HH_MM("HH:mm"),
    HH_MM_SS("HH:mm:ss"),
    HH_MM_SS_PURE("HHmmss"),
    MM_DD("MM-dd"),
    MM_DD_HH_MM("MM-dd HH:mm"),
    MM_DD_HH_MM_SS("MM-dd HH:mm:ss"),
    MM_DD_EN("MM/dd"),
    MM_DD_HH_MM_EN("MM/dd HH:mm"),
    MM_DD_HH_MM_SS_EN("MM/dd HH:mm:ss"),
    HTTP_DATETIME("EEE, dd MMM yyyy HH:mm:ss z"),
    JDK_DATETIME("EEE MMM dd HH:mm:ss zzz yyyy"),
    UTC("yyyy-MM-dd'T'HH:mm:ss'Z'"),
    UTC_WITH_ZONE_OFFSET("yyyy-MM-dd'T'HH:mm:ssZ"),
    UTC_MS("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"),
    UTC_MS_WITH_ZONE_OFFSET("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    private final String value;
    private static final Map<String, DatePattern> cacheMap;

    private DatePattern(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static DatePattern getPattern(String datePattern) {
        DatePattern resultDatePattern = cacheMap.get(datePattern);
        if (resultDatePattern == null) {
            throw new UnsupportedOperationException(String.format("datePattern[%s] is Unsupported", datePattern));
        }
        return resultDatePattern;
    }

    static {
        cacheMap = Arrays.stream(DatePattern.values()).collect(Collectors.toMap(DatePattern::getValue, Function.identity()));
    }
}

