/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.util.HrDomainEntity;

public class DomainFactory {
    public static <T> T getInstance(Class<T> clazz) {
        T o;
        if (!clazz.isAnnotationPresent(HrDomainEntity.class)) {
            throw new KDException(new ErrorCode("1000", clazz.getName() + " class is not Annotated by @HrDomainEntity"), new Object[0]);
        }
        HashMap<String, Object> completeObjCache = new HashMap<String, Object>(16);
        HashMap<String, Object> initObjCache = new HashMap<String, Object>(16);
        try {
            Field[] fields;
            o = clazz.newInstance();
            initObjCache.put(clazz.getName(), o);
            for (Field field : fields = clazz.getDeclaredFields()) {
                Class<?> type = field.getType();
                if (!type.isAnnotationPresent(HrDomainEntity.class)) continue;
                Object value = DomainFactory.getSingletonInstance(type, completeObjCache, initObjCache);
                ReflectionUtils.makeAccessible((Field)field);
                field.set(o, value);
            }
            initObjCache.remove(clazz.getName());
            completeObjCache.put(clazz.getName(), o);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("1001", clazz.getName() + " class initialize failed"), new Object[0]);
        }
        completeObjCache.clear();
        initObjCache.clear();
        return o;
    }

    public static <T> T getSingletonInstance(Class<T> clazz, Map<String, Object> completeObjCache, Map<String, Object> initObjCache) {
        if (!clazz.isAnnotationPresent(HrDomainEntity.class)) {
            throw new KDException(new ErrorCode("1000", clazz.getName() + " class is not Annotated by @HrDomainEntity"), new Object[0]);
        }
        Object obj = completeObjCache.get(clazz.getName());
        if (obj != null) {
            return (T)obj;
        }
        obj = initObjCache.get(clazz.getName());
        if (obj == null) {
            try {
                Field[] fields;
                obj = clazz.newInstance();
                initObjCache.put(clazz.getName(), obj);
                for (Field field : fields = clazz.getDeclaredFields()) {
                    Class<?> type = field.getType();
                    if (!type.isAnnotationPresent(HrDomainEntity.class)) continue;
                    Object value = DomainFactory.getSingletonInstance(type, completeObjCache, initObjCache);
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(obj, value);
                }
                initObjCache.remove(clazz.getName());
                completeObjCache.put(clazz.getName(), obj);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("1001", clazz.getName() + " class initialize failed"), new Object[0]);
            }
        }
        return (T)obj;
    }
}

