/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import kd.hr.hbp.common.function.Editor;
import kd.hr.hbp.common.function.Filter;
import kd.hr.hbp.common.function.Matcher;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.Assert;

public class HRArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    public static int getCount(Object[] objs) {
        int count = 0;
        if (objs == null) {
            return count;
        }
        int length = objs.length;
        for (int rowI = 0; rowI < length; ++rowI) {
            if (objs[rowI] == null) continue;
            ++count;
        }
        return count;
    }

    public static final boolean hasSameElements(Object[] objs0, Object[] objs1) {
        if (objs0 == objs1) {
            return true;
        }
        if (objs0 != null && objs1 != null && objs0.length == objs1.length) {
            int rowI;
            int length = objs0.length;
            boolean[] foundMap = new boolean[length];
            for (rowI = 0; rowI < length; ++rowI) {
                foundMap[rowI] = false;
            }
            for (rowI = 0; rowI < length; ++rowI) {
                int rowJ;
                for (rowJ = 0; rowJ < length; ++rowJ) {
                    if (foundMap[rowJ]) continue;
                    if (objs0[rowI] == null) {
                        if (objs0[rowI] == objs1[rowJ]) {
                            foundMap[rowJ] = true;
                            continue;
                        }
                        foundMap[rowJ] = false;
                        continue;
                    }
                    foundMap[rowJ] = objs0[rowI].equals(objs1[rowJ]);
                }
                if (rowJ != length) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final Object[] removeElement(Object[] objs, Object obj) {
        int length = objs.length;
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int rowI = 0; rowI < length; ++rowI) {
            if (obj == objs[rowI]) continue;
            list.add(objs[rowI]);
        }
        if (list.size() == length) {
            return objs;
        }
        Object[] array = (Object[])Array.newInstance(objs.getClass().getComponentType(), list.size());
        return list.toArray(array);
    }

    public static final int[] removeElement(int[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        int[] tArray = new int[array.length - 1];
        if (tArray.length != 0) {
            System.arraycopy(array, 0, tArray, 0, index);
            System.arraycopy(array, index + 1, tArray, index, tArray.length - index);
        }
        return tArray;
    }

    public static final Object[] removeElement(Object[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        Object[] tArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (tArray.length != 0) {
            System.arraycopy(array, 0, tArray, 0, index);
            System.arraycopy(array, index + 1, tArray, index, tArray.length - index);
        }
        return tArray;
    }

    public static final Object[] insertElement(Object[] array, int index, Object val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object[] tArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, tArray, 0, index);
        tArray[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, tArray, index + 1, tArray.length - index - 1);
        }
        return tArray;
    }

    public static final int[] insertElement(int[] array, int index, int val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] tArray = new int[array.length + 1];
        System.arraycopy(array, 0, tArray, 0, index);
        tArray[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, tArray, index + 1, tArray.length - index - 1);
        }
        return tArray;
    }

    public static final int[] removeUniqueElement(int[] arrays, int key) {
        if (arrays == null) {
            return null;
        }
        int index = -1;
        for (int rowI = 0; rowI < arrays.length; ++rowI) {
            if (arrays[rowI] != key) continue;
            index = rowI;
            break;
        }
        if (index == -1) {
            return arrays;
        }
        int[] newA = new int[arrays.length - 1];
        if (newA.length != 0) {
            System.arraycopy(arrays, 0, newA, 0, index);
            System.arraycopy(arrays, index + 1, newA, index, newA.length - index);
        }
        return newA;
    }

    public static final boolean containElement(Object[] objs, Object element) {
        return HRArrayUtils.findElement(objs, element, -1) != -1;
    }

    public static final int findElement(Object[] objs, Object element, int expect) {
        if (objs == null) {
            return -1;
        }
        int length = objs.length;
        for (int rowI = 0; rowI < length; ++rowI) {
            if (objs[rowI] != element && (objs[rowI] == null || !objs[rowI].equals(element)) || expect == rowI) continue;
            return rowI;
        }
        return -1;
    }

    public static final int findStringElement(String[] objs, String element, int expect, boolean ignoreCase) {
        if (objs == null) {
            return -1;
        }
        int length = objs.length;
        for (int rowI = 0; rowI < length; ++rowI) {
            if (objs[rowI] == null || !objs[rowI].equals(element) && (!ignoreCase || !objs[rowI].equalsIgnoreCase(element)) || expect == rowI) continue;
            return rowI;
        }
        return -1;
    }

    public static final boolean difference(Object[] objs0, Object[] objs1, ArrayList<Object> missing, ArrayList<Object> additional) {
        int rowi;
        if (objs0 == objs1) {
            return true;
        }
        Object[] rObjs0 = objs0 == null ? new Object[]{} : objs0;
        Object[] rObjs1 = objs1 == null ? new Object[]{} : objs1;
        int length0 = rObjs0.length;
        int length1 = rObjs1.length;
        int[] index1 = new int[length1];
        for (rowi = 0; rowi < length1; ++rowi) {
            index1[rowi] = rowi;
        }
        for (rowi = 0; rowi < length0; ++rowi) {
            boolean found = false;
            for (int rowJ = 0; rowJ < length1; ++rowJ) {
                if (rObjs0[rowi] != rObjs1[rowJ]) continue;
                found = true;
                index1[rowJ] = -1;
                break;
            }
            if (found) continue;
            additional.add(rObjs0[rowi]);
        }
        for (rowi = 0; rowi < length1; ++rowi) {
            if (index1[rowi] == -1) continue;
            missing.add(rObjs1[rowi]);
        }
        return missing.size() == 0 && additional.size() == 0;
    }

    public static final String objectArray2String(Object[] objs, String split) {
        if (objs == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int length = objs.length;
        for (int rowI = 0; rowI < length; ++rowI) {
            buffer.append(objs[rowI] == null ? "null" : objs[rowI].toString());
            buffer.append(split);
        }
        if (buffer.length() > 0) {
            return buffer.substring(0, buffer.length() - split.length());
        }
        return buffer.toString();
    }

    public static final String byteArray2String(byte[] bytes, String split) {
        if (bytes == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = bytes.length;
        for (int rowI = 0; rowI < length; ++rowI) {
            stringBuilder.append(bytes[rowI]);
            stringBuilder.append(split);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - split.length());
        }
        return stringBuilder.toString();
    }

    public static final String intArray2String(int[] ints, String split) {
        if (ints == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = ints.length;
        for (int rowI = 0; rowI < length; ++rowI) {
            stringBuilder.append(ints[rowI]);
            stringBuilder.append(split);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - split.length());
        }
        return stringBuilder.toString();
    }

    public static final ArrayList<Object> objects2ArrayList(Object[] objs) {
        ArrayList<Object> al = new ArrayList<Object>();
        if (objs != null) {
            int length = objs.length;
            for (int rowI = 0; rowI < length; ++rowI) {
                al.add(objs[rowI]);
            }
        }
        return al;
    }

    public static final Object[] copyGenericArray(Object[] array) {
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static final void clearArray(Object[] array) {
        int length = array.length;
        for (int rowI = 0; rowI < length; ++rowI) {
            array[rowI] = null;
        }
    }

    public static final byte[] addByteArray(byte[] bytesA, byte[] bytesB) {
        byte[] byteC = new byte[bytesA.length + bytesB.length];
        System.arraycopy(bytesA, 0, byteC, 0, bytesA.length);
        System.arraycopy(bytesB, 0, byteC, bytesA.length, bytesB.length);
        return byteC;
    }

    public static final boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return null != array && array.length != 0;
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        if (null == array || null == filter) {
            return array;
        }
        return HRArrayUtils.edit(array, t -> filter.accept(t) ? t : null);
    }

    public static <T> T[] edit(T[] array, Editor<T> editor) {
        if (null == editor) {
            return array;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(modified);
        }
        T[] result = HRArrayUtils.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (HRArrayUtils.isEmpty(buffer)) {
            return newElements;
        }
        return HRArrayUtils.insert(buffer, buffer.length, newElements);
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])HRArrayUtils.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (HRArrayUtils.isEmpty(newElements)) {
            return array;
        }
        if (array == null) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)array)) {
            return newElements;
        }
        int len = HRArrayUtils.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = HRArrayUtils.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> T firstMatch(Matcher<T> matcher, T ... array) {
        if (HRArrayUtils.isEmpty(array)) {
            return null;
        }
        int index = HRArrayUtils.matchIndex(matcher, array);
        if (index < 0) {
            return null;
        }
        return array[index];
    }

    public static <T> int matchIndex(Matcher<T> matcher, T ... array) {
        return HRArrayUtils.matchIndex(matcher, 0, array);
    }

    public static <T> int matchIndex(Matcher<T> matcher, int beginIndexInclude, T ... array) {
        Assert.notNull(matcher, (String)"Matcher must be not null !");
        if (HRArrayUtils.isNotEmpty(array)) {
            for (int i = beginIndexInclude; i < array.length; ++i) {
                if (!matcher.match(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (HRArrayUtils.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (HRArrayUtils.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }
}

