/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.Collection;
import java.util.Map;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRAssert {
    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
    }

    public static void isTrue(boolean expression) throws IllegalArgumentException {
        HRAssert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (expression) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
    }

    public static void isFalse(boolean expression) throws IllegalArgumentException {
        HRAssert.isFalse(expression, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    public static void isNull(Object object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (object != null) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
    }

    public static void isNull(Object object) throws NullPointerException {
        HRAssert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return object;
    }

    public static <T> T notNull(T object) throws NullPointerException {
        return HRAssert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    public static String notEmpty(String text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (HRStringUtils.isEmpty(text)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return text;
    }

    public static String notEmpty(String text) throws IllegalArgumentException {
        return HRAssert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static String notBlank(String text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (HRStringUtils.isBlank(text)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return text;
    }

    public static String notBlank(String text) throws IllegalArgumentException {
        return HRAssert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (HRStringUtils.isNotEmpty(textToSearch) && HRStringUtils.isNotEmpty(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return substring;
    }

    public static String notContain(String textToSearch, String substring) throws IllegalArgumentException {
        return HRAssert.notContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [{}]", substring);
    }

    public static Object[] notEmpty(Object[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (HRArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return array;
    }

    public static Object[] notEmpty(Object[] array) throws IllegalArgumentException {
        return HRAssert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (HRArrayUtils.isEmpty(array)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array) throws IllegalArgumentException {
        return HRAssert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (HRCollUtil.isEmpty(collection)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return collection;
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection) throws IllegalArgumentException {
        return HRAssert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (HRMapUtils.isEmpty(map)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return map;
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map) throws IllegalArgumentException {
        return HRAssert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", new Object[0]);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj) {
        return HRAssert.isInstanceOf(type, obj, "Object [{}] is not instanceof [{}]", obj, type);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        HRAssert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
        return obj;
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) throws IllegalArgumentException {
        HRAssert.isAssignable(superType, subType, "{} is not assignable to {})", subType, superType);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        HRAssert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(HRStringUtils.format(errorMsgTemplate, params));
        }
    }

    public static void state(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(HRStringUtils.format(errorMsgTemplate, params));
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        HRAssert.state(expression, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    public static int checkIndex(int index, int size) throws IllegalArgumentException, IndexOutOfBoundsException {
        return HRAssert.checkIndex(index, size, "[Assertion failed]", new Object[0]);
    }

    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(HRAssert.badIndexMsg(index, size, errorMsgTemplate, params));
        }
        return index;
    }

    public static int checkBetween(int value, int min, int max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(HRStringUtils.format("Length must be between {} and {}.", min, max));
        }
        return value;
    }

    public static long checkBetween(long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(HRStringUtils.format("Length must be between {} and {}.", min, max));
        }
        return value;
    }

    public static double checkBetween(double value, double min, double max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(HRStringUtils.format("Length must be between {} and {}.", min, max));
        }
        return value;
    }

    public static Number checkBetween(Number value, Number min, Number max) {
        HRAssert.notNull(value);
        HRAssert.notNull(min);
        HRAssert.notNull(max);
        double valueDouble = value.doubleValue();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        if (valueDouble < minDouble || valueDouble > maxDouble) {
            throw new IllegalArgumentException(HRStringUtils.format("Length must be between {} and {}.", min, max));
        }
        return value;
    }

    private static String badIndexMsg(int index, int size, String desc, Object ... params) {
        if (index < 0) {
            return HRStringUtils.format("{} ({}) must not be negative", HRStringUtils.format(desc, params), index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return HRStringUtils.format("{} ({}) must be less than size ({})", HRStringUtils.format(desc, params), index, size);
    }
}

