/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.function.Filter;
import kd.hr.hbp.common.util.BasicType;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.ReflectUtil;
import org.springframework.util.ReflectionUtils;

public class HRClassUtil {
    private static final Log logger = LogFactory.getLog(HRClassUtil.class);

    public static <T> Class<T> getClass(T obj) {
        return null == obj ? null : obj.getClass();
    }

    public static String getClassName(Object obj, boolean isSimple) {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        return HRClassUtil.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            classes[i] = null == obj ? Object.class : obj.getClass();
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || HRStringUtils.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        return ReflectUtil.getPublicMethodNames(clazz);
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return ReflectUtil.getPublicMethods(clazz);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        return ReflectUtil.getPublicMethods(clazz, filter);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        return ReflectUtil.getPublicMethods(clazz, excludeMethods);
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        return ReflectUtil.getPublicMethods(clazz, excludeMethodNames);
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getPublicMethod(clazz, methodName, paramTypes);
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        return ReflectUtil.getMethodNames(clazz);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectUtil.getMethods(clazz);
    }

    public static Method getDeclaredMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        return HRClassUtil.getDeclaredMethod(obj.getClass(), methodName, HRClassUtil.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, methodName, parameterTypes);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws SecurityException {
        if (null == clazz || HRStringUtils.isBlank(fieldName)) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return clazz.getDeclaredFields();
    }

    public static String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (HRArrayUtils.isEmpty(types1) && HRArrayUtils.isEmpty(types2)) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (null == type1 || null == type2) {
                return false;
            }
            if (!(HRClassUtil.isBasicType(type1) && HRClassUtil.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : !type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || HRClassUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return HRClassUtil.isSimpleValueType(clazz) || clazz.isArray() && HRClassUtil.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return HRClassUtil.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            Class<?> resolvedPrimitive = BasicType.wrapperPrimitiveMap.get(sourceType);
            return targetType.equals(resolvedPrimitive);
        }
        Class<?> resolvedWrapper = BasicType.primitiveWrapperMap.get(sourceType);
        return resolvedWrapper != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        HRAssert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return !HRClassUtil.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return !HRClassUtil.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        HRAssert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && !method.isAccessible()) {
            ReflectionUtils.makeAccessible((Method)method);
        }
        return method;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !HRClassUtil.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return HRClassUtil.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Long.TYPE == clazz) {
                return 0L;
            }
            if (Integer.TYPE == clazz) {
                return 0;
            }
            if (Short.TYPE == clazz) {
                return (short)0;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf('\u0000');
            }
            if (Byte.TYPE == clazz) {
                return (byte)0;
            }
            if (Double.TYPE == clazz) {
                return 0.0;
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.TYPE == clazz) {
                return false;
            }
        } else if (clazz.isArray()) {
            return null;
        }
        if (clazz.isEnum()) {
            return null;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (LinkedHashMap.class.isAssignableFrom(clazz)) {
                return HRMapUtils.newHashMap(true);
            }
            if (ConcurrentHashMap.class.isAssignableFrom(clazz)) {
                return new ConcurrentHashMap();
            }
            return HRMapUtils.newHashMap();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            if (LinkedHashSet.class.isAssignableFrom(clazz)) {
                return new LinkedHashSet();
            }
            if (HashSet.class.isAssignableFrom(clazz)) {
                return new HashSet();
            }
            return HRCollUtil.newHashSet(new Object[0]);
        }
        if (List.class.isAssignableFrom(clazz)) {
            if (LinkedList.class.isAssignableFrom(clazz)) {
                return new LinkedList();
            }
            if (ArrayList.class.isAssignableFrom(clazz)) {
                return new ArrayList();
            }
            return HRCollUtil.newArrayList(new Object[0]);
        }
        if (Queue.class.isAssignableFrom(clazz)) {
            if (LinkedBlockingQueue.class.isAssignableFrom(clazz)) {
                return new LinkedBlockingQueue();
            }
        } else if (HRClassUtil.isEnum(clazz)) {
            try {
                return ReflectUtil.createEnumInstance(clazz);
            }
            catch (Exception exception) {
            }
        } else {
            if (String.class.isAssignableFrom(clazz)) {
                return "";
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return 0L;
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return 0;
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return (short)0;
            }
            if (Character.class.isAssignableFrom(clazz)) {
                return Character.valueOf('\u0000');
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return (byte)0;
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return 0.0;
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                return false;
            }
        }
        try {
            return ReflectUtil.newInstanceIfPossible(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = HRClassUtil.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static Set<Class<?>> getClzFromPkg(String pkg) {
        String pkgDirName = pkg.replace('.', '/');
        try {
            Enumeration<URL> urls = HRClassUtil.class.getClassLoader().getResources(pkgDirName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    LinkedHashSet classes = new LinkedHashSet(16);
                    HRClassUtil.findClassesByFile(pkg, filePath, classes);
                    return classes;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                return HRClassUtil.findClassesByJar(pkg, jar);
            }
        }
        catch (IOException e) {
            logger.warn("getClzFromPkg class fail!errMsg={}", (Object)e.getMessage(), (Object)e);
        }
        return new LinkedHashSet(16);
    }

    private static void findClassesByFile(String pkgName, String pkgPath, Set<Class<?>> classes) {
        File dir = new File(pkgPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(pathname -> pathname.isDirectory() || pathname.getName().endsWith("class"));
        if (dirFiles == null || dirFiles.length == 0) {
            return;
        }
        for (File f : dirFiles) {
            if (f.isDirectory()) {
                HRClassUtil.findClassesByFile(pkgName + "." + f.getName(), pkgPath + "/" + f.getName(), classes);
                continue;
            }
            String className = f.getName();
            className = className.substring(0, className.length() - 6);
            Class<?> clz = HRClassUtil.loadClass(pkgName + "." + className);
            if (clz == null) continue;
            classes.add(clz);
        }
    }

    private static Set<Class<?>> findClassesByJar(String pkgName, JarFile jar) {
        LinkedHashSet<Class<Object>> classes = new LinkedHashSet(16);
        String pkgDir = pkgName.replace(".", "/");
        Enumeration<JarEntry> entry = jar.entries();
        int THRESHOLD_ENTRIES = 10000;
        int THRESHOLD_SIZE = 1000000000;
        double THRESHOLD_RATIO = 10.0;
        int totalSizeArchive = 0;
        int totalEntryArchive = 0;
        while (entry.hasMoreElements()) {
            String className;
            Class<?> clazz;
            JarEntry jarEntry = entry.nextElement();
            ++totalEntryArchive;
            if ((totalSizeArchive = (int)((long)totalSizeArchive + jarEntry.getSize())) > THRESHOLD_SIZE) {
                classes = new LinkedHashSet();
                break;
            }
            if (totalEntryArchive > THRESHOLD_ENTRIES) {
                classes = new LinkedHashSet();
                break;
            }
            String name = jarEntry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (jarEntry.isDirectory() || !name.startsWith(pkgDir) || !name.endsWith(".class") || (clazz = HRClassUtil.loadClass((className = name.substring(0, name.length() - 6)).replace("/", "."))) == null) continue;
            classes.add(clazz);
        }
        return classes;
    }

    private static Class<?> loadClass(String fullClzName) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(fullClzName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("loadClass class fail!errMsg={}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

