/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.hr.hbp.common.util.HRListUtils;

public class HRCollUtil {
    public static <T> Set<T> emptyIfNull(Set<T> set) {
        return null == set ? Collections.emptySet() : set;
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        return null == list ? Collections.emptyList() : list;
    }

    public static <T> HashSet<T> newHashSet(T ... ts) {
        return HRCollUtil.set(false, ts);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... ts) {
        return (LinkedHashSet)HRCollUtil.set(true, ts);
    }

    public static <T> HashSet<T> set(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return HRCollUtil.newHashSet(false, collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        return isSorted ? new LinkedHashSet<T>(collection) : new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return HRCollUtil.set(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Enumeration<T> enumeration) {
        HashSet set;
        if (null == enumeration) {
            return HRCollUtil.set(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public static <T> ArrayList<T> newArrayList(T ... values) {
        return HRListUtils.toList(values);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !HRCollUtil.isEmpty(collection);
    }
}

