/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.HRHttpResult;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class HRHttpClientUtil {
    private static final Log logger = LogFactory.getLog(HRHttpClientUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static HRHttpResult doPost(String url, Map<String, String> headerMap, Map<String, String> entityMap) {
        String result;
        int statusCode;
        Exception exception;
        block23: {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse httpResponse = null;
            Object httpEntity = null;
            exception = null;
            statusCode = 0;
            result = "";
            try {
                httpClient = HttpClientBuilder.create().build();
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(120000).setSocketTimeout(300000).build();
                HttpPost httpPost = new HttpPost(url);
                httpPost.setConfig(requestConfig);
                HRHttpClientUtil.setHead(headerMap, httpPost);
                if (entityMap != null && !entityMap.isEmpty()) {
                    HRHttpClientUtil.sethttpEntity(entityMap, httpPost);
                }
                httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity responseEntity = httpResponse.getEntity();
                statusCode = httpResponse.getStatusLine().getStatusCode();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseEntity.getContent()));){
                    StringBuilder buffer = new StringBuilder();
                    String str = "";
                    while (!HRStringUtils.isEmpty(str = reader.readLine())) {
                        buffer.append(str);
                    }
                    result = buffer.toString();
                }
                HRHttpClientUtil.closeResource(httpClient, httpResponse);
            }
            catch (IOException excep) {
                exception = excep;
                logger.error((Throwable)excep);
            }
            catch (Exception excep2) {
                exception = excep2;
                logger.error((Throwable)excep2);
                break block23;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                HRHttpClientUtil.closeResource(httpClient, httpResponse);
            }
        }
        if (exception != null) {
            result = exception.getClass().getName() + ":" + exception.getMessage();
        }
        HRHttpResult httpResult = new HRHttpResult(statusCode, result);
        return httpResult;
    }

    private static void setHead(Map<String, String> headerMap, HttpPost httpPost) {
        if (headerMap != null && !headerMap.isEmpty()) {
            headerMap.forEach((headerName, headerValue) -> {
                BasicHeader header = new BasicHeader(headerName, headerValue);
                httpPost.setHeader((Header)header);
            });
        }
    }

    private static void sethttpEntity(Map<String, String> entityMap, HttpPost httpPost) {
        ArrayList nameValuePairList = new ArrayList();
        entityMap.forEach((name, value) -> nameValuePairList.add(new BasicNameValuePair(name, value)));
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nameValuePairList, Charset.forName("UTF-8"));
        httpPost.setEntity((HttpEntity)httpEntity);
    }

    private static void closeResource(CloseableHttpClient httpClient, CloseableHttpResponse httpResponse) {
        IOException exception;
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException excep) {
                exception = excep;
                logger.error((Throwable)excep);
            }
        }
        if (httpResponse != null) {
            try {
                httpResponse.close();
            }
            catch (IOException excep) {
                exception = excep;
                logger.error((Throwable)excep);
            }
        }
    }
}

