/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRMultiEntityImptUtil {
    private static final String HRMP_HBP_COMMON = "hrmp-hbp-common";
    private static final String SEPARATOR = "#";

    public static String getMainEntitySuffix() {
        return ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53", (String)"HRMultiEntityImptUtil_0", (String)HRMP_HBP_COMMON, (Object[])new Object[0]);
    }

    public static boolean isMainEntity(String sheetName) {
        if (HRStringUtils.isEmpty(sheetName)) {
            return false;
        }
        String[] tags = sheetName.split(SEPARATOR);
        return HRStringUtils.equals(tags[tags.length - 1], HRMultiEntityImptUtil.getMainEntitySuffix());
    }

    public static boolean isPropertyImport(List<EntityItem<?>> newItems, IDataEntityProperty prop) {
        for (EntityItem<?> entityItem : newItems) {
            DateRangeField field;
            if (entityItem instanceof DateRangeField && (HRStringUtils.equals((field = (DateRangeField)entityItem).getStartDateFieldKey(), prop.getName()) || HRStringUtils.equals(field.getEndDateFieldKey(), prop.getName()))) {
                return true;
            }
            if (!HRStringUtils.equals(prop.getName(), entityItem.getKey())) continue;
            return true;
        }
        return false;
    }

    public static String getEntityId(String sheetName, int index) {
        return Optional.ofNullable(sheetName).map(name -> {
            String[] split = sheetName.split(SEPARATOR);
            return split[index];
        }).orElse(null);
    }

    public static void loadImportField4Combo(String billFormId, ComboEdit combo, HashMap<String, Boolean> importField) {
        ArrayList keyFieldItems = Lists.newArrayListWithCapacity((int)16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        List<EntityItem<?>> newItems = entityItems.stream().filter(item -> {
            boolean valid = item instanceof Field;
            if (valid) {
                valid = HRMultiEntityImptUtil.isValid((Field)item);
            }
            return valid;
        }).collect(Collectors.toList());
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (!HRMultiEntityImptUtil.isPropertyImport(newItems, prop) || !Objects.nonNull(importField.get(prop.getName())) || !importField.get(prop.getName()).booleanValue()) continue;
            keyFieldItems.add(new ComboItem(prop.getDisplayName(), prop.getName()));
        }
        if (!keyFieldItems.isEmpty()) {
            HRMultiEntityImptUtil.sortKeyFieldItems(keyFieldItems, entityType);
            combo.setComboItems((List)keyFieldItems);
        }
    }

    public static boolean isValid(Field field) {
        return HRStringUtils.isNotEmpty(field.getFieldName()) && field.getFeatures().isImportable() && !(field instanceof BillStatusField) && !(field instanceof CheckBoxField) && !(field instanceof RadioField) && !(field instanceof RadioGroupField) && !(field instanceof ModifierField) && !(field instanceof PictureField) && !(field instanceof UserAvatarField) && !(field instanceof IconField) && !(field instanceof AttachmentCountField) && !(field instanceof AttachmentField) && !(field instanceof PrintCountField);
    }

    private static void sortKeyFieldItems(List<ComboItem> keyFieldItems, MainEntityType entityType) {
        String orgKey = "";
        if (entityType != null && entityType.getMainOrg() != null) {
            orgKey = entityType.getMainOrg();
        }
        int orgIndex = 0;
        int billNoIndex = 0;
        boolean hasOrg = false;
        boolean hasBillNo = false;
        for (int i = 0; i < keyFieldItems.size(); ++i) {
            ComboItem comboItem = keyFieldItems.get(i);
            if (HRStringUtils.isNotEmpty(orgKey) && HRStringUtils.equals(orgKey, comboItem.getValue())) {
                orgIndex = i;
                hasOrg = true;
                continue;
            }
            if (!HRStringUtils.equals("billno", comboItem.getValue())) continue;
            billNoIndex = i;
            hasBillNo = true;
        }
        if (hasOrg) {
            keyFieldItems.add(1, keyFieldItems.get(orgIndex));
            keyFieldItems.remove(orgIndex + 1);
        }
        if (hasBillNo) {
            keyFieldItems.add(hasOrg ? 2 : 1, keyFieldItems.get(billNoIndex));
            keyFieldItems.remove(billNoIndex + 1);
        }
    }
}

