/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class HRStreamUtils {
    private static final Logger LOGGER = Logger.getLogger(HRStreamUtils.class);

    public static int copy(InputStream in, OutputStream out, int blockSize) throws IOException {
        int size = 0;
        byte[] block = new byte[blockSize];
        while (true) {
            int rowI;
            if ((rowI = in.read(block, 0, blockSize)) > 0) {
                out.write(block, 0, rowI);
                size += rowI;
                continue;
            }
            if (rowI == -1) break;
        }
        return size;
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[]{};
        byte[] perReadBuffer = new byte[32768];
        while ((read = in.read(perReadBuffer)) != -1) {
            byte[] temp = new byte[buffer.length + read];
            System.arraycopy(buffer, 0, temp, 0, buffer.length);
            System.arraycopy(perReadBuffer, 0, temp, buffer.length, read);
            buffer = temp;
        }
        return buffer;
    }

    public static final void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception ex) {
                LOGGER.error((Object)"", (Throwable)ex);
            }
        }
    }

    public static final void closeStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception ex) {
                LOGGER.error((Object)"", (Throwable)ex);
            }
        }
    }

    public static final void closeStream(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (Exception ex) {
                LOGGER.error((Object)"", (Throwable)ex);
            }
        }
    }

    public static final void forwardStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[32768];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }
}

