/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.util.TraceIdUtil;

public class LoggerUtils {
    private static final String KEY_PROCESS_ID = "processId";
    private static final String KEY_PROCESS_TYPE = "processType";
    private static final String KEY_LOG_ID = "logId";
    private static final String KEY_PARENT_ID = "parentId";
    private static final String KEY_TRACE_ID = "traceId";
    private static final String KEY_SEPARATEOR = ":";
    private static final String WORD_SEPARATEOR = ",";
    private static final String BEGIN_SIGN = "[";
    private static final String END_SIGN = "]";

    public static void info(Log log, Object obj) {
        Object rcinfo = ThreadTruck.get((Object)"rcinfo");
        if (rcinfo instanceof Map) {
            Map rcInfoMap = (Map)rcinfo;
            if (!rcInfoMap.containsKey(KEY_TRACE_ID)) {
                rcInfoMap.put(KEY_TRACE_ID, LoggerUtils.getHexId());
            }
            if (!rcInfoMap.containsKey(KEY_LOG_ID)) {
                rcInfoMap.put(KEY_LOG_ID, rcInfoMap.get(KEY_TRACE_ID));
            }
            if (!rcInfoMap.containsKey(KEY_PROCESS_ID)) {
                rcInfoMap.put(KEY_PROCESS_ID, LoggerUtils.getHexId());
            }
            String message = LoggerUtils.getMessage(rcInfoMap, obj);
            log.info(message, (Object)SerializationUtils.toJsonString((Object)obj));
        } else {
            log.info(SerializationUtils.toJsonString((Object)obj));
        }
    }

    public static void info(Log log, String processType, Object obj) {
        Object rcinfo = ThreadTruck.get((Object)"rcinfo");
        if (rcinfo instanceof Map) {
            Map rcInfoMap = (Map)rcinfo;
            rcInfoMap.put(KEY_PROCESS_TYPE, processType);
        }
        LoggerUtils.info(log, obj);
    }

    private static String getMessage(Map<String, String> rcInfoMap, Object obj) {
        StringBuilder sbuilder = new StringBuilder();
        StringBuilder processid = new StringBuilder();
        StringBuilder processtype = new StringBuilder();
        rcInfoMap.forEach((key, value) -> {
            if (KEY_PROCESS_ID.equals(key)) {
                processid.append((String)key).append(KEY_SEPARATEOR).append((String)value);
            } else if (KEY_PROCESS_TYPE.equals(key)) {
                processtype.append((String)key).append(KEY_SEPARATEOR).append((String)value).append(WORD_SEPARATEOR);
            } else {
                sbuilder.append((String)key).append(KEY_SEPARATEOR).append((String)value).append(WORD_SEPARATEOR);
            }
        });
        sbuilder.append((CharSequence)processtype).append((CharSequence)processid);
        sbuilder.insert(0, BEGIN_SIGN);
        sbuilder.insert(sbuilder.length(), END_SIGN);
        sbuilder.append(":{}");
        return sbuilder.toString();
    }

    private static String getHexId() {
        long id = TraceIdUtil.createTraceId();
        String hid = TraceIdUtil.idToHex((long)id);
        return hid;
    }
}

