/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.hr.hbp.common.exception.HRUtilException;
import kd.hr.hbp.common.function.Filter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hbp.common.util.HRClassUtil;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.SimpleCache;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class ReflectUtil {
    private static final SimpleCache<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Field[]> FIELDS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Method[]> METHODS_CACHE = new SimpleCache();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectUtil.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!HRClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectionUtils.makeAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        HRAssert.notNull(beanClass);
        Constructor<?>[] constructors = CONSTRUCTORS_CACHE.get(beanClass);
        if (null != constructors) {
            return constructors;
        }
        constructors = ReflectUtil.getConstructorsDirectly(beanClass);
        return CONSTRUCTORS_CACHE.put(beanClass, constructors);
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        HRAssert.notNull(beanClass);
        return beanClass.getDeclaredConstructors();
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != ReflectUtil.getField(beanClass, name);
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtil.getFields(beanClass);
        if (HRArrayUtils.isNotEmpty(fields)) {
            for (Field field : fields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Field[] allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields) {
            return allFields;
        }
        allFields = ReflectUtil.getFieldsDirectly(beanClass, true);
        return FIELDS_CACHE.put(beanClass, allFields);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFieds) throws SecurityException {
        HRAssert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : HRArrayUtils.append(allFields, declaredFields);
            searchType = withSuperClassFieds ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static Object getFieldValue(Object obj, String fieldName) throws HRUtilException {
        if (null == obj || HRStringUtils.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtil.getFieldValue(obj, ReflectUtil.getField(obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) throws HRUtilException {
        Object result;
        if (null == obj || null == field) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new HRUtilException(e, "IllegalAccess for {}.{}", obj.getClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object obj) {
        Field[] fields;
        if (null != obj && null != (fields = ReflectUtil.getFields(obj.getClass()))) {
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values[i] = ReflectUtil.getFieldValue(obj, fields[i]);
            }
            return values;
        }
        return null;
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray = ReflectUtil.getPublicMethods(clazz);
        if (HRArrayUtils.isNotEmpty(methodArray)) {
            for (Method method : methodArray) {
                methodSet.add(method.getName());
            }
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ReflectUtil.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = HRCollUtil.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        HashSet<Method> excludeMethodSet = HRCollUtil.newHashSet(excludeMethods);
        return ReflectUtil.getPublicMethods(clazz, (Method method) -> !excludeMethodSet.contains(method));
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        HashSet<String> excludeMethodNameSet = HRCollUtil.newHashSet(excludeMethodNames);
        return ReflectUtil.getPublicMethods(clazz, (Method method) -> !excludeMethodNameSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || HRStringUtils.isBlank(methodName)) {
            return null;
        }
        return ReflectUtil.getMethod(obj.getClass(), methodName, HRClassUtil.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || HRStringUtils.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (HRArrayUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!HRStringUtils.equals(methodName, method.getName(), ignoreCase) || !HRClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || HRStringUtils.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (HRArrayUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!HRStringUtils.equals(methodName, method.getName(), ignoreCase)) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectUtil.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return HRArrayUtils.filter(ReflectUtil.getMethods(clazz), filter);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Method[] allMethods = METHODS_CACHE.get(beanClass);
        if (null != allMethods) {
            return allMethods;
        }
        allMethods = ReflectUtil.getMethodsDirectly(beanClass, true, true);
        return METHODS_CACHE.put(beanClass, allMethods);
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSuperClassMethods, boolean withSuperInterFaceMethods) throws SecurityException {
        HRAssert.notNull(beanClass);
        Method[] allMethods = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Class<?>[] interfaces;
            allMethods = ReflectUtil.getMethods(searchType, allMethods);
            if (withSuperInterFaceMethods && (interfaces = searchType.getInterfaces()).length > 0) {
                for (Class<?> anInterface : interfaces) {
                    allMethods = ReflectUtil.getMethods(anInterface, allMethods);
                }
            }
            searchType = withSuperClassMethods ? searchType.getSuperclass() : null;
            searchType = Objects.equals(searchType, Object.class) ? null : searchType;
        }
        return allMethods;
    }

    private static Method[] getMethods(Class<?> searchType, Method[] allMethods) {
        Method[] declaredMethods = searchType.getDeclaredMethods();
        if (null == allMethods) {
            return declaredMethods;
        }
        return HRArrayUtils.append(allMethods, declaredMethods);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return 1 == paramTypes.length && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static <T> T newInstance(String clazz) throws HRUtilException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new HRUtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstance(String clazz, Object ... params) throws HRUtilException {
        try {
            return (T)ReflectUtil.newInstance(Class.forName(clazz), params);
        }
        catch (Exception e) {
            throw new HRUtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws HRUtilException {
        if (null == clazz) {
            throw new HRUtilException("Instance error!clazz is null");
        }
        if (HRArrayUtils.isEmpty(params)) {
            if (Map.class.isAssignableFrom(clazz)) {
                if (LinkedHashMap.class.isAssignableFrom(clazz)) {
                    return (T)HRMapUtils.newHashMap(true);
                }
                return (T)HRMapUtils.newHashMap();
            }
            if (Iterable.class.isAssignableFrom(clazz)) {
                if (LinkedHashSet.class.isAssignableFrom(clazz)) {
                    return (T)new LinkedHashSet();
                }
                if (Set.class.isAssignableFrom(clazz)) {
                    return (T)new HashSet();
                }
                if (LinkedList.class.isAssignableFrom(clazz)) {
                    return (T)new LinkedList();
                }
                return (T)HRCollUtil.newArrayList(new Object[0]);
            }
            Constructor<T> constructor = ReflectUtil.getConstructor(clazz, new Class[0]);
            if (null == constructor) {
                throw new HRUtilException("Instance error!constructor is null");
            }
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new HRUtilException(e, "Instance class [{}] error!", clazz);
            }
        }
        Class<?>[] paramTypes = HRClassUtil.getClasses(params);
        Constructor<T> constructor = ReflectUtil.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new HRUtilException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new HRUtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> beanClass) {
        HRAssert.notNull(beanClass);
        if (HRClassUtil.isAbstract(beanClass)) {
            throw new IllegalArgumentException("unsupported abstract class or interface:" + beanClass.getName());
        }
        try {
            return ReflectUtil.newInstance(beanClass, new Object[0]);
        }
        catch (Exception | NoSuchMethodError throwable) {
            return ReflectUtil.newInstanceIfPossible(beanClass, true);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> beanClass, boolean fetchOnly) {
        Constructor<T>[] constructors;
        T t = null;
        for (Constructor<T> constructor : constructors = ReflectUtil.getConstructors(beanClass)) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (0 == parameterTypes.length) continue;
            ReflectionUtils.makeAccessible(constructor);
            try {
                t = constructor.newInstance(HRClassUtil.getDefaultValues(parameterTypes));
                if (!fetchOnly) continue;
                return t;
            }
            catch (Exception | NoSuchMethodError throwable) {
                // empty catch block
            }
        }
        return t;
    }

    public static <T extends Enum<T>> T createEnumInstance(String clazz) {
        try {
            Class<?> clz = Class.forName(clazz);
            return (T)ReflectUtil.createEnumInstance(clz);
        }
        catch (ClassNotFoundException e) {
            throw new HRUtilException(e, "Instance enum [{}] error!", clazz);
        }
    }

    public static <T extends Enum<T>> T createEnumInstance(Class<T> clz) {
        Enum[] enumConstants;
        if (HRClassUtil.isEnum(clz) && (enumConstants = (Enum[])clz.getEnumConstants()) != null) {
            return Enum.valueOf(clz, enumConstants[0].name());
        }
        return null;
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws HRUtilException {
        return ReflectUtil.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws HRUtilException {
        Class<?>[] types = method.getParameterTypes();
        if (null != types && null != args) {
            HRAssert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = HRClassUtil.getDefaultValue(type);
            }
        }
        return ReflectUtil.invoke(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws HRUtilException {
        if (!method.isAccessible()) {
            ReflectionUtils.makeAccessible((Method)method);
        }
        try {
            if (method.isDefault()) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                ReflectionUtils.makeAccessible(constructor);
                Class<?> declaringClass = method.getDeclaringClass();
                return (T)((MethodHandles.Lookup)constructor.newInstance(declaringClass)).unreflectSpecial(method, declaringClass).bindTo(obj).invokeWithArguments(args);
            }
            return (T)method.invoke(HRClassUtil.isStatic(method) ? null : obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new HRUtilException(e);
        }
        catch (IllegalArgumentException e) {
            throw new HRUtilException("params is err,please check", e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws HRUtilException {
        Method method = ReflectUtil.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new HRUtilException(HRStringUtils.format("No such method: [{}]", methodName));
        }
        return ReflectUtil.invoke(obj, method, args);
    }

    public static boolean checkParameterType(Method method, Object ... args) throws HRUtilException {
        int argsLen;
        Class<?>[] types = method.getParameterTypes();
        int typeLen = types.length;
        int n = argsLen = ObjectUtils.isEmpty((Object)args) ? 0 : args.length;
        if (typeLen != argsLen) {
            throw new HRUtilException("method: [{}] param is required {}piece, actual delivery {}piece", method.getName(), typeLen, argsLen);
        }
        if (typeLen == 0) {
            return true;
        }
        ArrayList errMsgList = Lists.newArrayListWithExpectedSize((int)argsLen);
        for (int i = 0; i < argsLen; ++i) {
            Object param = args[i];
            Class<?> type = types[i];
            if (null == param) {
                if (!type.isPrimitive()) continue;
                errMsgList.add(HRStringUtils.format("param[{}] is required type:{}, actual delivery type:null", i + 1, type.getName()));
                continue;
            }
            Class<?> paramType = param.getClass();
            if (type.equals(paramType)) continue;
            errMsgList.add(HRStringUtils.format("param[{}] is required type:{}, actual delivery type:{}", i + 1, type.getName(), param.getClass().getName()));
        }
        if (CollectionUtils.isNotEmpty((Collection)errMsgList)) {
            throw new HRUtilException(String.join((CharSequence)";", errMsgList));
        }
        return true;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws HRUtilException {
        HRAssert.notNull(obj);
        HRAssert.notBlank(fieldName);
        Field field = ReflectUtil.getField(obj.getClass(), fieldName);
        if (null == field) {
            throw new HRUtilException("field[{}] not found in class{}", fieldName, obj.getClass());
        }
        ReflectUtil.setFieldValue(obj, field, value);
    }

    public static void setConstFieldValue(Object obj, String fieldName, Object value) throws HRUtilException {
        HRAssert.notNull(obj);
        HRAssert.notBlank(fieldName);
        Field field = ReflectUtil.getField(obj.getClass(), fieldName);
        if (null == field) {
            throw new HRUtilException("field[{}] not found in class{}", fieldName, obj.getClass());
        }
        try {
            ReflectionUtils.makeAccessible((Field)field);
            Field modifiers = field.getClass().getDeclaredField("modifiers");
            ReflectionUtils.makeAccessible((Field)modifiers);
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws HRUtilException {
        HRAssert.notNull(obj);
        HRAssert.notNull(field);
        ReflectionUtils.makeAccessible((Field)field);
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new HRUtilException(e, "IllegalAccess for {}.{}", obj.getClass(), field.getName());
        }
    }

    public static Object getFinalFieldValueByName(String fieldName, Class<?> clazz) throws IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name;
            boolean isFinal = Modifier.isFinal(field.getModifiers());
            if (!isFinal || !fieldName.equals(name = field.getName())) continue;
            ReflectionUtils.makeAccessible((Field)field);
            Field modifiers = field.getClass().getDeclaredField("modifiers");
            ReflectionUtils.makeAccessible((Field)modifiers);
            return field.get(null);
        }
        return null;
    }

    public static Map<String, Object> getFinalFieldValues(Class<?> clazz, boolean ignore) {
        Field[] fields;
        HashMap<String, Object> finalFieldValues = new HashMap<String, Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean isFinal = Modifier.isFinal(field.getModifiers());
            try {
                if (!isFinal) continue;
                ReflectionUtils.makeAccessible((Field)field);
                Field modifiers = field.getClass().getDeclaredField("modifiers");
                ReflectionUtils.makeAccessible((Field)modifiers);
                finalFieldValues.put(field.getName(), field.get(null));
            }
            catch (Exception e) {
                if (ignore) continue;
                throw new HRUtilException(e, "getFinalFieldValues fial {}.{} errMsg={}", clazz, field.getName(), e.getMessage(), e);
            }
        }
        return finalFieldValues;
    }

    public static Map<String, Object> getFinalFieldValues(Class<?> clazz) {
        return ReflectUtil.getFinalFieldValues(clazz, false);
    }
}

