/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TableAliasUtil {
    public static final String MULI_LANG_TABLE_SUFFIX = "_L";
    public static final String MULI_LANG_TABLE_ALIAS = "L";
    private static final String[] ALIAS_LIB = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int MAX_VALUE = 225;

    public static String genMuliLangAlias(String mainTableAlias) {
        return mainTableAlias + MULI_LANG_TABLE_ALIAS;
    }

    public static Map<String, String> genTableAlias(Set<String> tableSet) {
        TreeSet mainTableSet = new TreeSet(Comparator.naturalOrder());
        mainTableSet.addAll(tableSet);
        Set muliLangTableSet = mainTableSet.stream().filter(tb -> tb.endsWith(MULI_LANG_TABLE_SUFFIX) || tb.endsWith(MULI_LANG_TABLE_SUFFIX.toLowerCase(Locale.ROOT))).collect(Collectors.toSet());
        Iterator iterator = muliLangTableSet.iterator();
        while (iterator.hasNext()) {
            String mulLangTable = (String)iterator.next();
            String mainTable = mulLangTable.substring(0, mulLangTable.length() - 2);
            if (mainTableSet.contains(mainTable)) {
                mainTableSet.remove(mulLangTable);
                continue;
            }
            iterator.remove();
        }
        HashMap tableAlias = Maps.newHashMapWithExpectedSize((int)16);
        String[] alias = TableAliasUtil.genAlias(mainTableSet.size());
        int index = 0;
        for (String table : mainTableSet) {
            tableAlias.put(table, alias[index++]);
        }
        for (String muliLangTable : muliLangTableSet) {
            String mainTable = muliLangTable.substring(0, muliLangTable.length() - 2);
            String muliLangTableAlias = TableAliasUtil.genMuliLangAlias((String)tableAlias.get(mainTable));
            tableAlias.put(muliLangTable, muliLangTableAlias);
        }
        return tableAlias;
    }

    public static String[] genAlias(int number) {
        if (number > 225) {
            return new String[0];
        }
        int sigAliasLen = ALIAS_LIB.length;
        String[] retAliasArr = Arrays.copyOf(ALIAS_LIB, number);
        if (number <= sigAliasLen) {
            return retAliasArr;
        }
        int index = sigAliasLen;
        block0: for (int i = 1; i < 10; ++i) {
            String suffix = String.valueOf(i);
            for (String str : ALIAS_LIB) {
                if (index == number) continue block0;
                String alias = str + suffix;
                retAliasArr[index++] = alias;
            }
        }
        return retAliasArr;
    }

    private static int calRepeatTime(int number) {
        int sigAliasLen = ALIAS_LIB.length;
        return number / sigAliasLen + (number % sigAliasLen > 0 ? 0 : -1) + 1;
    }
}

