/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;

public class UserDateTimeUtil {
    private Map<String, String> timeFormatMap;
    private String dateFormatStr;
    private String userTimeZone;

    public UserDateTimeUtil() {
        this.init();
    }

    private void init() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        long currUserId = RequestContext.get().getCurrUserId();
        this.dateFormatStr = service.getDateFormat(Long.valueOf(currUserId));
        this.timeFormatMap = service.getTimeFormat(Long.valueOf(currUserId));
        DynamicObject dyo = service.getUserTimezone(Long.valueOf(currUserId));
        this.userTimeZone = dyo.getString("number");
    }

    public Map<String, String> getTimeFormatMap() {
        return this.timeFormatMap;
    }

    public String getDateFormatStr() {
        return this.dateFormatStr;
    }

    public DateFormat getUserDateTimeFormat(TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getDateFormatStr() + " " + this.getTimeFormatMap().get("timeFormat"));
        dateFormat.setTimeZone(timeZone);
        return dateFormat;
    }

    public Date transferUserDateTimeFormat(Date date) throws ParseException {
        TimeZone timeZone = TimeZone.getTimeZone(this.getUserTimeZone());
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getDateFormatStr() + " " + this.getTimeFormatMap().get("timeFormat"));
        dateFormat.setTimeZone(timeZone);
        String formatDate = dateFormat.format(date);
        return new SimpleDateFormat(this.getDateFormatStr() + " " + this.getTimeFormatMap().get("timeFormat")).parse(formatDate);
    }

    public String getUserTimeZone() {
        return this.userTimeZone;
    }
}

