/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util.labelandreport;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;

public class ComplexObjTransferUtil {
    public static HRComplexObjContext transferToComplexObjContext(List<JoinEntityCommonBo> joinEntities, List<QueryFieldCommonBo> queryFields, List<EntityRelationCommonBo> entityRelations, List<QFilter> qFilters) {
        HRComplexObjContext context = new HRComplexObjContext();
        Optional<JoinEntityCommonBo> mainEntityBo = joinEntities.stream().filter(entity -> HRStringUtils.equals(entity.getType(), "main")).findFirst();
        if (!mainEntityBo.isPresent()) {
            return null;
        }
        String mainEntityNumber = mainEntityBo.get().getEntityNumber();
        context.setEntityNumber(mainEntityNumber);
        boolean isVirtualEntity = joinEntities.size() == 1 && joinEntities.get(0).getVirtualEntity();
        context.setVirtualEntity(isVirtualEntity);
        if (!isVirtualEntity) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityBo.get().getEntityNumber());
            context.setEntityTable(dataEntityType.getAlias());
        }
        if (qFilters != null && !qFilters.isEmpty()) {
            context.setQfilterList(qFilters);
        }
        ArrayList queryFieldsInfoList = Lists.newArrayListWithExpectedSize((int)queryFields.size());
        for (QueryFieldCommonBo fieldBo : queryFields) {
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(fieldBo.getFieldPath(), "1", fieldBo.getFieldAlias());
            fieldInfo.setDataType(DataTypeEnum.of(fieldBo.getValueType()));
            fieldInfo.setTimeZoneInfo(fieldBo.getTimeZoneInfo());
            queryFieldsInfoList.add(fieldInfo);
        }
        context.setComplexObjFieldInfoList(queryFieldsInfoList);
        Map<String, JoinEntityCommonBo> entityMap = joinEntities.stream().collect(Collectors.toMap(JoinEntityCommonBo::getEntityAlias, entity -> entity));
        ArrayList joinRelationList = Lists.newArrayListWithExpectedSize((int)entityRelations.size());
        for (EntityRelationCommonBo entityRelation : entityRelations) {
            JoinEntityCommonBo entityBo = entityMap.get(entityRelation.getEntityAlias());
            JoinEntityCommonBo joinEntityBo = entityMap.get(entityRelation.getJoinEntityAlias());
            HRComplexObjJoinRelation relationInfo = new HRComplexObjJoinRelation(entityBo.getEntityNumber(), entityBo.getEntityAlias(), joinEntityBo.getEntityNumber(), joinEntityBo.getEntityAlias(), entityRelation.getJoinType());
            relationInfo.setRelEntityLongNumber(joinEntityBo.getLongNumber());
            List<JoinConditionBo> conditions = entityRelation.getConditions();
            ArrayList conditionInfoList = Lists.newArrayListWithExpectedSize((int)conditions.size());
            for (JoinConditionBo condition : conditions) {
                HRComplexObjConditionRow conditionRow;
                if (HRStringUtils.equals(condition.getRightPropType(), "field")) {
                    conditionRow = new HRComplexObjConditionRow(condition.getLeftProp(), condition.getRightProp());
                    conditionRow.setRightFieldItem(true);
                } else {
                    conditionRow = new HRComplexObjConditionRow(condition.getLeftProp(), condition.getRightPropVal());
                    conditionRow.setRightFieldItem(false);
                }
                conditionRow.setCompareOp(condition.getCompareType());
                conditionRow.setLogicOp(condition.getLogicType());
                conditionInfoList.add(conditionRow);
            }
            relationInfo.setCondition(conditionInfoList);
            joinRelationList.add(relationInfo);
        }
        context.setJoinRelationList(joinRelationList);
        return context;
    }
}

