/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.util.time;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.time.HRTimeWatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public final class CostTimeHelper {
    private final Log log;
    private final HRTimeWatch allTimeWatch;
    private final LinkedList<HRTimeWatch> nestedWatches = Lists.newLinkedList();
    private final Map<String, Long> timeCostMap = Maps.newHashMapWithExpectedSize((int)16);

    public static CostTimeHelper create() {
        return new CostTimeHelper();
    }

    public static CostTimeHelper createOnce() {
        return new CostTimeHelper(true);
    }

    public static CostTimeHelper create(Class<?> clazz) {
        return new CostTimeHelper(clazz);
    }

    public static CostTimeHelper createOnce(Class<?> clazz) {
        return new CostTimeHelper(clazz, true);
    }

    public void nestedStart() {
        this.nestedStart(true);
    }

    public void nestedStart(boolean isOnce) {
        HRTimeWatch nestedWatch = HRTimeWatch.createStarted(isOnce);
        this.nestedWatches.push(nestedWatch);
    }

    public long cost() {
        return this.cost(null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public long cost(String breakPointKey, boolean isContinue) {
        long costTime;
        HRTimeWatch watch = this.nestedWatches.peek();
        if (watch == null) {
            if (!this.allTimeWatch.isOnce()) {
                this.log.error("nestWatch is empty!");
                return 0L;
            }
            if (this.allTimeWatch.isStopped()) {
                this.log.error("CostTimeHelper is stop!");
                return 0L;
            }
            this.allTimeWatch.stop();
            costTime = this.allTimeWatch.getTime();
        } else {
            if (watch.isStopped()) {
                this.log.error("nestWatch is stop!");
                return 0L;
            }
            if (watch.isOnce()) {
                watch.stop();
                costTime = watch.getTime();
                this.nestedWatches.removeFirst();
            } else if (watch.isSplit()) {
                costTime = watch.getIntervalTime();
                watch.split();
                if (!isContinue) {
                    watch.stop();
                    this.nestedWatches.removeFirst();
                }
            } else {
                watch.split();
                costTime = watch.getSplitTime();
            }
        }
        if (HRStringUtils.isNotEmpty(breakPointKey)) {
            this.timeCostMap.put(breakPointKey, costTime);
        }
        return costTime;
    }

    public void logCost() {
        long costTime = this.cost();
        String costInfo = String.format("COST TIME\uff1a%d ms", costTime);
        if (costTime > 500L) {
            this.log.warn(costInfo);
        } else {
            this.log.info(costInfo);
        }
    }

    public void logCost(String breakPointKey) {
        this.logCost(breakPointKey, false, null);
    }

    public void logCost(String breakPointKey, boolean isContinue) {
        this.logCost(breakPointKey, isContinue, null);
    }

    public void logCost(String breakPointKey, String logDesc) {
        this.logCost(breakPointKey, false, logDesc);
    }

    public void logCost(String breakPointKey, boolean isContinue, String logDesc) {
        long costTime = this.cost(breakPointKey, isContinue);
        String costInfo = logDesc != null ? logDesc.concat(String.format(" [COST TIME\uff1a%d ms]", costTime)) : String.format(" [COST TIME\uff1a%d ms]", costTime);
        if (costTime > 500L) {
            this.log.warn(costInfo);
        } else {
            this.log.info(costInfo);
        }
    }

    public void logCostKey(String breakPointKey, boolean isContinue, String logDesc) {
        if (StringUtils.isBlank((CharSequence)breakPointKey)) {
            return;
        }
        long costTime = this.cost(breakPointKey, isContinue);
        String costInfo = String.format(" [%s]:", breakPointKey);
        costInfo = logDesc != null ? costInfo.concat(logDesc.concat(String.format(" [COST TIME\uff1a%d ms]", costTime))) : costInfo.concat(String.format(" [COST TIME\uff1a%d ms]", costTime));
        if (costTime > 500L) {
            this.log.warn(costInfo);
        } else {
            this.log.info(costInfo);
        }
    }

    public Map.Entry<String, Long> getMaxCost() {
        return this.timeCostMap.entrySet().stream().max((o1, o2) -> (int)((Long)o1.getValue() - (Long)o2.getValue())).orElse(null);
    }

    public String getMaxCostStr() {
        Map.Entry<String, Long> maxCost = this.getMaxCost();
        if (maxCost != null) {
            return MessageFormat.format("{0}_cost_max_time_is_{1}", maxCost.getKey(), maxCost.getValue());
        }
        return "time_watch_is_empty";
    }

    public List<Map.Entry<String, Long>> getCostTimeMap() {
        return this.timeCostMap.entrySet().stream().sorted((o1, o2) -> (int)((Long)o1.getValue() - (Long)o2.getValue())).collect(Collectors.toList());
    }

    public long getTotalCostTime() {
        return this.getTotalCostTime(false);
    }

    public long getTotalCostTime(boolean isStop) {
        long totalTime;
        if (isStop) {
            if (!this.allTimeWatch.isStopped()) {
                this.allTimeWatch.stop();
            }
            for (StopWatch stopWatch : this.nestedWatches) {
                if (stopWatch.isStopped()) continue;
                stopWatch.stop();
            }
            this.nestedWatches.clear();
            totalTime = this.allTimeWatch.getTime();
        } else {
            this.allTimeWatch.split();
            totalTime = this.allTimeWatch.getSplitTime();
        }
        return totalTime;
    }

    private CostTimeHelper() {
        this(true);
    }

    private CostTimeHelper(Class<?> clazz) {
        this(clazz, true);
    }

    private CostTimeHelper(boolean isOnce) {
        this(CostTimeHelper.class, isOnce);
    }

    private CostTimeHelper(Class<?> clazz, boolean isOnce) {
        this.allTimeWatch = HRTimeWatch.createStarted(isOnce);
        this.log = LogFactory.getLog(clazz);
    }
}

