/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.bgtask;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskSubscriber;
import kd.hr.hbp.business.bgtask.TaskResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRJSONUtils;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class HRBackgroundTaskHelper {
    private Log log = LogFactory.getLog(HRBackgroundTaskHelper.class);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"task-hrbackground-resume", (int)ZkConfig.getNumOfWorkThread());
    public static final String TASK_SERVICEAPP = "hbp";
    public static final String ENTITY_BGTASKREGISTER = "hrcs_bgtaskregister";
    public static final String ENTITY_BGTASKRECORD = "hrcs_bgtaskrecord";
    public static final String ENTITY_BGTASKSESSION = "hrcs_bgtasksession";
    public static final String HRBACKGROUND_TASKPROCESS = "hrbackgroundTask_%s_process";
    public static final String HRBACKGROUND_TASKPROGRESSPAGEID = "hrbackgroundTask_%s_progressPageId";
    private static final String SELECTPROPERTIES_BGTASKRECORD = "id,taskid,bgtaskregister,jobforminfo,taskstatus,isconfirm,isbackground,starttime,endtime,modifytime,modifier";
    private static final String SELECTPROPERTIES_BGTASKREGISTER = "id,number,name,bizapp,timeout,taskclassname,clickclassname,callbackclassname,actionid";

    private HRBackgroundTaskHelper() {
    }

    public static HRBackgroundTaskHelper getInstance() {
        HRBackgroundTaskHelper taskHelper = Holder.taskHelper;
        return taskHelper;
    }

    public String showBaskgroundTask(String bgTaskNumber, String name, boolean useBizTask, String rootPageId, String parentPageId, Map<String, Object> params) {
        DynamicObject bgTaskRegister = this.getBgTaskRegister(bgTaskNumber);
        JobFormInfo jobFormInfo = this.createJobFormInfo(bgTaskRegister, name, useBizTask, rootPageId, parentPageId, params);
        String taskId = this.addTask(jobFormInfo, bgTaskRegister, true);
        if (useBizTask) {
            this.feedbackProgress(taskId, 0, "", params);
        }
        this.createMonitor(taskId, jobFormInfo);
        return taskId;
    }

    public String createBaskgroundTask(String bgTaskNumber, String name, boolean useBizTask, String rootPageId, String parentPageId, Map<String, Object> params) {
        DynamicObject bgTaskRegister = this.getBgTaskRegister(bgTaskNumber);
        JobFormInfo jobFormInfo = this.createJobFormInfo(bgTaskRegister, name, useBizTask, rootPageId, parentPageId, params);
        String taskId = this.addTask(jobFormInfo, bgTaskRegister, false);
        if (useBizTask) {
            this.feedbackProgress(taskId, 0, "", params);
        }
        return taskId;
    }

    @Deprecated
    public String showBaskgroundTask(String bgTaskNumber, String name, boolean useBizTask, String parentPageId, Map<String, Object> params) {
        return this.showBaskgroundTask(bgTaskNumber, name, useBizTask, this.getRootPageId(parentPageId), parentPageId, params);
    }

    @Deprecated
    public String createBaskgroundTask(String bgTaskNumber, String name, boolean useBizTask, String parentPageId, Map<String, Object> params) {
        return this.createBaskgroundTask(bgTaskNumber, name, useBizTask, this.getRootPageId(parentPageId), parentPageId, params);
    }

    private String getRootPageId(String parentPageId) {
        if (parentPageId == null) {
            return null;
        }
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
        String rootPageId = null;
        if (view != null && view.getMainView() != null) {
            rootPageId = view.getMainView().getPageId();
        }
        return rootPageId;
    }

    public void showBaskgroundTask(String taskId) {
        DynamicObject bgTaskRecord = this.getBgTaskRecordByTaskId(taskId);
        if (bgTaskRecord == null) {
            return;
        }
        JobFormInfo jobFormInfo = this.getJobFormInfo(bgTaskRecord.getString("jobforminfo"));
        if (!bgTaskRecord.getBoolean("isbackground")) {
            HRBaseServiceHelper taskRecordHelper = new HRBaseServiceHelper(ENTITY_BGTASKRECORD);
            bgTaskRecord.set("isbackground", (Object)Boolean.TRUE);
            taskRecordHelper.saveOne(bgTaskRecord);
            this.createMonitor(taskId, jobFormInfo);
        }
    }

    private JobFormInfo createJobFormInfo(DynamicObject bgTaskRegister, String name, boolean useBizTask, String rootPageId, String parentPageId, Map<String, Object> params) {
        String taskClassName = bgTaskRegister.getString("taskclassname");
        String clickClassName = bgTaskRegister.getString("clickclassname");
        String callbackClassName = bgTaskRegister.getString("callbackclassname");
        String actionId = bgTaskRegister.getString("actionid");
        String appId = bgTaskRegister.getString("bizapp.number");
        int timeout = bgTaskRegister.getInt("timeout");
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(name);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setAppId(appId);
        jobInfo.setTaskClassname(taskClassName);
        if (params == null) {
            params = Maps.newHashMap();
        }
        params.put("useBizTask", useBizTask);
        jobInfo.setParams((Map)params);
        if (timeout > 0) {
            jobInfo.setTimeout(timeout);
        }
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setRootPageId(rootPageId);
        jobFormInfo.setParentPageId(parentPageId);
        jobFormInfo.setParams((Map)params);
        if (timeout > 0) {
            jobFormInfo.setTimeout(timeout);
        }
        jobFormInfo.setClickClassName(clickClassName);
        if (!StringUtils.isEmpty((String)callbackClassName)) {
            jobFormInfo.setCloseCallBack(new CloseCallBack(callbackClassName, actionId));
        }
        jobFormInfo.setCanBackground(true);
        return jobFormInfo;
    }

    private String addTask(JobFormInfo jobFormInfo, DynamicObject bgTaskRegister, boolean isBackground) {
        if (jobFormInfo == null) {
            return "";
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.createNewBgTaskRecord(taskId, bgTaskRegister, jobFormInfo, isBackground);
        return taskId;
    }

    private void createMonitor(String taskId, JobFormInfo jobFormInfo) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(taskId);
        taskInfo.setProgress(0);
        taskInfo.setStatus("RUNNING");
        taskInfo.setDesc(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5df2\u5c31\u7eea", (String)"HRBackgroundTaskHelper_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), jobFormInfo.getJobInfo().getName()));
        TaskClientProxy.addTask((JobFormInfo)jobFormInfo, (TaskInfo)taskInfo, null);
        HRBackgroundTaskSubscriber subscriber = new HRBackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
        ThreadPools.executeOnce((String)"task-hrbackground-monitor", (Runnable)subscriber);
        this.addTaskSession(taskId, RequestContext.get().getGlobalSessionId());
    }

    private DynamicObject createNewBgTaskRecord(String taskId, DynamicObject bgTaskRegister, JobFormInfo jobforminfo, boolean isBackground) {
        HRBaseServiceHelper taskRecordHelper = new HRBaseServiceHelper(ENTITY_BGTASKRECORD);
        Date nowDate = new Date();
        DynamicObject taskRecord = taskRecordHelper.generateEmptyDynamicObject();
        taskRecord.set("starttime", (Object)nowDate);
        taskRecord.set("taskstatus", (Object)"RUNNING");
        taskRecord.set("bgtaskregister", (Object)bgTaskRegister.getLong("id"));
        taskRecord.set("taskid", (Object)taskId);
        try {
            taskRecord.set("jobforminfo", (Object)HRJSONUtils.toString((Object)jobforminfo));
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        taskRecord.set("starttime", (Object)nowDate);
        taskRecord.set("isbackground", (Object)isBackground);
        taskRecord.set("createtime", (Object)nowDate);
        taskRecord.set("modifytime", (Object)nowDate);
        taskRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        taskRecord.set("modifier", (Object)RequestContext.get().getCurrUserId());
        taskRecordHelper.saveOne(taskRecord);
        return taskRecord;
    }

    public void buildTaskInfo(TaskInfo taskInfo, String name, String taskStatus) {
        taskInfo.setStatus(taskStatus);
        if ("ABORTED".equals(taskStatus)) {
            taskInfo.setDesc(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5df2\u7ec8\u6b62", (String)"HRBackgroundTaskHelper_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), name));
        } else if ("COMPLETED".equals(taskStatus)) {
            taskInfo.setDesc(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5df2\u5b8c\u6210", (String)"HRBackgroundTaskHelper_4", (String)"hrmp-hbp-business", (Object[])new Object[0]), name));
        } else if ("TIMEOUT".equals(taskStatus)) {
            taskInfo.setDesc(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5df2\u8d85\u65f6", (String)"HRBackgroundTaskHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), name));
        } else if ("FAILED".equals(taskStatus)) {
            taskInfo.setDesc(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5df2\u5931\u8d25", (String)"HRBackgroundTaskHelper_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), name));
        }
    }

    public void updateTaskRecordStatus(DynamicObject bgTaskRecord, String taskStatus, boolean isConfirm) {
        HRBaseServiceHelper taskRecordHelper = new HRBaseServiceHelper(ENTITY_BGTASKRECORD);
        Date nowDate = new Date();
        if (!StringUtils.isEmpty((String)taskStatus)) {
            bgTaskRecord.set("taskstatus", (Object)taskStatus);
        }
        if (isConfirm) {
            bgTaskRecord.set("isconfirm", (Object)Boolean.TRUE);
            bgTaskRecord.set("endtime", (Object)nowDate);
        }
        bgTaskRecord.set("modifytime", (Object)nowDate);
        bgTaskRecord.set("modifier", (Object)RequestContext.get().getCurrUserId());
        taskRecordHelper.saveOne(bgTaskRecord);
    }

    public void confirmEndTask(String taskId, String taskStatus) {
        this.confirmEndTask(taskId, taskStatus, true);
    }

    public void confirmEndTask(String taskId, String taskStatus, boolean delTask) {
        DynamicObject bgTaskRecord = this.getBgTaskRecordByTaskId(taskId);
        this.updateTaskRecordStatus(bgTaskRecord, taskStatus, true);
        this.deleteTaskSession(taskId);
        if (delTask) {
            TaskClientProxy.delTask((JobFormInfo)this.getJobFormInfo(bgTaskRecord.getString("jobforminfo")), (String)taskId, null);
        }
    }

    public void endTask(String taskId, String status) {
        DynamicObject bgTaskRecord = this.getBgTaskRecordByTaskId(taskId);
        this.updateTaskRecordStatus(bgTaskRecord, status, false);
    }

    private void deleteTaskSession(String taskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_BGTASKSESSION);
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public DynamicObject getBgTaskRecordByTaskId(String taskId) {
        HRBaseServiceHelper taskRecordHelper = new HRBaseServiceHelper(ENTITY_BGTASKRECORD);
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject bgTaskRecord = taskRecordHelper.queryOne(SELECTPROPERTIES_BGTASKRECORD, new QFilter[]{filter});
        return bgTaskRecord;
    }

    public JobFormInfo getJobFormInfo(String jobforminfo) {
        JobFormInfo jobFormInfo = null;
        try {
            jobFormInfo = (JobFormInfo)HRJSONUtils.cast((String)jobforminfo, JobFormInfo.class);
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return jobFormInfo;
    }

    public JobFormInfo getJobFormInfoByTaskId(String taskId) {
        DynamicObject bgTaskRecord = this.getBgTaskRecordByTaskId(taskId);
        if (bgTaskRecord == null) {
            return null;
        }
        return this.getJobFormInfo(bgTaskRecord.getString("jobforminfo"));
    }

    private DynamicObject getBgTaskRegister(String number) {
        HRBaseServiceHelper bgTaskRegisterHelper = new HRBaseServiceHelper(ENTITY_BGTASKREGISTER);
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject bgTaskRegister = bgTaskRegisterHelper.queryOne(SELECTPROPERTIES_BGTASKREGISTER, new QFilter[]{filter});
        return bgTaskRegister;
    }

    public void addTaskSession(String taskId, String sessionId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_BGTASKSESSION);
        DynamicObject bgTaskSession = helper.generateEmptyDynamicObject();
        Date nowDate = new Date();
        bgTaskSession.set("taskid", (Object)taskId);
        bgTaskSession.set("globalsessionid", (Object)sessionId);
        bgTaskSession.set("isstop", (Object)Boolean.FALSE);
        bgTaskSession.set("createtime", (Object)nowDate);
        bgTaskSession.set("modifytime", (Object)nowDate);
        bgTaskSession.set("creator", (Object)RequestContext.get().getCurrUserId());
        bgTaskSession.set("modifier", (Object)RequestContext.get().getCurrUserId());
        helper.saveOne(bgTaskSession);
    }

    public void feedbackProgress(String taskId, int progress, String desc, Map<String, Object> customData) {
        TaskInfo taskInfo;
        String key = String.format(Locale.ROOT, HRBACKGROUND_TASKPROCESS, taskId);
        IHRAppCache appCache = HRAppCache.get((String)TASK_SERVICEAPP);
        String taskResultString = (String)appCache.get(key, String.class);
        TaskResult taskResult = null;
        if (!StringUtils.isEmpty((String)taskResultString)) {
            taskResult = (TaskResult)SerializationUtils.deSerializeFromBase64((String)taskResultString);
        }
        if (taskResult == null) {
            taskInfo = new TaskInfo();
            taskResult = new TaskResult(taskInfo, customData);
        } else {
            taskInfo = taskResult.getTaskInfo();
            taskResult.setCustomData(customData);
        }
        taskInfo.setId(taskId);
        if (progress >= 100) {
            taskInfo.setStatus("COMPLETED");
            this.endTask(taskId, "COMPLETED");
        }
        taskInfo.setProgress(progress);
        taskInfo.setDesc(desc);
        taskInfo.setRunTime(System.currentTimeMillis());
        appCache.put(key, (Object)SerializationUtils.serializeToBase64((Object)taskResult));
    }

    public void feedbackStatus(String taskId, String status, String desc, Map<String, Object> customData) {
        TaskInfo taskInfo;
        String key = String.format(Locale.ROOT, HRBACKGROUND_TASKPROCESS, taskId);
        IHRAppCache appCache = HRAppCache.get((String)TASK_SERVICEAPP);
        String taskResultString = (String)appCache.get(key, String.class);
        TaskResult taskResult = null;
        if (!StringUtils.isEmpty((String)taskResultString)) {
            taskResult = (TaskResult)SerializationUtils.deSerializeFromBase64((String)taskResultString);
        }
        if (taskResult == null) {
            taskInfo = new TaskInfo();
            taskResult = new TaskResult(taskInfo, customData);
        } else {
            taskInfo = taskResult.getTaskInfo();
            taskResult.setCustomData(customData);
        }
        taskInfo.setId(taskId);
        if ("COMPLETED".equals(status)) {
            taskInfo.setProgress(100);
            this.endTask(taskId, status);
        } else if (TaskStatusConstant.isEnd((String)status)) {
            this.endTask(taskId, status);
        }
        taskInfo.setStatus(status);
        taskInfo.setDesc(desc);
        taskInfo.setRunTime(System.currentTimeMillis());
        appCache.put(key, (Object)SerializationUtils.serializeToBase64((Object)taskResult));
    }

    public TaskResult getBizTaskResult(String taskId) {
        String key = String.format(Locale.ROOT, HRBACKGROUND_TASKPROCESS, taskId);
        IHRAppCache appCache = HRAppCache.get((String)TASK_SERVICEAPP);
        String taskResultString = (String)appCache.get(key, String.class);
        TaskResult taskResult = null;
        if (!StringUtils.isEmpty((String)taskResultString)) {
            taskResult = (TaskResult)SerializationUtils.deSerializeFromBase64((String)taskResultString);
        }
        if (taskResult == null) {
            TaskInfo taskInfo = this.buildTaskInfoByTaskRecord(taskId);
            taskResult = new TaskResult(taskInfo, null);
            this.feedbackStatus(taskInfo.getId(), taskInfo.getStatus(), taskInfo.getDesc(), null);
        }
        return taskResult;
    }

    private TaskInfo buildTaskInfoByTaskRecord(String taskId) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(taskId);
        DynamicObject bgTaskRecord = this.getBgTaskRecordByTaskId(taskId);
        String taskStatus = bgTaskRecord.getString("taskstatus");
        JobFormInfo jobFormInfo = this.getJobFormInfo(bgTaskRecord.getString("jobforminfo"));
        String name = jobFormInfo.getJobInfo().getName();
        if (TaskStatusConstant.isEnd((String)taskStatus)) {
            this.buildTaskInfo(taskInfo, name, taskStatus);
        } else {
            Date modifyTime = bgTaskRecord.getDate("modifytime");
            long time = modifyTime == null ? 0L : modifyTime.getTime();
            long timeout_MS = 1000 * jobFormInfo.getTimeout();
            if (time == 0L || time + timeout_MS < System.currentTimeMillis()) {
                taskStatus = "TIMEOUT";
                this.buildTaskInfo(taskInfo, name, taskStatus);
            }
        }
        return taskInfo;
    }

    public TaskResult getTaskResult(String taskId) {
        TaskResult taskResult;
        if (this.getUseBizTaskByTaskId(taskId)) {
            taskResult = this.getBizTaskResult(taskId);
        } else {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            JSONObject customData = null;
            if (taskInfo != null && StringUtils.isNotBlank((String)taskInfo.getData())) {
                try {
                    customData = JSONObject.fromObject((Object)taskInfo.getData());
                }
                catch (Exception ex) {
                    this.log.error((Throwable)ex);
                }
            }
            taskResult = new TaskResult(taskInfo, (Map<String, Object>)customData);
        }
        return taskResult;
    }

    public TaskInfo getTaskInfo(String taskId) {
        TaskResult taskResult = this.getTaskResult(taskId);
        return taskResult.getTaskInfo();
    }

    public boolean getUseBizTask(JobFormInfo jobFormInfo) {
        if (jobFormInfo != null) {
            return MapUtils.getBoolean((Map)jobFormInfo.getParams(), (Object)"useBizTask");
        }
        return false;
    }

    public boolean getUseBizTaskByTaskId(String taskId) {
        JobFormInfo jobFormInfo = this.getJobFormInfoByTaskId(taskId);
        if (jobFormInfo == null) {
            return false;
        }
        return this.getUseBizTask(jobFormInfo);
    }

    public void setProgressPageId(IFormView mainView, String taskId, String progressPageId) {
        HRPageCache pageCache = new HRPageCache(mainView);
        String key = String.format(Locale.ROOT, HRBACKGROUND_TASKPROGRESSPAGEID, taskId);
        pageCache.put(key, (Object)progressPageId);
    }

    public String getProgressPageId(IFormView mainView, String taskId) {
        HRPageCache pageCache = new HRPageCache(mainView);
        String key = String.format(Locale.ROOT, HRBACKGROUND_TASKPROGRESSPAGEID, taskId);
        return (String)pageCache.get(key, String.class);
    }

    public void removeProgressPageId(IFormView mainView, String taskId) {
        HRPageCache pageCache = new HRPageCache(mainView);
        String key = String.format(Locale.ROOT, HRBACKGROUND_TASKPROGRESSPAGEID, taskId);
        pageCache.remove(key);
    }

    public Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (taskInfo != null) {
            String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
            result.put("taskinfo", taskInfoStr);
            result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        }
        return result;
    }

    private static class Holder {
        private static HRBackgroundTaskHelper taskHelper = new HRBackgroundTaskHelper();

        private Holder() {
        }
    }
}

