/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.cache.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.cache.IHBPCache;
import kd.hr.hbp.common.cache.HRAppCache;

public class HBPCacheImpl
implements IHBPCache {
    protected String appKey;
    protected String cacheKey;
    protected String entityName;
    protected String field_key = "key";
    protected String field_value = "value";

    public HBPCacheImpl(String appKey, String cacheKey) {
        this.appKey = appKey;
        this.cacheKey = cacheKey;
        this.entityName = cacheKey;
    }

    public HBPCacheImpl(String appKey, String cacheKey, String key, String value) {
        this.appKey = appKey;
        this.cacheKey = cacheKey;
        this.entityName = cacheKey;
        this.field_key = key;
        this.field_value = value;
    }

    public HBPCacheImpl(String appKey, String cacheKey, String entityName) {
        this.appKey = appKey;
        this.cacheKey = cacheKey;
        this.entityName = entityName;
    }

    public HBPCacheImpl(String appKey, String cacheKey, String entityName, String key, String value) {
        this.appKey = appKey;
        this.cacheKey = cacheKey;
        this.entityName = entityName;
        this.field_key = key;
        this.field_value = value;
    }

    @Override
    public void initCache() {
        Map<String, String> map = this.getCacheFromDB(null);
        HRAppCache.get((String)this.appKey).put(this.cacheKey, map);
    }

    @Override
    public String getValue(String key) {
        Map<String, String> cacheMap = (Map<String, String>)HRAppCache.get((String)this.appKey).get(this.cacheKey, Map.class);
        if (cacheMap == null || cacheMap.size() == 0) {
            cacheMap = this.getCacheFromDB(null);
            this.updateCache(cacheMap);
        } else if (!cacheMap.containsKey(key)) {
            QFilter filter = new QFilter(this.field_key, "=", (Object)key);
            cacheMap = this.getCacheFromDB(filter);
            this.updateCache(cacheMap);
        }
        return cacheMap.get(key) != null ? cacheMap.get(key) : "";
    }

    private void updateCache(Map<String, String> cacheMap) {
        if (cacheMap != null && cacheMap.size() > 0) {
            HRAppCache.get((String)this.appKey).put(this.cacheKey, cacheMap);
        }
    }

    private Map<String, String> getCacheFromDB(QFilter filter) {
        String selectFields = this.field_key + "," + this.field_value;
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        if (filter != null) {
            filter.and(enableFilter);
        }
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection cacheColl = QueryServiceHelper.query((String)this.entityName, (String)selectFields, (QFilter[])filters, (String)"number");
        HashMap<String, String> map = new HashMap<String, String>(cacheColl.size());
        int size = cacheColl.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject cacheDy = (DynamicObject)cacheColl.get(i);
            String key = cacheDy.getString(this.field_key);
            String value = cacheDy.getString(this.field_value);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void cleanCache(String key) {
        Map cacheMap = (Map)HRAppCache.get((String)this.appKey).get(this.cacheKey, Map.class);
        if (cacheMap.containsKey(key)) {
            cacheMap.remove(key);
            HRAppCache.get((String)this.appKey).put(this.cacheKey, (Object)cacheMap);
        }
    }

    @Override
    public void cleanCacheAll() {
        HRAppCache.get((String)this.appKey).put(this.cacheKey, new HashMap());
    }

    @Override
    public void updateCache(String key, String value) {
        HashMap<String, String> cacheMap = (HashMap<String, String>)HRAppCache.get((String)this.appKey).get(this.cacheKey, Map.class);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, String>();
        }
        cacheMap.put(key, value);
        HRAppCache.get((String)this.appKey).put(this.cacheKey, cacheMap);
    }

    @Override
    public void refreshCache() {
        this.cleanCacheAll();
        this.initCache();
    }
}

