/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.model.newhismodel.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBusinessBo;
import kd.hr.hbp.business.domain.model.newhismodel.bubasedata.HisCalcPersonalDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSyncStatusEntityDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSyncStatusParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSyncStatusResponseBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.bo.HisEntitySyncStatusParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.bo.HisEntitySyncStatusResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.bo.HisEntitySyncStatusValidateResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.bo.HisEntityValidateErrorMsgBo;
import kd.hr.hbp.business.domain.model.newhismodel.writeback.HisWriteBackCurrentBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisSyncDataStatusRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisModelEventService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.personal.HisPersonalDataService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.writeback.HisWriteBackCurrentService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class HisSynDataStatusServicerHelper {
    private static final Log LOGGER = LogFactory.getLog(HisSynDataStatusServicerHelper.class);
    public static final String IS_CURRENT_VERSION = "iscurrentversion";
    public static final String BOID = "boid";
    private static final int MAX_FETCH_BOID = 1000;

    @Deprecated
    public static Map<String, DynamicObject[]> synBaseData(List<String> appIds) {
        HRBaseServiceHelper metaHelper = new HRBaseServiceHelper("bos_entitymeta");
        QFilter hisBuSideTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbusidetimeseqtpl");
        QFilter hisBuTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbutimeseqtpl");
        QFilter hisTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_histimeseqtpl");
        QFilter hisBuGrpTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbugrptimeseqtpl");
        QFilter hisGrpTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisgrptimeseqtpl");
        QFilter hisBuTreeTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbutreetimeseqtpl");
        QFilter hisTreeTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_histreetimeseqtpl");
        QFilter oriminTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_orimintimeseqtpl");
        QFilter oriTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_oritimeseqtpl");
        HashMap<String, DynamicObject[]> map = new HashMap<String, DynamicObject[]>();
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, hisBuSideTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, hisBuTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, hisTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, hisBuGrpTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, hisGrpTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, hisBuTreeTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, hisTreeTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, oriminTimeSeqFilter, map);
        HisSynDataStatusServicerHelper.batchProcessData(metaHelper, appIds, oriTimeSeqFilter, map);
        return map;
    }

    public static HrApiResponse<HisSyncStatusResponseBo> synByBo(HisSyncStatusParamBo hisSyncStatusParamBo) {
        HRBaseServiceHelper metaHelper = new HRBaseServiceHelper("bos_entitymeta");
        QFilter hisBuGrpTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbugrptimeseqtpl");
        QFilter hisGrpTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisgrptimeseqtpl");
        QFilter hisBuSideTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbusidetimeseqtpl");
        QFilter hisBuTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbutimeseqtpl");
        QFilter hisTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_histimeseqtpl");
        QFilter oriminTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_orimintimeseqtpl");
        QFilter oriTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_oritimeseqtpl");
        QFilter hisBuTreeTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_hisbutreetimeseqtpl");
        QFilter hisTreeTimeSeqFilter = new QFilter("number", "=", (Object)"hbp_histreetimeseqtpl");
        List<HisSyncStatusEntityDataBo> hisSyncStatusEntityDataBoList = HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, hisBuSideTimeSeqFilter);
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, hisBuTimeSeqFilter));
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, hisTimeSeqFilter));
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, hisBuGrpTimeSeqFilter));
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, hisGrpTimeSeqFilter));
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, hisBuTreeTimeSeqFilter));
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, hisTreeTimeSeqFilter));
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, oriminTimeSeqFilter));
        hisSyncStatusEntityDataBoList.addAll(HisSynDataStatusServicerHelper.batchProcessData(metaHelper, hisSyncStatusParamBo, oriTimeSeqFilter));
        HrApiResponse response = new HrApiResponse();
        HisSyncStatusResponseBo hisSyncStatusResponseBo = new HisSyncStatusResponseBo();
        hisSyncStatusResponseBo.setHisSyncStatusEntityDataBoList(hisSyncStatusEntityDataBoList);
        response.setData((Object)hisSyncStatusResponseBo);
        return response;
    }

    public static HisSyncStatusEntityDataBo processData(String entityNumber, List<Long> excludeBoId, Map<String, DynamicObject[]> map) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        HisSyncStatusEntityDataBo hisSyncStatusEntityDataBo = new HisSyncStatusEntityDataBo();
        hisSyncStatusEntityDataBo.setEntityNumber(entityNumber);
        hisSyncStatusEntityDataBo.setBoIds(Lists.newArrayListWithExpectedSize((int)256));
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            if (StringUtils.isEmpty((CharSequence)dataEntityType.getAlias())) {
                return hisSyncStatusEntityDataBo;
            }
            DataSet dataSet = HisSyncDataStatusRepository.getInstance().getNeedSyncVersionDataSet(serviceHelper);
            ArrayList boIdList = Lists.newArrayListWithExpectedSize((int)10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                boIdList.add(row.getLong(BOID));
                if (boIdList.size() != 1000) continue;
                HisSynDataStatusServicerHelper.processData(boIdList, serviceHelper, excludeBoId, map, hisSyncStatusEntityDataBo);
                boIdList = Lists.newArrayListWithExpectedSize((int)10);
            }
            if (CollectionUtils.isNotEmpty((Collection)boIdList)) {
                HisSynDataStatusServicerHelper.processData(boIdList, serviceHelper, excludeBoId, map, hisSyncStatusEntityDataBo);
            }
        }
        catch (Exception exception) {
            LOGGER.error("processData:entityNumber={}", (Object)entityNumber, (Object)exception);
        }
        return hisSyncStatusEntityDataBo;
    }

    private static void processData(List<Long> boIdList, HRBaseServiceHelper serviceHelper, List<Long> excludeBoId, Map<String, DynamicObject[]> map, HisSyncStatusEntityDataBo hisSyncStatusEntityDataBo) {
        boIdList.removeIf(excludeBoId::contains);
        List<Long> successBoIdList = HisSynDataStatusServicerHelper.processData(boIdList, serviceHelper, map);
        if (CollectionUtils.isNotEmpty(successBoIdList)) {
            hisSyncStatusEntityDataBo.getBoIds().addAll(successBoIdList);
        }
    }

    private static HisSyncStatusEntityDataBo processData(String entityNumber, Map<String, DynamicObject[]> map) {
        return HisSynDataStatusServicerHelper.processData(entityNumber, Lists.newArrayList(), map);
    }

    private static List<HisSyncStatusEntityDataBo> batchProcessData(HRBaseServiceHelper metaHelper, List<String> appIds, QFilter parentFilter, Map<String, DynamicObject[]> map) {
        DynamicObject[] dynResults = HisSyncDataStatusRepository.getInstance().getEntityMata(metaHelper, appIds, parentFilter);
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)dynResults.length);
        Set<String> excludeEntities = HisSynDataStatusServicerHelper.getExcludeEntitiesByDependent();
        for (DynamicObject dyn : dynResults) {
            if (excludeEntities.contains(dyn.getString("id"))) continue;
            HisSyncStatusEntityDataBo bo = HisSynDataStatusServicerHelper.processData(dyn.getString("number"), map);
            boList.add(bo);
        }
        return boList;
    }

    private static List<HisSyncStatusEntityDataBo> batchProcessData(HRBaseServiceHelper metaHelper, HisSyncStatusParamBo hisSyncStatusParamBo, QFilter parentFilter) {
        List<String> appIds = hisSyncStatusParamBo.getAppIds();
        List<String> ignoreEntities = hisSyncStatusParamBo.getIgnoreEntities();
        Map<String, List<Long>> excludeBoIdMap = hisSyncStatusParamBo.getExcludeBoIdMap();
        DynamicObject[] entities = HisSyncDataStatusRepository.getInstance().getEntityMata(metaHelper, appIds, parentFilter);
        DynamicObjectCollection filteredDynCol = new DynamicObjectCollection();
        DynamicObject[] taskConfigs = HisSynDataStatusServicerHelper.getTaskConfigs(appIds);
        Set<String> excludeEntities = HisSynDataStatusServicerHelper.getExcludeEntities(taskConfigs);
        ignoreEntities.addAll(excludeEntities);
        for (DynamicObject entity : entities) {
            String entityNumber = entity.getString("number");
            if (ignoreEntities.contains(entityNumber)) continue;
            filteredDynCol.add((Object)entity);
        }
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)filteredDynCol.size());
        Map<String, List<DynamicObject>> serviceMap = HisSynDataStatusServicerHelper.getServiceMap(taskConfigs);
        HashMap validateResultBoMap = Maps.newHashMapWithExpectedSize((int)filteredDynCol.size());
        for (DynamicObject dyn : filteredDynCol) {
            ArrayList excludeBoIdList;
            String entityNum = dyn.getString("number");
            HisEntitySyncStatusValidateResultBo validateResultBo = HisSynDataStatusServicerHelper.validateBusiness(entityNum, serviceMap);
            List<Object> list = excludeBoIdList = excludeBoIdMap.get(entityNum) == null ? Lists.newArrayListWithExpectedSize((int)10) : excludeBoIdMap.get(entityNum);
            if (validateResultBo != null) {
                validateResultBoMap.put(entityNum, validateResultBo);
                List<HisEntityValidateErrorMsgBo> hisEntityValidateErrorMsgBoList = validateResultBo.getHisEntityValidateErrorMsgBoList();
                for (HisEntityValidateErrorMsgBo hisEntityValidateErrorMsgBo : hisEntityValidateErrorMsgBoList) {
                    excludeBoIdList.add(hisEntityValidateErrorMsgBo.getBoId());
                }
            }
            HisSyncStatusEntityDataBo bo = HisSynDataStatusServicerHelper.processData(dyn.getString("number"), excludeBoIdList, null);
            boList.add(bo);
        }
        HisSynDataStatusServicerHelper.writeErrorLog(validateResultBoMap);
        return boList;
    }

    private static HisEntitySyncStatusValidateResultBo validateBusiness(String entityNum, Map<String, List<DynamicObject>> serviceMap) {
        List<DynamicObject> serviceList = serviceMap.get(entityNum);
        HisEntitySyncStatusValidateResultBo bo = null;
        if (!CollectionUtils.isEmpty(serviceList)) {
            for (DynamicObject dynamicObject : serviceList) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject service : dynamicObjectCollection) {
                    if (!HRStringUtils.equals((String)entityNum, (String)service.getString("entity.id"))) continue;
                    String cloud = dynamicObject.getString("bizapp.bizcloud.number");
                    String app = dynamicObject.getString("bizapp.number");
                    String serviceName = service.getString("entityservice");
                    String method = service.getString("entitymethod");
                    if (HRStringUtils.isEmpty((String)method)) {
                        method = "validate";
                    }
                    HisEntitySyncStatusParamBo hisEntitySyncStatusParamBo = new HisEntitySyncStatusParamBo();
                    hisEntitySyncStatusParamBo.setEntityNumberList(Lists.newArrayList((Object[])new String[]{entityNum}));
                    HrApiResponse response = (HrApiResponse)HRMServiceHelper.invokeBizService(cloud.toLowerCase(), app, serviceName, method, hisEntitySyncStatusParamBo);
                    HisEntitySyncStatusResultBo data = (HisEntitySyncStatusResultBo)response.getData();
                    List<HisEntitySyncStatusValidateResultBo> hisEntitySyncStatusValidateResultBoList = data.getHisEntitySyncStatusValidateResultBoList();
                    HisEntitySyncStatusValidateResultBo hisEntitySyncStatusValidateResultBo = hisEntitySyncStatusValidateResultBoList.get(0);
                    if (bo == null) {
                        bo = hisEntitySyncStatusValidateResultBo;
                        continue;
                    }
                    List<HisEntityValidateErrorMsgBo> hisEntityValidateErrorMsgBoList = bo.getHisEntityValidateErrorMsgBoList();
                    hisEntityValidateErrorMsgBoList.addAll(hisEntitySyncStatusValidateResultBo.getHisEntityValidateErrorMsgBoList());
                }
            }
        }
        return bo;
    }

    public static void writeErrorLog(Map<String, HisEntitySyncStatusValidateResultBo> validateResultBoMap) {
        DynamicObjectCollection updateCol = new DynamicObjectCollection();
        DynamicObjectCollection insertCol = new DynamicObjectCollection();
        ArrayList deleteIdList = Lists.newArrayListWithExpectedSize((int)validateResultBoMap.size());
        HashMap entityBOMap = Maps.newHashMapWithExpectedSize((int)validateResultBoMap.size());
        for (Map.Entry<String, HisEntitySyncStatusValidateResultBo> entry : validateResultBoMap.entrySet()) {
            for (HisEntityValidateErrorMsgBo bo : entry.getValue().getHisEntityValidateErrorMsgBoList()) {
                String string = entry.getKey();
                Set boIdSet = entityBOMap.getOrDefault(string, Sets.newHashSetWithExpectedSize((int)validateResultBoMap.size()));
                boIdSet.add(bo.getBoId());
                entityBOMap.put(string, boIdSet);
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_hissyncerror");
        DynamicObject[] errorResults = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("entitynumber", "in", validateResultBoMap.keySet())});
        HashMap entityBODBMap = Maps.newHashMapWithExpectedSize((int)errorResults.length);
        for (DynamicObject errorResult : errorResults) {
            String entityNumber = errorResult.getString("entitynumber");
            long boId = errorResult.getLong(BOID);
            Set boIdSet = entityBODBMap.getOrDefault(entityNumber, Sets.newHashSetWithExpectedSize((int)errorResults.length));
            boIdSet.add(boId);
            entityBODBMap.put(entityNumber, boIdSet);
            HisEntitySyncStatusValidateResultBo hisEntitySyncStatusValidateResultBo = validateResultBoMap.get(entityNumber);
            if (hisEntitySyncStatusValidateResultBo == null || hisEntitySyncStatusValidateResultBo.getHisEntityValidateErrorMsgBoList().isEmpty()) {
                deleteIdList.add(errorResult.getLong("id"));
                continue;
            }
            Set nowBoIdSet = (Set)entityBOMap.get(entityNumber);
            for (HisEntityValidateErrorMsgBo hisEntityValidateErrorMsgBo : hisEntitySyncStatusValidateResultBo.getHisEntityValidateErrorMsgBoList()) {
                if (boId == hisEntityValidateErrorMsgBo.getBoId()) {
                    errorResult.set("errormsg", (Object)hisEntityValidateErrorMsgBo.getErrorMsg());
                    updateCol.add((Object)errorResult);
                    continue;
                }
                if (nowBoIdSet.contains(boId)) continue;
                deleteIdList.add(errorResult.getLong("id"));
            }
        }
        for (Map.Entry entry : validateResultBoMap.entrySet()) {
            if (!entityBODBMap.containsKey(entry.getKey())) {
                for (HisEntityValidateErrorMsgBo bo : ((HisEntitySyncStatusValidateResultBo)entry.getValue()).getHisEntityValidateErrorMsgBoList()) {
                    DynamicObject error = HisSynDataStatusServicerHelper.buildErrorDyn(serviceHelper, (String)entry.getKey(), bo.getBoId(), bo.getErrorMsg());
                    insertCol.add((Object)error);
                }
                continue;
            }
            Set dbBoIdSet = (Set)entityBODBMap.get(entry.getKey());
            for (HisEntityValidateErrorMsgBo bo : ((HisEntitySyncStatusValidateResultBo)entry.getValue()).getHisEntityValidateErrorMsgBoList()) {
                Long boId = bo.getBoId();
                if (dbBoIdSet.contains(boId)) continue;
                DynamicObject error = HisSynDataStatusServicerHelper.buildErrorDyn(serviceHelper, (String)entry.getKey(), bo.getBoId(), bo.getErrorMsg());
                insertCol.add((Object)error);
            }
        }
        serviceHelper.delete(deleteIdList.toArray());
        serviceHelper.save(updateCol);
        serviceHelper.save(insertCol);
    }

    private static DynamicObject buildErrorDyn(HRBaseServiceHelper serviceHelper, String entityNumber, Long boId, String errorMsg) {
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("entitynumber", (Object)entityNumber);
        dynamicObject.set(BOID, (Object)boId);
        dynamicObject.set("errormsg", (Object)errorMsg);
        dynamicObject.set("processstatus", (Object)Character.valueOf('1'));
        return dynamicObject;
    }

    private static List<Long> processData(List<Long> partitionList, HRBaseServiceHelper serviceHelper, Map<String, DynamicObject[]> map) {
        if (CollectionUtils.isEmpty(partitionList)) {
            return null;
        }
        String entityNumber = serviceHelper.getEntityName();
        DynamicObject[] dyCurrentAndVersions = HisCommonEntityRepository.loadOldEffDataByBoIds(serviceHelper, new HashSet<Long>(partitionList));
        if (dyCurrentAndVersions == null || dyCurrentAndVersions.length == 0) {
            LOGGER.info("processData error: can not find current version.");
            return null;
        }
        List<DynamicObject> dyCurrentAndVersionList = HisSynDataStatusServicerHelper.filterData(dyCurrentAndVersions);
        if (CollectionUtils.isEmpty(dyCurrentAndVersionList)) {
            return null;
        }
        ArrayList<DynamicObject> dyVersionList = new ArrayList<DynamicObject>(partitionList.size());
        ArrayList<DynamicObject> dyCurrentList = new ArrayList<DynamicObject>(partitionList.size());
        for (DynamicObject dynamicObject2 : dyCurrentAndVersionList) {
            boolean isCurrentVersion = dynamicObject2.getBoolean(IS_CURRENT_VERSION);
            if (isCurrentVersion) {
                dyCurrentList.add(dynamicObject2);
                continue;
            }
            dyVersionList.add(dynamicObject2);
        }
        if (CollectionUtils.isEmpty(dyCurrentList) || CollectionUtils.isEmpty(dyVersionList)) {
            LOGGER.info("processData error: data error! Only have current version or version.");
            return null;
        }
        Map<Long, List<DynamicObject>> mapBoIdGroupAllVersion = dyVersionList.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong(BOID)));
        LOGGER.info("queryDyns:mapBoIdGroupAllVersion.length\uff1a{}", (Object)mapBoIdGroupAllVersion.size());
        HisTransBo hisTransBo = new HisTransBo();
        HisCalcPersonalDataBo hisCalcPersonalDataBo = new HisCalcPersonalDataBo(serviceHelper, entityNumber, null, mapBoIdGroupAllVersion);
        hisCalcPersonalDataBo.setHisTransBo(hisTransBo);
        HisPersonalDataService.getInstance().batchCalcPersonalData(hisCalcPersonalDataBo);
        DynamicObject[] dyCurrents = dyCurrentList.toArray(new DynamicObject[dyCurrentList.size()]);
        HisWriteBackCurrentBo hisWriteBackCurrentBo = new HisWriteBackCurrentBo(entityNumber, mapBoIdGroupAllVersion, dyCurrentList, null);
        List<DynamicObject> updateStatusVersionList = HisWriteBackCurrentService.getInstance().WriteBackCurrentVersion(hisWriteBackCurrentBo, false);
        if (CollectionUtils.isEmpty(updateStatusVersionList)) {
            return null;
        }
        DynamicObject[] needUpdateVersions = updateStatusVersionList.toArray(new DynamicObject[updateStatusVersionList.size()]);
        try (TXHandle txHandle = TX.required();){
            try {
                serviceHelper.save(dyCurrents);
                Date effDate = new Date();
                for (DynamicObject dynamicObject3 : needUpdateVersions) {
                    String dataStatus = dynamicObject3.getString("datastatus");
                    Date realEffEndDate = dynamicObject3.getDate("brled");
                    if (!EnumHisDataVersionStatus.INVALIDED.getStatus().equals(dataStatus) || realEffEndDate != null) continue;
                    dynamicObject3.set("brled", (Object)effDate);
                }
                serviceHelper.save(needUpdateVersions);
                HisSynDataStatusServicerHelper.saveEvent(hisTransBo, entityNumber, dyCurrents);
                if (map != null) {
                    map.put(entityNumber, dyCurrents);
                }
            }
            catch (Exception ex) {
                if (map != null) {
                    map.remove(entityNumber);
                }
                partitionList.clear();
                LOGGER.error("syn datastatus error,entity number:{}", (Object)entityNumber);
                LOGGER.error("syn datastatus error,message:{}", (Object)ex.toString());
                txHandle.markRollback();
            }
        }
        return dyCurrentList.stream().map(dy -> dy.getLong(BOID)).collect(Collectors.toList());
    }

    private static List<DynamicObject> filterData(DynamicObject[] dyCurrentAndVersions) {
        Map<Long, List<DynamicObject>> mapBoIdGroupAllVersion = Stream.of(dyCurrentAndVersions).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong(BOID)));
        Date date = new Date();
        HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<Long, List<DynamicObject>> entry : mapBoIdGroupAllVersion.entrySet()) {
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
            boolean hasToBeEffVersion = false;
            for (DynamicObject dy2 : dynamicObjectList) {
                String dataStatus = dy2.getString("datastatus");
                if (!EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dataStatus)) continue;
                Date planBsed = dy2.getDate("changebsed");
                Date startDate = dy2.getDate("bsed");
                if (planBsed != null) {
                    if (planBsed.getTime() >= date.getTime()) continue;
                    hasToBeEffVersion = true;
                    break;
                }
                if (startDate == null || startDate.getTime() >= date.getTime()) continue;
                hasToBeEffVersion = true;
                break;
            }
            if (!hasToBeEffVersion) continue;
            boIdSet.add(entry.getKey());
        }
        return Arrays.stream(dyCurrentAndVersions).filter(dy -> boIdSet.contains(dy.getLong(BOID))).collect(Collectors.toList());
    }

    private static void saveEvent(HisTransBo hisTransBo, String number, DynamicObject[] list) {
        hisTransBo.setTransExecuteMode(EventOperateEnums.EVENT_EXECUTE_AUTO.getValue());
        hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
        ArrayList ListHisTransBusinessBo = Lists.newArrayListWithCapacity((int)list.length);
        for (DynamicObject dynamicObject : list) {
            HisTransBusinessBo hisTransBusinessBo = new HisTransBusinessBo();
            hisTransBusinessBo.setBoId(dynamicObject.getLong(BOID));
            hisTransBusinessBo.setEntityNumber(number);
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)number);
            hisTransBusinessBo.setAppId(appIdByFormNum);
            hisTransBusinessBo.setMainBo(true);
            ListHisTransBusinessBo.add(hisTransBusinessBo);
        }
        hisTransBo.setListHisTransBusinessBo(ListHisTransBusinessBo);
        HisModelEventService.getInstance().saveEvent(hisTransBo);
    }

    private static Set<String> getExcludeEntitiesByDependent() {
        HRBaseServiceHelper edEntityHelper = new HRBaseServiceHelper("hrcs_edentity");
        DynamicObject[] results = edEntityHelper.query("entity.dentityid", new QFilter[0]);
        HashSet excludeEntities = Sets.newHashSetWithExpectedSize((int)results.length);
        for (DynamicObject result : results) {
            excludeEntities.add(result.getString("entity.dentityid"));
        }
        return excludeEntities;
    }

    private static Set<String> getExcludeEntities(DynamicObject[] taskConfigs) {
        HashSet excludeEntities = Sets.newHashSetWithExpectedSize((int)taskConfigs.length);
        for (DynamicObject taskConfig : taskConfigs) {
            DynamicObjectCollection entry = taskConfig.getDynamicObjectCollection("excludeentryentity");
            for (DynamicObject row : entry) {
                String entityNum = row.getString("excludeentity.id");
                excludeEntities.add(entityNum);
            }
        }
        return excludeEntities;
    }

    private static Map<String, List<DynamicObject>> getServiceMap(DynamicObject[] taskConfigs) {
        HashMap serviceMap = Maps.newHashMapWithExpectedSize((int)taskConfigs.length);
        for (DynamicObject taskConfig : taskConfigs) {
            DynamicObjectCollection services = taskConfig.getDynamicObjectCollection("entryentity");
            for (DynamicObject service : services) {
                String entityNum = service.getString("entity.id");
                List taskConfigList = serviceMap.getOrDefault(entityNum, Lists.newArrayListWithExpectedSize((int)taskConfigs.length));
                taskConfigList.add(taskConfig);
                serviceMap.put(entityNum, taskConfigList);
            }
        }
        return serviceMap;
    }

    private static DynamicObject[] getTaskConfigs(List<String> appIds) {
        HRBaseServiceHelper taskConfigServiceHelper = new HRBaseServiceHelper("hrcs_taskconfig");
        return taskConfigServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("taskbizapp.fbasedataid.id", "in", appIds)});
    }
}

