/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.odc.service;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.domain.odc.service.BizMserviceInvokeService;
import kd.hr.hbp.business.domain.odc.util.FieldConfigMap;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.model.DimValueResultWithSub;
import kd.hr.hbp.common.model.DimValueSubInfo;
import kd.hr.hbp.common.odc.DimValueResultDTO;
import kd.hr.hbp.common.odc.FieldNameInfo;
import kd.hr.hbp.common.odc.PositionTypeEnum;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DataFilterService {
    private DataFilterService() {
    }

    public static DataFilterService getInstance() {
        return DataFilterServiceInstance.INSTANCE;
    }

    public DimValueResultDTO getOrgDesignPerm(String entityNum) {
        DimValueResultDTO dimValueResultDto = new DimValueResultDTO();
        DimValueResultWithSub dimValueResultWithSub = (DimValueResultWithSub)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSBizDataPermissionService", "getEntityDimValueWithSub", RequestContext.getOrCreate().getCurrUserId(), BizAppServiceHelp.getAppIdByFormNum((String)entityNum), entityNum, "47150e89000000ac", "orgdesign");
        ArrayList<Long> orgIds = new ArrayList<Long>(dimValueResultWithSub.getDimValues().size());
        if (!dimValueResultWithSub.isAll()) {
            ArrayList<Long> includeSubIds = new ArrayList<Long>(dimValueResultWithSub.getDimValues().size());
            for (DimValueSubInfo dimValue : dimValueResultWithSub.getDimValues()) {
                Long orgId = HRJSONUtils.getLongValOfCustomParam((Object)dimValue.getValue());
                if (dimValue.isContainSub()) {
                    includeSubIds.add(orgId);
                    continue;
                }
                orgIds.add(orgId);
            }
            if (!HRCollUtil.isEmpty(includeSubIds)) {
                List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"25", includeSubIds, (boolean)true, (boolean)true);
                orgIds.addAll(allSubordinateOrgs);
            }
        }
        dimValueResultDto.setAll(dimValueResultWithSub.isAll());
        dimValueResultDto.setOrgIds(orgIds);
        return dimValueResultDto;
    }

    public DimValueResultDTO getOrgTeamPerm(String entityNum, String propKey) {
        DimValueResultDTO dimValueResultDto = new DimValueResultDTO();
        AuthorizedOrgTeamResult authorizedOrgTeamResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSBizDataPermissionService", "getAuthorizedOrgTeamsF7", RequestContext.getOrCreate().getCurrUserId(), BizAppServiceHelp.getAppIdByFormNum((String)entityNum), entityNum, "47150e89000000ac", propKey);
        dimValueResultDto.setAll(authorizedOrgTeamResult.isHasAllOrgPerm());
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        authorizedOrgTeamResult.getHasPermOrgTeamMap().forEach((teamType, orgList) -> {
            if (!CollectionUtils.isEmpty((Collection)orgList)) {
                orgIdList.addAll((Collection<Long>)orgList);
            }
        });
        if (!dimValueResultDto.isAll() && orgIdList.size() > 0) {
            List<Long> adminorgBoids = BizMserviceInvokeService.getInstance().queryAdminBoIdByIds(orgIdList);
            dimValueResultDto.setOrgIds(adminorgBoids);
        }
        return dimValueResultDto;
    }

    public QFilter getQFilterWithStdposition(long adminOrgId) {
        if (adminOrgId == 0L) {
            return null;
        }
        Map<Long, List<DynamicObject>> stdpositionMap = BizMserviceInvokeService.getInstance().queryStdPositionByOrg((List<Long>)ImmutableList.of((Object)adminOrgId));
        List<DynamicObject> standardPositions = stdpositionMap.get(adminOrgId);
        if (standardPositions == null || standardPositions.isEmpty()) {
            return new QFilter("boid", "=", null);
        }
        List ids = standardPositions.stream().map(dyInfo -> dyInfo.getLong("id")).collect(Collectors.toList());
        return new QFilter("boid", "in", ids);
    }

    public QFilter getQFilterWithStdposition(List<Long> adminOrgIdList) {
        if (CollectionUtils.isEmpty(adminOrgIdList)) {
            return null;
        }
        Map<Long, List<DynamicObject>> stdpositionMap = BizMserviceInvokeService.getInstance().queryStdPositionByOrg(adminOrgIdList);
        if (CollectionUtils.isEmpty(stdpositionMap)) {
            return new QFilter("boid", "=", null);
        }
        HashSet ids = new HashSet();
        stdpositionMap.forEach((adminorgid, stdpositions) -> {
            if (!CollectionUtils.isEmpty((Collection)stdpositions)) {
                ids.addAll(stdpositions.stream().map(dyInfo -> dyInfo.getLong("id")).collect(Collectors.toList()));
            }
        });
        if (CollectionUtils.isEmpty(ids)) {
            return new QFilter("boid", "=", null);
        }
        return new QFilter("boid", "in", ids);
    }

    public QFilter getQFilterWithJobLevelScm(FieldNameInfo fieldNameInfo) {
        long jobLevelScmId = (Long)this.getJobLevelGradeScmId((FieldNameInfo)fieldNameInfo).item1;
        return jobLevelScmId == 0L ? null : new QFilter("boid", "=", (Object)jobLevelScmId);
    }

    public QFilter getQFilterWithJobGradeScm(FieldNameInfo fieldNameInfo) {
        long jobGradeScmId = (Long)this.getJobLevelGradeScmId((FieldNameInfo)fieldNameInfo).item2;
        return jobGradeScmId == 0L ? null : new QFilter("boid", "=", (Object)jobGradeScmId);
    }

    public QFilter getQFilterWithJobLevel(FieldNameInfo fieldNameInfo) {
        Map<String, Object> positionLevelGradeMap;
        List jobLevels;
        QFilter qFilter = null;
        QFilter idFilter = null;
        long jobLevelScmId = fieldNameInfo.getFieldValue(fieldNameInfo.getJobLevelScmFieldName());
        if (jobLevelScmId != 0L) {
            qFilter = new QFilter("joblevelscm", "=", (Object)jobLevelScmId);
        }
        if (CollectionUtils.isEmpty(jobLevels = this.getJobLevel(positionLevelGradeMap = this.getPositionLevelGradeMap(fieldNameInfo)))) {
            long jobId = this.getJobIdByPositionType(fieldNameInfo);
            jobLevels = (List)this.getLevelGradeRangesByJobId((Long)Long.valueOf((long)jobId)).item1;
        }
        if (!CollectionUtils.isEmpty(jobLevels)) {
            List jobLevelIdList = jobLevels.stream().map(jobLevel -> jobLevel.getLong("id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "in", jobLevelIdList);
        }
        if (idFilter != null) {
            qFilter = qFilter == null ? idFilter : idFilter.and(qFilter);
        }
        return qFilter;
    }

    private long getJobIdByPositionType(FieldNameInfo fieldNameInfo) {
        long jobId = fieldNameInfo.getFieldValue(fieldNameInfo.getJobFieldName());
        if (jobId != 0L) {
            return jobId;
        }
        String positionType = String.valueOf(fieldNameInfo.getFieldValue(fieldNameInfo.getPositionTypeFieldName()));
        if (HRStringUtils.equals((String)"1", (String)positionType)) {
            long positionId = fieldNameInfo.getFieldValue(fieldNameInfo.getPositionFieldName());
            Map<String, Object> resultMap = BizMserviceInvokeService.getInstance().getHrPositionSingle(positionId);
            if (!HRObjectUtils.isEmpty(resultMap)) {
                return DataFilterService.getLongValOfCustomParam(resultMap.get("job"));
            }
        } else if (HRStringUtils.equals((String)"0", (String)positionType)) {
            long stdPositionId = fieldNameInfo.getFieldValue(fieldNameInfo.getStdPositionFieldName());
            Map<String, Object> resultMap = BizMserviceInvokeService.getInstance().getStandardIpositionSingle(stdPositionId);
            if (!HRObjectUtils.isEmpty(resultMap)) {
                return DataFilterService.getLongValOfCustomParam(resultMap.get("job"));
            }
        }
        return jobId;
    }

    public QFilter getQFilterWithJobGrade(FieldNameInfo fieldNameInfo) {
        Map<String, Object> positionLevelGradeMap;
        List jobGrades;
        QFilter qFilter = null;
        QFilter idFilter = null;
        long jobgradeScmId = fieldNameInfo.getFieldValue(fieldNameInfo.getJobGradeScmFieldName());
        if (jobgradeScmId != 0L) {
            qFilter = new QFilter("jobgradescm", "=", (Object)jobgradeScmId);
        }
        if (CollectionUtils.isEmpty(jobGrades = this.getJobGrade(positionLevelGradeMap = this.getPositionLevelGradeMap(fieldNameInfo)))) {
            long jobId = this.getJobIdByPositionType(fieldNameInfo);
            jobGrades = (List)this.getLevelGradeRangesByJobId((Long)Long.valueOf((long)jobId)).item2;
        }
        if (jobGrades != null && !jobGrades.isEmpty()) {
            List jobGradeIdList = jobGrades.stream().map(jobGrade -> jobGrade.getLong("id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "in", jobGradeIdList);
        }
        if (idFilter != null) {
            qFilter = qFilter == null ? idFilter : idFilter.and(qFilter);
        }
        return qFilter;
    }

    public QFilter getJobGradeScmQFilterWithUseOrgIdList(List<Long> useOrgIdList) {
        List<Long> gradeScmIdList = BizMserviceInvokeService.getInstance().getJobGradeScmIdsByUseorgIdList(useOrgIdList);
        if (!CollectionUtils.isEmpty(gradeScmIdList)) {
            return new QFilter("jobgradescm", "in", gradeScmIdList);
        }
        return null;
    }

    public QFilter getJobLevelScmQFilterWithUseOrgIdList(List<Long> useOrgIdList) {
        List<Long> levelScmIdList = BizMserviceInvokeService.getInstance().getJobLevelScmIdsByUseorgIdList(useOrgIdList);
        if (!CollectionUtils.isEmpty(levelScmIdList)) {
            return new QFilter("joblevelscm", "in", levelScmIdList);
        }
        return null;
    }

    private Map<String, Object> getPositionLevelGradeMap(FieldNameInfo fieldNameInfo) {
        String positionType = String.valueOf(fieldNameInfo.getFieldValue(fieldNameInfo.getPositionTypeFieldName()));
        Map<String, Object> positionLevelGradeMap = new HashMap<String, Object>();
        if (HRStringUtils.equals((String)"1", (String)positionType)) {
            Map<String, Object> resultMap;
            long positionId = fieldNameInfo.getFieldValue(fieldNameInfo.getPositionFieldName());
            Map<Long, Object> jobInfoMap = BizMserviceInvokeService.getInstance().queryJobLevelAndJobGradeByPositionIds((List<Long>)ImmutableList.of((Object)positionId));
            if (!ObjectUtils.isEmpty(jobInfoMap)) {
                positionLevelGradeMap = (Map)jobInfoMap.get(positionId);
            }
            if (!HRObjectUtils.isEmpty(resultMap = BizMserviceInvokeService.getInstance().getHrPositionSingle(positionId))) {
                positionLevelGradeMap.put("job", DataFilterService.getLongValOfCustomParam(resultMap.get("job")));
            }
        } else if (HRStringUtils.equals((String)"0", (String)positionType)) {
            Map<String, Object> resultMap;
            long stdPositionId = fieldNameInfo.getFieldValue(fieldNameInfo.getStdPositionFieldName());
            Map<Long, Object> jobInfoMap = BizMserviceInvokeService.getInstance().queryJobLevelAndJobGradeByStdPositionIds((List<Long>)ImmutableList.of((Object)stdPositionId));
            if (!ObjectUtils.isEmpty(jobInfoMap)) {
                positionLevelGradeMap = (Map)jobInfoMap.get(stdPositionId);
            }
            if (!HRObjectUtils.isEmpty(resultMap = BizMserviceInvokeService.getInstance().getStandardIpositionSingle(stdPositionId))) {
                positionLevelGradeMap.put("job", DataFilterService.getLongValOfCustomParam(resultMap.get("job")));
            }
        }
        return positionLevelGradeMap;
    }

    private Tuple<List<DynamicObject>, List<DynamicObject>> getLevelGradeRangesByJobId(Long jobId) {
        Map<Object, Object> jobInfoMap = new HashMap();
        if (jobId != 0L) {
            Map<Long, Map<String, Object>> resultMap = BizMserviceInvokeService.getInstance().getJobLevelGradeRangeInfoByJobIds((List<Long>)ImmutableList.of((Object)jobId));
            jobInfoMap = resultMap.get(jobId);
        }
        List jobGrades = new ArrayList();
        List jobleves = new ArrayList();
        if (jobInfoMap != null && !jobInfoMap.isEmpty()) {
            jobGrades = (List)jobInfoMap.get("jobgradeRanges");
            jobleves = (List)jobInfoMap.get("joblevelRanges");
        }
        return Tuple.create(jobleves, jobGrades);
    }

    private Tuple<Long, Long> getJobLevelGradeScmId(FieldNameInfo fieldNameInfo) {
        Map<Object, Object> resultMap;
        long jobLevelScmId = 0L;
        long jobGradeScmId = 0L;
        long jobId = 0L;
        String positionType = String.valueOf(fieldNameInfo.getFieldValue(fieldNameInfo.getPositionTypeFieldName()));
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)positionType)) {
            Long stdPositionId = fieldNameInfo.getFieldValue(fieldNameInfo.getStdPositionFieldName());
            resultMap = BizMserviceInvokeService.getInstance().getStandardIpositionSingle(stdPositionId);
            if (!HRObjectUtils.isEmpty(resultMap)) {
                jobLevelScmId = DataFilterService.getLongValOfCustomParam(resultMap.get("joblevelscm.id"));
                jobGradeScmId = DataFilterService.getLongValOfCustomParam(resultMap.get("jobgradescm.id"));
                jobId = DataFilterService.getLongValOfCustomParam(resultMap.get("job"));
            }
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)positionType)) {
            Long positionId = fieldNameInfo.getFieldValue(fieldNameInfo.getPositionFieldName());
            resultMap = BizMserviceInvokeService.getInstance().getHrPositionSingle(positionId);
            if (!HRObjectUtils.isEmpty(resultMap)) {
                jobLevelScmId = DataFilterService.getLongValOfCustomParam(resultMap.get("highjoblevel.joblevelscm"));
                jobGradeScmId = DataFilterService.getLongValOfCustomParam(resultMap.get("highjobgrade.jobgradescm"));
                jobId = DataFilterService.getLongValOfCustomParam(resultMap.get("job"));
            }
        }
        if (jobLevelScmId == 0L || jobGradeScmId == 0L) {
            if (jobId == 0L) {
                jobId = fieldNameInfo.getFieldValue(fieldNameInfo.getJobFieldName());
            }
            Map jobInfoMap = new HashMap();
            if (jobId != 0L) {
                resultMap = BizMserviceInvokeService.getInstance().getJobLevelGradeRangeInfoByJobIds((List<Long>)ImmutableList.of((Object)jobId));
                jobInfoMap = (Map)resultMap.get(jobId);
            }
            if (jobInfoMap != null) {
                jobLevelScmId = jobLevelScmId == 0L ? DataFilterService.getLongValOfCustomParam(jobInfoMap.get("joblevelScmid")) : jobLevelScmId;
                jobGradeScmId = jobGradeScmId == 0L ? DataFilterService.getLongValOfCustomParam(jobInfoMap.get("jobgradeScmid")) : jobGradeScmId;
            }
        }
        return Tuple.create((Object)jobLevelScmId, (Object)jobGradeScmId);
    }

    private static long getLongValOfCustomParam(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        return Long.parseLong(object.toString());
    }

    private List<DynamicObject> getJobLevel(Map<String, Object> levelGradeMap) {
        if (!ObjectUtils.isEmpty(levelGradeMap) && !ObjectUtils.isEmpty((Object)levelGradeMap.get("joblevel"))) {
            return (List)levelGradeMap.get("joblevel");
        }
        return new ArrayList<DynamicObject>();
    }

    private List<DynamicObject> getJobGrade(Map<String, Object> levelGradeMap) {
        if (!ObjectUtils.isEmpty(levelGradeMap) && !ObjectUtils.isEmpty((Object)levelGradeMap.get("jobgrade"))) {
            return (List)levelGradeMap.get("jobgrade");
        }
        return new ArrayList<DynamicObject>();
    }

    public QFilter getJobGradeScmFilter(String entityNum) {
        DimValueResultDTO dimValueWithSub = this.getOrgDesignPerm(entityNum);
        if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
            return this.getJobGradeScmQFilterWithUseOrgIdList(dimValueWithSub.getOrgIds());
        }
        return null;
    }

    public QFilter getJobLevelScmFilter(String entityNum) {
        DimValueResultDTO dimValueWithSub = this.getOrgDesignPerm(entityNum);
        if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
            return this.getJobLevelScmQFilterWithUseOrgIdList(dimValueWithSub.getOrgIds());
        }
        return null;
    }

    public QFilter getAdminorgSuitRangeFilter(String entityNum) {
        DimValueResultDTO dimValueWithSub = this.getOrgTeamPerm(entityNum);
        if (dimValueWithSub != null && !dimValueWithSub.isAll()) {
            return this.getQFilterWithStdposition(dimValueWithSub.getOrgIds());
        }
        return null;
    }

    private DimValueResultDTO getOrgTeamPerm(String entityNum) {
        DimValueResultDTO permResult;
        FieldNameInfo fieldNameInfo = FieldConfigMap.getFieldName(entityNum);
        if (HRStringUtils.isEmpty((String)fieldNameInfo.getAdminOrgFieldName())) {
            permResult = new DimValueResultDTO();
            permResult.setAll(true);
        } else {
            permResult = this.getOrgTeamPerm(entityNum, fieldNameInfo.getAdminOrgFieldName());
        }
        return permResult;
    }

    private static class DataFilterServiceInstance {
        private static DataFilterService INSTANCE = new DataFilterService();

        private DataFilterServiceInstance() {
        }
    }
}

