/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.orm.ORM;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.AttachmentServiceImpl;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HisAttachmentFiledService {
    private static final Log log = LogFactory.getLog(HisAttachmentFiledService.class);
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};
    private static volatile HisAttachmentFiledService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisAttachmentFiledService getInstance() {
        if (service != null) return service;
        Class<HisAttachmentFiledService> clazz = HisAttachmentFiledService.class;
        synchronized (HisAttachmentFiledService.class) {
            if (service != null) return service;
            service = new HisAttachmentFiledService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void persistAttachments(OperateOption operateOption, String entityNumber, String billNo, String pageId, Object pkId, DynamicObject[] dynamicObjects) {
        IAttachmentFieldModelProxy attachmentFieldModel = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class);
        if (!attachmentFieldModel.checkIfHasAttProp(entityNumber)) {
            return;
        }
        if (attachmentFieldModel.checkIfHasAttProp(entityNumber)) {
            HashMap<String, Object> attachmentField = new HashMap<String, Object>();
            attachmentField.put("PkId", pkId);
            attachmentField.put("PageId", pageId);
            attachmentField.put("BillNo", billNo);
            operateOption.setVariableValue("AttachmentField", SerializationUtils.toJsonString(attachmentField));
        }
        IAttachmentOperateService attService = (IAttachmentOperateService)ServiceFactory.getService(IAttachmentOperateService.class);
        attService.persistAttachments(operateOption, dynamicObjects);
    }

    public MulBasedataDynamicObjectCollection copyNewMulBaseData(MulBasedataDynamicObjectCollection mulBaseData, String pageId) {
        if (mulBaseData == null) {
            return null;
        }
        DynamicObjectType dynamicObjectType = mulBaseData.getDynamicObjectType();
        MulBasedataDynamicObjectCollection newMulBaseData = new MulBasedataDynamicObjectCollection(mulBaseData.getDynamicObjectType(), mulBaseData.getParent());
        if (HisAttachmentFiledService.getInstance().isAttachField(dynamicObjectType) && StringUtils.isNotEmpty((String)pageId)) {
            AttachmentServiceImpl attachmentService = new AttachmentServiceImpl();
            attachmentService.copyAttachmentField((DynamicObjectCollection)mulBaseData, (DynamicObjectCollection)newMulBaseData, pageId);
        } else {
            mulBaseData.forEach(mulBaseDatum -> {
                DynamicObject newMulBasedataNum = newMulBaseData.addNew();
                HRDynamicObjectUtils.copy((DynamicObject)mulBaseDatum, (DynamicObject)newMulBasedataNum);
            });
        }
        return newMulBaseData;
    }

    public boolean isAttachField(DynamicObjectType dynamicObjectType) {
        DynamicProperty property = dynamicObjectType.getProperty("fbasedataid");
        if (property instanceof BasedataProp) {
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            return "bd_attachment".equals(baseEntityId);
        }
        return false;
    }

    public void copyAttachmentField(DynamicObjectCollection oldDynObjColl, DynamicObjectCollection newDynObjColl) {
        log.info("oldDynObjColl:" + SerializationUtils.toJsonString((Object)oldDynObjColl));
        log.info("newDynObjColl:" + SerializationUtils.toJsonString((Object)newDynObjColl));
        int count = oldDynObjColl.size();
        ArrayList<DynamicObject> copyAttFiledList = new ArrayList<DynamicObject>(10);
        log.info("before_genLongIds" + System.currentTimeMillis());
        long[] genLongIds = ORM.create().genLongIds("bd_attachment", count);
        log.info("after_genLongIds" + System.currentTimeMillis());
        for (int i = 0; i < count; ++i) {
            DynamicObject oldDynObj = (DynamicObject)oldDynObjColl.get(i);
            log.info("before_OrmUtils.clone1" + System.currentTimeMillis());
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)oldDynObj, (boolean)false, (boolean)true);
            log.info("after_OrmUtils.clone1" + System.currentTimeMillis());
            copyDynObj.getDataEntityState().setDirty(true);
            DynamicObject attachmentField = copyDynObj.getDynamicObject("fbasedataid");
            DynamicObject attachment = this.getNewAttachDynamicObject(genLongIds[i], attachmentField);
            if (attachment == null) continue;
            copyAttFiledList.add(attachment);
            copyDynObj.set("fbasedataid_id", (Object)genLongIds[i]);
            newDynObjColl.add((Object)copyDynObj);
        }
        if (!copyAttFiledList.isEmpty()) {
            try (TXHandle required = TX.requiresNew();){
                log.info("before_ORM.create().save ," + System.currentTimeMillis());
                ORM.create().save(copyAttFiledList.toArray(new DynamicObject[0]));
                log.info("after_ORM.create().save ," + System.currentTimeMillis());
            }
        }
        log.info("newDynObjColl2:" + SerializationUtils.toJsonString((Object)newDynObjColl));
    }

    private DynamicObject getNewAttachDynamicObject(long genLongId, DynamicObject attachmentField) {
        String extName;
        DynamicObject attachment = (DynamicObject)OrmUtils.clone((IDataEntityBase)attachmentField, (boolean)false, (boolean)true);
        log.info("after_OrmUtils.clone2" + System.currentTimeMillis());
        String newPath = this.getPath(genLongId, attachmentField);
        long compressPicSize = AttachmentServiceHelper.getCompressPicSize();
        if (newPath == null) {
            return null;
        }
        log.info("after fileService.upload ," + System.currentTimeMillis());
        attachment.set("url", (Object)newPath);
        attachment.set("id", (Object)genLongId);
        attachment.set("number", (Object)UUID.randomUUID());
        attachment.set("uid", (Object)AttachmentServiceHelper.generateUid());
        attachment.set("status", (Object)"B");
        attachment.set("tempfile", (Object)"1");
        String name = attachment.getString("name");
        String string = extName = name != null ? name.substring(name.lastIndexOf(46) + 1) : "";
        if ("jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,dcx,pic,tif,wmf".contains(extName.toLowerCase()) && compressPicSize != 0L && attachment.getLong("size") > compressPicSize * 1024L) {
            attachment.set("size", (Object)(compressPicSize * 1024L));
        }
        return attachment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPath(long genLongId, DynamicObject attachmentField) {
        String path = attachmentField.getString("url");
        log.info("getPath_start = " + path);
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException var10) {
            log.warn("path_analysis_error" + path);
        }
        try (InputStream in = this.getFileInputStream(attachmentField);){
            String string = this.saveInputStreamToFileService(in, genLongId, attachmentField.getString("name"));
            return string;
        }
        catch (Exception e) {
            log.error("inputStream_get_error", (Throwable)e);
            throw new KDBizException("inputStream_get_error_;path = " + path);
        }
    }

    public String saveInputStreamToFileService(InputStream originalInputStream, Object AttPk, String fileName) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)AttPk, (String)(uuid + "/" + this.replaceSpeSymbol(fileName)));
        FileItemExt fileItem = new FileItemExt(fileName, path, originalInputStream);
        fileItem.setSource(FileSource.ATTACHMENT_FIELD);
        fileItem.setComputeDigest(true);
        fileItem.setCreateNewFileWhenExists(true);
        String url = "";
        long compressPicSize = 0L;
        String[] splits = fileName.trim().split("\\.");
        String fileType = splits[splits.length - 1];
        int fileSize = 0;
        try {
            InputStream inputStream = fileItem.getInputStream();
            fileSize = inputStream.available() / 1024;
        }
        catch (IOException var17) {
            log.error((Throwable)var17);
        }
        if ("jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,dcx,pic,tif,wmf".contains(fileType.toLowerCase())) {
            compressPicSize = AttachmentServiceHelper.getCompressPicSize();
        }
        url = compressPicSize != 0L && (long)fileSize > compressPicSize ? service.compressPicUpload((FileItem)fileItem, compressPicSize) : service.upload((FileItem)fileItem);
        return url;
    }

    private String replaceSpeSymbol(String str) {
        for (String specialSymbol : SPECIAL_SYMBOLS) {
            if (!str.contains(specialSymbol)) continue;
            str = str.replace(specialSymbol, "_");
        }
        return str;
    }

    private InputStream getFileInputStream(DynamicObject attachmentField) {
        String path = attachmentField.getString("url");
        log.info("getPath_start = " + path);
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException var10) {
            log.warn("path_analysis_error_{}", (Object)path);
        }
        if (path.contains("tempfile/download.do")) {
            TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
            return downLoad.getInputStream(path);
        }
        path = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(path);
        if (path.contains("download.do?path=")) {
            path = path.split("download.do\\?path=")[1];
            while (path.startsWith("//")) {
                path = path.replaceFirst("//", "/");
            }
        }
        log.info("after_getRealPath = " + path);
        if (!StringUtils.isBlank((String)path) && path.contains("/")) {
            log.info("before_fileService_getInputStream_path = " + path + " ," + System.currentTimeMillis());
            InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(path);
            log.info("after_fileService_getInputStream_path = " + path + " ," + System.currentTimeMillis());
            return in;
        }
        return null;
    }
}

