/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.comparediff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.comparediff.IHrCommonCompareDiffService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class HisTimeCompareDiffService
implements IHrCommonCompareDiffService {
    private static volatile HisTimeCompareDiffService hisTimeCompareDiffService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisTimeCompareDiffService getInstance() {
        if (hisTimeCompareDiffService != null) return hisTimeCompareDiffService;
        Class<HisTimeCompareDiffService> clazz = HisTimeCompareDiffService.class;
        synchronized (HisTimeCompareDiffService.class) {
            if (hisTimeCompareDiffService != null) return hisTimeCompareDiffService;
            hisTimeCompareDiffService = new HisTimeCompareDiffService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisTimeCompareDiffService;
        }
    }

    @Override
    public String getDefaultKeyField() {
        return "boid";
    }

    @Override
    public Set<String> getDefaultIgnoreFields() {
        HashSet<String> ignoreKeys = new HashSet<String>(16);
        ignoreKeys.addAll(IGNORE_COMMON_COL);
        ignoreKeys.add("id");
        ignoreKeys.add("boid");
        ignoreKeys.add("datastatus");
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("hisversion");
        ignoreKeys.add("firstbsed");
        ignoreKeys.add("datastatus");
        ignoreKeys.add("changebsed");
        ignoreKeys.add("ismodify");
        ignoreKeys.add("bred");
        ignoreKeys.add("brled");
        ignoreKeys.add("brfd");
        ignoreKeys.add("sourcevid");
        ignoreKeys.add("versionsource");
        return ignoreKeys;
    }

    @Override
    public List<QFilter> getDefaultQFilters() {
        ArrayList<QFilter> QFilterList = new ArrayList<QFilter>(10);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilterList.add(isCurrentFilter);
        QFilterList.add(statusFilter);
        return QFilterList;
    }

    @Override
    public DynamicObject filterData(DynamicObject dynamicObject, List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return null;
        }
        Date effStartDate = dynamicObject.getDate("bsed");
        Date effEndDate = dynamicObject.getDate("bsled");
        if (effStartDate == null) {
            return null;
        }
        if (effEndDate == null) {
            effEndDate = HisEffDateCommonService.getInstance().getDate2999(null);
        }
        for (DynamicObject dy : dynamicObjectList) {
            Date effStartDateFromDb = dy.getDate("bsed");
            Date effEndDateFromDb = dy.getDate("bsled");
            if (effStartDateFromDb == null || effEndDateFromDb == null || effStartDate.getTime() != effStartDateFromDb.getTime() || effEndDate.getTime() != effEndDateFromDb.getTime()) continue;
            return dy;
        }
        return null;
    }
}

