/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.comparediff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiBatchInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiOutPutParam;
import kd.hr.hbp.business.domain.service.comparediff.IHrCommonCompareDiffService;
import kd.hr.hbp.business.domain.service.comparediff.IHrCompareDiffService;
import kd.hr.hbp.business.domain.service.impl.comparediff.HrCompareDiffFactory;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.ArrayUtils;

public class HrCommonCompareDiffService
implements IHrCompareDiffService {
    private static final Log LOGGER = LogFactory.getLog(HrCommonCompareDiffService.class);
    private static volatile HrCommonCompareDiffService hrCommonCompareDiffService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HrCommonCompareDiffService getInstance() {
        if (hrCommonCompareDiffService != null) return hrCommonCompareDiffService;
        Class<HrCommonCompareDiffService> clazz = HrCommonCompareDiffService.class;
        synchronized (HrCommonCompareDiffService.class) {
            if (hrCommonCompareDiffService != null) return hrCommonCompareDiffService;
            hrCommonCompareDiffService = new HrCommonCompareDiffService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hrCommonCompareDiffService;
        }
    }

    @Override
    public boolean isDiff(DynamicObject dynamicObjectA, DynamicObject dynamicObjectB, Set<String> fieldSet, boolean stringIgnoreCase, boolean checkMultiLang) {
        return this.isDiff(dynamicObjectA, dynamicObjectB, fieldSet, stringIgnoreCase, checkMultiLang, false);
    }

    @Override
    public boolean isDiff(DynamicObject dynamicObjectA, DynamicObject dynamicObjectB, Set<String> fieldSet, boolean stringIgnoreCase, boolean checkMultiLang, boolean stringNullEqualsEmpty) {
        for (String field : fieldSet) {
            Object filedA = dynamicObjectA.get(field);
            Object filedB = dynamicObjectB.get(field);
            if (HisCommonService.getInstance().equalsValueWithAll(filedA, filedB, stringIgnoreCase, checkMultiLang, stringNullEqualsEmpty)) continue;
            LOGGER.info("HrCommonCompareDiffService.isDiff - entity:{} - field:{}", (Object)dynamicObjectA.getDynamicObjectType().getName(), (Object)field);
            return true;
        }
        return false;
    }

    @Override
    public HrApiResponse<List<CompareDiffApiOutPutParam>> isNewData(CompareDiffApiInputParam compareDiffApiParam) {
        String entityNumber = compareDiffApiParam.getEntityNumber();
        this.validateParam(compareDiffApiParam);
        IHrCommonCompareDiffService hrCommonCompareDiffService = HrCompareDiffFactory.getInstance(entityNumber);
        String keyField = compareDiffApiParam.getKeyField() == null ? hrCommonCompareDiffService.getDefaultKeyField() : compareDiffApiParam.getKeyField();
        List<QFilter> qFilterList = hrCommonCompareDiffService.getDefaultQFilters();
        Set<String> defaultIgnoreFields = hrCommonCompareDiffService.getDefaultIgnoreFields();
        Set<String> ignoreFields = compareDiffApiParam.getIgnoreFields();
        if (!CollectionUtils.isEmpty(ignoreFields)) {
            defaultIgnoreFields.addAll(ignoreFields);
        }
        DynamicObject[] dynamicObjects = compareDiffApiParam.getDynamicObjects();
        this.buildQFilters(qFilterList, keyField, dynamicObjects);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (CollectionUtils.isEmpty(qFilterList)) {
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a", (String)"HrCommonCompareDiffService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            LOGGER.error("HrCommonCompareDiffService.isNewData,error :{}", (Object)errorMsg);
            throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
        }
        DynamicObject[] dyDataFromDb = serviceHelper.loadDynamicObjectArray(qFilterList.toArray(new QFilter[qFilterList.size()]));
        DataEntityPropertyCollection dataEntityProperties = dynamicObjects[0].getDynamicObjectType().getProperties();
        Set<String> needCompareFieldSet = this.invertSelectionFields(dataEntityProperties, defaultIgnoreFields);
        HrApiResponse<List<CompareDiffApiOutPutParam>> hrApiResponse = this.isDiff(dynamicObjects, dyDataFromDb, keyField, needCompareFieldSet, true, true, hrCommonCompareDiffService, entityNumber, compareDiffApiParam.isStringNullEqualsEmpty());
        return hrApiResponse;
    }

    @Override
    public HrApiResponse<List<CompareDiffApiOutPutParam>> isNewDataBatch(CompareDiffApiBatchInputParam compareDiffApiBatchInputParam) {
        this.validateBatchParam(compareDiffApiBatchInputParam);
        HrApiResponse multiHrApiRsp = new HrApiResponse();
        ArrayList compareDiffApiOutPutParamList = new ArrayList(10);
        List<CompareDiffApiInputParam> compareDiffApiInputParamList = compareDiffApiBatchInputParam.getCompareDiffApiInputParamList();
        for (int i = 0; i < compareDiffApiInputParamList.size(); ++i) {
            CompareDiffApiInputParam compareDiffApiInputParam = compareDiffApiInputParamList.get(i);
            HrApiResponse<List<CompareDiffApiOutPutParam>> singleRsp = this.isNewData(compareDiffApiInputParam);
            List singleData = (List)singleRsp.getData();
            if (CollectionUtils.isEmpty((Collection)singleData)) continue;
            compareDiffApiOutPutParamList.addAll(singleData);
        }
        multiHrApiRsp.setData(compareDiffApiOutPutParamList);
        if (!CollectionUtils.isEmpty((Collection)((Collection)multiHrApiRsp.getData()))) {
            multiHrApiRsp.setSuccess(false);
            multiHrApiRsp.setCode(EnumResponseCode.FAIL.getCode());
            multiHrApiRsp.setData(compareDiffApiOutPutParamList);
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u4e14\u4e0e\u6570\u636e\u5e93\u4e2d\u6570\u636e\u5b57\u6bb5\u503c\u5b8c\u5168\u76f8\u540c", (String)"HrCommonCompareDiffService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            LOGGER.error("HrCommonCompareDiffService.isNewDataBatch,error :{}", (Object)errorMsg);
            multiHrApiRsp.setErrorMessage(errorMsg);
        }
        return multiHrApiRsp;
    }

    private HrApiResponse<List<CompareDiffApiOutPutParam>> isDiff(DynamicObject[] dynamicObjects, DynamicObject[] dyDataFromDb, String keyField, Set<String> ignoreFields, boolean stringIgnoreCase, boolean checkMultiLang, IHrCommonCompareDiffService hrCommonCompareDiffService, String entityNumber, boolean stringNullEqualsEmpty) {
        HrApiResponse hrApiResponse = new HrApiResponse();
        Map<Object, List<DynamicObject>> map = this.groupByKeyDyMap(dynamicObjects, keyField);
        Map<Object, List<DynamicObject>> mapDataFormDb = this.groupByKeyDyMap(dyDataFromDb, keyField);
        ArrayList<CompareDiffApiOutPutParam> compareDiffApiOutPutParamList = null;
        for (Map.Entry<Object, List<DynamicObject>> entry : map.entrySet()) {
            Object objKey = entry.getKey();
            List<DynamicObject> dynamicObjectList = entry.getValue();
            List<DynamicObject> dyListFormDb = mapDataFormDb.get(objKey);
            if (dyListFormDb == null) continue;
            for (DynamicObject dynamicObject : dynamicObjectList) {
                boolean bIsDiff;
                DynamicObject dyFormDb = hrCommonCompareDiffService.filterData(dynamicObject, dyListFormDb);
                if (null == dyFormDb || (bIsDiff = this.isDiff(dynamicObject, dyFormDb, ignoreFields, stringIgnoreCase, checkMultiLang, stringNullEqualsEmpty))) continue;
                hrApiResponse.setSuccess(false);
                hrApiResponse.setCode(EnumResponseCode.FAIL.getCode());
                if (compareDiffApiOutPutParamList == null) {
                    compareDiffApiOutPutParamList = new ArrayList<CompareDiffApiOutPutParam>(10);
                }
                CompareDiffApiOutPutParam compareDiffApiOutPutParam = new CompareDiffApiOutPutParam();
                compareDiffApiOutPutParam.setEntityNumber(entityNumber);
                compareDiffApiOutPutParam.setDyOriginal(dynamicObject);
                compareDiffApiOutPutParam.setDyFromDatabase(dyFormDb);
                compareDiffApiOutPutParamList.add(compareDiffApiOutPutParam);
                hrApiResponse.setData(compareDiffApiOutPutParamList);
                String errorMsg = ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u4e14\u4e0e\u6570\u636e\u5e93\u4e2d\u6570\u636e\u5b57\u6bb5\u503c\u5b8c\u5168\u76f8\u540c", (String)"HrCommonCompareDiffService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                hrApiResponse.setErrorMessage(errorMsg);
            }
        }
        return hrApiResponse;
    }

    private void validateParam(CompareDiffApiInputParam compareDiffApiParam) {
        if (compareDiffApiParam == null) {
            String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"HrCommonCompareDiffService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
        }
        String entityNumber = compareDiffApiParam.getEntityNumber();
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u4f53\u7f16\u7801\u3002", (String)"HrCommonCompareDiffService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
        }
        Object[] dynamicObjects = compareDiffApiParam.getDynamicObjects();
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            String errorMsg = ResManager.loadKDString((String)"\u52a8\u6001\u5bf9\u8c61\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HrCommonCompareDiffService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
        }
    }

    private void validateBatchParam(CompareDiffApiBatchInputParam compareDiffApiBatchInputParam) {
        if (compareDiffApiBatchInputParam == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (String)"HrCommonCompareDiffService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
        }
        List<CompareDiffApiInputParam> compareDiffApiInputParamList = compareDiffApiBatchInputParam.getCompareDiffApiInputParamList();
        if (CollectionUtils.isEmpty(compareDiffApiInputParamList)) {
            String errorMsg = ResManager.loadKDString((String)"\u5165\u53c2\u7684compareDiffApiInputParamList\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HrCommonCompareDiffService_9", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
        }
    }

    private void buildQFilters(List<QFilter> qFilterList, String keyField, DynamicObject[] dynamicObjects) {
        HashSet<Object> objValues = new HashSet<Object>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)keyField)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u201cs%\u201d\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"HrCommonCompareDiffService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), keyField);
                throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
            }
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)keyField);
            if (!(dataEntityProperty instanceof DynamicSimpleProperty)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 \u201cs%\u201d \u4e0d\u662f\u57fa\u672c\u5b57\u6bb5\u7c7b\u578b\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u6bd4\u5bf9\u3002", (String)"HrCommonCompareDiffService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), keyField);
                throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
            }
            Object objFiled = dynamicObject.get(keyField);
            if (objFiled == null) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u201cs%\u201d\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u6bd4\u5bf9\u3002", (String)"HrCommonCompareDiffService_7", (String)"hrmp-hbp-business", (Object[])new Object[0]), keyField);
                throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL.getCode(), errorMsg), new Object[0]);
            }
            objValues.add(objFiled);
        }
        QFilter qFilter = new QFilter(keyField, "in", objValues);
        qFilterList.add(qFilter);
    }

    private Map<Object, List<DynamicObject>> groupByKeyDyMap(DynamicObject[] dynamicObjects, String keyField) {
        HashMap<Object, List<DynamicObject>> map = new HashMap<Object, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object key = dynamicObject.get(keyField);
            ArrayList<DynamicObject> dynamicObjectList = (ArrayList<DynamicObject>)map.get(key);
            if (dynamicObjectList == null) {
                dynamicObjectList = new ArrayList<DynamicObject>();
                map.put(key, dynamicObjectList);
            }
            dynamicObjectList.add(dynamicObject);
        }
        return map;
    }

    private Set<String> invertSelectionFields(DataEntityPropertyCollection dataEntityProperties, Set<String> defaultIgnoreFields) {
        HashSet<String> needCompareFieldSet = new HashSet<String>(16);
        dataEntityProperties.forEach(filed -> needCompareFieldSet.add(filed.getName()));
        needCompareFieldSet.removeAll(defaultIgnoreFields);
        return needCompareFieldSet;
    }
}

