/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBusinessBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransVersionBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisValidateRespBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.attachment.HisAttachAndDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.attachment.HisAttachmentSourceIdBo;
import kd.hr.hbp.business.domain.model.newhismodel.bubasedata.HisCalcPersonalDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.writeback.HisWriteBackCurrentBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisModelEventService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.SortingEffStartEndDateBoService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.calc.HisVersionCalcService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.personal.HisPersonalDataService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.timezone.HisTimeZoneService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.writeback.HisWriteBackCurrentService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisSaveVersion;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisPersonalDataType;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRHisEntryObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public abstract class AbstractHisSaveVersion
implements IHisSaveVersion {
    @Override
    public void saveTempVersion(HisVersionParamBo hisVersionParamBo, HRBaseServiceHelper serviceHelper) {
        DynamicObject[] dynamicObjects = hisVersionParamBo.getHisDyns();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        DataEntityPropertyCollection properties = dynamicObjects[0].getDataEntityType().getProperties();
        boolean hasStatus = HisModelImportUtil.hasStatus(properties);
        boolean hasEnable = HisModelImportUtil.hasEnable(properties);
        HisValidateService.getInstance().saveValidate(dynamicObjects);
        HashSet<Long> boIdSet = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : dynamicObjects) {
            boolean nonEnabling;
            Long boId = dynamicObject.getLong("boid");
            boolean isCurrentVersion = dynamicObject.getBoolean("iscurrentversion");
            boolean nonSubmitted = hasStatus && !HRStringUtils.equals((String)dynamicObject.getString("status"), (String)"B");
            boolean bl = nonEnabling = hasEnable && !HRStringUtils.equals((String)dynamicObject.getString("enable"), (String)"10");
            if (nonSubmitted && nonEnabling) {
                dynamicObject.set("status", (Object)"A");
            }
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dynamicObject);
            HisTimeZoneService.getInstance().initPlanBsed(dynamicObject);
            if (isCurrentVersion) continue;
            boIdSet.add(boId);
            dynamicObject.set("hisversion", null);
        }
        HRHisEntryObjectUtils.initEntryBoId((DynamicObject[])dynamicObjects, (String)hisVersionParamBo.getEntityNumber());
        DynamicObject[] dynamicObjectCurrentArray = HisCommonEntityRepository.getOldCurrentDataArray(serviceHelper, boIdSet);
        if (dynamicObjectCurrentArray == null || dynamicObjectCurrentArray.length == 0) {
            return;
        }
        for (DynamicObject dynamicObjectCurrent : dynamicObjectCurrentArray) {
            dynamicObjectCurrent.set("ismodify", (Object)"1");
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dynamicObjectCurrent);
        }
        DynamicObjectCommonService.getInstance().setMastId(dynamicObjectCurrentArray);
        serviceHelper.save(dynamicObjectCurrentArray);
    }

    @Override
    public DynamicObject[] saveEffVersion(HisVersionParamBo hisVersionParamBo, HisTransBo hisTransBo, HRBaseServiceHelper serviceHelper, boolean isBatch) {
        DynamicObject[] dynamicObjects = hisVersionParamBo.getHisDyns();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        Set<Long> canNotUpdatePlanBsedIdSet = HisTimeZoneService.getInstance().canNotUpdatePlanBsedSet(serviceHelper, dynamicObjects);
        HisValidateService.getInstance().saveValidate(dynamicObjects);
        ArrayList<DynamicObject> currentDynamicObjectList = new ArrayList<DynamicObject>(8);
        String entityNumber = hisVersionParamBo.getEntityNumber();
        ArrayList<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList = null;
        Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos = hisVersionParamBo.getMapHisAttachmentBos();
        if (mapHisAttachmentBos == null) {
            mapHisAttachmentBos = new HashMap<Long, List<HisAttachmentBo>>(8);
            hisVersionParamBo.setMapHisAttachmentBos(mapHisAttachmentBos);
        }
        if (!CollectionUtils.isEmpty(mapHisAttachmentBos) && hisVersionParamBo.isNeedProcessAttachment()) {
            hisAttachmentSourceIdBoList = new ArrayList(8);
        }
        HisAttachAndDataBo hisAttachAndDataBo = this.groupByBoId(dynamicObjects, serviceHelper, currentDynamicObjectList, hisAttachmentSourceIdBoList, hisVersionParamBo);
        Map<Long, List<DynamicObject>> mapBoIdGroupData = hisAttachAndDataBo.getMapBoIdGroupData();
        hisAttachmentSourceIdBoList = hisAttachAndDataBo.getHisAttachmentSourceIdBoList();
        List<HisTransBusinessBo> listHisTransBusinessBo = (hisTransBo = this.buildHisTransBo(hisVersionParamBo, hisTransBo, mapBoIdGroupData)).getListHisTransBusinessBo();
        if (listHisTransBusinessBo == null) {
            listHisTransBusinessBo = new ArrayList<HisTransBusinessBo>(8);
            hisTransBo.setListHisTransBusinessBo(listHisTransBusinessBo);
        }
        ArrayList<DynamicObject> newDynamicObjectResult = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> allVersionDynamicObjectResult = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> updateDateVersionList = new ArrayList<DynamicObject>(8);
        boolean allowMultiToBeEffData = HisCommonEntityRepository.getAllowMultiToBeEffData(entityNumber);
        Set<Long> boIdSet = mapBoIdGroupData.keySet();
        HisCalcPersonalDataBo hisCalcPersonalDataBo = new HisCalcPersonalDataBo(serviceHelper, entityNumber, hisVersionParamBo.getPersonalDataType(), mapBoIdGroupData);
        hisCalcPersonalDataBo.setHisTransBo(hisTransBo);
        HisPersonalDataService.getInstance().batchCalcPersonalData(hisCalcPersonalDataBo);
        DynamicObject[] allOldDynamicObjects = HisCommonEntityRepository.loadOldEffVersionByBoIds(serviceHelper, boIdSet);
        Set<Long> oldVersionIdSet = null;
        if (allOldDynamicObjects != null && allOldDynamicObjects.length > 0) {
            oldVersionIdSet = Arrays.stream(allOldDynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        }
        Map<Long, List<DynamicObject>> mapDyListGroup = this.getDyListGroupByBoId(allOldDynamicObjects);
        for (Map.Entry<Long, List<DynamicObject>> entry : mapBoIdGroupData.entrySet()) {
            Long boId = entry.getKey();
            List<DynamicObject> newDynamicObjectList = entry.getValue();
            List<DynamicObject> dynamicObjectList = mapDyListGroup.get(boId);
            DynamicObject[] oldDynamicObjects = null;
            if (dynamicObjectList != null && dynamicObjectList.size() > 0) {
                oldDynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
            }
            if (!EnumHisPersonalDataType.PERSONAL_DATA_SAVE.getType().equals(hisVersionParamBo.getPersonalDataType())) {
                HisTimeZoneService.getInstance().initPlanBsedByList(newDynamicObjectList, canNotUpdatePlanBsedIdSet);
            }
            EffStartEndDateBo[] effStartEndDateBos = this.buildStartEndDateBoList(newDynamicObjectList);
            if (hisVersionParamBo.isNeedValidateDate()) {
                this.validateDate(entityNumber, newDynamicObjectList, oldDynamicObjects, boId);
            }
            HisTransBusinessBo hisTransBusinessBo = new HisTransBusinessBo();
            hisTransBusinessBo.setBoId(boId);
            hisTransBusinessBo.setEntityNumber(entityNumber);
            HisVersionCalcService.getInstance().processVersion(newDynamicObjectList, effStartEndDateBos, oldDynamicObjects, hisTransBusinessBo, serviceHelper, hisAttachmentSourceIdBoList, updateDateVersionList);
            newDynamicObjectResult.addAll(newDynamicObjectList);
            long toBeEffDataCount = 0L;
            if (oldDynamicObjects != null && oldDynamicObjects.length > 0) {
                toBeEffDataCount = Arrays.stream(oldDynamicObjects).filter(hisDy -> HRStringUtils.equals((String)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), (String)hisDy.getString("datastatus"))).count();
            }
            if (!CollectionUtils.isEmpty(newDynamicObjectList)) {
                toBeEffDataCount += newDynamicObjectList.stream().filter(dy -> HRStringUtils.equals((String)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), (String)dy.getString("datastatus"))).count();
            }
            if (!allowMultiToBeEffData && toBeEffDataCount > 1L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u57fa\u7840\u8d44\u6599\u53ea\u5141\u8bb8\u6709\u4e00\u6761\u201c\u5f85\u751f\u6548\u201d\u6570\u636e\u7248\u672c\u3002", (String)"AbstractHisSaveVersion_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            if (oldDynamicObjects != null) {
                Collections.addAll(allVersionDynamicObjectResult, oldDynamicObjects);
            }
            hisTransBusinessBo.setMainBo(hisVersionParamBo.getMainBoId() != null && hisVersionParamBo.getMainBoId().longValue() == boId.longValue());
            listHisTransBusinessBo.add(hisTransBusinessBo);
        }
        this.removeNewDy(updateDateVersionList);
        HashSet<String> dataStatusSet = new HashSet<String>(4);
        dataStatusSet.add(EnumHisDataVersionStatus.DELETED.getStatus());
        this.removeVersion(newDynamicObjectResult, dataStatusSet);
        dataStatusSet.add(EnumHisDataVersionStatus.TEMP.getStatus());
        this.removeVersion(allVersionDynamicObjectResult, dataStatusSet);
        allVersionDynamicObjectResult.addAll(newDynamicObjectResult);
        this.buildNewVersionHisTransBo(hisTransBo, newDynamicObjectResult);
        Map<Long, List<DynamicObject>> mapBoIdGroupAllVersion = this.groupDynamicObjectByBoId(allVersionDynamicObjectResult);
        HisWriteBackCurrentBo hisWriteBackCurrentBo = new HisWriteBackCurrentBo(entityNumber, mapBoIdGroupAllVersion, currentDynamicObjectList, null);
        List<DynamicObject> updateStatusVersionList = HisWriteBackCurrentService.getInstance().WriteBackCurrentVersion(hisWriteBackCurrentBo, false);
        HisWriteBackCurrentService.getInstance().updateOldVersion(serviceHelper, updateDateVersionList, updateStatusVersionList, oldVersionIdSet);
        if (!isBatch) {
            if (hisTransBo != null && !hisTransBo.getRecursionNoSave().booleanValue()) {
                HisModelEventService hisModelEventService = new HisModelEventService();
                hisModelEventService.saveEvent(hisTransBo);
                hisVersionParamBo.setEventId(hisTransBo.getEventId());
            } else {
                hisTransBo.setRecursionNoSave(false);
            }
        }
        newDynamicObjectResult.addAll(currentDynamicObjectList);
        if (hisVersionParamBo.isNeedProcessAttachment() && HisCommonService.getInstance().hasAttachments((Control)FormMetadataCache.getRootControl((String)entityNumber))) {
            this.processAttachment(hisAttachmentSourceIdBoList, currentDynamicObjectList, mapHisAttachmentBos, entityNumber);
        }
        DynamicObject[] dynamicObjectsResult = newDynamicObjectResult.toArray(new DynamicObject[newDynamicObjectResult.size()]);
        DynamicObjectCommonService.getInstance().setMastId(dynamicObjectsResult);
        HRHisEntryObjectUtils.initEntryBoId((DynamicObject[])dynamicObjectsResult, (String)entityNumber);
        return dynamicObjectsResult;
    }

    private void validateDate(String entityNumber, List<DynamicObject> newDynamicObjectList, DynamicObject[] oldDynamicObjects, Long boId) {
        HisValidateRespBo hisValidateRespBo;
        if (oldDynamicObjects == null || oldDynamicObjects.length == 0) {
            return;
        }
        EffStartEndDateBo[] effStartEndDateBos = this.buildStartEndDateBoList(newDynamicObjectList);
        List<HisValidateRespBo> hisValidateRespBoList = HisEffDateCommonService.getInstance().validateVersionDateSection(entityNumber, effStartEndDateBos, boId);
        if (hisValidateRespBoList != null && hisValidateRespBoList.size() > 0 && (hisValidateRespBo = hisValidateRespBoList.get(0)).isError()) {
            throw new KDBizException(hisValidateRespBo.getMsg());
        }
        ArrayList<EffStartEndDateBo> effStartEndDateBoList = new ArrayList<EffStartEndDateBo>(oldDynamicObjects.length);
        for (DynamicObject dynamicObject : oldDynamicObjects) {
            EffStartEndDateBo effStartEndDateBo = new EffStartEndDateBo();
            effStartEndDateBo.setEffectStartDate(dynamicObject.getDate("bsed"));
            effStartEndDateBo.setEffectEndDate(dynamicObject.getDate("bsled"));
            effStartEndDateBoList.add(effStartEndDateBo);
        }
        HisValidateRespBo hisValidateRespBo2 = HisEffDateCommonService.getInstance().validateVersionDisconnect(effStartEndDateBos, effStartEndDateBoList, boId);
        if (hisValidateRespBo2 != null && hisValidateRespBo2.isError()) {
            throw new KDBizException(hisValidateRespBo2.getMsg());
        }
    }

    private HisAttachAndDataBo groupByBoId(DynamicObject[] dynamicObjects, HRBaseServiceHelper serviceHelper, List<DynamicObject> currentDynamicObjectList, List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList, HisVersionParamBo hisVersionParamBo) {
        long[] firstVersionIds = hisVersionParamBo.getFirstVersionIds();
        List<Map<String, Object>> customizedFiledValue = hisVersionParamBo.getCustomizedFiledValue();
        int size = dynamicObjects.length;
        HashMap<Long, List<DynamicObject>> mapBoIdGroupData = new HashMap<Long, List<DynamicObject>>(size);
        String entityName = dynamicObjects[0].getDataEntityType().getName();
        HashSet<Long> idSet = new HashSet<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = dynamicObject.getLong("id");
            if (id == null || id == 0L) continue;
            idSet.add(id);
        }
        Set<Long> oldIdSet = null;
        if (idSet != null && idSet.size() > 0) {
            oldIdSet = HisCommonEntityRepository.getEffectVersionBoId(serviceHelper, idSet);
        }
        DataEntityPropertyCollection properties = dynamicObjects[0].getDataEntityType().getProperties();
        boolean hasStatus = HisModelImportUtil.hasStatus(properties);
        long[] ids = ORM.create().genLongIds(entityName, 2 * size);
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            Date effStartDate = dynamicObject.getDate("bsed");
            Date effEndDate = dynamicObject.getDate("bsled");
            Long boId = dynamicObject.getLong("boid");
            Long id = dynamicObject.getLong("id");
            if (hasStatus) {
                dynamicObject.set("status", (Object)"C");
            }
            if (id == null || id == 0L) {
                id = ids[i];
                dynamicObject.set("id", (Object)id);
            } else {
                String dataStatus = dynamicObject.getString("datastatus");
                if (!EnumHisDataVersionStatus.TEMP.getStatus().equals(dataStatus) && oldIdSet != null && oldIdSet.contains(id)) {
                    String errorMsg = ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25\uff0c\u8be5\u6570\u636e\u7248\u672c\u5df2\u5b58\u5728\u3002", (String)"AbstractHisSaveVersion_4", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(new ErrorCode(EnumResponseCode.FAIL_501.getCode(), errorMsg), new Object[0]);
                }
            }
            if (boId == null || boId == 0L) {
                dynamicObject.set("boid", (Object)id);
                boId = id;
                dynamicObject.set("iscurrentversion", (Object)Character.valueOf('1'));
            }
            boolean isCurrentVersion = dynamicObject.getBoolean("iscurrentversion");
            DynamicObject dyNewVersion = null;
            if (boId.longValue() == id.longValue()) {
                if (!isCurrentVersion) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u524d\u7248\u672c\u6570\u636e\uff0c\u4e0d\u5141\u8bb8(\u4e1a\u52a1ID)boid\u4e0e\u4e3b\u952e(fid)\u76f8\u540c", (String)"AbstractHisSaveVersion_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
                dyNewVersion = serviceHelper.generateEmptyDynamicObject();
                long newId = this.getVersionId(ids, firstVersionIds, i, size);
                dyNewVersion.set("id", (Object)newId);
                if (hisAttachmentSourceIdBoList == null) {
                    hisAttachmentSourceIdBoList = new ArrayList<HisAttachmentSourceIdBo>(10);
                }
                HisAttachmentSourceIdBo hisAttachmentSourceIdBo = new HisAttachmentSourceIdBo();
                hisAttachmentSourceIdBo.setId(newId);
                hisAttachmentSourceIdBo.setSourceId(boId);
                hisAttachmentSourceIdBo.setFirstVersion(true);
                hisAttachmentSourceIdBoList.add(hisAttachmentSourceIdBo);
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyNewVersion, this.getBaseIgnoreKeys(), (boolean)true);
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dyNewVersion);
                dynamicObject.set("iscurrentversion", (Object)Character.valueOf('1'));
                currentDynamicObjectList.add(dynamicObject);
                dyNewVersion.set("datastatus", (Object)HisEffDateCommonService.getInstance().calcDataStatus(effStartDate, effEndDate));
                dyNewVersion.set("iscurrentversion", (Object)Character.valueOf('0'));
                this.setCustomizedFiledValue(dyNewVersion, i, customizedFiledValue);
            }
            dynamicObject.set("datastatus", (Object)HisEffDateCommonService.getInstance().calcDataStatus(effStartDate, effEndDate));
            dynamicObject.set("iscurrentversion", (Object)Character.valueOf('0'));
            ArrayList<DynamicObject> dynamicObjectList = (ArrayList<DynamicObject>)mapBoIdGroupData.get(boId);
            if (dynamicObjectList == null) {
                dynamicObjectList = new ArrayList<DynamicObject>();
            }
            if (dyNewVersion != null) {
                dynamicObjectList.add(dyNewVersion);
            } else {
                dynamicObjectList.add(dynamicObject);
            }
            mapBoIdGroupData.put(boId, dynamicObjectList);
        }
        HisAttachAndDataBo hisAttachAndDataBo = new HisAttachAndDataBo();
        hisAttachAndDataBo.setMapBoIdGroupData(mapBoIdGroupData);
        hisAttachAndDataBo.setHisAttachmentSourceIdBoList(hisAttachmentSourceIdBoList);
        return hisAttachAndDataBo;
    }

    private HisTransBo buildHisTransBo(HisVersionParamBo hisVersionParamBo, HisTransBo hisTransBo, Map<Long, List<DynamicObject>> mapBoIdGroupData) {
        if (hisTransBo == null) {
            hisTransBo = new HisTransBo();
        }
        if (mapBoIdGroupData.size() == 1) {
            hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_SINGLE.getValue());
        } else {
            boolean atomicTrans = hisVersionParamBo.isAtomicTrans();
            if (atomicTrans) {
                hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
            } else {
                hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_NOTATOM.getValue());
            }
        }
        return hisTransBo;
    }

    private void buildNewVersionHisTransBo(HisTransBo hisTransBo, List<DynamicObject> newDynamicObjectResult) {
        if (hisTransBo == null || CollectionUtils.isEmpty(newDynamicObjectResult)) {
            return;
        }
        List<HisTransBusinessBo> hisTransBusinessBoList = hisTransBo.getListHisTransBusinessBo();
        HashMap<Long, HisTransBusinessBo> businessBoMap = new HashMap<Long, HisTransBusinessBo>(8);
        for (HisTransBusinessBo hisTransBusinessBo : hisTransBusinessBoList) {
            businessBoMap.put(hisTransBusinessBo.getBoId(), hisTransBusinessBo);
        }
        Map<Long, List<DynamicObject>> mapBoIdGroupData = this.groupDynamicObjectByBoId(newDynamicObjectResult);
        ORM orm = ORM.create();
        for (Map.Entry<Long, List<DynamicObject>> entry : mapBoIdGroupData.entrySet()) {
            List<HisTransVersionBo> hisTransVersionBoList;
            Long boId = entry.getKey();
            List<DynamicObject> newDynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(newDynamicObjectList)) continue;
            HisTransBusinessBo hisTransBusinessBo = (HisTransBusinessBo)businessBoMap.get(boId);
            if (hisTransBusinessBo == null) {
                hisTransBusinessBo = new HisTransBusinessBo();
                hisTransBusinessBo.setBoId(boId);
                hisTransBusinessBoList.add(hisTransBusinessBo);
            }
            if (CollectionUtils.isEmpty(hisTransVersionBoList = hisTransBusinessBo.getListHisTransVersionBo())) {
                hisTransVersionBoList = new ArrayList<HisTransVersionBo>(8);
                hisTransBusinessBo.setListHisTransVersionBo(hisTransVersionBoList);
            }
            if (CollectionUtils.isEmpty(newDynamicObjectList)) continue;
            String entityNumber = newDynamicObjectList.get(0).getDataEntityType().getName();
            hisTransBusinessBo.setEntityNumber(entityNumber);
            long[] ids = this.getIds(orm, entityNumber, newDynamicObjectList);
            int step = 0;
            for (DynamicObject dynamicObject : newDynamicObjectList) {
                HisTransVersionBo hisTransVersionBo = new HisTransVersionBo();
                Long versionId = dynamicObject.getLong("id");
                if (versionId == null || versionId == 0L) {
                    versionId = ids[step];
                    dynamicObject.set("id", (Object)versionId);
                    ++step;
                }
                hisTransVersionBo.setVersionId(versionId);
                hisTransVersionBoList.add(hisTransVersionBo);
            }
        }
    }

    private long[] getIds(ORM orm, String entityNumber, List<DynamicObject> newDynamicObjectList) {
        return orm.genLongIds(entityNumber, newDynamicObjectList.size());
    }

    private Map<Long, List<DynamicObject>> groupDynamicObjectByBoId(List<DynamicObject> dynamicObjectResult) {
        if (CollectionUtils.isEmpty(dynamicObjectResult)) {
            return null;
        }
        HashMap<Long, List<DynamicObject>> mapBoIdGroupData = new HashMap<Long, List<DynamicObject>>(dynamicObjectResult.size());
        for (DynamicObject dynamicObject : dynamicObjectResult) {
            Long boId = dynamicObject.getLong("boid");
            ArrayList<DynamicObject> subDynamicObjectList = null;
            subDynamicObjectList = mapBoIdGroupData.containsKey(boId) ? (ArrayList<DynamicObject>)mapBoIdGroupData.get(boId) : new ArrayList<DynamicObject>(8);
            subDynamicObjectList.add(dynamicObject);
            mapBoIdGroupData.put(boId, subDynamicObjectList);
        }
        return mapBoIdGroupData;
    }

    private EffStartEndDateBo[] buildStartEndDateBoList(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return null;
        }
        ArrayList<EffStartEndDateBo> effStartEndDateBoList = new ArrayList<EffStartEndDateBo>(dynamicObjectList.size());
        if (dynamicObjectList == null || dynamicObjectList.size() == 0) {
            return null;
        }
        for (DynamicObject dynamicObject : dynamicObjectList) {
            EffStartEndDateBo effStartEndDateBo = new EffStartEndDateBo();
            effStartEndDateBo.setEffectStartDate(dynamicObject.getDate("bsed"));
            effStartEndDateBo.setEffectEndDate(dynamicObject.getDate("bsled"));
            boolean hasPlanBsedField = dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"changebsed");
            if (hasPlanBsedField) {
                effStartEndDateBo.setPlanBsed(dynamicObject.getDate("changebsed"));
            } else {
                effStartEndDateBo.setPlanBsed(dynamicObject.getDate("bsed"));
            }
            effStartEndDateBoList.add(effStartEndDateBo);
        }
        Object[] effStartEndDateBos = effStartEndDateBoList.toArray(new EffStartEndDateBo[effStartEndDateBoList.size()]);
        SortingEffStartEndDateBoService.getInstance().quickSort(effStartEndDateBos);
        return effStartEndDateBos;
    }

    private void removeVersion(List<DynamicObject> newDynamicObjectResult, Set<String> dataStatusSet) {
        Iterator<DynamicObject> it = newDynamicObjectResult.iterator();
        while (it.hasNext()) {
            DynamicObject dynamicObject = it.next();
            if (!dataStatusSet.contains(dynamicObject.getString("datastatus"))) continue;
            it.remove();
        }
    }

    private void processAttachment(List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList, List<DynamicObject> currentDynamicObjectList, Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos, String entityNumber) {
        if (hisAttachmentSourceIdBoList == null) {
            hisAttachmentSourceIdBoList = new ArrayList<HisAttachmentSourceIdBo>(8);
        }
        HashSet setKey = new HashSet(8);
        hisAttachmentSourceIdBoList.forEach(hisAttachmentSourceIdBo -> setKey.add(hisAttachmentSourceIdBo.getSourceId()));
        for (DynamicObject dynamicObject : currentDynamicObjectList) {
            Long id = dynamicObject.getLong("id");
            if (setKey.contains(id)) continue;
            HisAttachmentSourceIdBo hisAttachmentSourceIdBo2 = new HisAttachmentSourceIdBo();
            hisAttachmentSourceIdBo2.setId(dynamicObject.getLong("id"));
            hisAttachmentSourceIdBo2.setSourceId(dynamicObject.getLong("sourcevid"));
            hisAttachmentSourceIdBoList.add(hisAttachmentSourceIdBo2);
        }
        HisAttachmentService.processAttachment(hisAttachmentSourceIdBoList, mapHisAttachmentBos, entityNumber);
    }

    private Map<Long, List<DynamicObject>> getDyListGroupByBoId(DynamicObject[] allDynamicObjects) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        if (allDynamicObjects == null || allDynamicObjects.length == 0) {
            return map;
        }
        for (DynamicObject dynamicObject : allDynamicObjects) {
            Long boId = dynamicObject.getLong("boid");
            List dynamicObjectList = (List)map.get(boId);
            if (dynamicObjectList == null) {
                dynamicObjectList = Lists.newArrayListWithExpectedSize((int)allDynamicObjects.length);
                map.put(boId, dynamicObjectList);
            }
            dynamicObjectList.add(dynamicObject);
        }
        return map;
    }

    private Set<String> getBaseIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("id");
        ignoreKeys.add("masterid");
        return ignoreKeys;
    }

    private void removeNewDy(List<DynamicObject> oldReUpdateVersionDys) {
        if (oldReUpdateVersionDys == null || oldReUpdateVersionDys.size() == 0) {
            return;
        }
        Iterator<DynamicObject> dynamicObjectIterator = oldReUpdateVersionDys.iterator();
        while (dynamicObjectIterator.hasNext()) {
            DynamicObject dynamicObject = dynamicObjectIterator.next();
            Long id = dynamicObject.getLong("id");
            if (id != null && id != 0L) continue;
            dynamicObjectIterator.remove();
        }
    }

    private void saveOldVersion(HRBaseServiceHelper serviceHelper, List<DynamicObject> oldReUpdateVersionDys) {
        for (DynamicObject dynamicObject : oldReUpdateVersionDys) {
            String dataStatus = dynamicObject.getString("datastatus");
            Date date = dynamicObject.getDate("brled");
            if (!EnumHisDataVersionStatus.INVALIDED.getStatus().equals(dataStatus) || date != null) continue;
            dynamicObject.set("brled", (Object)new Date());
        }
        serviceHelper.save(oldReUpdateVersionDys.toArray(new DynamicObject[oldReUpdateVersionDys.size()]));
    }

    private Long getVersionId(long[] ids, long[] firstVersionIds, int i, int size) {
        if (firstVersionIds == null || firstVersionIds.length == 0 || size != firstVersionIds.length) {
            return ids[size + i];
        }
        Long newID = firstVersionIds[i];
        if (newID == null || newID == 0L) {
            return ids[size + i];
        }
        return newID;
    }

    private void setCustomizedFiledValue(DynamicObject dynamicObject, int i, List<Map<String, Object>> customizedFiledValue) {
        if (customizedFiledValue == null || customizedFiledValue.size() == 0) {
            return;
        }
        Map<String, Object> customizedFiledValueMap = customizedFiledValue.get(i);
        DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObject.getDynamicObjectType().getProperties();
        for (Map.Entry<String, Object> entry : customizedFiledValueMap.entrySet()) {
            String filedName = entry.getKey();
            if (StringUtils.isEmpty((String)filedName) || !dataEntityPropertyCollection.containsKey((Object)filedName)) continue;
            dynamicObject.set(filedName, entry.getValue());
        }
    }
}

