/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.service.newhismodel.HisModelServiceFactory;
import kd.hr.hbp.business.domain.service.newhismodel.IHisSaveVersion;
import kd.hr.hbp.business.domain.service.newhismodel.IHisVersionChangeService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;

public abstract class AbstractHisVersionChangeService
implements IHisVersionChangeService {
    private static final Log LOGGER = LogFactory.getLog(AbstractHisVersionChangeService.class);

    @Override
    public void saveTempVersion(HisVersionParamBo hisVersionParamBo) {
        String entityNumber = hisVersionParamBo.getEntityNumber();
        if (StringUtils.isEmpty((String)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AbstractHisVersionChangeService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        HisValidateService.getInstance().validateAndProcessTempVersion(hisVersionParamBo, serviceHelper);
        IHisSaveVersion hisSaveVersion = HisModelServiceFactory.getHisSaveVersionInstance(hisVersionParamBo.getEntityNumber());
        hisSaveVersion.saveTempVersion(hisVersionParamBo, serviceHelper);
    }

    @Override
    public DynamicObject[] saveEffVersion(HisVersionParamBo hisVersionParamBo) {
        String entityNumber = hisVersionParamBo.getEntityNumber();
        if (StringUtils.isEmpty((String)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AbstractHisVersionChangeService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        HisValidateService.getInstance().validateEffVersion(hisVersionParamBo);
        IHisSaveVersion hisSaveVersion = HisModelServiceFactory.getHisSaveVersionInstance(hisVersionParamBo.getEntityNumber());
        HisTransBo hisTransBo = new HisTransBo();
        hisTransBo.setEventId(hisVersionParamBo.getEventId());
        try {
            DynamicObject[] dynamicObjects = hisSaveVersion.saveEffVersion(hisVersionParamBo, hisTransBo, serviceHelper, false);
            return dynamicObjects;
        }
        catch (KDBizException ex) {
            LOGGER.error("saveEffVersion error :entityNumber: {},message:{}.", (Object)entityNumber, (Object)ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            String errorMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractHisVersionChangeService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            LOGGER.error("saveEffVersion error :entityNumber: {},message:{}.", (Object)entityNumber, (Object)ex.getMessage());
            throw new KDBizException(errorMsg);
        }
    }

    @Override
    public HisResponse<VersionChangeRespData> hisVersionChange(HisVersionParamBo hisVersionParamBo) {
        HisResponse<VersionChangeRespData> hisResponse = new HisResponse<VersionChangeRespData>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(hisVersionParamBo.getEntityNumber());
        String operateType = hisVersionParamBo.getOperateType();
        if (StringUtils.isEmpty((String)operateType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AbstractHisVersionChangeService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (EnumHisOperateType.SAVE_VERSION.getType().equals(operateType)) {
            if (hisVersionParamBo.isEffImmediately()) {
                DynamicObject[] hisDyns = HisVersionChangeService.getInstance().saveEffVersion(hisVersionParamBo);
                HisVersionNumberService.getInstance().calcVersionNumber(hisVersionParamBo.getEntityNumber(), hisDyns, hisVersionParamBo.isCancel_notSupported());
                serviceHelper.save(hisDyns);
                VersionChangeRespData versionChangeRespData = new VersionChangeRespData();
                versionChangeRespData.setNewDynamicObjects(hisDyns);
                versionChangeRespData.setEventId(hisVersionParamBo.getEventId());
                hisResponse.setData(versionChangeRespData);
            } else {
                HisVersionChangeService.getInstance().saveTempVersion(hisVersionParamBo);
                DynamicObjectCommonService.getInstance().setMastId(hisVersionParamBo.getHisDyns());
                serviceHelper.save(hisVersionParamBo.getHisDyns());
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6b64\u64cd\u4f5c\u7c7b\u578b: s%", (String)"AbstractHisVersionChangeService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), operateType));
        }
        return hisResponse;
    }
}

