/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.ext.hr.metadata.field.HisModelBasedataField;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.application.impl.common.HrEntityCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseDataInfoBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisInitReturnBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRHisEntryObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisCommonService
implements IHisCommonService,
HisSysConstants {
    private static volatile HisCommonService hisCommonService = null;
    private static Log LOG = LogFactory.getLog(HisCommonService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisCommonService getInstance() {
        if (hisCommonService != null) return hisCommonService;
        Class<HisCommonService> clazz = HisCommonService.class;
        synchronized (HisCommonService.class) {
            if (hisCommonService != null) return hisCommonService;
            hisCommonService = new HisCommonService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisCommonService;
        }
    }

    @Override
    public String entityInhRelation(String entityNumber) {
        Map allFields = EntityMetadataCache.getDataEntityType((String)entityNumber).getAllFields();
        boolean boid = allFields.containsKey("boid");
        boolean isCurrentVersion = allFields.containsKey("iscurrentversion");
        boolean bsed = allFields.containsKey("bsed");
        if (boid && isCurrentVersion) {
            if (bsed) {
                return EnumEntityTpl.LINETIMESEQ_TPL.getNumber();
            }
            return EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber();
        }
        return EnumEntityTpl.COMMON_TPL.getNumber();
    }

    public boolean isOriginalTpl(String entityId) {
        List<String> parentEntity = HrEntityCommonService.getInstance().getParentEntity(entityId);
        List originalTplList = Arrays.stream(originalTpl).collect(Collectors.toList());
        for (String originalTpl : originalTplList) {
            if (!parentEntity.contains(originalTpl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBuBaseData(String entityNum) {
        Set allFields = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields().keySet();
        return allFields.containsAll(Stream.of("createorg", "org", "useorg", "ctrlstrategy").collect(Collectors.toSet()));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public HisInitReturnBo buildImportFilter(String mainEntityNumber, String f7FieldName, String baseEntityNumber) {
        if (StringUtils.isEmpty((CharSequence)f7FieldName) || StringUtils.isEmpty((CharSequence)baseEntityNumber)) {
            return null;
        }
        String inhRelation = HisCommonService.getInstance().entityInhRelation(baseEntityNumber);
        HisInitReturnBo hisInitReturnBo = new HisInitReturnBo();
        if (EnumEntityTpl.COMMON_TPL.getNumber().equals(inhRelation)) {
            hisInitReturnBo.setF7Version(false);
            hisInitReturnBo.setHisModel(false);
            return hisInitReturnBo;
        }
        if (EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(inhRelation)) {
            hisInitReturnBo.setF7Version(false);
            hisInitReturnBo.setHisModel(true);
            hisInitReturnBo.setqFilter(new QFilter("iscurrentversion", "=", (Object)"1"));
            return hisInitReturnBo;
        }
        if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(inhRelation)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
            if (dataEntityType instanceof QueryEntityType) {
                HashSet entityNums = Sets.newHashSetWithExpectedSize((int)16);
                String mainEntityNum = ((QueryEntityType)dataEntityType).getEntityName();
                entityNums.add(mainEntityNum);
                entityNums.addAll(((QueryEntityType)dataEntityType).getAllJoinEntityType().stream().map(DynamicObjectType::getName).collect(Collectors.toSet()));
                for (String entityNum : entityNums) {
                    HisInitReturnBo hisInitReturnBo1 = this.getHisInitReturnBo(entityNum, f7FieldName);
                    if (hisInitReturnBo1 == null) continue;
                    return hisInitReturnBo1;
                }
            } else {
                return this.getHisInitReturnBo(mainEntityNumber, f7FieldName);
            }
        }
        return null;
    }

    private HisInitReturnBo getHisInitReturnBo(String mainEntityNumber, String f7FieldName) {
        HisInitReturnBo hisInitReturnBo = new HisInitReturnBo();
        hisInitReturnBo.setHisModel(true);
        String entityId = MetadataDao.getIdByNumber((String)mainEntityNumber, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List entityItemList = entityMetadata.getItems();
        ArrayList<String> dataStatusList = new ArrayList<String>(10);
        dataStatusList.add(EnumHisDataVersionStatus.EFFECTING.getStatus());
        dataStatusList.add(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus());
        dataStatusList.add(EnumHisDataVersionStatus.INVALIDED.getStatus());
        for (EntityItem entityItem : entityItemList) {
            HisModelBasedataField hisModelBasedataField;
            if (!(entityItem instanceof HisModelBasedataField) || !(hisModelBasedataField = (HisModelBasedataField)entityItem).getKey().equals(f7FieldName)) continue;
            this.setHisInitReturnBo(hisModelBasedataField.getSelData(), hisInitReturnBo, dataStatusList);
            return hisInitReturnBo;
        }
        this.setHisInitReturnBo("bd", hisInitReturnBo, dataStatusList);
        return hisInitReturnBo;
    }

    @ExcludeFromJacocoGeneratedReport
    private void setHisInitReturnBo(String selData, HisInitReturnBo hisInitReturnBo, List<String> dataStatusList) {
        if (StringUtils.isEmpty((CharSequence)selData) || selData.equals("bd")) {
            hisInitReturnBo.setF7Version(false);
            hisInitReturnBo.setqFilter(new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "in", dataStatusList)));
        } else {
            QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"0").and(new QFilter("datastatus", "in", dataStatusList));
            hisInitReturnBo.setqFilter(qFilter);
            hisInitReturnBo.setF7Version(true);
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public HisBaseDataInfoBo getHisControlAttribute(String billFormId, String f7FieldName) {
        String basedField;
        HisBaseDataInfoBo bo = new HisBaseDataInfoBo();
        List<HashMap<String, Object>> list = this.findFormMeta(billFormId);
        if (list == null) {
            return bo;
        }
        for (Map map : list) {
            if (!map.containsKey("Key") || !map.get("Key").equals(f7FieldName)) continue;
            bo.setFieldName(f7FieldName);
            this.setHisBaseDataInfo(map, bo);
            break;
        }
        if (StringUtils.isNotEmpty((CharSequence)(basedField = bo.getBsedField()))) {
            for (HashMap<String, Object> map : list) {
                if (!map.get("Id").equals(basedField)) continue;
                bo.setBsedField((String)map.get("Key"));
                break;
            }
        }
        return bo;
    }

    @Override
    public List<HisBaseDataInfoBo> getHisControlAttributeBatch(String billFormId, Set<String> f7FieldNames) {
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)f7FieldNames.size());
        List<HashMap<String, Object>> list = this.findFormMeta(billFormId);
        if (list == null) {
            return boList;
        }
        for (HashMap<String, Object> map : list) {
            for (String f7FieldName : f7FieldNames) {
                if (!map.containsKey("Key") || !map.get("Key").equals(f7FieldName)) continue;
                HisBaseDataInfoBo bo = new HisBaseDataInfoBo();
                bo.setFieldName(f7FieldName);
                this.setHisBaseDataInfo(map, bo);
                boList.add(bo);
            }
        }
        for (HashMap<String, Object> map : list) {
            for (HisBaseDataInfoBo hisBaseDataInfoBo : boList) {
                if (!map.get("Id").equals(hisBaseDataInfoBo.getBsedField())) continue;
                hisBaseDataInfoBo.setBsedField((String)map.get("Key"));
            }
        }
        return boList;
    }

    private List<HashMap<String, Object>> findFormMeta(String billFormId) {
        String formId;
        Map designMeta;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        if (dataEntityType instanceof QueryEntityType) {
            MainEntityType mainEntityType = ((QueryEntityType)dataEntityType).getMainEntityType();
            billFormId = mainEntityType.getName();
        }
        if ((designMeta = MetadataDao.loadDesignerMetadata((String)(formId = MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Form)), (String)RequestContext.get().getLang().toString())) == null) {
            return null;
        }
        Map entitymeta = (Map)designMeta.get("entitymeta");
        if (entitymeta == null) {
            return null;
        }
        return (ArrayList)entitymeta.get("Items");
    }

    private void setHisBaseDataInfo(Map<String, Object> map, HisBaseDataInfoBo bo) {
        Object isShowCurrentNumAndName;
        Object isShowDisableData;
        String selData = (String)map.get("SelData");
        boolean flag = selData == null || "bd".equals(selData);
        bo.setSelData(flag);
        Object isShowUsed = map.get("isShowUsed");
        if (isShowUsed != null) {
            bo.setShowUsed((Boolean)isShowUsed);
        }
        if ((isShowDisableData = map.get("isShowDisableData")) != null) {
            bo.setShowDisableData((Boolean)isShowDisableData);
        }
        String bsedField = (String)map.get("bsedField");
        bo.setBsedField(bsedField);
        String effDateFieldType = (String)map.get("effDateFieldType");
        bo.setEffDateFieldType(effDateFieldType);
        Object isShowEffDateControl = map.get("isShowEffDateControl");
        if (isShowEffDateControl != null) {
            bo.setShowEffDateControl((Boolean)isShowEffDateControl);
        }
        if ((isShowCurrentNumAndName = map.get("isShowCurrentNumAndName")) != null) {
            bo.setShowCurrentNumAndName((Boolean)isShowCurrentNumAndName);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean equalsValue(Object v1, Object v2, boolean stringIgnoreCase, boolean checkMultiLang) {
        return this.equalsValueWhitMultiLangAllItem(v1, v2, stringIgnoreCase, checkMultiLang, true, false);
    }

    public boolean equalsValueMultiLangHasEqualItem(Object v1, Object v2, boolean stringIgnoreCase, boolean checkMultiLang) {
        return this.equalsValueWhitMultiLangAllItem(v1, v2, stringIgnoreCase, checkMultiLang, false, false);
    }

    public boolean equalsValueWithAll(Object v1, Object v2, boolean stringIgnoreCase, boolean checkMultiLang, boolean stringNullEqualsEmpty) {
        return this.equalsValueWhitMultiLangAllItem(v1, v2, stringIgnoreCase, checkMultiLang, true, stringNullEqualsEmpty);
    }

    private boolean equalsValueWhitMultiLangAllItem(Object v1, Object v2, boolean stringIgnoreCase, boolean checkMultiLang, boolean checkAllMultiItem, boolean stringNullEqualsEmpty) {
        if (v1 instanceof String || v2 instanceof String) {
            return this.stringEquals(v1, v2, stringIgnoreCase, stringNullEqualsEmpty);
        }
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Integer && v2 instanceof Long) {
            return ((Integer)v1).longValue() == ((Long)v2).longValue();
        }
        if (v1 instanceof Long && v2 instanceof Integer) {
            return ((Long)v1).longValue() == ((Integer)v2).longValue();
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof OrmLocaleValue && v2 instanceof OrmLocaleValue) {
            if (checkAllMultiItem) {
                return this.checkMultiLangAllItemEqual((OrmLocaleValue)v1, (OrmLocaleValue)v2, checkMultiLang, stringIgnoreCase);
            }
            return this.checkMultiLangHasEqualItem((OrmLocaleValue)v1, (OrmLocaleValue)v2, checkMultiLang, stringIgnoreCase);
        }
        if (v1 instanceof DynamicObjectCollection && v2 instanceof DynamicObjectCollection) {
            DynamicObjectCollection originalEntity = (DynamicObjectCollection)v1;
            DynamicObjectType entityType = originalEntity.getDynamicObjectType();
            if (entityType instanceof EntryType || entityType instanceof SubEntryType) {
                return this.compareEntryEntityValues(v1, v2);
            }
            if (v1 instanceof MulBasedataDynamicObjectCollection && v2 instanceof MulBasedataDynamicObjectCollection) {
                return this.compareMulBaseDataValues((MulBasedataDynamicObjectCollection)v1, (MulBasedataDynamicObjectCollection)v2, stringIgnoreCase, checkMultiLang);
            }
            return true;
        }
        if (v1 instanceof DynamicObject && v2 instanceof DynamicObject) {
            return ((DynamicObject)v1).get("id").equals(((DynamicObject)v2).get("id"));
        }
        if (!(v1 instanceof DynamicObject) && v2 instanceof DynamicObject) {
            return ObjectUtils.nullSafeEquals((Object)v1, (Object)((DynamicObject)v2).get("id"));
        }
        if (!(v2 instanceof DynamicObject) && v1 instanceof DynamicObject) {
            return ObjectUtils.nullSafeEquals((Object)v2, (Object)((DynamicObject)v1).get("id"));
        }
        return v1.equals(v2);
    }

    private boolean stringEquals(Object v1, Object v2, boolean stringIgnoreCase, boolean stringNullEqualsEmpty) {
        if (v1 == null && v2 != null) {
            if (v2 instanceof String) {
                if (stringNullEqualsEmpty) {
                    return ((String)v2).trim().equals("");
                }
                return false;
            }
            return false;
        }
        if (v2 == null && v1 != null) {
            if (v1 instanceof String) {
                if (stringNullEqualsEmpty) {
                    return ((String)v1).trim().equals("");
                }
                return false;
            }
            return false;
        }
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 != null && v2 != null) {
            if (stringIgnoreCase) {
                return ((String)v1).trim().equalsIgnoreCase(((String)v2).trim());
            }
            return ((String)v1).trim().equals(((String)v2).trim());
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean checkMultiLangHasEqualItem(OrmLocaleValue currentValue, OrmLocaleValue dbValue, boolean checkMultiLang, boolean ignoreCase) {
        boolean equal = false;
        if (currentValue == null && dbValue == null) {
            equal = false;
        } else if (currentValue == null || dbValue == null) {
            equal = true;
        } else {
            if (currentValue.size() == 0 && dbValue.size() == 0) {
                equal = true;
                return equal;
            }
            for (String currentKey : currentValue.keySet()) {
                if (!checkMultiLang && !currentKey.equals(Lang.get().name()) || !(equal = ignoreCase ? StringUtils.equalsIgnoreCase((CharSequence)currentValue.get((Object)currentKey), (CharSequence)dbValue.get((Object)currentKey)) : StringUtils.equals((CharSequence)currentValue.get((Object)currentKey), (CharSequence)dbValue.get((Object)currentKey)))) continue;
                break;
            }
        }
        return equal;
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean checkMultiLangAllItemEqual(OrmLocaleValue currentValue, OrmLocaleValue dbValue, boolean checkMultiLang, boolean ignoreCase) {
        boolean equal = false;
        if (currentValue == null && dbValue == null) {
            equal = false;
        } else if (currentValue == null || dbValue == null) {
            equal = true;
        } else {
            if (currentValue.size() == 0 && dbValue.size() == 0) {
                equal = true;
                return equal;
            }
            for (String currentKey : currentValue.keySet()) {
                if (!checkMultiLang && !currentKey.equals(Lang.get().name()) || (equal = ignoreCase ? StringUtils.equalsIgnoreCase((CharSequence)currentValue.get((Object)currentKey), (CharSequence)dbValue.get((Object)currentKey)) : StringUtils.equals((CharSequence)currentValue.get((Object)currentKey), (CharSequence)dbValue.get((Object)currentKey)))) continue;
                return false;
            }
        }
        return equal;
    }

    public Date getCalcDay(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    @ExcludeFromJacocoGeneratedReport
    public void calcVersionStatus(List<DynamicObject> dynamicObjectList) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjectList) {
            Date effStartDate = dynamicObject.getDate("bsed");
            Date effEndDate = dynamicObject.getDate("bsled");
            dynamicObject.set("datastatus", (Object)HisEffDateCommonService.getInstance().calcDataStatus(effStartDate, effEndDate));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void calcVersionStatusByArray(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date effStartDate = dynamicObject.getDate("bsed");
            Date effEndDate = dynamicObject.getDate("bsled");
            dynamicObject.set("datastatus", (Object)HisEffDateCommonService.getInstance().calcDataStatus(effStartDate, effEndDate));
        }
    }

    public Map<Long, List<DynamicObject>> groupByBoIdDyMap(DynamicObject[] allDynamicObjects) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : allDynamicObjects) {
            Long boId = dynamicObject.getLong("boid");
            ArrayList<DynamicObject> dynamicObjectList = (ArrayList<DynamicObject>)map.get(boId);
            if (dynamicObjectList == null) {
                dynamicObjectList = new ArrayList<DynamicObject>();
                map.put(boId, dynamicObjectList);
            }
            dynamicObjectList.add(dynamicObject);
        }
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    public Map<Long, DynamicObject> groupByBoIdCurrentDyMap(DynamicObject[] dynamicObjects) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long boId = dynamicObject.getLong("boid");
            if (map.get(boId) != null) continue;
            map.put(boId, dynamicObject);
        }
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean compareMulBaseDataValues(MulBasedataDynamicObjectCollection v1, MulBasedataDynamicObjectCollection v2, boolean stringIgnoreCase, boolean checkMultiLang) {
        if (Objects.isNull(v1) || v1.size() == 0) {
            return Objects.isNull(v2) || v2.size() == 0;
        }
        if (Objects.isNull(v2) || v2.size() == 0) {
            return true;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        int size = v1.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dy1 = (DynamicObject)v1.get(i);
            DynamicObject dy2 = (DynamicObject)v2.get(i);
            if (!dy1.getDynamicObjectType().getProperties().containsKey((Object)"fbasedataid") || !dy2.getDynamicObjectType().getProperties().containsKey((Object)"fbasedataid")) {
                return false;
            }
            DynamicObject dynamicObject1 = dy1.getDynamicObject("fbasedataid");
            DynamicObject dynamicObject2 = dy2.getDynamicObject("fbasedataid");
            if (!(HRStringUtils.equals((String)dynamicObject1.getDynamicObjectType().getName(), (String)"bd_attachment") ? !this.compareAttachFieldValues(dynamicObject1, dynamicObject2, stringIgnoreCase, checkMultiLang) : !HRObjectUtils.equals((Object)dynamicObject1.getPkValue(), (Object)dynamicObject2.getPkValue()))) continue;
            return false;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean compareAttachFieldValues(DynamicObject dynamicObject1, DynamicObject dynamicObject2, boolean stringIgnoreCase, boolean checkMultiLang) {
        if (!dynamicObject1.getDynamicObjectType().getProperties().containsKey((Object)"name") || !dynamicObject1.getDynamicObjectType().getProperties().containsKey((Object)"url")) {
            return true;
        }
        if (dynamicObject2 == null) {
            return false;
        }
        Object v1 = dynamicObject1.get("name");
        Object v2 = dynamicObject2.get("name");
        if (!(v1 instanceof OrmLocaleValue) || !(v2 instanceof OrmLocaleValue)) {
            return true;
        }
        if (!this.checkMultiLangHasEqualItem((OrmLocaleValue)v1, (OrmLocaleValue)v2, checkMultiLang, stringIgnoreCase)) {
            return false;
        }
        String url1 = dynamicObject1.getString("url");
        String url2 = dynamicObject2.getString("url");
        return HRStringUtils.equals((String)url1, (String)url2);
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean compareEntryEntityValues(Object v1, Object v2) {
        DynamicObjectCollection originalEntity = (DynamicObjectCollection)v1;
        DynamicObjectCollection personalEntity = (DynamicObjectCollection)v2;
        if (Objects.isNull(originalEntity) || originalEntity.size() == 0) {
            return Objects.isNull(personalEntity) || personalEntity.size() == 0;
        }
        if (Objects.isNull(personalEntity) || personalEntity.size() == 0) {
            return false;
        }
        if (originalEntity.size() != personalEntity.size()) {
            return false;
        }
        String entryBoIdFiledName = HRHisEntryObjectUtils.getEntryBoIdFiledName((DynamicObjectCollection)originalEntity);
        Map originalBoidToDyMaps = originalEntity.stream().collect(Collectors.toMap(dy -> dy.getLong(entryBoIdFiledName), Function.identity()));
        Map personalBoidToDyMaps = personalEntity.stream().collect(Collectors.toMap(dy -> dy.getLong(entryBoIdFiledName), Function.identity()));
        for (Map.Entry entry : originalBoidToDyMaps.entrySet()) {
            Long entryBoid = entry.getKey();
            DynamicObject personalBoDy = (DynamicObject)personalBoidToDyMaps.get(entryBoid);
            if (HRObjectUtils.isEmpty((Object)personalBoDy)) {
                return false;
            }
            DynamicObject originalBoDy = (DynamicObject)entry.getValue();
            DataEntityPropertyCollection properties = originalBoDy.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String fieldName = property.getName();
                if (HRStringUtils.isEmpty((String)fieldName) || HRStringUtils.equals((String)"id", (String)fieldName) || HRStringUtils.equals((String)"seq", (String)fieldName) || this.equalsValue(originalBoDy.get(fieldName), personalBoDy.get(fieldName), true, true)) continue;
                return false;
            }
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    public Object getVersionId(Object focusRowPkId, String entityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter qFilter = new QFilter("id", "=", focusRowPkId);
        DynamicObject dy = serviceHelper.queryOriginalOne("id,iscurrentversion,sourcevid", qFilter.toArray());
        if (dy == null) {
            return focusRowPkId;
        }
        if (dy.getBoolean("iscurrentversion")) {
            return dy.get("sourcevid");
        }
        return focusRowPkId;
    }

    @ExcludeFromJacocoGeneratedReport
    public Map<Long, Date> getFirstEffDateMap(String entityNumber, Set<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return null;
        }
        HashMap firstEffDateMap = Maps.newHashMapWithExpectedSize((int)boIds.size());
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        DynamicObjectCollection effDys = helper.queryOriginalCollection("id,firstbsed", new QFilter[]{new QFilter("id", "in", boIds)});
        for (DynamicObject effDy : effDys) {
            firstEffDateMap.put(effDy.getLong("id"), effDy.getDate("firstbsed"));
        }
        return firstEffDateMap;
    }

    public boolean hasDataRuleRight(Object id, String entityNumber) {
        Boolean hasRight = null;
        QFilter filter = new QFilter("id", "in", (Object)new Object[]{id});
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
        Map result = (Map)HRMServiceHelper.invokeHRMPService("hrcs", "IHRCSDataPermissionService", "matchDataRule", RequestContext.get().getCurrUserId(), appId, entityNumber, "4715a0df000000ac", new QFilter[]{filter}, Maps.newHashMapWithExpectedSize((int)16));
        if (result != null) {
            hasRight = (Boolean)result.get(id);
        }
        return hasRight == null || hasRight != false;
    }

    public boolean hasInitStatusFiled(IDataEntityType dataEntityType, String entityNumber) {
        if (dataEntityType == null) {
            if (entityNumber == null) {
                return false;
            }
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        if (dataEntityType == null) {
            return false;
        }
        boolean hasInitStatus = dataEntityType.getProperties().containsKey((Object)"initstatus");
        if (hasInitStatus) {
            hasInitStatus = StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)dataEntityType.getProperties().get((Object)"initstatus")).getAlias());
        }
        return hasInitStatus;
    }

    public void findAttachments(Control control, Set<String> attachmentKeys) {
        if (control instanceof Container) {
            for (Control item : ((Container)control).getItems()) {
                this.findAttachments(item, attachmentKeys);
            }
        } else if (control instanceof AttachmentPanel) {
            attachmentKeys.add(control.getKey());
        }
    }

    public boolean hasAttachments(Control control) {
        HashSet attachKeys = Sets.newHashSetWithExpectedSize((int)16);
        this.findAttachments(control, attachKeys);
        return !CollectionUtils.isEmpty((Collection)attachKeys);
    }
}

