/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.attachment.HisAttachmentSourceIdBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisPersonalDataRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisNonLineTimeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisDisabledService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisPersonalDataType;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRHisEntryObjectUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HisDisabledService
implements IHisDisabledService {
    private static volatile HisDisabledService hisDisabledService = null;
    private static final Log LOGGER = LogFactory.getLog(HisDisabledService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisDisabledService getInstance() {
        if (hisDisabledService != null) return hisDisabledService;
        Class<HisDisabledService> clazz = HisDisabledService.class;
        synchronized (HisDisabledService.class) {
            if (hisDisabledService != null) return hisDisabledService;
            hisDisabledService = new HisDisabledService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisDisabledService;
        }
    }

    @Override
    public void disableOrEnableBo(HisEnableParamBo hisEnableParamBo) {
        String entityNumber = hisEnableParamBo.getHisBaseBo().getEntityNumber();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisDisabledService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        List<Long> boIdList = hisEnableParamBo.getHisBaseBo().getBoIdList();
        if (CollectionUtils.isEmpty(boIdList) && hisEnableParamBo.getHisBaseBo().getDyCurrents() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"boid\u5217\u8868\u4e0edyCurrents\u53c2\u6570\u4e0d\u80fd\u5168\u4e3a\u7a7a", (String)"HisDisabledService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String entityType = HisCommonService.getInstance().entityInhRelation(entityNumber);
        if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType)) {
            if (hisEnableParamBo.isDisabled()) {
                this.disableTimeSeqBo(hisEnableParamBo);
            } else {
                this.enableTimeSeqBo(hisEnableParamBo);
            }
        } else if (EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType)) {
            QFilter qFilter = new QFilter("id", "in", boIdList);
            Object[] nonLineRelEffectingDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, qFilter);
            if (ArrayUtils.isEmpty((Object[])nonLineRelEffectingDys)) {
                return;
            }
            Arrays.stream(nonLineRelEffectingDys).forEach(nonLineRelEffectingDy -> {
                if (hisEnableParamBo.isDisabled()) {
                    nonLineRelEffectingDy.set("enable", (Object)"0");
                } else {
                    nonLineRelEffectingDy.set("enable", (Object)"1");
                }
            });
            HisNonLineTimeService hisNonLineTimeService = new HisNonLineTimeService();
            hisNonLineTimeService.handleDisableOrEnableData((DynamicObject[])nonLineRelEffectingDys);
        }
    }

    private void disableTimeSeqBo(HisEnableParamBo hisEnableParamBo) {
        String entityNumber = hisEnableParamBo.getHisBaseBo().getEntityNumber();
        List<Long> boIdList = hisEnableParamBo.getHisBaseBo().getBoIdList();
        if (boIdList == null) {
            return;
        }
        List<Long> personalIdList = this.getPersonalIds(hisEnableParamBo.getEffectDate(), hisEnableParamBo.getHisBaseBo().getEntityNumber(), boIdList);
        if (personalIdList != null) {
            boIdList.addAll(personalIdList);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        Date effectDate = hisEnableParamBo.getEffectDate();
        effectDate = HRDateTimeUtils.splitYYYY_MM_DD((Date)effectDate);
        Date now = null;
        DynamicObject[] dynamicObjects = hisEnableParamBo.getHisBaseBo().getDyCurrents();
        if (effectDate == null) {
            now = HisEffDateCommonService.getInstance().getNowMaskDate(entityNumber);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                dynamicObjects = HisCommonEntityRepository.getAllCurrentValidDataByBoId(serviceHelper, boIdList);
            }
        } else if (dynamicObjects == null || dynamicObjects.length == 0) {
            dynamicObjects = HisCommonEntityRepository.getValidDataVersionByDate(serviceHelper, boIdList, effectDate);
        }
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(8);
        ORM orm = ORM.create();
        ArrayList hisAttachmentSourceIdBoList = Lists.newArrayListWithCapacity((int)8);
        ArrayList<DynamicObject> dynamicObjectTempList = new ArrayList<DynamicObject>(4);
        boolean hasStatus = dynamicObjects[0].getDynamicObjectType().getProperties().containsKey((Object)"status");
        long[] ids = orm.genLongIds(entityNumber, dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            String status;
            DynamicObject dynamicObject = dynamicObjects[i];
            String dataStatus = dynamicObject.getString("datastatus");
            String string = status = hasStatus ? dynamicObject.getString("status") : "C";
            if (EnumHisDataVersionStatus.TEMP.getStatus().equals(dataStatus) && "B".equals(status)) {
                dynamicObject.set("enable", (Object)"0");
                dynamicObjectTempList.add(dynamicObject);
                continue;
            }
            DynamicObject dyNewVersion = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyNewVersion);
            dyNewVersion.set("id", (Object)ids[i]);
            boolean isCurrentVersion = dynamicObject.getBoolean("iscurrentversion");
            if (EnumHisDataVersionStatus.TEMP.getStatus().equals(dataStatus) && isCurrentVersion) {
                HRHisEntryObjectUtils.initEntryBoId((DynamicObject[])new DynamicObject[]{dyNewVersion}, (String)entityNumber);
            }
            if (effectDate == null) {
                if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus)) {
                    dyNewVersion.set("bsed", (Object)now);
                }
            } else {
                dyNewVersion.set("bsed", (Object)effectDate);
            }
            try {
                Date effEndDate = HRDateTimeUtils.parseDate((String)"2999-12-31");
                dyNewVersion.set("bsled", (Object)effEndDate);
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dyNewVersion);
                DynamicObjectCommonService.getInstance().setMastId(dyNewVersion);
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
            }
            dyNewVersion.set("iscurrentversion", (Object)"0");
            dyNewVersion.set("enable", (Object)"0");
            dynamicObjectList.add(dyNewVersion);
            HisAttachmentSourceIdBo hisAttachmentSourceIdBo = new HisAttachmentSourceIdBo();
            hisAttachmentSourceIdBo.setId(ids[i]);
            hisAttachmentSourceIdBo.setSourceId(dynamicObject.getLong("sourcevid"));
            hisAttachmentSourceIdBoList.add(hisAttachmentSourceIdBo);
        }
        if (dynamicObjectList.size() > 0) {
            HisVersionParamBo hisVersionParamBo = this.buildHisVersionParamBo(entityNumber, dynamicObjectList, hisAttachmentSourceIdBoList, hisEnableParamBo);
            hisVersionParamBo.setPersonalDataType(EnumHisPersonalDataType.NO_PROCESS_DATA.getType());
            DynamicObject[] dataCol = HisVersionChangeService.getInstance().saveEffVersion(hisVersionParamBo);
            HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, dataCol);
            serviceHelper.save(dataCol);
            hisEnableParamBo.setMapHisAttachmentBos(hisVersionParamBo.getMapHisAttachmentBos());
        }
        if (dynamicObjectTempList.size() > 0) {
            serviceHelper.save(dynamicObjectTempList.toArray(new DynamicObject[dynamicObjectTempList.size()]));
        }
    }

    private void enableTimeSeqBo(HisEnableParamBo hisEnableParamBo) {
        String entityNumber = hisEnableParamBo.getHisBaseBo().getEntityNumber();
        List<Long> boIdList = hisEnableParamBo.getHisBaseBo().getBoIdList();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        Date effectDate = this.getEffectDate(hisEnableParamBo, entityNumber);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(8);
        DynamicObject[] dyCurrents = hisEnableParamBo.getHisBaseBo().getDyCurrents();
        if (dyCurrents == null || dyCurrents.length == 0) {
            dyCurrents = HisCommonEntityRepository.getAllCurrentValidDataByBoId(serviceHelper, boIdList);
        }
        if (CollectionUtils.isEmpty(boIdList)) {
            boIdList = new ArrayList<Long>(dyCurrents.length);
            for (DynamicObject dynamicObject : dyCurrents) {
                boIdList.add(dynamicObject.getLong("boid"));
            }
        }
        Map<Long, EffStartEndDateBo> mapBoIdDate = HisCommonEntityRepository.getVersionEffEndDate(serviceHelper, boIdList, effectDate);
        ORM orm = ORM.create();
        ArrayList hisAttachmentSourceIdBoList = Lists.newArrayListWithCapacity((int)8);
        ArrayList<DynamicObject> dynamicObjectTempList = new ArrayList<DynamicObject>(4);
        long[] ids = orm.genLongIds(entityNumber, dyCurrents.length);
        for (int i = 0; i < dyCurrents.length; ++i) {
            DynamicObject dynamicObject = dyCurrents[i];
            if (EnumHisDataVersionStatus.TEMP.getStatus().equals(dynamicObject.getString("datastatus"))) {
                dynamicObject.set("enable", (Object)"1");
                dynamicObjectTempList.add(dynamicObject);
                continue;
            }
            DynamicObject dyNewVersion = serviceHelper.generateEmptyDynamicObject();
            Long boId = dynamicObject.getLong("boid");
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyNewVersion);
            dyNewVersion.set("id", (Object)ids[i]);
            EffStartEndDateBo effStartEndDateBo = mapBoIdDate.get(boId);
            if (effStartEndDateBo == null) continue;
            Date dateEffectStartDate = effStartEndDateBo.getEffectStartDate();
            Date dateEffectEndDate = effStartEndDateBo.getEffectEndDate();
            if (dateEffectStartDate != null && dateEffectStartDate.getTime() > effectDate.getTime()) {
                dyNewVersion.set("bsed", (Object)dateEffectStartDate);
            } else {
                dyNewVersion.set("bsed", (Object)effectDate);
            }
            dyNewVersion.set("bsled", (Object)dateEffectEndDate);
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dyNewVersion);
            DynamicObjectCommonService.getInstance().setMastId(dyNewVersion);
            dyNewVersion.set("iscurrentversion", (Object)"0");
            dyNewVersion.set("enable", (Object)"1");
            HisAttachmentSourceIdBo hisAttachmentSourceIdBo = new HisAttachmentSourceIdBo();
            hisAttachmentSourceIdBo.setId(ids[i]);
            hisAttachmentSourceIdBo.setSourceId(dynamicObject.getLong("sourcevid"));
            hisAttachmentSourceIdBoList.add(hisAttachmentSourceIdBo);
            dynamicObjectList.add(dyNewVersion);
        }
        if (dynamicObjectList.size() > 0) {
            HisVersionParamBo hisVersionParamBo = this.buildHisVersionParamBo(entityNumber, dynamicObjectList, hisAttachmentSourceIdBoList, hisEnableParamBo);
            hisVersionParamBo.setPersonalDataType(4);
            DynamicObject[] dataCol = HisVersionChangeService.getInstance().saveEffVersion(hisVersionParamBo);
            HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, dataCol);
            serviceHelper.save(dataCol);
            hisEnableParamBo.setMapHisAttachmentBos(hisVersionParamBo.getMapHisAttachmentBos());
        }
        if (dynamicObjectTempList.size() > 0) {
            serviceHelper.save(dynamicObjectTempList.toArray(new DynamicObject[dynamicObjectTempList.size()]));
        }
    }

    private Date getEffectDate(HisEnableParamBo hisEnableParamBo, String entityNumber) {
        Date effectDate = hisEnableParamBo.getEffectDate();
        if (effectDate == null) {
            return HisEffDateCommonService.getInstance().getNowMaskDate(entityNumber);
        }
        return effectDate;
    }

    private HisVersionParamBo buildHisVersionParamBo(String entityNumber, List<DynamicObject> dynamicObjectList, List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList, HisEnableParamBo hisEnableParamBo) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setHisDyns(dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
        Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos = HisAttachmentService.processAttachment(hisAttachmentSourceIdBoList, entityNumber);
        hisVersionParamBo.setMapHisAttachmentBos(mapHisAttachmentBos);
        hisVersionParamBo.setNeedProcessAttachment(false);
        hisVersionParamBo.setAtomicTrans(hisEnableParamBo.isAtomicTrans());
        hisVersionParamBo.setEventId(hisEnableParamBo.getEventId());
        return hisVersionParamBo;
    }

    public List<Long> getPersonalIds(Date disableDate, String entityNumber, List<Long> masterIdSet) {
        if (entityNumber == null) {
            return null;
        }
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        List<Long> personalBoIdSet = HisPersonalDataRepository.getBoIdListByMasterId(serviceHelper, masterIdSet);
        if (personalBoIdSet == null) {
            return null;
        }
        if (disableDate == null) {
            disableDate = HisEffDateCommonService.getInstance().getNowMaskDate(entityNumber);
        }
        QFilter idQFilter = new QFilter("boid", "in", personalBoIdSet);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter versionQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter currentDateQFilter = new QFilter("bsed", "<=", (Object)disableDate).and(new QFilter("bsled", ">=", (Object)disableDate));
        QFilter dateQFilter = new QFilter("bsed", ">=", (Object)disableDate).or(currentDateQFilter);
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()));
        DynamicObjectCollection personalVersionCol = serviceHelper.queryOriginalCollection("boid", new QFilter[]{idQFilter, dateQFilter, dataStatusQFilter, versionQFilter, enableQFilter});
        Set personalDataIds = personalVersionCol.stream().map(data -> data.getLong("boid")).collect(Collectors.toSet());
        personalBoIdSet.removeIf(next -> !personalDataIds.contains(next));
        return personalBoIdSet;
    }
}

