/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisValidateRespBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.SortingEffStartEndDateBoService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HisEffDateCommonService
implements IHisEffDateCommonService {
    private static final Log LOGGER = LogFactory.getLog(HisEffDateCommonService.class);
    private static volatile HisEffDateCommonService hisEffDateCommonService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisEffDateCommonService getInstance() {
        if (hisEffDateCommonService != null) return hisEffDateCommonService;
        Class<HisEffDateCommonService> clazz = HisEffDateCommonService.class;
        synchronized (HisEffDateCommonService.class) {
            if (hisEffDateCommonService != null) return hisEffDateCommonService;
            hisEffDateCommonService = new HisEffDateCommonService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisEffDateCommonService;
        }
    }

    @Override
    public String calcDataStatus(Date effStartDate, Date effEndDate) {
        if (effEndDate.getTime() < effStartDate.getTime()) {
            return null;
        }
        Date now = new Date();
        Calendar calendarEndTime = Calendar.getInstance();
        calendarEndTime.setTime(effEndDate);
        calendarEndTime.add(5, 1);
        if (now.getTime() < effStartDate.getTime()) {
            return EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus();
        }
        if (now.getTime() >= effStartDate.getTime() && now.getTime() < calendarEndTime.getTime().getTime()) {
            return EnumHisDataVersionStatus.EFFECTING.getStatus();
        }
        if (now.getTime() >= calendarEndTime.getTime().getTime()) {
            return EnumHisDataVersionStatus.INVALIDED.getStatus();
        }
        return null;
    }

    public String calcPlanDateDataStatus(Date planBsed, Date planBsLed) {
        Date now = new Date();
        if (now.getTime() < planBsed.getTime()) {
            return EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus();
        }
        if (now.getTime() >= planBsed.getTime() && now.getTime() < planBsLed.getTime()) {
            return EnumHisDataVersionStatus.EFFECTING.getStatus();
        }
        if (now.getTime() >= planBsLed.getTime()) {
            return EnumHisDataVersionStatus.INVALIDED.getStatus();
        }
        return null;
    }

    public List<DynamicObject> reBuildDataStatusBySortedArray(DynamicObject[] dynamicObjects) {
        ArrayList needUpdateVersion = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        Date planBsled = HisEffDateCommonService.getInstance().getDate2999(null);
        boolean findEffectingVersion = false;
        boolean hasPlanBsedField = dynamicObjects[0].getDynamicObjectType().getProperties().containsKey((Object)"changebsed");
        for (int i = dynamicObjects.length - 1; i >= 0; --i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            Date planBsed = null;
            if (hasPlanBsedField) {
                planBsed = dynamicObject.getDate("changebsed");
            }
            if (planBsed == null) {
                planBsed = dynamicObject.getDate("bsed");
            }
            if (planBsed == null) continue;
            String dataStatus = dynamicObject.getString("datastatus");
            if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus) || EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dataStatus) || EnumHisDataVersionStatus.INVALIDED.getStatus().equals(dataStatus)) {
                String version;
                String newDateStatus;
                if (findEffectingVersion) {
                    newDateStatus = EnumHisDataVersionStatus.INVALIDED.getStatus();
                    if (newDateStatus.equals(dataStatus)) continue;
                    dynamicObject.set("datastatus", (Object)newDateStatus);
                    version = dynamicObject.getString("hisversion");
                    if (!StringUtils.isNotEmpty((CharSequence)version)) continue;
                    needUpdateVersion.add(dynamicObject);
                    continue;
                }
                newDateStatus = this.calcPlanDateDataStatus(planBsed, planBsled);
                if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(newDateStatus)) {
                    findEffectingVersion = true;
                }
                if (!newDateStatus.equals(dataStatus)) {
                    dynamicObject.set("datastatus", (Object)newDateStatus);
                    version = dynamicObject.getString("hisversion");
                    if (StringUtils.isNotEmpty((CharSequence)version)) {
                        needUpdateVersion.add(dynamicObject);
                    }
                }
            }
            planBsled = new Date(planBsed.getTime() - 1L);
        }
        return needUpdateVersion;
    }

    @Override
    public Date getDate2999(SimpleDateFormat sdf) {
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        }
        sdf.setTimeZone(KDDateUtils.getSysTimeZone());
        Date date2999 = null;
        try {
            date2999 = sdf.parse("2999-12-31");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date2999;
    }

    public Date getToday() {
        long current = System.currentTimeMillis();
        long dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
        return new Date(dayTime);
    }

    @Override
    public EffStartEndDateBo getAllEffVersionDateSection(List<EffStartEndDateBo> effStartEndDateBoList) {
        if (effStartEndDateBoList == null || effStartEndDateBoList.size() == 0) {
            return null;
        }
        EffStartEndDateBo effStartEndDateBo = null;
        for (EffStartEndDateBo startEndDateBo : effStartEndDateBoList) {
            Date startDate = startEndDateBo.getEffectStartDate();
            Date endDate = startEndDateBo.getEffectEndDate();
            if (effStartEndDateBo == null) {
                effStartEndDateBo = new EffStartEndDateBo();
                effStartEndDateBo.setEffectStartDate(startDate);
                effStartEndDateBo.setEffectEndDate(endDate);
                continue;
            }
            if (startDate.getTime() < effStartEndDateBo.getEffectStartDate().getTime()) {
                effStartEndDateBo.setEffectStartDate(startDate);
            }
            if (endDate.getTime() <= effStartEndDateBo.getEffectEndDate().getTime()) continue;
            effStartEndDateBo.setEffectEndDate(endDate);
        }
        return effStartEndDateBo;
    }

    @Override
    public List<HisValidateRespBo> validateTempVersionDateSection(HRBaseServiceHelper serviceHelper, Map<Long, List<EffStartEndDateBo>> mapBoIdGroupData, boolean checkOldTempData, List<Long> idList) {
        if (mapBoIdGroupData == null || mapBoIdGroupData.size() == 0) {
            return null;
        }
        ArrayList<HisValidateRespBo> hisValidateRespBoListAll = new ArrayList<HisValidateRespBo>(8);
        if (checkOldTempData) {
            HisCommonEntityRepository.getTempVersionEffEndDate(serviceHelper, idList, mapBoIdGroupData);
        }
        HisCommonEntityRepository.getTempVersionEffEndDate(serviceHelper, idList, mapBoIdGroupData);
        for (Map.Entry<Long, List<EffStartEndDateBo>> entry : mapBoIdGroupData.entrySet()) {
            List<EffStartEndDateBo> effStartEndDateBoList;
            Long boId = entry.getKey();
            if (boId == null || boId == 0L || (effStartEndDateBoList = mapBoIdGroupData.get(boId)) == null) continue;
            EffStartEndDateBo[] effStartEndDateBos = effStartEndDateBoList.toArray(new EffStartEndDateBo[effStartEndDateBoList.size()]);
            List<HisValidateRespBo> hisValidateRespBoList = this.validateVersionDateSection(serviceHelper.getEntityName(), effStartEndDateBos, boId);
            if (hisValidateRespBoList == null) continue;
            hisValidateRespBoListAll.addAll(hisValidateRespBoList);
        }
        return hisValidateRespBoListAll;
    }

    public List<HisValidateRespBo> validateVersionDateSection(String entityNumber, EffStartEndDateBo[] effStartEndDateBos, Long boId) throws KDBizException {
        if (effStartEndDateBos == null || effStartEndDateBos.length == 1) {
            return null;
        }
        ArrayList<HisValidateRespBo> hisValidateRespBoList = new ArrayList<HisValidateRespBo>(4);
        for (int i = 0; i < effStartEndDateBos.length; ++i) {
            EffStartEndDateBo effStartEndDateBoA = effStartEndDateBos[i];
            for (int j = i + 1; j < effStartEndDateBos.length; ++j) {
                EffStartEndDateBo effStartEndDateBoB = effStartEndDateBos[j];
                if (effStartEndDateBoA.getEffectStartDate().getTime() < effStartEndDateBoB.getEffectStartDate().getTime()) {
                    if (effStartEndDateBoA.getEffectEndDate().getTime() < effStartEndDateBoB.getEffectStartDate().getTime()) continue;
                    this.buildHisValidateRespBo(entityNumber, hisValidateRespBoList, effStartEndDateBoA, effStartEndDateBoB, boId);
                    continue;
                }
                if (effStartEndDateBoA.getEffectStartDate().getTime() > effStartEndDateBoB.getEffectStartDate().getTime()) {
                    if (effStartEndDateBoA.getEffectStartDate().getTime() > effStartEndDateBoB.getEffectEndDate().getTime()) continue;
                    this.buildHisValidateRespBo(entityNumber, hisValidateRespBoList, effStartEndDateBoA, effStartEndDateBoB, boId);
                    continue;
                }
                this.buildHisValidateRespBo(entityNumber, hisValidateRespBoList, effStartEndDateBoA, effStartEndDateBoB, boId);
            }
        }
        return hisValidateRespBoList;
    }

    private void buildHisValidateRespBo(String entityNumber, List<HisValidateRespBo> hisValidateRespBoList, EffStartEndDateBo effStartEndDateBoA, EffStartEndDateBo effStartEndDateBoB, Long boId) {
        HisValidateRespBo hisValidateRespBo = new HisValidateRespBo();
        hisValidateRespBo.setError(true);
        Pair pair = Pair.of((Object)effStartEndDateBoA.getDataEntityIndex(), (Object)effStartEndDateBoB.getDataEntityIndex());
        hisValidateRespBo.setRowPair((Pair<Integer, Integer>)pair);
        LOGGER.error(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\uff1a%1$s\uff0cBOID: %2$s \u4e0e\u5df2\u6709\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u7684\u751f/\u5931\u6548\u65e5\u671f\u91cd\u53e0\u3002", (String)"HisCommonService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber, boId));
        hisValidateRespBo.setMsg(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e0e\u5df2\u6709\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u7684\u751f/\u5931\u6548\u65e5\u671f\u91cd\u53e0\u3002", (String)"HisCommonService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        hisValidateRespBo.setBoId(boId);
        hisValidateRespBoList.add(hisValidateRespBo);
    }

    private EffStartEndDateBo[] mergeVersionDateSection(EffStartEndDateBo[] effStartEndDateBos) {
        if (effStartEndDateBos == null || effStartEndDateBos.length <= 1) {
            return effStartEndDateBos;
        }
        ArrayList<EffStartEndDateBo> mergedEffStartEndDateBoList = new ArrayList<EffStartEndDateBo>(8);
        EffStartEndDateBo effStartEndDateBo = effStartEndDateBos[0];
        for (int i = 1; i < effStartEndDateBos.length; ++i) {
            Set<Integer> dataEntityIndexSet;
            Date effStartDate = effStartEndDateBo.getEffectStartDate();
            Date effEndDate = effStartEndDateBo.getEffectEndDate();
            EffStartEndDateBo effStartEndDateBoA = effStartEndDateBos[i];
            Date effStartDateA = effStartEndDateBoA.getEffectStartDate();
            Date effEndDateA = effStartEndDateBoA.getEffectEndDate();
            int days = (int)((effStartDateA.getTime() - effEndDate.getTime()) / 86400000L);
            if (!mergedEffStartEndDateBoList.contains(effStartEndDateBo)) {
                mergedEffStartEndDateBoList.add(effStartEndDateBo);
            }
            if ((dataEntityIndexSet = effStartEndDateBo.getDataEntityIndexSet()) == null) {
                dataEntityIndexSet = new HashSet<Integer>(8);
                effStartEndDateBo.setDataEntityIndexSet(dataEntityIndexSet);
            }
            dataEntityIndexSet.add(effStartEndDateBo.getDataEntityIndex());
            if (days == 1) {
                effStartEndDateBo.setEffectStartDate(effStartDate);
                effStartEndDateBo.setEffectEndDate(effEndDateA);
                dataEntityIndexSet.add(effStartEndDateBoA.getDataEntityIndex());
                continue;
            }
            effStartEndDateBo = effStartEndDateBoA;
        }
        return mergedEffStartEndDateBoList.toArray(new EffStartEndDateBo[mergedEffStartEndDateBoList.size()]);
    }

    private void effStartEndDateDisconnect(EffStartEndDateBo[] effStartEndDateBos, EffStartEndDateBo allEffStartEndDateBo) throws KDBizException {
        if (effStartEndDateBos == null || effStartEndDateBos.length == 0 || allEffStartEndDateBo == null) {
            return;
        }
        Date allEffStartDate = allEffStartEndDateBo.getEffectStartDate();
        Date allEffEndDate = allEffStartEndDateBo.getEffectEndDate();
        for (EffStartEndDateBo effStartEndDateBo : effStartEndDateBos) {
            Date effStartDate = effStartEndDateBo.getEffectStartDate();
            Date effEndDate = effStartEndDateBo.getEffectEndDate();
            int days = 0;
            if (effStartDate.getTime() > allEffStartDate.getTime() && (days = (int)((effStartDate.getTime() - allEffEndDate.getTime()) / 86400000L)) > 1) {
                effStartEndDateBo.setDisconnect(true);
            }
            if (effStartDate.getTime() >= allEffStartDate.getTime() || (days = (int)((allEffStartDate.getTime() - effEndDate.getTime()) / 86400000L)) <= 1) continue;
            effStartEndDateBo.setDisconnect(true);
        }
    }

    @Override
    public HisValidateRespBo validateVersionDisconnect(EffStartEndDateBo[] effStartEndDateBos, List<EffStartEndDateBo> effStartEndDateBoList, Long boId) {
        SortingEffStartEndDateBoService.getInstance().quickSort(effStartEndDateBos);
        EffStartEndDateBo allEffStartEndDateBo = null;
        if (effStartEndDateBoList != null && effStartEndDateBoList.size() > 0) {
            allEffStartEndDateBo = HisEffDateCommonService.getInstance().getAllEffVersionDateSection(effStartEndDateBoList);
        }
        effStartEndDateBos = HisEffDateCommonService.getInstance().mergeVersionDateSection(effStartEndDateBos);
        HisEffDateCommonService.getInstance().effStartEndDateDisconnect(effStartEndDateBos, allEffStartEndDateBo);
        HashSet<Integer> dataEntityIndexSet = new HashSet<Integer>(8);
        for (EffStartEndDateBo effStartEndDateBo : effStartEndDateBos) {
            if (!effStartEndDateBo.isDisconnect()) continue;
            Set<Integer> dataEntityIndexSet1 = effStartEndDateBo.getDataEntityIndexSet();
            if (dataEntityIndexSet1 != null) {
                dataEntityIndexSet.addAll(dataEntityIndexSet1);
                continue;
            }
            dataEntityIndexSet.add(effStartEndDateBo.getDataEntityIndex());
        }
        if (dataEntityIndexSet.size() > 0) {
            HisValidateRespBo hisValidateRespBo = new HisValidateRespBo();
            hisValidateRespBo.setError(true);
            hisValidateRespBo.setBoId(boId);
            hisValidateRespBo.setDataEntityIndexSet(dataEntityIndexSet);
            hisValidateRespBo.setMsg(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\uff0c\u53d8\u66f4\u6709\u6548\u671f\u4e0e\u5f53\u524d\u6570\u636e\u7684\u6709\u6548\u671f\u4e0d\u8fde\u7eed\u3002", (String)"HisEffDateCommonService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return hisValidateRespBo;
        }
        return null;
    }

    @Override
    public Date getNowMaskDate(String entityNumber) {
        String mask = this.getMask(entityNumber);
        long current = System.currentTimeMillis();
        long todayTime = current - (current + (long)KDDateUtils.getSysTimeZone().getRawOffset()) % 86400000L;
        if (mask == null || "".equals(mask)) {
            return new Date(todayTime);
        }
        boolean hasDay = false;
        boolean hasMonth = false;
        for (int i = 0; i < mask.length(); ++i) {
            char maskChar = mask.charAt(i);
            if (maskChar == 'd' || maskChar == 'D') {
                hasDay = true;
            }
            if (maskChar != 'm' && maskChar != 'M') continue;
            hasMonth = true;
        }
        if (hasDay) {
            return new Date(todayTime);
        }
        if (hasMonth) {
            return HRDateTimeUtils.getFirstDayOfCurrentMonth();
        }
        return HRDateTimeUtils.getFirstDayOfCurrentYear();
    }

    private String getMask(String entityNumber) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entityNumber)) {
            return null;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        for (ControlAp control : formMeta.getItems()) {
            if (!(control instanceof FieldAp) || !control.getKey().equals("bsed")) continue;
            return ((FieldAp)control).getMask();
        }
        return null;
    }

    public Date getCurrentVersionEffStartDate(String entityNumber, Long boId) {
        if (entityNumber == null || boId == null || boId == 0L) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        return HisCommonEntityRepository.getCurrentVersionEffStartDate(serviceHelper, boId);
    }
}

