/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import java.util.Date;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.domain.model.newhismodel.calc.HisVersionCalcNoInitResult;
import kd.hr.hbp.business.domain.repository.HisLineTimeDao;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import org.springframework.util.CollectionUtils;

public class HisInitValidateService {
    private static volatile HisInitValidateService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisInitValidateService getInstance() {
        if (service != null) return service;
        Class<HisInitValidateService> clazz = HisInitValidateService.class;
        synchronized (HisInitValidateService.class) {
            if (service != null) return service;
            service = new HisInitValidateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public String validInitNoComplete(Date startDate, String entityNumber, Long boId, IDataEntityType dataEntityType, String operation) {
        if (startDate == null) {
            return null;
        }
        boolean hasInitStatus = HisCommonService.getInstance().hasInitStatusFiled(dataEntityType, entityNumber);
        if (!hasInitStatus) {
            return null;
        }
        if (boId == null || boId == 0L) {
            return null;
        }
        HisVersionCalcNoInitResult hisVersionCalcNoInitResult = HisLineTimeDao.getInstance().getNotInitStatus(entityNumber, boId);
        if (hisVersionCalcNoInitResult == null) {
            return null;
        }
        Set<String> setResult = hisVersionCalcNoInitResult.getSetResult();
        if (CollectionUtils.isEmpty(setResult)) {
            return null;
        }
        Date firstEffDate = hisVersionCalcNoInitResult.getFirstEffDate();
        if (startDate.getTime() >= firstEffDate.getTime()) {
            return null;
        }
        String firstDate = HRDateTimeUtils.getUserSettingFormat().format(firstEffDate);
        String onlyInit_0 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5b58\u5728\u201c\u521d\u59cb\u5316\u72b6\u6001\u201d\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u7684\u7248\u672c\uff0c\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u65e9\u4e8e\u201c\u6700\u65e9\u751f\u6548\u65e5\u671f\u201d\uff1a%s", (String)"HisInitValidateService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), firstDate);
        String onlyInit_1 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5b58\u5728\u201c\u521d\u59cb\u5316\u72b6\u6001\u201c\u5df2\u9a8c\u8bc1\u201d\u7684\u7248\u672c\uff0c\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u65e9\u4e8e\u201c\u6700\u65e9\u751f\u6548\u65e5\u671f\u201d\uff1a%s", (String)"HisInitValidateService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), firstDate);
        String init_0_1 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5b58\u5728\u201c\u521d\u59cb\u5316\u72b6\u6001\u201d\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5df2\u9a8c\u8bc1\u201d\u7684\u7248\u672c\uff0c\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u65e9\u4e8e\u201c\u6700\u65e9\u751f\u6548\u65e5\u671f\u201d\uff1a%s", (String)"HisInitValidateService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), firstDate);
        if (setResult.size() == 1) {
            if (setResult.contains("0")) {
                return onlyInit_0;
            }
            if (setResult.contains("1")) {
                return onlyInit_1;
            }
        } else if (setResult.size() == 2) {
            return init_0_1;
        }
        return null;
    }
}

