/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseFailDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseResultBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisReviseValidateService {
    private static final Log LOGGER = LogFactory.getLog(HisReviseValidateService.class);
    private final String ENTRY_BOID = "entryboid";
    private static volatile HisReviseValidateService hisReviseValidateService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisReviseValidateService getInstance() {
        if (hisReviseValidateService != null) return hisReviseValidateService;
        Class<HisVersionNumberService> clazz = HisVersionNumberService.class;
        synchronized (HisVersionNumberService.class) {
            if (hisReviseValidateService != null) return hisReviseValidateService;
            hisReviseValidateService = new HisReviseValidateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisReviseValidateService;
        }
    }

    public boolean isCtrlBaseData(String entity) {
        Map allFields = EntityMetadataCache.getDataEntityType((String)entity).getAllFields();
        return allFields.keySet().containsAll(Stream.of("createorg", "org", "useorg", "ctrlstrategy").collect(Collectors.toSet()));
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean hasOnlyOneVersion(String entity, Object boid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
        List dateStatus = Stream.of(EnumHisDataVersionStatus.DELETED.getStatus(), EnumHisDataVersionStatus.DISCARDED.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("boid", "=", boid).and("datastatus", "in", dateStatus);
        DynamicObject[] dys = helper.queryOriginalArray("id,datastatus", qFilter.toArray());
        return dys.length == 2;
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean isTreeModel(String entity) {
        String[] inheritpathArray;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entitymeta");
        QFilter treeTplFilter = new QFilter("number", "in", (Object)HisSysConstants.Tree_TPL);
        DynamicObject[] dys = helper.queryOriginalArray("id", treeTplFilter.toArray());
        List parentIds = Arrays.stream(dys).map(dy -> dy.getString("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("number", "=", (Object)entity);
        DynamicObject object = helper.queryOriginalOne("id,inheritpath", qFilter.toArray());
        String inheritpath = object.getString("inheritpath");
        for (String str : inheritpathArray = inheritpath.split(",")) {
            if (!parentIds.contains(str)) continue;
            return true;
        }
        return false;
    }

    public Map<Long, String> getUserAvatarPath(List<Long> userIds) {
        return UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
    }

    @ExcludeFromJacocoGeneratedReport
    public String getNameByUserId(Long userId) {
        String selectFields = "id, name";
        QFilter idFilter = new QFilter("id", "=", (Object)userId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idFilter, enableFilter};
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (userObj != null) {
            return userObj.getString("name");
        }
        return String.valueOf(userId);
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean reviseOrgValidate(IFormView view, Object pkId, String billFormId) {
        boolean isCtrlBaseData;
        HRBaseServiceHelper helper = new HRBaseServiceHelper(billFormId);
        DynamicObject rowData = helper.queryOne(pkId);
        boolean bl = isCtrlBaseData = rowData.containsProperty("createorg") && rowData.containsProperty("org") && rowData.containsProperty("useorg") && rowData.containsProperty("ctrlstrategy");
        if (!isCtrlBaseData) {
            return true;
        }
        String useOrgID = (String)view.getFormShowParameter().getCustomParam("useorgId");
        DynamicObject createorg = rowData.getDynamicObject("createorg");
        if (null == useOrgID && null != rowData.getDynamicObject("useOrg")) {
            useOrgID = rowData.getDynamicObject("useOrg").getPkValue().toString();
        }
        String createorgId = String.valueOf(createorg.getPkValue());
        return createorgId.equals(useOrgID);
    }

    @ExcludeFromJacocoGeneratedReport
    public HrApiResponse<HisVersionReviseResultBo> saveValidate(DynamicObject[] dataEntitys) {
        HrApiResponse apiResponse = new HrApiResponse();
        if (dataEntitys == null || dataEntitys.length < 1) {
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisReviseValidateService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        String entityNumber = dataEntitys[0].getDataEntityType().getName();
        String inhRelation = HisCommonService.getInstance().entityInhRelation(entityNumber);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (!HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u65f6\u5e8f\u5386\u53f2\u6570\u636e\u4f7f\u7528\u4fee\u8ba2\u529f\u80fd\u3002", (String)"HisReviseValidateService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        Set<Long> idSet = Arrays.stream(dataEntitys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Map<Long, Date> mapEffEndDate = HisCommonEntityRepository.getEffEndDateByIds(serviceHelper, idSet);
        if (mapEffEndDate == null || mapEffEndDate.isEmpty()) {
            apiResponse.setErrorMessage(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4f20\u9012\u6570\u636e\u7684\u5931\u6548\u65e5\u671f\u3002", (String)"HisReviseValidateService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            apiResponse.setSuccess(false);
            apiResponse.setCode(EnumResponseCode.FAIL.getCode());
            return apiResponse;
        }
        HisVersionReviseResultBo resultBo = new HisVersionReviseResultBo();
        ArrayList<HisVersionReviseFailDataBo> failDataBoList = new ArrayList<HisVersionReviseFailDataBo>(dataEntitys.length);
        for (DynamicObject dataEntity : dataEntitys) {
            boolean dataValidate;
            String errorMsg;
            HisVersionReviseFailDataBo failDataBo = new HisVersionReviseFailDataBo();
            ArrayList<String> errorMsgList = new ArrayList<String>(2);
            if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.LINETIMESEQ_TPL.getNumber()) && HRStringUtils.isNotEmpty((String)(errorMsg = this.saveTimeValidate(dataEntity)))) {
                failDataBo.setId(dataEntity.getLong("id"));
                failDataBo.setErrorLevel(ErrorLevel.Error);
                errorMsgList.add(errorMsg);
            }
            if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
                Long id = dataEntity.getLong("id");
                Date effEndDate = dataEntity.getDate("bsled");
                if (effEndDate == null) {
                    failDataBo.setId(dataEntity.getLong("id"));
                    failDataBo.setErrorLevel(ErrorLevel.Error);
                    errorMsgList.add(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u5931\u6548\u65f6\u95f4\u3002", (String)"HisReviseValidateService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                } else {
                    Date effEndDateFromDB = mapEffEndDate.get(id);
                    if (effEndDateFromDB == null) {
                        failDataBo.setId(dataEntity.getLong("id"));
                        failDataBo.setErrorLevel(ErrorLevel.Error);
                        errorMsgList.add(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7528\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u7684\u7248\u672c\u6765\u4fee\u8ba2\u3002", (String)"HisReviseValidateService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                    } else if (effEndDate.getTime() != effEndDateFromDB.getTime()) {
                        failDataBo.setId(dataEntity.getLong("id"));
                        failDataBo.setErrorLevel(ErrorLevel.Error);
                        errorMsgList.add(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u5931\u6548\u65f6\u95f4\u3002", (String)"HisReviseValidateService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                        failDataBoList.add(failDataBo);
                    }
                }
            }
            if (!(dataValidate = this.saveDataValidate(dataEntity))) {
                failDataBo.setId(dataEntity.getLong("id"));
                failDataBo.setErrorLevel(ErrorLevel.FatalError);
                errorMsgList.add(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5355\u636e\u4f53\u3002", (String)"HisReviseValidateService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            failDataBo.setErrorMsgs(errorMsgList);
            if (failDataBo.getId() == null || failDataBo.getId() == 0L) continue;
            failDataBoList.add(failDataBo);
        }
        long failCount = failDataBoList.stream().filter(e -> e != null && e.getId() != null && e.getId() != 0L).count();
        long successCount = (long)dataEntitys.length - failCount;
        resultBo.setFailDataBos(failDataBoList);
        resultBo.setFailtCount(failCount);
        resultBo.setSuccessCount(successCount);
        apiResponse.setSuccess(failCount == 0L);
        apiResponse.setCode(failCount == 0L ? EnumResponseCode.SUCCESS.getCode() : EnumResponseCode.FAIL.getCode());
        apiResponse.setData((Object)resultBo);
        return apiResponse;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean saveDataValidate(DynamicObject newDyn) {
        Object pkId = newDyn.getPkValue();
        String entity = newDyn.getDataEntityType().getName();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
        DynamicObject oldDyn = helper.loadSingle(pkId);
        List collectionProperties = newDyn.getDataEntityType().getProperties().getCollectionProperties(false);
        for (ICollectionProperty subEntryProperty : collectionProperties) {
            String subEntryName = subEntryProperty.getName().toLowerCase();
            if (subEntryProperty instanceof DynamicLocaleProperty || HRStringUtils.isEmpty((String)subEntryProperty.getItemType().getAlias()) || subEntryProperty instanceof MulBasedataProp) continue;
            DynamicObjectCollection newEntry = newDyn.getDynamicObjectCollection(subEntryName);
            DynamicObjectCollection oldEntry = oldDyn != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldDyn) : null;
            if (oldEntry == null) continue;
            for (int i = 0; i < oldEntry.size(); ++i) {
                DynamicObject oldRowData = (DynamicObject)oldEntry.get(i);
                Object pkValue = oldRowData.getPkValue();
                if (HRObjectUtils.isEmpty((Object)pkValue)) continue;
                String entryBoidProperty = "entryboid";
                for (IDataEntityProperty property : oldEntry.getDynamicObjectType().getProperties()) {
                    if (!property.getName().startsWith("entryboid") || !(property instanceof BigIntProp)) continue;
                    entryBoidProperty = property.getName();
                    break;
                }
                long entryBoid = oldRowData.getLong(entryBoidProperty);
                String finalEntryBoidProperty = entryBoidProperty;
                boolean noneMatch = newEntry.stream().noneMatch(y -> y.getLong(finalEntryBoidProperty) == entryBoid);
                if (noneMatch) {
                    return false;
                }
                DynamicObject newRowData = (DynamicObject)newEntry.get(i);
                boolean flag = this.validateSubEntry(oldRowData, newRowData);
                if (flag) continue;
                return false;
            }
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateSubEntry(DynamicObject oldRowData, DynamicObject newRowData) {
        List properties = oldRowData.getDataEntityType().getProperties().getCollectionProperties(false);
        DynamicObjectCollection emptyCol = new DynamicObjectCollection();
        for (ICollectionProperty property : properties) {
            if (property instanceof DynamicLocaleProperty) {
                return true;
            }
            if (property instanceof MulBasedataProp) {
                return true;
            }
            DynamicObjectCollection newSubEntry = newRowData == null ? emptyCol : (DynamicObjectCollection)property.getValueFast((Object)newRowData);
            DynamicObjectCollection oldSubEntry = (DynamicObjectCollection)property.getValueFast((Object)oldRowData);
            for (int index = 0; index < oldSubEntry.size(); ++index) {
                DynamicObject oldSubRowData = (DynamicObject)oldSubEntry.get(index);
                Object pkValue = oldSubRowData.getPkValue();
                if (pkValue == null) continue;
                String entryBoidProperty = "entryboid";
                for (IDataEntityProperty subProperty : oldSubEntry.getDynamicObjectType().getProperties()) {
                    if (!subProperty.getName().startsWith("entryboid") || !(subProperty instanceof BigIntProp)) continue;
                    entryBoidProperty = subProperty.getName();
                    break;
                }
                long entryBoid = oldSubRowData.getLong(entryBoidProperty);
                String finalEntryBoidProperty = entryBoidProperty;
                boolean noneMatch = newSubEntry.stream().noneMatch(y -> y.getLong(finalEntryBoidProperty) == entryBoid);
                if (!noneMatch) continue;
                return false;
            }
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private String saveTimeValidate(DynamicObject dataEntity) {
        List firstbseds;
        Date firstbsed;
        Date bsed;
        boolean isPersionalized;
        QFilter boidFilter;
        boolean isCtrlBaseData = this.isCtrlBaseData(dataEntity.getDataEntityType().getName());
        if (!isCtrlBaseData) {
            return null;
        }
        boolean hasOnlyOneVersion = HisReviseValidateService.getInstance().hasOnlyOneVersion(dataEntity.getDataEntityType().getName(), dataEntity.get("boid"));
        if (!hasOnlyOneVersion) {
            return null;
        }
        Object boid = dataEntity.get("boid");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dataEntity.getDataEntityType().getName());
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("id,masterid", (boidFilter = new QFilter("boid", "=", boid).and("iscurrentversion", "=", (Object)"1")).toArray());
        if (dynamicObject == null) {
            return null;
        }
        long id = dynamicObject.getLong("id");
        QFilter qFilter = new QFilter("masterid", "=", (Object)id).and("id", "!=", (Object)id);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id,firstbsed", qFilter.toArray());
        boolean bl = isPersionalized = dys.length > 0;
        if (isPersionalized && (bsed = dataEntity.getDate("bsed")).after(firstbsed = (Date)(firstbseds = Arrays.stream(dys).map(dy -> dy.getDate("firstbsed")).sorted(Date::compareTo).collect(Collectors.toList())).get(0))) {
            String userPatternDate = HRDateTimeUtils.getUserSettingFormat().format(firstbsed);
            return String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5176\u4e2a\u6027\u5316\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisReviseValidateService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), userPatternDate);
        }
        return null;
    }
}

