/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisValidateRespBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisValidateService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisPersonalDataType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRHisEntryObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisValidateService
implements IHisValidateService {
    private static final Log LOGGER = LogFactory.getLog(HisValidateService.class);
    private static volatile HisValidateService hisValidateService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisValidateService getInstance() {
        if (hisValidateService != null) return hisValidateService;
        Class<HisValidateService> clazz = HisValidateService.class;
        synchronized (HisValidateService.class) {
            if (hisValidateService != null) return hisValidateService;
            hisValidateService = new HisValidateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisValidateService;
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void validateAndProcessTempVersion(HisVersionParamBo hisVersionParamBo, HRBaseServiceHelper serviceHelper) {
        List<HisValidateRespBo> hisValidateRespBoList;
        DynamicObject[] dynamicObjects = hisVersionParamBo.getHisDyns();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisValidateService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String entityNumber = hisVersionParamBo.getEntityNumber();
        int size = dynamicObjects.length;
        HashMap<Long, List<EffStartEndDateBo>> mapBoIdGroupData = new HashMap<Long, List<EffStartEndDateBo>>(size);
        long[] ids = ORM.create().genLongIds(entityNumber, dynamicObjects.length);
        int index = 0;
        ArrayList<Long> originalIdList = new ArrayList<Long>(dynamicObjects.length);
        HashMap<Long, Boolean> mapBoIdExits = new HashMap<Long, Boolean>(4);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id;
            Date effEndDate;
            Date date = dynamicObject.getDate("bsed");
            HisValidateRespBo hisValidateRespBo = this.commonValidate(dynamicObject, date, effEndDate = dynamicObject.getDate("bsled"), false);
            if (hisValidateRespBo.isError()) {
                throw new KDBizException(hisValidateRespBo.getMsg());
            }
            EffStartEndDateBo effStartEndDateBo = hisValidateRespBo.getEffStartEndDateBo();
            Long boId = dynamicObject.getLong("boid");
            Long originalId = id = Long.valueOf(dynamicObject.getLong("id"));
            if (id == 0L) {
                id = ids[index];
                ++index;
                dynamicObject.set("id", (Object)id);
            }
            if (boId == 0L || boId.longValue() == id.longValue()) {
                dynamicObject.set("boid", (Object)id);
                dynamicObject.set("iscurrentversion", (Object)"1");
            } else {
                Boolean exitsOldBoIdVersion = (Boolean)mapBoIdExits.get(boId);
                if (exitsOldBoIdVersion == null) {
                    exitsOldBoIdVersion = HisCommonEntityRepository.exitsOldCurrentData(serviceHelper, boId);
                    mapBoIdExits.put(boId, exitsOldBoIdVersion);
                }
                if (!exitsOldBoIdVersion.booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8981\u64a4\u9500\u7684\u6570\u636e\u3002", (String)"HisValidateService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
                ArrayList<EffStartEndDateBo> effStartEndDateBoList = (ArrayList<EffStartEndDateBo>)mapBoIdGroupData.get(boId);
                if (effStartEndDateBoList == null) {
                    effStartEndDateBoList = new ArrayList<EffStartEndDateBo>(8);
                }
                effStartEndDateBo.setId(originalId);
                originalIdList.add(originalId);
                effStartEndDateBoList.add(effStartEndDateBo);
                mapBoIdGroupData.put(boId, effStartEndDateBoList);
            }
            dynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        }
        if (hisVersionParamBo.isNeedValidateDate() && (hisValidateRespBoList = HisEffDateCommonService.getInstance().validateTempVersionDateSection(serviceHelper, mapBoIdGroupData, true, originalIdList)) != null && hisValidateRespBoList.size() > 0) {
            HashSet<Object> rowIndexSet = new HashSet<Object>(8);
            String msg = null;
            for (HisValidateRespBo hisValidateRespBo : hisValidateRespBoList) {
                if (msg == null) {
                    msg = hisValidateRespBo.getMsg();
                }
                rowIndexSet.add(hisValidateRespBo.getRowPair().getKey());
                rowIndexSet.add(hisValidateRespBo.getRowPair().getValue());
            }
            for (Integer n : rowIndexSet) {
                if (n < 0) continue;
                throw new KDBizException(msg);
            }
        }
    }

    @Override
    public void validateEffVersion(HisVersionParamBo hisVersionParamBo) {
        DynamicObject[] dynamicObjects = hisVersionParamBo.getHisDyns();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisValidateService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (EnumHisPersonalDataType.PERSONAL_DATA_SAVE.getType().equals(hisVersionParamBo.getPersonalDataType())) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String dataStatus = HisEffDateCommonService.getInstance().calcDataStatus(dynamicObject.getDate("bsed"), dynamicObject.getDate("bsled"));
                if (!EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dataStatus)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u5f85\u751f\u6548\u6570\u636e\u3002", (String)"HisValidateService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date effEndDate;
            Date effStartDate = dynamicObject.getDate("bsed");
            HisValidateRespBo hisValidateRespBo = this.commonValidate(dynamicObject, effStartDate, effEndDate = dynamicObject.getDate("bsled"), false);
            if (!hisValidateRespBo.isError()) continue;
            throw new KDBizException(hisValidateRespBo.getMsg());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public HisValidateRespBo commonValidate(DynamicObject dynamicObject, Date effStartDate, Date effEndDate, boolean fromValidator) {
        HisValidateRespBo hisValidateRespBo = new HisValidateRespBo();
        if (effStartDate == null) {
            if (!fromValidator) {
                hisValidateRespBo.setError(true);
                hisValidateRespBo.setMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisValidateService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                return hisValidateRespBo;
            }
            return null;
        }
        Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
        if (effStartDate.getTime() > date2999.getTime()) {
            hisValidateRespBo.setError(true);
            String userPatternDate = HRDateTimeUtils.getUserSettingFormat().format(date2999);
            hisValidateRespBo.setMsg(String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e2999-12-31\u3002", (String)"HisValidateService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), userPatternDate));
            return hisValidateRespBo;
        }
        effEndDate = effEndDate == null ? date2999 : HRDateTimeUtils.splitYYYY_MM_DD((Date)effEndDate);
        effStartDate = HRDateTimeUtils.splitYYYY_MM_DD((Date)effStartDate);
        if (!fromValidator) {
            dynamicObject.set("bsed", (Object)effStartDate);
            dynamicObject.set("bsled", (Object)effEndDate);
        }
        if (effEndDate != null && effStartDate.getTime() > effEndDate.getTime()) {
            hisValidateRespBo.setError(true);
            hisValidateRespBo.setMsg(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"HisValidateService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            String entityNumber = dynamicObject.getDynamicObjectType().getName();
            String id = "";
            if (dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"id")) {
                id = String.valueOf(dynamicObject.getLong("id"));
            }
            String number = "";
            if (dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"number")) {
                number = dynamicObject.getString("number");
            }
            LOGGER.error(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5931\u6548\u65e5\u671f\uff1a\u5b9e\u4f53\u7f16\u7801\uff1a %1$s\uff0c\u7f16\u7801\uff1a %2$s\uff0cID: %3$s\u3002", (String)"HisValidateService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]), entityNumber, number, id));
            return hisValidateRespBo;
        }
        hisValidateRespBo.setError(false);
        EffStartEndDateBo effStartEndDateBo = new EffStartEndDateBo();
        effStartEndDateBo.setDataEntityIndex(0);
        effStartEndDateBo.setEffectStartDate(effStartDate);
        effStartEndDateBo.setEffectEndDate(effEndDate);
        hisValidateRespBo.setEffStartEndDateBo(effStartEndDateBo);
        return hisValidateRespBo;
    }

    @Override
    public void saveValidate(DynamicObject[] dys) {
        if (dys == null || dys.length < 1) {
            return;
        }
        this.entryValidate(dys);
    }

    private void entryValidate(DynamicObject[] dys) {
        for (DynamicObject dy : dys) {
            this.entryBoidValidate(dy);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void entryBoidValidate(DynamicObject dy) {
        List collectionProperties = dy.getDataEntityType().getProperties().getCollectionProperties(false);
        for (ICollectionProperty property : collectionProperties) {
            DynamicObjectCollection entry;
            if (HRStringUtils.isEmpty((String)property.getItemType().getAlias()) || !(property instanceof EntryType) || property instanceof LinkEntryType || (entry = (DynamicObjectCollection)property.getValueFast((Object)dy)) == null || entry.size() < 1) continue;
            HRHisEntryObjectUtils.validateEntry((DynamicObjectCollection)entry);
            String entryBoid = HRHisEntryObjectUtils.getEntryBoIdFiledName((DynamicObjectCollection)entry);
            List list = entry.stream().filter(e -> e.getLong(entryBoid) != 0L).map(e -> e.getLong(entryBoid)).collect(Collectors.toList());
            if ((long)list.size() != list.stream().distinct().count()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e2d\u7684\u201centryboid\u201d\u5b57\u6bb5\u4e0d\u5141\u8bb8\u590d\u5236\uff0c\u8bf7\u6e05\u7a7a\u8be5\u5b57\u6bb5\u503c\u3002", (String)"HisValidateService_7", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            for (DynamicObject rowData : entry) {
                this.entryBoidValidate(rowData);
            }
        }
    }
}

