/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.log.EntityModifyInfo;
import kd.hr.hbp.business.log.FieldModifyInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.hismodel.HisVersionDifferenceBo;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HisVersionContrastService {
    private static final Log LOGGER = LogFactory.getLog(HisVersionContrastService.class);
    private MainEntityType mainEntityType;
    private String operate = "save";
    private Map<String, IDataEntityProperty> monitorFields;
    private List<String> ignoreProps;

    public static HisVersionContrastService getInstance() {
        return new HisVersionContrastService();
    }

    public HisVersionDifferenceBo contrast(String entity, Long newId, Long oldId, boolean hasAttachSearchPerm) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        QFilter qFilter = new QFilter("id", "=", (Object)newId).or("id", "=", (Object)oldId);
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        Map<Long, DynamicObject> map = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        DynamicObject newDyn = map.get(newId);
        DynamicObject oldDyn = map.get(oldId);
        if (newDyn == null || oldDyn == null) {
            return this.buildRetureData(entity, newId, oldId, newDyn, oldDyn, null, false, hasAttachSearchPerm);
        }
        this.processAttachField(newDyn, oldDyn, hasAttachSearchPerm);
        this.mainEntityType = (MainEntityType)newDyn.getDataEntityType();
        this.monitorFields = EntityMetadataCache.getDataEntityType((String)this.mainEntityType.getName()).getAllFields();
        this.ignoreProps = Stream.of("entryboid", "sourcevid", "datastatus", "hisversion", "versionsource", "firstbsed", "bred", "brled", "ismodify").collect(Collectors.toList());
        EntityModifyInfo info = this.buildModifyInfo(newDyn, oldDyn);
        return this.buildRetureData(entity, newId, oldId, newDyn, oldDyn, info, true, hasAttachSearchPerm);
    }

    private void processAttachField(DynamicObject newDyn, DynamicObject oldDyn, boolean hasAttachSearchPerm) {
        if (hasAttachSearchPerm) {
            return;
        }
        IDataEntityType mainEntityType = newDyn.getDataEntityType();
        DataEntityPropertyCollection collection = mainEntityType.getProperties();
        if (collection == null || collection.size() == 0) {
            return;
        }
        for (IDataEntityProperty property : collection) {
            if (property instanceof AttachmentProp) {
                newDyn.set(property, null);
                oldDyn.set(property, null);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection dpEntry = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
            for (IDataEntityProperty entryProperty : dpEntry) {
                if (entryProperty instanceof AttachmentProp) {
                    this.setEntryValueNull(newDyn, property, entryProperty);
                    this.setEntryValueNull(oldDyn, property, entryProperty);
                    continue;
                }
                if (!(entryProperty instanceof SubEntryProp)) continue;
                DataEntityPropertyCollection dpSubEntry = ((SubEntryProp)entryProperty).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty subEntryProperty : dpSubEntry) {
                    if (!(subEntryProperty instanceof AttachmentProp)) continue;
                    this.setSubEntryValueNull(newDyn, property, entryProperty, subEntryProperty);
                    this.setSubEntryValueNull(oldDyn, property, entryProperty, subEntryProperty);
                }
            }
        }
    }

    private void setEntryValueNull(DynamicObject dynamicObject, IDataEntityProperty property, IDataEntityProperty entryProperty) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(property);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (DynamicObject dyRow : dynamicObjectCollection) {
            if (dyRow == null) continue;
            dyRow.set(entryProperty, null);
        }
    }

    private void setSubEntryValueNull(DynamicObject dynamicObject, IDataEntityProperty property, IDataEntityProperty entryProperty, IDataEntityProperty subEntryProperty) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(property);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (DynamicObject dyRow : dynamicObjectCollection) {
            DynamicObjectCollection subDyCol;
            if (dyRow == null || (subDyCol = dyRow.getDynamicObjectCollection(entryProperty)) == null) continue;
            for (DynamicObject dySubRow : subDyCol) {
                if (dySubRow == null) continue;
                dySubRow.set(subEntryProperty, null);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private HisVersionDifferenceBo buildRetureData(String entity, Long newId, Long oldId, DynamicObject newDyn, DynamicObject oldDyn, EntityModifyInfo info, boolean isSuccess, boolean hasAttachSearchPerm) {
        IAttachmentFieldModelProxy attachmentFieldModel;
        boolean hasAttProp;
        ObjectMapper mapper = new ObjectMapper();
        Map<String, List<Map<String, Object>>> attachment = null;
        if (hasAttachSearchPerm) {
            attachment = this.getAttachmentById(newId, oldId, entity);
        }
        if (hasAttProp = (attachmentFieldModel = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class)).checkIfHasAttProp(entity)) {
            // empty if block
        }
        HisVersionDifferenceBo bo = new HisVersionDifferenceBo();
        bo.setEntityNumber(entity);
        bo.setEntityName(this.getEntityNameByNumber(entity));
        bo.setNewId(newId);
        bo.setOldId(oldId);
        bo.setNewDyn(newDyn);
        bo.setOldDyn(oldDyn);
        bo.setSuccess(isSuccess);
        if (attachment != null) {
            bo.setOldAttachments(attachment.get(String.valueOf(oldId)));
            bo.setNewAttachments(attachment.get(String.valueOf(newId)));
        }
        if (isSuccess) {
            try {
                bo.setDifferenceInfo(mapper.writeValueAsString((Object)info));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("HisVersionContrastService.buildRetureData is error ", (Throwable)e);
            }
        } else {
            Long nullId = newDyn == null ? newId : oldId;
            bo.setErrorMsg(String.format(ResManager.loadKDString((String)"ID\u4e3a %1$s \u7684\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"HisVersionContrastService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), nullId));
        }
        return bo;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, List<Map<String, Object>>> getAttachmentById(Long newId, Long oldId, String entityNumber) {
        Set ids = Stream.of(newId, oldId).collect(Collectors.toSet());
        Set<Object> idSet = ids.stream().map(dy -> String.valueOf(dy)).collect(Collectors.toSet());
        List<Map<String, Object>> list = HisAttachmentService.generateAttachmentMapById(idSet, entityNumber);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(2);
        for (Map<String, Object> map : list) {
            if (!map.containsKey("pk")) continue;
            String pk = (String)map.get("pk");
            result.computeIfAbsent(pk, key -> new ArrayList(16)).add(map);
        }
        return result;
    }

    private ILocaleString getEntityNameByNumber(String entity) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_devpn_entitymeta");
        QFilter qFilter = new QFilter("number", "=", (Object)entity);
        DynamicObject dy = helper.queryOne("name", qFilter.toArray());
        return dy.getLocaleString("name");
    }

    public EntityModifyInfo buildModifyInfo(DynamicObject newDyn, DynamicObject oldDyn) {
        Object pkValObj = newDyn.getPkValue();
        if (pkValObj == null) {
            return null;
        }
        boolean isDeleteOperate = this.isDeleteOperate();
        boolean isNewOperate = !newDyn.getDataEntityState().getFromDatabase() && !isDeleteOperate;
        return this.buildEntityModifyInfo(newDyn, oldDyn, isDeleteOperate, isNewOperate);
    }

    @ExcludeFromJacocoGeneratedReport
    private String getBillNo(DynamicObject dynamicObject) {
        IDataEntityProperty billNoProp = null;
        if (this.mainEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.mainEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.mainEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this.mainEntityType instanceof BillEntityType) {
            billNoProp = this.mainEntityType.findProperty(((BillEntityType)this.mainEntityType).getBillNo());
        }
        if (billNoProp != null) {
            return (String)billNoProp.getValue((Object)dynamicObject);
        }
        return "";
    }

    private EntityModifyInfo buildEntityModifyInfo(DynamicObject newDyn, DynamicObject oldDyn, boolean isDeleteOperate, boolean isNewOperate) {
        IDataEntityType mainEntityType = newDyn.getDataEntityType();
        if (isDeleteOperate) {
            mainEntityType = oldDyn.getDataEntityType();
        }
        String pkValueStr = newDyn.getPkValue().toString();
        boolean isUpdateOperate = !isDeleteOperate && !isNewOperate;
        EntityModifyInfo mainModifyInfo = new EntityModifyInfo();
        mainModifyInfo.setKeyID(pkValueStr);
        String billNo = this.getBillNo(newDyn);
        if (!StringUtils.isBlank((CharSequence)billNo)) {
            mainModifyInfo.setCaption(billNo);
        }
        this.buildHeaderPropsInfo(newDyn, oldDyn, isDeleteOperate, isNewOperate, mainModifyInfo);
        for (ICollectionProperty subEntryProperty : mainEntityType.getProperties().getCollectionProperties(false)) {
            DynamicObjectCollection oldEntry;
            String subEntryName = subEntryProperty.getName().toLowerCase();
            if (subEntryProperty instanceof DynamicLocaleProperty || HRStringUtils.isEmpty((String)subEntryProperty.getItemType().getAlias())) continue;
            if (subEntryProperty instanceof MulBasedataProp) {
                this.handleMulBasedata(newDyn, oldDyn, isDeleteOperate, isNewOperate, mainModifyInfo, subEntryProperty);
                continue;
            }
            String entryBoidProperty = "entryboid";
            DynamicObjectCollection newEntry = newDyn != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)newDyn) : null;
            DynamicObjectCollection dynamicObjectCollection = oldEntry = oldDyn != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldDyn) : null;
            if (newEntry != null) {
                for (int index = 0; index < newEntry.size(); ++index) {
                    EntityModifyInfo subModifyInfo;
                    boolean isNewRow;
                    DynamicObject newRowData = (DynamicObject)newEntry.get(index);
                    Object pkValue = newRowData.getPkValue();
                    if (HRObjectUtils.isEmpty((Object)pkValue)) continue;
                    for (IDataEntityProperty subProperty : newEntry.getDynamicObjectType().getProperties()) {
                        if (!subProperty.getName().startsWith("entryboid") || !(subProperty instanceof BigIntProp)) continue;
                        entryBoidProperty = subProperty.getName();
                        break;
                    }
                    DynamicObject oldRowData = null;
                    long entryBoid = newRowData.getLong(entryBoidProperty);
                    String finalEntryBoidProperty = entryBoidProperty;
                    boolean bl = isNewRow = oldEntry == null || oldEntry.stream().noneMatch(y -> y.getLong(finalEntryBoidProperty) == entryBoid);
                    if (!isNewRow && oldEntry != null) {
                        oldRowData = oldEntry.stream().filter(o -> o.getLong(finalEntryBoidProperty) == entryBoid).findFirst().orElse(null);
                    }
                    if ((subModifyInfo = this.buildSubEntry(false, isNewOperate, isNewRow, false, subEntryProperty, index, newRowData, oldRowData, subEntryProperty.getName())) == null || subModifyInfo.isEmpty()) continue;
                    mainModifyInfo.addChild(subEntryName, subModifyInfo);
                }
            }
            if (!isUpdateOperate || oldEntry == null) continue;
            String finalEntryBoidProperty = entryBoidProperty;
            List deletedSubObjs = oldEntry.stream().filter(s -> {
                assert (newEntry != null);
                return newEntry.stream().noneMatch(y -> y.getLong(finalEntryBoidProperty) == s.getLong(finalEntryBoidProperty));
            }).collect(Collectors.toList());
            for (DynamicObject deletedSubObj : deletedSubObjs) {
                EntityModifyInfo subModifyInfo = this.buildSubEntry(false, false, false, true, subEntryProperty, oldEntry.indexOf((Object)deletedSubObj), null, deletedSubObj, subEntryProperty.getName());
                if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                mainModifyInfo.addChild(subEntryName, subModifyInfo);
            }
        }
        return mainModifyInfo;
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleMulBasedata(DynamicObject newDyn, DynamicObject oldDyn, boolean isDeleteOperate, boolean isNewOperate, EntityModifyInfo mainModifyInfo, ICollectionProperty subEntryProperty) {
        if (subEntryProperty == null) {
            return;
        }
        MulBasedataProp mulbdProp = (MulBasedataProp)subEntryProperty;
        if (isDeleteOperate) {
            DynamicObjectCollection mulSelObjs = oldDyn == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldDyn);
            String mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
            if (!StringUtils.isBlank((CharSequence)mulBasedataPropValue)) {
                FieldModifyInfo fieldModifyInfo = new FieldModifyInfo(mulBasedataPropValue, null, subEntryProperty.getDisplayName().toString());
                mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo);
            }
        } else if (isNewOperate) {
            DynamicObjectCollection mulSelObjs = newDyn == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)newDyn);
            String mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
            if (!StringUtils.isBlank((CharSequence)mulBasedataPropValue)) {
                FieldModifyInfo fieldModifyInfo = new FieldModifyInfo(null, mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo);
            }
        } else {
            DynamicObjectCollection mulSelObjs = newDyn == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)newDyn);
            String mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
            DynamicObjectCollection mulSelObjsOld = oldDyn == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldDyn);
            String mulBasedataPropValueOld = this.getMulBasedataPropValue(mulSelObjsOld, mulbdProp);
            if (!StringUtils.isBlank((CharSequence)mulBasedataPropValue) && !mulBasedataPropValue.equals(mulBasedataPropValueOld) || !StringUtils.isBlank((CharSequence)mulBasedataPropValueOld) && !mulBasedataPropValueOld.equals(mulBasedataPropValue)) {
                FieldModifyInfo fieldModifyInfo = new FieldModifyInfo(mulBasedataPropValueOld, mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo);
            }
        }
    }

    private void buildHeaderPropsInfo(DynamicObject newDyn, DynamicObject oldDyn, boolean isDeleteOperate, boolean isNewOperate, EntityModifyInfo mainModifyInfo) {
        ArrayList<IDataEntityProperty> headerProps = new ArrayList<IDataEntityProperty>();
        this.setContrastProps(oldDyn, newDyn, headerProps);
        for (IDataEntityProperty headerProp : headerProps) {
            FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(newDyn, oldDyn, headerProp, false);
            if (Objects.isNull(fieldModifyInfo)) continue;
            mainModifyInfo.addField(headerProp.getName(), fieldModifyInfo);
        }
        if (isDeleteOperate) {
            mainModifyInfo.setFlag("-");
        } else if (isNewOperate) {
            mainModifyInfo.setFlag("+");
        }
    }

    private EntityModifyInfo buildSubEntry(boolean isDeleteOperate, boolean isNewOperate, boolean isNewRow, boolean isDeleteRow, ICollectionProperty collectionProperty, int indexOfEntry, DynamicObject newRowData, DynamicObject oldRowData, String parentPropertyPath) {
        IDataEntityProperty entrySeq;
        String newPkValueStr;
        Object newRowPkValue = newRowData != null ? newRowData.getPkValue() : null;
        Object oldRowPkValue = oldRowData != null ? oldRowData.getPkValue() : null;
        String oldPkValueStr = oldRowPkValue != null ? oldRowPkValue.toString() : null;
        String string = newPkValueStr = newRowPkValue != null ? newRowPkValue.toString() : oldPkValueStr;
        if (StringUtils.isBlank((CharSequence)newPkValueStr)) {
            return null;
        }
        DynamicObjectType oldRowDynamicType = oldRowData != null ? oldRowData.getDynamicObjectType() : null;
        DynamicObjectType newRowDynamicType = newRowData != null ? newRowData.getDynamicObjectType() : oldRowDynamicType;
        String entryDisplayName = collectionProperty.getDisplayName().getLocaleValue();
        if (newRowDynamicType == null) {
            return null;
        }
        String seqStr = "" + (indexOfEntry + 1);
        if (newRowDynamicType instanceof IEntryType && (entrySeq = ((IEntryType)newRowDynamicType).getSeqProperty()) != null) {
            try {
                Object seqVal = entrySeq.getValue((Object)(newRowData != null ? newRowData : oldRowData));
                if (seqVal != null) {
                    seqStr = seqVal.toString();
                }
            }
            catch (ORMArgInvalidException e) {
                LOGGER.error(e.getMessage());
            }
        }
        String caption = entryDisplayName + "." + seqStr;
        EntityModifyInfo entityModifyInfo = new EntityModifyInfo(newPkValueStr, caption);
        this.handleMainEntry(isDeleteOperate, isNewOperate, newRowData, oldRowData, entityModifyInfo);
        if (isDeleteRow || isDeleteOperate) {
            entityModifyInfo.setFlag("-");
        } else if (isNewOperate || isNewRow) {
            entityModifyInfo.setFlag("+");
        }
        if (isDeleteOperate && oldRowData != null) {
            newRowDynamicType = oldRowDynamicType;
        }
        if (newRowDynamicType != null && newRowDynamicType.getProperties() != null) {
            for (ICollectionProperty subEntryProperty : newRowDynamicType.getProperties().getCollectionProperties(false)) {
                this.handleSubEntry(isDeleteOperate, isNewOperate, newRowData, oldRowData, parentPropertyPath, entityModifyInfo, subEntryProperty);
            }
        }
        return entityModifyInfo;
    }

    private void handleSubEntry(boolean isDeleteOperate, boolean isNewOperate, DynamicObject newDyn, DynamicObject oldDyn, String parentPropertyPath, EntityModifyInfo entityModifyInfo, ICollectionProperty subEntryProperty) {
        String subEntryName = subEntryProperty.getName().toLowerCase();
        if (subEntryProperty instanceof DynamicLocaleProperty) {
            return;
        }
        if (subEntryProperty instanceof MulBasedataProp) {
            this.handleMulBasedata(newDyn, oldDyn, isDeleteOperate, isNewOperate, entityModifyInfo, subEntryProperty);
        } else {
            String entryBoidProperty = "entryboid";
            DynamicObjectCollection newSubEntry = newDyn == null ? new DynamicObjectCollection() : (DynamicObjectCollection)subEntryProperty.getValueFast((Object)newDyn);
            DynamicObjectCollection oldSubEntry = oldDyn != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldDyn) : null;
            for (int index = 0; index < newSubEntry.size(); ++index) {
                EntityModifyInfo subEntryModifyInfo;
                boolean isSubNewRow;
                DynamicObject newSubRowData = (DynamicObject)newSubEntry.get(index);
                Object pkValue = newSubRowData.getPkValue();
                if (pkValue == null) continue;
                DynamicObjectCollection entry = oldSubEntry == null ? newSubEntry : oldSubEntry;
                for (IDataEntityProperty subProperty : entry.getDynamicObjectType().getProperties()) {
                    if (!subProperty.getName().startsWith("entryboid") || !(subProperty instanceof BigIntProp)) continue;
                    entryBoidProperty = subProperty.getName();
                    break;
                }
                long entryBoid = newSubRowData.getLong(entryBoidProperty);
                DynamicObject oldSubRowData = null;
                String finalEntryBoidProperty = entryBoidProperty;
                boolean bl = isSubNewRow = oldSubEntry == null || oldSubEntry.stream().noneMatch(y -> y.getLong(finalEntryBoidProperty) == entryBoid);
                if (!isSubNewRow && oldSubEntry != null) {
                    oldSubRowData = oldSubEntry.stream().filter(o -> o.getLong(finalEntryBoidProperty) == entryBoid).findFirst().orElse(null);
                }
                if ((subEntryModifyInfo = this.buildSubEntry(false, isNewOperate, isSubNewRow, false, subEntryProperty, index, newSubRowData, oldSubRowData, parentPropertyPath + "." + subEntryProperty.getName())) == null || subEntryModifyInfo.isEmpty()) continue;
                entityModifyInfo.addChild(subEntryName, subEntryModifyInfo);
            }
            if (!isNewOperate && oldSubEntry != null) {
                String finalEntryBoidProperty1 = entryBoidProperty;
                List deletedSubRowData = oldSubEntry.stream().filter(s -> newSubEntry.stream().noneMatch(y -> y.getLong(finalEntryBoidProperty1) == s.getLong(finalEntryBoidProperty1))).collect(Collectors.toList());
                for (DynamicObject deletedSubDyn : deletedSubRowData) {
                    EntityModifyInfo subEntryModifyInfo = this.buildSubEntry(false, false, false, true, subEntryProperty, oldSubEntry.indexOf((Object)deletedSubDyn), null, deletedSubDyn, parentPropertyPath + "." + subEntryProperty.getName());
                    if (subEntryModifyInfo == null || subEntryModifyInfo.isEmpty()) continue;
                    entityModifyInfo.addChild(subEntryName, subEntryModifyInfo);
                }
            }
        }
    }

    private void handleMainEntry(boolean isDeleteOperate, boolean isNewOperate, DynamicObject newDyn, DynamicObject oldDyn, EntityModifyInfo entityModifyInfo) {
        ArrayList<IDataEntityProperty> entryProps = new ArrayList<IDataEntityProperty>();
        this.setContrastProps(oldDyn, newDyn, entryProps);
        for (IDataEntityProperty entryProp : entryProps) {
            FieldModifyInfo fieldModifyInfo = this.buildFieldModifyInfo(newDyn, oldDyn, entryProp, isDeleteOperate);
            if (Objects.isNull(fieldModifyInfo)) continue;
            entityModifyInfo.addField(entryProp.getName(), fieldModifyInfo);
        }
        if (isDeleteOperate) {
            entityModifyInfo.setFlag("-");
        } else if (isNewOperate) {
            entityModifyInfo.setFlag("+");
        }
    }

    private String getPropertyValue(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof DynamicSimpleProperty) {
            if (dynamicProperty instanceof IFieldHandle) {
                return this.getFieldHandle(dynamicObject, dynamicProperty);
            }
            return dynamicObject.getString(dynamicProperty.getName());
        }
        if (dynamicProperty instanceof DynamicComplexProperty) {
            try {
                return this.getComplexProp(dynamicObject, dynamicProperty);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    @NotNull
    private String getComplexProp(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof FlexProp) {
            List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dynamicObject, (FlexProp)((FlexProp)dynamicProperty), (String)((FlexProp)dynamicProperty).getBasePropertyKey());
            ArrayList<String> displayValues = new ArrayList<String>();
            for (Map item : flexValues) {
                String alias = (String)item.get("alias");
                if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                displayValues.add(alias);
            }
            return String.join((CharSequence)"; ", displayValues);
        }
        DynamicObject obj = dynamicObject.getDynamicObject(dynamicProperty);
        return Objects.requireNonNull(Optional.ofNullable(obj).map(s -> s.getString("name")).orElse(null));
    }

    @ExcludeFromJacocoGeneratedReport
    @Nullable
    private String getFieldHandle(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof TimeProp) {
            TimeProp timeProp = (TimeProp)dynamicProperty;
            Object timePropObj = timeProp.getBasePropDisplayValue((Object)dynamicObject);
            return timePropObj != null ? timePropObj.toString() : null;
        }
        try {
            Object[] val;
            IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
            ListField listField = new ListField(dynamicProperty.getName());
            listField.setSrcFieldProp(dynamicProperty);
            listField.setFieldProp(dynamicProperty);
            AbstractColumnDesc listColumnDesc = fldHandle.getListColumnDesc(listField);
            listColumnDesc.setFormaType(2);
            Object valueObj = listColumnDesc.getValue(dynamicObject);
            if (valueObj instanceof Object[] && (val = (Object[])valueObj).length > 0) {
                Object o = val[0];
                return o != null ? o.toString() : null;
            }
            return valueObj != null ? valueObj.toString() : null;
        }
        catch (Exception e1) {
            try {
                IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
                Object dispValueObj = fldHandle.getBasePropDisplayValue((Object)dynamicObject);
                return dispValueObj != null ? dispValueObj.toString() : null;
            }
            catch (Exception e) {
                return dynamicObject.getString(dynamicProperty.getName());
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String getMulBasedataPropValue(DynamicObjectCollection mulSelObjs, MulBasedataProp mulbdProp) {
        if (mulSelObjs == null || mulSelObjs.size() == 0 || mulbdProp == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject mulSelObj : mulSelObjs) {
            String value;
            IComplexProperty refBaseProp = mulbdProp.getRefBaseProp();
            DynamicObject refBaseObj = (DynamicObject)refBaseProp.getValue((Object)mulSelObj);
            Object displayPropObj = refBaseObj.get(mulbdProp.getDisplayProp());
            if (displayPropObj == null || StringUtils.isBlank((CharSequence)(value = displayPropObj.toString()))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private FieldModifyInfo buildFieldModifyInfo(DynamicObject newDyn, DynamicObject oldDyn, IDataEntityProperty property, boolean isDelete) {
        LocaleString name = property.getDisplayName();
        String displayName = name != null ? name.toString() : property.getName();
        String newValue = null;
        if (newDyn != null && !isDelete) {
            newValue = this.getPropertyValue(newDyn, property);
        }
        Object desensitizeNewValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)newDyn, (Object)newValue);
        String oldValue = null;
        if (oldDyn != null) {
            oldValue = this.getPropertyValue(oldDyn, property);
        }
        Object desensitizeOldValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)newDyn, (Object)oldValue);
        if (HRStringUtils.equals((String)newValue, (String)oldValue)) {
            return null;
        }
        return new FieldModifyInfo(desensitizeOldValue, desensitizeNewValue, displayName);
    }

    private void setContrastProps(DynamicObject oldDyn, DynamicObject newDyn, List<IDataEntityProperty> contrastProps) {
        if (this.monitorFields == null || this.monitorFields.size() == 0) {
            return;
        }
        newDyn = newDyn == null ? oldDyn : newDyn;
        DataEntityPropertyCollection properties = newDyn.getDataEntityType().getProperties();
        for (Map.Entry<String, IDataEntityProperty> stringIDataEntityPropertyEntry : this.monitorFields.entrySet()) {
            IDataEntityProperty prop;
            String key = stringIDataEntityPropertyEntry.getKey();
            IDataEntityProperty property = stringIDataEntityPropertyEntry.getValue();
            if (this.ignoreProps.contains(key) || property instanceof CreaterProp || property instanceof CreateDateProp || property instanceof ModifierProp || property instanceof ModifyDateProp || HRStringUtils.isEmpty((String)property.getAlias()) || property instanceof ISimpleProperty && ((ISimpleProperty)property).isEncrypt() || (prop = (IDataEntityProperty)properties.get((Object)key)) == null) continue;
            contrastProps.add(prop);
        }
        contrastProps.sort(Comparator.comparingInt(IDataEntityProperty::getOrdinal));
    }

    private boolean isDeleteOperate() {
        return "delete".equals(this.operate);
    }
}

