/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.attachment.HisAttachmentSourceIdBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionNumberService;
import kd.hr.hbp.business.domain.service.newhismodel.INoLineTimeHisVersionChangeService;
import kd.hr.hbp.business.domain.util.HisModelNonEventUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;

public class NoLineTimeHisVersionChangeService
implements INoLineTimeHisVersionChangeService {
    private static final Log LOGGER = LogFactory.getLog(NoLineTimeHisVersionChangeService.class);
    private static volatile NoLineTimeHisVersionChangeService noLineTimeHisVersionChangeService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NoLineTimeHisVersionChangeService getInstance() {
        if (noLineTimeHisVersionChangeService != null) return noLineTimeHisVersionChangeService;
        Class<NoLineTimeHisVersionChangeService> clazz = NoLineTimeHisVersionChangeService.class;
        synchronized (NoLineTimeHisVersionChangeService.class) {
            if (noLineTimeHisVersionChangeService != null) return noLineTimeHisVersionChangeService;
            noLineTimeHisVersionChangeService = new NoLineTimeHisVersionChangeService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return noLineTimeHisVersionChangeService;
        }
    }

    @Override
    public HisResponse<VersionChangeRespData> noLineTimeHisVersionChange(HisVersionParamBo hisVersionParamBo) {
        long startTime = System.currentTimeMillis();
        String operateType = hisVersionParamBo.getOperateType();
        if (HRStringUtils.isEmpty((String)operateType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisModelController_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String entityNumber = hisVersionParamBo.getEntityNumber();
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisModelController_7", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)EnumHisOperateType.NO_TIME_SAVE_VERSION.getType(), (String)operateType)) {
            DynamicObject[] dynamicObjects = this.handleNoLineData(hisVersionParamBo);
            HisResponse<VersionChangeRespData> hisResponse = new HisResponse<VersionChangeRespData>();
            VersionChangeRespData versionChangeRespData = new VersionChangeRespData();
            versionChangeRespData.setNewDynamicObjects(dynamicObjects);
            versionChangeRespData.setEventId(hisVersionParamBo.getEventId());
            versionChangeRespData.setEntityNumber(hisVersionParamBo.getEntityNumber());
            hisResponse.setData(versionChangeRespData);
            long endTime = System.currentTimeMillis();
            LOGGER.info(String.format("noLineTimeHisVersionChange-consume-time:%s", endTime - startTime));
            return hisResponse;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6b64\u64cd\u4f5c\u7c7b\u578b:%s", (String)"HisModelController_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), operateType));
    }

    @Override
    public DynamicObject[] handleNoLineData(HisVersionParamBo hisVersionParamBo) {
        Object[] dynamicObjects = hisVersionParamBo.getHisDyns();
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisModelController_3", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        ArrayList curDyLists = Lists.newArrayListWithCapacity((int)16);
        String entityNumber = hisVersionParamBo.getEntityNumber();
        if (hisVersionParamBo.isEffImmediately()) {
            DynamicObjectCollection updateEffectDyCol;
            HashMap relEventMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObjectCollection saveDyCol = new DynamicObjectCollection();
            Map<String, Object> allMaps = this.setAllMaps((DynamicObject[])dynamicObjects, entityNumber);
            Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
                long boid = dynamicObject.getLong("boid");
                if (!(boid == 0L || dynamicObject.getBoolean("iscurrentversion") && HRStringUtils.equals((String)EnumHisDataVersionStatus.TEMP.getStatus(), (String)dynamicObject.getString("datastatus")))) {
                    dynamicObject.set("datastatus", null);
                    this.addParamDyCol((DynamicObject)dynamicObject, allMaps, relEventMap, entityNumber);
                }
            });
            DynamicObjectCollection paramDyCol = (DynamicObjectCollection)allMaps.get("paramDyCol");
            if (CollectionUtils.isNotEmpty((Collection)paramDyCol)) {
                HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, (DynamicObject[])dynamicObjects);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
                serviceHelper.save(paramDyCol);
            }
            ArrayList hisAttachmentSourceIdBoList = null;
            if (hisVersionParamBo.isNeedProcessAttachment()) {
                hisAttachmentSourceIdBoList = Lists.newArrayListWithExpectedSize((int)16);
            }
            for (Object dynamicObject2 : dynamicObjects) {
                long boid = dynamicObject2.getLong("boid");
                if (boid == 0L) {
                    this.saveEffectDy((DynamicObject)dynamicObject2, entityNumber, curDyLists, relEventMap, saveDyCol, hisAttachmentSourceIdBoList);
                    continue;
                }
                this.updateEffectDy((DynamicObject)dynamicObject2, entityNumber, curDyLists, relEventMap, allMaps, hisAttachmentSourceIdBoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)saveDyCol)) {
                List<DynamicObject> relEffectDys = saveDyCol.stream().filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
                HisVersionNumberService.getInstance().calcVersionNumber(entityNumber, relEffectDys.toArray(new DynamicObject[0]));
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
                serviceHelper.save(saveDyCol);
            }
            if (CollectionUtils.isNotEmpty((Collection)(updateEffectDyCol = (DynamicObjectCollection)allMaps.get("updateEffectDyCol")))) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
                serviceHelper.save(updateEffectDyCol);
            }
            if (hisVersionParamBo.isNeedProcessAttachment()) {
                this.processAttachment(hisAttachmentSourceIdBoList, hisVersionParamBo, entityNumber);
            }
            if (MapUtils.isNotEmpty((Map)relEventMap)) {
                if (relEventMap.size() == 1) {
                    relEventMap.put("eventbatchtype", "1");
                } else if (hisVersionParamBo.isAtomicTrans()) {
                    relEventMap.put("eventbatchtype", "2");
                } else {
                    relEventMap.put("eventbatchtype", "3");
                }
                Map<String, Object> returnEventGroupMap = HisModelNonEventUtil.saveNonDatasEvent(entityNumber, (DynamicObject[])dynamicObjects, relEventMap, hisVersionParamBo.getEventId());
                hisVersionParamBo.setEventId((Long)returnEventGroupMap.get("eventId"));
            }
        } else {
            Map<String, Object> allTempMaps = this.getAllTempMaps((DynamicObject[])dynamicObjects, entityNumber);
            Arrays.stream(dynamicObjects).forEach(dynamicObject -> this.saveTempDy((DynamicObject)dynamicObject, entityNumber, curDyLists, allTempMaps));
            DynamicObjectCollection updateEffectDyCol = (DynamicObjectCollection)allTempMaps.get("tempDyCol");
            if (CollectionUtils.isNotEmpty((Collection)updateEffectDyCol)) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
                serviceHelper.save(updateEffectDyCol);
            }
        }
        return curDyLists.toArray(new DynamicObject[0]);
    }

    private void addParamDyCol(DynamicObject dynamicObject, Map<String, Object> allMaps, Map<Object, Object> relEventMap, String entityNumber) {
        DynamicObjectCollection paramDyCol = (DynamicObjectCollection)allMaps.get("paramDyCol");
        ArrayList relEventMapLists = Lists.newArrayListWithExpectedSize((int)16);
        if (dynamicObject.getLong("id") == 0L) {
            Long id = ORM.create().genLongId(entityNumber);
            dynamicObject.set("id", (Object)id);
        }
        Map<String, Object> relToTempMap = HisModelNonEventUtil.getRelToEventMap(dynamicObject);
        relEventMapLists.add(relToTempMap);
        dynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        dynamicObject.set("iscurrentversion", (Object)"0");
        dynamicObject.set("ismodify", (Object)"0");
        this.setDyMasterid(entityNumber, dynamicObject);
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(dynamicObject);
        LOGGER.info("updateEffectDy-with-boid-no-curversion-dy : {}", (Object)dynamicObject.getLong("id"));
        paramDyCol.add((Object)dynamicObject);
        relEventMap.put(dynamicObject.getLong("id"), relEventMapLists);
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Object> getAllTempMaps(DynamicObject[] dynamicObjects, String entityNumber) {
        HashMap allTempMaps = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection tempDyCol = new DynamicObjectCollection();
        allTempMaps.put("tempDyCol", tempDyCol);
        Set boidSet = Arrays.stream(dynamicObjects).filter(dy -> {
            long boid = dy.getLong("boid");
            return boid != 0L;
        }).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(boidSet)) {
            QFilter boidFilter = new QFilter("boid", "in", boidSet);
            QFilter dataStatusQfiter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            DynamicObject[] tempDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, boidFilter.and(dataStatusQfiter));
            Map idToTempDyMaps = Arrays.stream(tempDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
            allTempMaps.put("idToTempDyMaps", idToTempDyMaps);
            DynamicObject[] curDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, new QFilter("id", "in", boidSet));
            Map idToCurDyMaps = Arrays.stream(curDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
            allTempMaps.put("idToCurDyMaps", idToCurDyMaps);
        }
        return allTempMaps;
    }

    private Map<String, Object> setAllMaps(DynamicObject[] dynamicObjects, String entityNumber) {
        HashMap allMaps = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection updateEffectDyCol = new DynamicObjectCollection();
        DynamicObjectCollection paramDyCol = new DynamicObjectCollection();
        HashSet<Long> idSet = new HashSet<Long>(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            long id = dynamicObject.getLong("id");
            if (id != 0L) {
                idSet.add(id);
            }
        });
        Set<Long> oldIdSet = null;
        if (CollectionUtils.isNotEmpty(idSet)) {
            HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
            oldIdSet = HisCommonEntityRepository.getEffectVersionBoId(hRBaseServiceHelper, idSet);
        }
        for (DynamicObject dynamicObject2 : dynamicObjects) {
            long id = dynamicObject2.getLong("id");
            if (oldIdSet == null || !oldIdSet.contains(id)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25\uff0c\u8be5\u6570\u636e\u7248\u672c\u5df2\u5b58\u5728\u3002", (String)"AbstractHisSaveVersion_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        Set set = Arrays.stream(dynamicObjects).filter(dy -> {
            long boid = dy.getLong("boid");
            return boid != 0L;
        }).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(set)) {
            return allMaps;
        }
        DynamicObject[] curDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, new QFilter("id", "in", set));
        Map idToCurDyMaps = Arrays.stream(curDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        Set sourceIdSet = Arrays.stream(curDys).map(dy -> dy.getLong("sourcevid")).collect(Collectors.toSet());
        DynamicObject[] relEffectDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, new QFilter("id", "in", sourceIdSet));
        Map idToRelEffectDyMaps = Arrays.stream(relEffectDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        QFilter boidFilter = new QFilter("boid", "in", set);
        QFilter dataStatusQfiter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        DynamicObject[] tempDys = HisCommonEntityRepository.queryOriginalArray(entityNumber, boidFilter.and(dataStatusQfiter), "id,datastatus,modifytime,modifier,ismodify,boid");
        Map idToTempDyMaps = Arrays.stream(tempDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
        allMaps.put("idToCurDyMaps", idToCurDyMaps);
        allMaps.put("idToRelEffectDyMaps", idToRelEffectDyMaps);
        allMaps.put("idToTempDyMaps", idToTempDyMaps);
        allMaps.put("updateEffectDyCol", updateEffectDyCol);
        allMaps.put("paramDyCol", paramDyCol);
        return allMaps;
    }

    @ExcludeFromJacocoGeneratedReport
    private void saveTempDy(DynamicObject nonTimeHisDy, String entityNumber, List<DynamicObject> curDyLists, Map<String, Object> allTempMaps) {
        if (nonTimeHisDy.getLong("id") == 0L) {
            Long id = ORM.create().genLongId(entityNumber);
            nonTimeHisDy.set("id", (Object)id);
        }
        DynamicObjectCollection tempDyCol = (DynamicObjectCollection)allTempMaps.get("tempDyCol");
        if (nonTimeHisDy.getLong("boid") == 0L) {
            nonTimeHisDy.set("boid", (Object)nonTimeHisDy.getLong("id"));
            nonTimeHisDy.set("iscurrentversion", (Object)"1");
            nonTimeHisDy.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            this.setDyMasterid(entityNumber, nonTimeHisDy);
            DynamicObjectCommonService.getInstance().setSimpleNewInfo(nonTimeHisDy);
            tempDyCol.add((Object)nonTimeHisDy);
            curDyLists.add(nonTimeHisDy);
        } else {
            Map idToTempDyMaps = (Map)allTempMaps.get("idToTempDyMaps");
            DynamicObject tempDy = (DynamicObject)idToTempDyMaps.get(nonTimeHisDy.getLong("boid"));
            if (!HRObjectUtils.isEmpty((Object)tempDy)) {
                DataEntityPropertyCollection properties = nonTimeHisDy.getDataEntityType().getProperties();
                for (IDataEntityProperty iDataEntityProperty : properties) {
                    if (!(iDataEntityProperty instanceof BasedataProp) || !(nonTimeHisDy.get(iDataEntityProperty.getName()) instanceof Long)) continue;
                    String propertyName = String.format("%s_id", iDataEntityProperty.getName());
                    nonTimeHisDy.set(propertyName, nonTimeHisDy.get(iDataEntityProperty.getName()));
                }
                HashSet excludeFields = Sets.newHashSetWithExpectedSize((int)16);
                excludeFields.add("id");
                excludeFields.add("creator");
                excludeFields.add("creator_id");
                excludeFields.add("createtime");
                excludeFields.add("datastatus");
                excludeFields.add("ismodify");
                excludeFields.add("iscurrentversion");
                HRDynamicObjectUtils.copy((DynamicObject)nonTimeHisDy, (DynamicObject)tempDy, (Set)excludeFields, (boolean)true);
                this.setDyMasterid(entityNumber, tempDy);
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(tempDy);
                tempDyCol.add((Object)tempDy);
                return;
            }
            Map idToCurDyMaps = (Map)allTempMaps.get("idToCurDyMaps");
            DynamicObject nonLineRelCurEffectingDy = (DynamicObject)idToCurDyMaps.get(nonTimeHisDy.getLong("boid"));
            if (HRObjectUtils.isEmpty((Object)nonLineRelCurEffectingDy)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6682\u5b58\u7248\u672c\u65e0\u5173\u8054\u751f\u6548\u4e2d\u7684\u6570\u636e.", (String)"HisModelController_6", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            nonTimeHisDy.set("ismodify", (Object)"1");
            nonTimeHisDy.set("iscurrentversion", (Object)"0");
            nonTimeHisDy.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            this.setDyMasterid(entityNumber, nonTimeHisDy);
            DynamicObjectCommonService.getInstance().setSimpleNewInfo(nonTimeHisDy);
            tempDyCol.add((Object)nonTimeHisDy);
            nonLineRelCurEffectingDy.set("ismodify", (Object)"1");
            DynamicObjectCommonService.getInstance().setSimpleModifyInfo(nonLineRelCurEffectingDy);
            tempDyCol.add((Object)nonLineRelCurEffectingDy);
            curDyLists.add(nonLineRelCurEffectingDy);
        }
    }

    private void updateEffectDy(DynamicObject nonTimeHisDy, String entityNumber, List<DynamicObject> curDyLists, Map<Object, Object> relEventMap, Map<String, Object> allMaps, List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        List relEventMapLists = (List)relEventMap.get(nonTimeHisDy.getLong("id"));
        if (CollectionUtils.isEmpty((Collection)relEventMapLists)) {
            relEventMapLists = Lists.newArrayListWithExpectedSize((int)16);
        }
        if (nonTimeHisDy.getBoolean("iscurrentversion") && HRStringUtils.equals((String)nonTimeHisDy.getString("datastatus"), (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
            this.toEffectCurTempData(serviceHelper, nonTimeHisDy, relEventMap, relEventMapLists);
            curDyLists.add(nonTimeHisDy);
            return;
        }
        Map idToCurDyMaps = (Map)allMaps.get("idToCurDyMaps");
        DynamicObject nonLineRelCurEffectingDy = (DynamicObject)idToCurDyMaps.get(nonTimeHisDy.getLong("boid"));
        if (HRObjectUtils.isEmpty((Object)nonLineRelCurEffectingDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u7248\u672c\u751f\u6548\u4e2d\u7684\u6570\u636e.", (String)"HisModelController_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        Map idToRelEffectDyMaps = (Map)allMaps.get("idToRelEffectDyMaps");
        DynamicObject nonLineRelHisDy = (DynamicObject)idToRelEffectDyMaps.get(nonLineRelCurEffectingDy.getLong("sourcevid"));
        if (HRObjectUtils.isEmpty((Object)nonLineRelHisDy)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u6548\u4e2d\u7248\u672c\u65e0\u5173\u8054\u7684\u5386\u53f2\u6570\u636e.", (String)"HisModelController_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection updateEffectDyCol = (DynamicObjectCollection)allMaps.get("updateEffectDyCol");
        Map<String, Object> relToHisMap = HisModelNonEventUtil.getRelToEventMap(nonLineRelHisDy);
        relEventMapLists.add(relToHisMap);
        nonLineRelHisDy.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(nonLineRelHisDy);
        nonLineRelHisDy.set("ismodify", (Object)"0");
        updateEffectDyCol.add((Object)nonLineRelHisDy);
        HashSet excludeFields = Sets.newHashSetWithExpectedSize((int)16);
        excludeFields.add("id");
        excludeFields.add("creator");
        excludeFields.add("creator_id");
        excludeFields.add("createtime");
        excludeFields.add("iscurrentversion");
        excludeFields.add("hisversion");
        HRDynamicObjectUtils.copy((DynamicObject)nonTimeHisDy, (DynamicObject)nonLineRelCurEffectingDy, (Set)excludeFields, (boolean)true);
        nonLineRelCurEffectingDy.set("sourcevid", (Object)nonTimeHisDy.getLong("id"));
        this.setDyMasterid(entityNumber, nonLineRelCurEffectingDy);
        Map idToTempDyMaps = (Map)allMaps.get("idToTempDyMaps");
        DynamicObject tempBDy = (DynamicObject)idToTempDyMaps.get(nonTimeHisDy.getLong("boid"));
        if (HRObjectUtils.isEmpty((Object)tempBDy) || tempBDy.getLong("id") == nonTimeHisDy.getLong("id")) {
            nonLineRelCurEffectingDy.set("ismodify", (Object)"0");
        } else {
            nonLineRelCurEffectingDy.set("ismodify", (Object)"1");
        }
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(nonLineRelCurEffectingDy);
        LOGGER.info("updateEffectDy-curversion-dy : {}", (Object)nonLineRelCurEffectingDy.getLong("id"));
        updateEffectDyCol.add((Object)nonLineRelCurEffectingDy);
        curDyLists.add(nonLineRelCurEffectingDy);
        if (hisAttachmentSourceIdBoList != null) {
            HisAttachmentSourceIdBo hisAttachmentSourceIdBo = new HisAttachmentSourceIdBo();
            hisAttachmentSourceIdBo.setSourceId(nonTimeHisDy.getLong("id"));
            hisAttachmentSourceIdBo.setId(nonLineRelCurEffectingDy.getLong("id"));
            hisAttachmentSourceIdBo.setFirstVersion(false);
            hisAttachmentSourceIdBoList.add(hisAttachmentSourceIdBo);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void toEffectCurTempData(HRBaseServiceHelper serviceHelper, DynamicObject nonTimeHisDy, Map<Object, Object> relEventMap, List<Map<String, Object>> relEventMapLists) {
        DynamicObject relHisEffectDy = serviceHelper.generateEmptyDynamicObject();
        HashSet excludeFields = Sets.newHashSetWithExpectedSize((int)16);
        excludeFields.add("id");
        excludeFields.add("iscurrentversion");
        HRDynamicObjectUtils.copy((DynamicObject)nonTimeHisDy, (DynamicObject)relHisEffectDy, (Set)excludeFields, (boolean)true);
        relHisEffectDy.set("id", (Object)ORM.create().genLongId(serviceHelper.getEntityName()));
        Map<String, Object> relToEventMap = HisModelNonEventUtil.getRelToEventMap(relHisEffectDy);
        relEventMapLists.add(relToEventMap);
        relEventMap.put(nonTimeHisDy.getLong("id"), relEventMapLists);
        relHisEffectDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        relHisEffectDy.set("iscurrentversion", (Object)"0");
        HisVersionNumberService.getInstance().calcVersionNumber(serviceHelper.getEntityName(), new DynamicObject[]{relHisEffectDy});
        this.setDyMasterid(serviceHelper.getEntityName(), relHisEffectDy);
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(relHisEffectDy);
        serviceHelper.saveOne(relHisEffectDy);
        nonTimeHisDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        nonTimeHisDy.set("sourcevid", (Object)relHisEffectDy.getLong("id"));
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(nonTimeHisDy);
        serviceHelper.saveOne(nonTimeHisDy);
    }

    private void saveEffectDy(DynamicObject nonTimeHisDy, String entityNumber, List<DynamicObject> curDyLists, Map<Object, Object> relEventMap, DynamicObjectCollection saveDyCol, List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        nonTimeHisDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        if (nonTimeHisDy.getLong("id") == 0L) {
            Long id = ORM.create().genLongId(entityNumber);
            nonTimeHisDy.set("id", (Object)id);
        }
        nonTimeHisDy.set("boid", (Object)nonTimeHisDy.getLong("id"));
        nonTimeHisDy.set("iscurrentversion", (Object)"1");
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(nonTimeHisDy);
        DynamicObject relEffectDy = serviceHelper.generateEmptyDynamicObject();
        Long relEffectDyId = ORM.create().genLongId(entityNumber);
        relEffectDy.set("id", (Object)relEffectDyId);
        ArrayList relEventMapLists = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, Object> relToEventMap = HisModelNonEventUtil.getRelToEventMap(relEffectDy);
        relEventMapLists.add(relToEventMap);
        relEventMap.put(nonTimeHisDy.getLong("id"), relEventMapLists);
        HashSet<String> excludeFields = new HashSet<String>();
        excludeFields.add("id");
        HRDynamicObjectUtils.copy((DynamicObject)nonTimeHisDy, (DynamicObject)relEffectDy, excludeFields, (boolean)true);
        relEffectDy.set("iscurrentversion", (Object)"0");
        this.setDyMasterid(entityNumber, relEffectDy);
        nonTimeHisDy.set("sourcevid", (Object)relEffectDy.getLong("id"));
        this.setDyMasterid(entityNumber, nonTimeHisDy);
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(relEffectDy);
        LOGGER.info("curversion-dy : {}", (Object)nonTimeHisDy.getLong("id"));
        LOGGER.info("no-curversion-dy : {}", (Object)relEffectDy.getLong("id"));
        saveDyCol.add((Object)nonTimeHisDy);
        saveDyCol.add((Object)relEffectDy);
        curDyLists.add(nonTimeHisDy);
        if (hisAttachmentSourceIdBoList != null) {
            HisAttachmentSourceIdBo hisAttachmentSourceIdBo = new HisAttachmentSourceIdBo();
            hisAttachmentSourceIdBo.setSourceId(nonTimeHisDy.getLong("id"));
            hisAttachmentSourceIdBo.setId(relEffectDyId);
            hisAttachmentSourceIdBo.setFirstVersion(true);
            hisAttachmentSourceIdBoList.add(hisAttachmentSourceIdBo);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void setDyMasterid(String entityNumber, DynamicObject dy) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)dataEntityType.getProperties().get((Object)"masterid");
        if (Objects.nonNull(iDataEntityProperty)) {
            dy.set("masterid", (Object)dy.getLong("id"));
        }
    }

    private void processAttachment(List<HisAttachmentSourceIdBo> hisAttachmentSourceIdBoList, HisVersionParamBo hisVersionParamBo, String entityNumber) {
        if (!hisVersionParamBo.isNeedProcessAttachment()) {
            return;
        }
        Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos = hisVersionParamBo.getMapHisAttachmentBos();
        HisAttachmentService.processAttachment(hisAttachmentSourceIdBoList, mapHisAttachmentBos, entityNumber);
    }
}

