/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.calc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.domain.model.newhismodel.EffStartEndDateBo;
import kd.hr.hbp.business.domain.model.newhismodel.calc.HisVersionCalcResult;
import kd.hr.hbp.business.domain.model.newhismodel.calc.HisVersionCalcTipsData;
import kd.hr.hbp.business.domain.model.newhismodel.calc.HisVersionCalcTipsVo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import org.apache.commons.collections.CollectionUtils;

public class HisVersionCalcTipsService {
    private static volatile HisVersionCalcTipsService hisVersionCalcTipsService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisVersionCalcTipsService getInstance() {
        if (hisVersionCalcTipsService != null) return hisVersionCalcTipsService;
        Class<HisVersionCalcTipsService> clazz = HisVersionCalcTipsService.class;
        synchronized (HisVersionCalcTipsService.class) {
            if (hisVersionCalcTipsService != null) return hisVersionCalcTipsService;
            hisVersionCalcTipsService = new HisVersionCalcTipsService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisVersionCalcTipsService;
        }
    }

    public List<HisVersionCalcResult> processVersion(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        String entityNumber = dynamicObject.getDynamicObjectType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        Long boId = dynamicObject.getLong("boid");
        Map<String, EffStartEndDateBo> mapOldVersionEffDate = HisCommonEntityRepository.queryOldEffVersionEffDateByBoId(serviceHelper, boId);
        EffStartEndDateBo newEffStartEndDateBo = new EffStartEndDateBo();
        Date effStartDate = dynamicObject.getDate("bsed");
        if (effStartDate == null) {
            return null;
        }
        newEffStartEndDateBo.setEffectStartDate(effStartDate);
        Date effEndDate = dynamicObject.getDate("bsled");
        if (effEndDate == null) {
            effEndDate = HisEffDateCommonService.getInstance().getDate2999(null);
        }
        if (effEndDate.getTime() < effStartDate.getTime()) {
            return null;
        }
        newEffStartEndDateBo.setEffectEndDate(effEndDate);
        ArrayList<HisVersionCalcResult> hisVersionCalcResultList = new ArrayList<HisVersionCalcResult>(8);
        this.processVersion(hisVersionCalcResultList, newEffStartEndDateBo, mapOldVersionEffDate);
        return hisVersionCalcResultList;
    }

    public HisVersionCalcTipsVo calcTipsVo(DynamicObject dynamicObject, boolean isSave) {
        List<HisVersionCalcResult> hisVersionCalcResultList = this.processVersion(dynamicObject);
        this.removeUpdateOneVersion(hisVersionCalcResultList);
        if (CollectionUtils.isEmpty(hisVersionCalcResultList)) {
            return null;
        }
        HisVersionCalcTipsVo hisVersionCalcTipsVo = new HisVersionCalcTipsVo();
        HisVersionCalcTipsData addData = null;
        HisVersionCalcTipsData updateData = null;
        HisVersionCalcTipsData deleteData = null;
        HashMap<String, String> idVersionMap = new HashMap<String, String>(hisVersionCalcResultList.size());
        String deleteDescription = ResManager.loadKDString((String)"\u7f6e\u4e3a\u5df2\u5220\u9664\u72b6\u6001", (String)"HisVersionCalcTipsService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        HashMap<String, String> mapDelete = null;
        HashMap<String, String> mapAdd = null;
        HashMap<String, String> mapUpdate = null;
        StringBuilder sbVersions = new StringBuilder();
        for (int i = 0; i < hisVersionCalcResultList.size(); ++i) {
            HisVersionCalcResult hisVersionCalcResult = hisVersionCalcResultList.get(i);
            String newDataStatus = hisVersionCalcResult.getNewDataStatus();
            String version = hisVersionCalcResult.getVersion();
            Long id = hisVersionCalcResult.getId();
            if (EnumHisDataVersionStatus.DELETED.getStatus().equals(newDataStatus)) {
                if (mapDelete == null) {
                    mapDelete = new HashMap<String, String>(16);
                }
                mapDelete.put(version, deleteDescription);
                if (deleteData == null) {
                    deleteData = new HisVersionCalcTipsData();
                }
                deleteData.setData(mapDelete);
                if (hisVersionCalcTipsVo.getDeleteData() == null) {
                    hisVersionCalcTipsVo.setDeleteData(deleteData);
                }
            } else {
                if (hisVersionCalcResult.getSecondEffStartEndDateBo() != null) {
                    if (mapAdd == null) {
                        mapAdd = new HashMap<String, String>(1);
                    }
                    StringBuilder addDesc = new StringBuilder(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0e%1$s\u76f8\u540c\uff0c%2$s", (String)"HisVersionCalcTipsService_16", (String)"hrmp-hbp-business", (Object[])new Object[0]), version, this.buildAddDesc(hisVersionCalcResult)));
                    mapAdd.put(version, addDesc.toString());
                    if (addData == null) {
                        addData = new HisVersionCalcTipsData();
                    }
                    addData.setData(mapAdd);
                    hisVersionCalcTipsVo.setAddData(addData);
                }
                if (hisVersionCalcResult.getFirstEffStartEndDateBo() != null && hisVersionCalcResult.getOldEffStartEndDateBo() != null) {
                    if (mapUpdate == null) {
                        mapUpdate = new HashMap<String, String>(1);
                    }
                    mapUpdate.put(version, this.buildUpdateDesc(hisVersionCalcResult));
                    if (updateData == null) {
                        updateData = new HisVersionCalcTipsData();
                    }
                    updateData.setData(mapUpdate);
                    hisVersionCalcTipsVo.setUpdateData(updateData);
                }
            }
            sbVersions.append(version);
            if (i != hisVersionCalcResultList.size() - 1) {
                sbVersions.append("\u3001");
            }
            idVersionMap.put(version, String.valueOf(id));
        }
        hisVersionCalcTipsVo.setIdVersionMap(idVersionMap);
        Date endDate = dynamicObject.getDate("bsled");
        if (endDate == null) {
            endDate = HisEffDateCommonService.getInstance().getDate2999(null);
        }
        String dataStatus = HisEffDateCommonService.getInstance().calcDataStatus(dynamicObject.getDate("bsed"), endDate);
        String dataStatusValue = EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dataStatus) ? ResManager.loadKDString((String)"\u5f85\u751f\u6548", (String)"HisVersionCalcTipsService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]) : (EnumHisDataVersionStatus.INVALIDED.getStatus().equals(dataStatus) ? ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"HisVersionCalcTipsService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u751f\u6548\u4e2d", (String)"HisVersionCalcTipsService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        boolean isNewData = true;
        if (dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() != 0L) {
            isNewData = false;
        }
        this.buildDesc(hisVersionCalcTipsVo, isSave, dataStatusValue, sbVersions.toString(), isNewData);
        return hisVersionCalcTipsVo;
    }

    private void removeUpdateOneVersion(List<HisVersionCalcResult> hisVersionCalcResultList) {
        if (hisVersionCalcResultList == null) {
            return;
        }
        if (hisVersionCalcResultList.size() != 1) {
            return;
        }
        HisVersionCalcResult hisVersionCalcResult = hisVersionCalcResultList.get(0);
        if (EnumHisDataVersionStatus.DELETED.getStatus().equals(hisVersionCalcResult.getNewDataStatus())) {
            return;
        }
        if (hisVersionCalcResult.getFirstEffStartEndDateBo() == null || hisVersionCalcResult.getOldEffStartEndDateBo() == null) {
            return;
        }
        if (hisVersionCalcResult.getSecondEffStartEndDateBo() != null) {
            return;
        }
        Date endDate = hisVersionCalcResult.getOldEffStartEndDateBo().getEffectEndDate();
        if (endDate == null) {
            return;
        }
        if (endDate.getTime() == HisEffDateCommonService.getInstance().getDate2999(null).getTime()) {
            hisVersionCalcResultList.remove(0);
        }
    }

    private String buildAddDesc(HisVersionCalcResult hisVersionCalcResult) {
        if (EnumHisDataVersionStatus.DELETED.getStatus().equals(hisVersionCalcResult.getNewDataStatus())) {
            return null;
        }
        return String.format(ResManager.loadKDString((String)"\u751f/\u5931\u6548\u65e5\u671f%s\u3002", (String)"HisVersionCalcTipsService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), this.buildDateDesc(hisVersionCalcResult.getSecondEffStartEndDateBo()));
    }

    private String buildUpdateDesc(HisVersionCalcResult hisVersionCalcResult) {
        if (EnumHisDataVersionStatus.DELETED.getStatus().equals(hisVersionCalcResult.getNewDataStatus())) {
            return null;
        }
        return String.format(ResManager.loadKDString((String)"\u751f/\u5931\u6548\u65e5\u671f%1$s\u4fee\u6539\u4e3a%2$s\u3002", (String)"HisVersionCalcTipsService_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), this.buildDateDesc(hisVersionCalcResult.getOldEffStartEndDateBo()), this.buildDateDesc(hisVersionCalcResult.getFirstEffStartEndDateBo()));
    }

    private String buildDateDesc(EffStartEndDateBo endDateBo) {
        if (endDateBo == null) {
            return null;
        }
        Date startDate = endDateBo.getEffectStartDate();
        Date endDate = endDateBo.getEffectEndDate();
        if (startDate == null || endDate == null) {
            return null;
        }
        SimpleDateFormat sdf = HRDateTimeUtils.getUserSettingFormat();
        StringBuilder description = new StringBuilder();
        description.append(sdf.format(startDate));
        description.append("~");
        description.append(sdf.format(endDate));
        return description.toString();
    }

    private void buildDesc(HisVersionCalcTipsVo hisVersionCalcTipsVo, boolean isSave, String dataStatus, String versions, boolean isNewData) {
        Map<String, String> mapDelete;
        Map<String, String> mapUpdate;
        Map<String, String> mapAdd;
        HisVersionCalcTipsData addData = hisVersionCalcTipsVo.getAddData();
        HisVersionCalcTipsData updateData = hisVersionCalcTipsVo.getUpdateData();
        HisVersionCalcTipsData deleteData = hisVersionCalcTipsVo.getDeleteData();
        if (addData != null && (mapAdd = addData.getData()) != null && mapAdd.size() > 0) {
            addData.setDescription(String.format(ResManager.loadKDString((String)"\u65b0\u589e%s\u4e2a\u6570\u636e\u7248\u672c", (String)"HisVersionCalcTipsService_7", (String)"hrmp-hbp-business", (Object[])new Object[0]), mapAdd.size()));
        }
        if (updateData != null && (mapUpdate = updateData.getData()) != null && mapUpdate.size() > 0) {
            updateData.setDescription(String.format(ResManager.loadKDString((String)"%s\u4e2a\u7248\u672c\u7684\u751f/\u5931\u6548\u65e5\u671f\u53d1\u751f\u53d8\u66f4", (String)"HisVersionCalcTipsService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]), String.valueOf(mapUpdate.size())));
        }
        if (deleteData != null && (mapDelete = deleteData.getData()) != null && mapDelete.size() > 0) {
            deleteData.setDescription(String.format(ResManager.loadKDString((String)"%s\u4e2a\u6570\u636e\u7248\u672c\u88ab\u7f6e\u4e3a\u201c\u5df2\u5220\u9664\u201d\u72b6\u6001\uff08\u201c\u5df2\u5220\u9664\u201d\u72b6\u6001\u6570\u636e\u4e0d\u5141\u8bb8\u53d1\u751f\u65b0\u7684\u4e1a\u52a1\uff09\u3002", (String)"HisVersionCalcTipsService_9", (String)"hrmp-hbp-business", (Object[])new Object[0]), String.valueOf(mapDelete.size())));
        }
        if (isSave) {
            if (isNewData) {
                hisVersionCalcTipsVo.setDescription(ResManager.loadKDString((String)"\u5c06\u65b0\u589e\u4e00\u4e2a\u201c\u6682\u5b58\u201d\u72b6\u6001\u6570\u636e\u7248\u672c\u3002", (String)"HisVersionCalcTipsService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            hisVersionCalcTipsVo.setSpecialDescription(String.format(ResManager.loadKDString((String)"\u7279\u522b\u8bf4\u660e\uff1a\u6b64\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u7684\u751f/\u5931\u6548\u65e5\u671f\u4e0e\u539f\u6709%s\u6570\u636e\u7248\u672c\u7684\u751f/\u5931\u6548\u65e5\u671f\u91cd\u53e0\uff0c\u5f53\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u751f\u6548\u65f6\uff0c\u6570\u636e\u7248\u672c\u5c06\u53d1\u751f\u4ee5\u4e0b\u53d8\u5316\uff1a", (String)"HisVersionCalcTipsService_11", (String)"hrmp-hbp-business", (Object[])new Object[0]), versions));
            hisVersionCalcTipsVo.setCommitDescription(ResManager.loadKDString((String)"\u786e\u5b9a\u4fdd\u5b58\u5417\uff1f", (String)"HisVersionCalcTipsService_12", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        } else {
            if (isNewData) {
                hisVersionCalcTipsVo.setDescription(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u540e\uff0c\u5c06\u65b0\u589e\u4e00\u4e2a\u201c%s\u201d\u72b6\u6001\u6570\u636e\u7248\u672c\u3002", (String)"HisVersionCalcTipsService_13", (String)"hrmp-hbp-business", (Object[])new Object[0]), dataStatus));
            } else {
                hisVersionCalcTipsVo.setDescription(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u540e\uff0c\u5c06\u6b64\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u7f6e\u4e3a\u201c%s\u201d\u72b6\u6001\u3002", (String)"HisVersionCalcTipsService_17", (String)"hrmp-hbp-business", (Object[])new Object[0]), dataStatus));
            }
            hisVersionCalcTipsVo.setSpecialDescription(String.format(ResManager.loadKDString((String)"\u7279\u522b\u8bf4\u660e\uff1a\u6b64\u201c%1$s\u201d\u6570\u636e\u7248\u672c\u7684\u751f/\u5931\u6548\u65e5\u671f\u4e0e\u539f\u6709%2$s\u6570\u636e\u7248\u672c\u7684\u751f/\u5931\u6548\u65e5\u671f\u91cd\u53e0\uff0c\u6570\u636e\u7248\u672c\u5c06\u53d1\u751f\u4ee5\u4e0b\u53d8\u5316\uff1a", (String)"HisVersionCalcTipsService_14", (String)"hrmp-hbp-business", (Object[])new Object[0]), dataStatus, versions));
            hisVersionCalcTipsVo.setCommitDescription(ResManager.loadKDString((String)"\u786e\u5b9a\u53d8\u66f4\u5417\uff1f", (String)"HisVersionCalcTipsService_15", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    private void processVersion(List<HisVersionCalcResult> hisVersionCalcResultList, EffStartEndDateBo newEffStartEndDateBo, Map<String, EffStartEndDateBo> mapOldVersionEffDate) {
        for (Map.Entry<String, EffStartEndDateBo> entry : mapOldVersionEffDate.entrySet()) {
            String version = entry.getKey();
            EffStartEndDateBo oldEffStartEndDateBo = entry.getValue();
            Date effStartDate = newEffStartEndDateBo.getEffectStartDate();
            Date oldEffStartDate = oldEffStartEndDateBo.getEffectStartDate();
            if (effStartDate.getTime() < oldEffStartDate.getTime()) {
                this.processBeforeVersion(hisVersionCalcResultList, version, newEffStartEndDateBo, oldEffStartEndDateBo);
                continue;
            }
            if (effStartDate.getTime() > oldEffStartDate.getTime()) {
                this.processAfterVersion(hisVersionCalcResultList, version, newEffStartEndDateBo, oldEffStartEndDateBo);
                continue;
            }
            this.processEqualsVersion(hisVersionCalcResultList, version, newEffStartEndDateBo, oldEffStartEndDateBo);
        }
    }

    private void processBeforeVersion(List<HisVersionCalcResult> hisVersionCalcResultList, String version, EffStartEndDateBo newEffStartEndDateBo, EffStartEndDateBo oldEffStartEndDateBo) {
        HisVersionCalcResult hisVersionCalcResult;
        Date effEndDate = newEffStartEndDateBo.getEffectEndDate();
        Date oldEffStartDate = oldEffStartEndDateBo.getEffectStartDate();
        Date oldEffEndDate = oldEffStartEndDateBo.getEffectEndDate();
        if (effEndDate.getTime() >= oldEffStartDate.getTime() && effEndDate.getTime() < oldEffEndDate.getTime()) {
            hisVersionCalcResult = this.buildHisVersionCalcResult(oldEffStartEndDateBo.getId(), oldEffStartDate, oldEffEndDate, version);
            hisVersionCalcResultList.add(hisVersionCalcResult);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            Date newDate = calendar.getTime();
            EffStartEndDateBo firstEffStartEndDateBo = new EffStartEndDateBo();
            firstEffStartEndDateBo.setEffectStartDate(newDate);
            firstEffStartEndDateBo.setEffectEndDate(oldEffEndDate);
            hisVersionCalcResult.setFirstEffStartEndDateBo(firstEffStartEndDateBo);
        }
        if (effEndDate.getTime() >= oldEffEndDate.getTime()) {
            hisVersionCalcResult = this.buildHisVersionCalcResult(oldEffStartEndDateBo.getId(), oldEffStartDate, oldEffEndDate, version);
            hisVersionCalcResultList.add(hisVersionCalcResult);
            hisVersionCalcResult.setNewDataStatus(EnumHisDataVersionStatus.DELETED.getStatus());
        }
    }

    private void processAfterVersion(List<HisVersionCalcResult> hisVersionCalcResultList, String version, EffStartEndDateBo newEffStartEndDateBo, EffStartEndDateBo oldEffStartEndDateBo) {
        EffStartEndDateBo firstEffStartEndDateBo;
        Calendar calendar;
        HisVersionCalcResult hisVersionCalcResult;
        Date effStartDate = newEffStartEndDateBo.getEffectStartDate();
        Date effEndDate = newEffStartEndDateBo.getEffectEndDate();
        Date oldEffStartDate = oldEffStartEndDateBo.getEffectStartDate();
        Date oldEffEndDate = oldEffStartEndDateBo.getEffectEndDate();
        if (effStartDate.getTime() <= oldEffEndDate.getTime() && effEndDate.getTime() >= oldEffEndDate.getTime()) {
            hisVersionCalcResult = this.buildHisVersionCalcResult(oldEffStartEndDateBo.getId(), oldEffStartDate, oldEffEndDate, version);
            hisVersionCalcResultList.add(hisVersionCalcResult);
            calendar = Calendar.getInstance();
            calendar.setTime(effStartDate);
            calendar.add(5, -1);
            firstEffStartEndDateBo = new EffStartEndDateBo();
            firstEffStartEndDateBo.setEffectStartDate(oldEffStartDate);
            firstEffStartEndDateBo.setEffectEndDate(calendar.getTime());
            hisVersionCalcResult.setFirstEffStartEndDateBo(firstEffStartEndDateBo);
        }
        if (effEndDate.getTime() < oldEffEndDate.getTime()) {
            hisVersionCalcResult = this.buildHisVersionCalcResult(oldEffStartEndDateBo.getId(), oldEffStartDate, oldEffEndDate, version);
            hisVersionCalcResultList.add(hisVersionCalcResult);
            calendar = Calendar.getInstance();
            calendar.setTime(effStartDate);
            calendar.add(5, -1);
            firstEffStartEndDateBo = new EffStartEndDateBo();
            firstEffStartEndDateBo.setEffectStartDate(oldEffStartDate);
            firstEffStartEndDateBo.setEffectEndDate(calendar.getTime());
            hisVersionCalcResult.setFirstEffStartEndDateBo(firstEffStartEndDateBo);
            String newDataStatus = HisEffDateCommonService.getInstance().calcDataStatus(calendar.getTime(), oldEffEndDate);
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            EffStartEndDateBo secondEffStartEndDateBo = new EffStartEndDateBo();
            secondEffStartEndDateBo.setEffectStartDate(calendar.getTime());
            secondEffStartEndDateBo.setEffectEndDate(oldEffEndDate);
            hisVersionCalcResult.setSecondEffStartEndDateBo(secondEffStartEndDateBo);
            hisVersionCalcResult.setNewDataStatus(newDataStatus);
        }
    }

    private void processEqualsVersion(List<HisVersionCalcResult> hisVersionCalcResultList, String version, EffStartEndDateBo newEffStartEndDateBo, EffStartEndDateBo oldEffStartEndDateBo) {
        Date effEndDate = newEffStartEndDateBo.getEffectEndDate();
        Date oldEffStartDate = oldEffStartEndDateBo.getEffectStartDate();
        Date oldEffEndDate = oldEffStartEndDateBo.getEffectEndDate();
        if (effEndDate.getTime() >= oldEffEndDate.getTime()) {
            HisVersionCalcResult hisVersionCalcResult = this.buildHisVersionCalcResult(oldEffStartEndDateBo.getId(), oldEffStartDate, oldEffEndDate, version);
            hisVersionCalcResultList.add(hisVersionCalcResult);
            hisVersionCalcResult.setNewDataStatus(EnumHisDataVersionStatus.DELETED.getStatus());
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effEndDate);
            calendar.add(5, 1);
            HisVersionCalcResult hisVersionCalcResult = this.buildHisVersionCalcResult(oldEffStartEndDateBo.getId(), oldEffStartDate, oldEffEndDate, version);
            String newDataStatus = HisEffDateCommonService.getInstance().calcDataStatus(oldEffStartDate, calendar.getTime());
            hisVersionCalcResult.setNewDataStatus(newDataStatus);
            EffStartEndDateBo firstEffStartEndDateBo = new EffStartEndDateBo();
            firstEffStartEndDateBo.setEffectStartDate(calendar.getTime());
            firstEffStartEndDateBo.setEffectEndDate(oldEffEndDate);
            hisVersionCalcResult.setFirstEffStartEndDateBo(firstEffStartEndDateBo);
            hisVersionCalcResult.setFirstEffStartEndDateBo(firstEffStartEndDateBo);
            hisVersionCalcResultList.add(hisVersionCalcResult);
        }
    }

    private HisVersionCalcResult buildHisVersionCalcResult(Long id, Date oldEffStartDate, Date oldEffEndDate, String version) {
        HisVersionCalcResult hisVersionCalcResult = new HisVersionCalcResult();
        hisVersionCalcResult.setId(id);
        hisVersionCalcResult.setVersion(version);
        EffStartEndDateBo oldEffStartEndDateBo = new EffStartEndDateBo();
        oldEffStartEndDateBo.setEffectStartDate(oldEffStartDate);
        oldEffStartEndDateBo.setEffectEndDate(oldEffEndDate);
        hisVersionCalcResult.setOldEffStartEndDateBo(oldEffStartEndDateBo);
        return hisVersionCalcResult;
    }
}

