/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.discard;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisDiscardBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisNonLineTimeService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisDiscardService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;

@ExcludeFromJacocoGeneratedReport
public class HisNoTimeDiscardService
implements IHisDiscardService {
    private static volatile HisNoTimeDiscardService hisNoTimeDiscardService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisNoTimeDiscardService getInstance() {
        if (hisNoTimeDiscardService != null) return hisNoTimeDiscardService;
        Class<HisNoTimeDiscardService> clazz = HisNoTimeDiscardService.class;
        synchronized (HisNoTimeDiscardService.class) {
            if (hisNoTimeDiscardService != null) return hisNoTimeDiscardService;
            hisNoTimeDiscardService = new HisNoTimeDiscardService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisNoTimeDiscardService;
        }
    }

    @Override
    public void discardPersonalData(HisDiscardBo hisDiscardBo) {
        String entityNumber = hisDiscardBo.getEntityNumber();
        Set<Long> boIdSet = hisDiscardBo.getBoIdSet();
        QFilter idFilter = new QFilter("id", "in", boIdSet);
        DynamicObject[] curPersonalDys = HisCommonEntityRepository.loadDynamicObjectArray(entityNumber, idFilter);
        Arrays.stream(curPersonalDys).forEach(curPersonalDy -> curPersonalDy.set("datastatus", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus()));
        HisNonLineTimeService hisNonLineTimeService = new HisNonLineTimeService();
        HisTransBo hisTransBo = hisDiscardBo.getHisTransBo();
        if (hisTransBo == null) {
            hisTransBo = this.buildHisTransBo(hisTransBo, boIdSet, entityNumber);
        }
        Long eventId = hisTransBo.getEventId();
        HashMap<String, Object> originalEventMap = new HashMap<String, Object>(8);
        originalEventMap.put("eventId", eventId);
        hisNonLineTimeService.handlePersonalChangeData(curPersonalDys, originalEventMap);
    }

    private HisTransBo buildHisTransBo(HisTransBo hisTransBo, Set<Long> boIdSet, String entityNumber) {
        if (hisTransBo == null) {
            hisTransBo = new HisTransBo();
        }
        if (boIdSet.size() == 1) {
            hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_SINGLE.getValue());
        } else {
            hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
        }
        Long eventId = hisTransBo.getEventId();
        if (eventId == null || eventId == 0L) {
            eventId = ORM.create().genLongId(entityNumber);
            hisTransBo.setEventId(eventId);
        }
        return hisTransBo;
    }
}

