/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.discard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisDiscardBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransBusinessBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransVersionBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisModelEventService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisDiscardService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class HisTimeDiscardService
implements IHisDiscardService {
    private static volatile HisTimeDiscardService hisTimeDiscardService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisTimeDiscardService getInstance() {
        if (hisTimeDiscardService != null) return hisTimeDiscardService;
        Class<HisTimeDiscardService> clazz = HisTimeDiscardService.class;
        synchronized (HisTimeDiscardService.class) {
            if (hisTimeDiscardService != null) return hisTimeDiscardService;
            hisTimeDiscardService = new HisTimeDiscardService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisTimeDiscardService;
        }
    }

    @Override
    public void discardPersonalData(HisDiscardBo hisDiscardBo) {
        String entityNumber = hisDiscardBo.getEntityNumber();
        Set<Long> boIdSet = hisDiscardBo.getBoIdSet();
        HisTransBo hisTransBo = hisDiscardBo.getHisTransBo();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] dynamicObjects = HisCommonEntityRepository.loadOldEffDataByBoIds(serviceHelper, boIdSet);
        Map<Long, List<DynamicObject>> mapDynamicObject = HisCommonService.getInstance().groupByBoIdDyMap(dynamicObjects);
        if (CollectionUtils.isEmpty(mapDynamicObject)) {
            return;
        }
        hisTransBo = this.buildHisTransBo(hisTransBo, mapDynamicObject);
        ArrayList<HisTransBusinessBo> hisTransBusinessBoList = new ArrayList<HisTransBusinessBo>(10);
        hisTransBo.setListHisTransBusinessBo(hisTransBusinessBoList);
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds(entityNumber, mapDynamicObject.size());
        int step = 0;
        ArrayList<DynamicObject> allDy = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : mapDynamicObject.entrySet()) {
            Long boId = entry.getKey();
            List<DynamicObject> dynamicObjectList = entry.getValue();
            HisTransBusinessBo hisTransBusinessBo = new HisTransBusinessBo();
            hisTransBusinessBo.setBoId(boId);
            hisTransBusinessBo.setEntityNumber(entityNumber);
            ArrayList<HisTransVersionBo> hisTransVersionBoList = new ArrayList<HisTransVersionBo>(10);
            hisTransBusinessBo.setListHisTransVersionBo(hisTransVersionBoList);
            hisTransBusinessBoList.add(hisTransBusinessBo);
            long id = ids[step];
            ++step;
            DynamicObject dyNewVersion = this.processData(serviceHelper, dynamicObjectList, hisTransVersionBoList, id);
            allDy.addAll(dynamicObjectList);
            allDy.add(dyNewVersion);
        }
        serviceHelper.save(allDy.toArray(new DynamicObject[allDy.size()]));
        HisModelEventService hisModelEventService = new HisModelEventService();
        hisModelEventService.saveEvent(hisTransBo);
    }

    private DynamicObject processData(HRBaseServiceHelper serviceHelper, List<DynamicObject> dynamicObjectList, List<HisTransVersionBo> hisTransVersionBoList, long id) {
        DynamicObject dyNewVersion = serviceHelper.generateEmptyDynamicObject();
        for (DynamicObject dynamicObject : dynamicObjectList) {
            Boolean isCurrentVersion = dynamicObject.getBoolean("iscurrentversion");
            HisTransVersionBo hisTransVersionBo = new HisTransVersionBo();
            if (isCurrentVersion.booleanValue()) {
                dynamicObject.set("bsed", (Object)dynamicObject.getDate("firstbsed"));
                dynamicObject.set("bsled", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
                dynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.DISCARDED.getStatus());
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyNewVersion, this.getIgnoreKeys(), (boolean)true);
                dyNewVersion.set("id", (Object)id);
                DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dyNewVersion);
                hisTransVersionBo.setVersionId(id);
            } else {
                hisTransVersionBo.setBeforeStatus(dynamicObject.getString("datastatus"));
                dynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.DELETED.getStatus());
                hisTransVersionBo.setVersionId(dynamicObject.getLong("id"));
            }
            hisTransVersionBoList.add(hisTransVersionBo);
        }
        return dyNewVersion;
    }

    private Set<String> getIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("id");
        ignoreKeys.add("masterid");
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("createtime");
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        return ignoreKeys;
    }

    private HisTransBo buildHisTransBo(HisTransBo hisTransBo, Map<Long, List<DynamicObject>> mapBoIdGroupData) {
        if (hisTransBo == null) {
            hisTransBo = new HisTransBo();
        }
        Long eventId = hisTransBo.getEventId();
        if (mapBoIdGroupData.size() == 1 && (eventId == null || eventId == 0L)) {
            hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_SINGLE.getValue());
        } else {
            hisTransBo.setTransBatchType(EventOperateEnums.EVENT_PATCH_TYPE_ATOM.getValue());
        }
        return hisTransBo;
    }
}

