/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisInitBoApiParam;
import kd.hr.hbp.business.domain.model.newhismodel.init.HisInitValidateDataAndError;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.BoInitGroupKey;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.HisInitCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.SortingDyEffDateWithNoTipsService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HisInitBoValidateService {
    private static volatile HisInitBoValidateService service = null;

    private HisInitBoValidateService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisInitBoValidateService getInstance() {
        if (service != null) return service;
        Class<HisInitBoValidateService> clazz = HisInitBoValidateService.class;
        synchronized (HisInitBoValidateService.class) {
            if (service != null) return service;
            service = new HisInitBoValidateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    private String initBoBaseValidate(HisInitBoApiParam hisInitBoApiParam) {
        if (hisInitBoApiParam == null) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisInitBoValidateService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        LinkedHashSet<String> boGroupFields = hisInitBoApiParam.getBoGroupFields();
        if (CollectionUtils.isEmpty(boGroupFields)) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u201cBO\u5206\u7ec4\u5b57\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitBoValidateService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        DynamicObject[] dynamicObjects = hisInitBoApiParam.getDynamicObjects();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u201c\u52a8\u6001\u5bf9\u8c61\u6570\u7ec4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitBoValidateService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        for (String field : boGroupFields) {
            if (dynamicObjects[0].getDynamicObjectType().getProperties().containsKey((Object)field)) continue;
            return String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201cBO\u5206\u7ec4\u5b57\u6bb5\uff1a\u201d%s\uff0c\u5728\u8be5\u5143\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"HisInitBoValidateService_4", (String)"hrmp-hbp-business", (Object[])new Object[]{field}), new Object[0]);
        }
        return null;
    }

    public HisInitValidateDataAndError initBoValidate(HisInitBoApiParam hisInitBoApiParam) {
        String baseValidateResult = this.initBoBaseValidate(hisInitBoApiParam);
        if (baseValidateResult != null) {
            HisInitValidateDataAndError hisInitValidateDataAndError = new HisInitValidateDataAndError();
            hisInitValidateDataAndError.setBaseValidateResult(baseValidateResult);
            return hisInitValidateDataAndError;
        }
        LinkedHashSet<String> boGroupFields = hisInitBoApiParam.getBoGroupFields();
        DynamicObject[] dynamicObjects = hisInitBoApiParam.getDynamicObjects();
        boolean skipHisFieldValidate = hisInitBoApiParam.isSkipHisFieldValidate();
        boolean skipDbValidate = hisInitBoApiParam.isSkipDbValidate();
        boolean skipBusinessValidate = hisInitBoApiParam.isSkipBusinessValidate();
        return this.buildBoGroupDataAndValidate(dynamicObjects, boGroupFields, skipDbValidate, skipHisFieldValidate, skipBusinessValidate);
    }

    private HisInitValidateDataAndError buildBoGroupDataAndValidate(DynamicObject[] dynamicObjects, Set<String> boGroupFields, boolean skipDbValidate, boolean skipHisFieldValidate, boolean skipBusinessValidate) {
        HashMap mapGroupDyData = Maps.newHashMapWithExpectedSize((int)16);
        LinkedHashMap errorMessageListMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        IDataEntityType dataEntityTypes = dynamicObjects[0].getDataEntityType();
        String entityNumber = dataEntityTypes.getName();
        this.commonValidateAndBuildData(mapGroupDyData, errorMessageListMap, dynamicObjects, boGroupFields);
        if (!skipDbValidate) {
            this.validateUniqueInDb(errorMessageListMap, mapGroupDyData, boGroupFields, entityNumber);
        }
        this.validateBusinessRule(errorMessageListMap, mapGroupDyData, entityNumber, dataEntityTypes, skipHisFieldValidate, skipBusinessValidate);
        HisInitValidateDataAndError hisInitValidateDataAndError = new HisInitValidateDataAndError();
        if (!errorMessageListMap.isEmpty()) {
            hisInitValidateDataAndError.setErrorMessageListMap(errorMessageListMap);
        }
        hisInitValidateDataAndError.setData(mapGroupDyData);
        return hisInitValidateDataAndError;
    }

    private void commonValidateAndBuildData(Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, Map<Long, List<String>> errorMessageListMap, DynamicObject[] dynamicObjects, Set<String> boGroupFields) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject == null) continue;
            int step = 0;
            Object[] fieldValues = new Object[boGroupFields.size()];
            Long id = dynamicObject.getLong("id");
            if (!this.validateIdNull(id, errorMessageListMap)) continue;
            for (String fieldName : boGroupFields) {
                Object fieldValue = dynamicObject.get(fieldName);
                this.validateNullAndFieldType(id, fieldName, fieldValue, errorMessageListMap);
                fieldValues[step] = fieldValue;
                ++step;
            }
            BoInitGroupKey boInitGroupKey = new BoInitGroupKey(fieldValues);
            ArrayList groupList = mapGroupDyData.get(boInitGroupKey);
            if (groupList == null) {
                groupList = Lists.newArrayListWithExpectedSize((int)10);
                mapGroupDyData.put(boInitGroupKey, groupList);
            }
            groupList.add(dynamicObject);
        }
    }

    private boolean validateIdNull(Long id, Map<Long, List<String>> errorMessageListMap) {
        boolean validateResult = true;
        if (id == null || id == 0L) {
            String errorMessage = String.format(ResManager.loadKDString((String)"ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitBoValidateService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            ArrayList errorMessageList = errorMessageListMap.get(id);
            if (errorMessageList == null) {
                errorMessageList = Lists.newArrayListWithExpectedSize((int)10);
                errorMessageListMap.put(id, errorMessageList);
            }
            errorMessageList.add(errorMessage);
            validateResult = false;
        }
        return validateResult;
    }

    private boolean validateNullAndFieldType(Long id, String fieldName, Object fieldValue, Map<Long, List<String>> errorMessageListMap) {
        String errorMessage;
        boolean validateResult = true;
        if (id == null || id == 0L) {
            errorMessage = String.format(ResManager.loadKDString((String)"ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitBoValidateService_5", (String)"hrmp-hbp-business", (Object[])new Object[]{fieldName}), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            validateResult = false;
        }
        if (this.fieldValueIsNull(fieldValue)) {
            errorMessage = String.format(ResManager.loadKDString((String)"BO\u5206\u7ec4\u5b57\u6bb5\u201c%s\u201d\u7684\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisInitBoValidateService_6", (String)"hrmp-hbp-business", (Object[])new Object[]{fieldName}), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            validateResult = false;
        }
        if (fieldValue instanceof ILocaleString) {
            errorMessage = String.format(ResManager.loadKDString((String)"BO\u5206\u7ec4\u5b57\u6bb5\u4e0d\u652f\u6301\u591a\u8bed\u8a00\u5b57\u6bb5\u3002", (String)"HisInitBoValidateService_7", (String)"hrmp-hbp-business", (Object[])new Object[]{fieldName}), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            validateResult = false;
        }
        return validateResult;
    }

    private boolean fieldValueIsNull(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        return fieldValue instanceof String && StringUtils.isEmpty((String)((String)fieldValue));
    }

    private void validateUniqueInDb(Map<Long, List<String>> errorMessageListMap, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, Set<String> boGroupFields, String entityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (boGroupFields.size() == 1) {
            String filedName = boGroupFields.iterator().next();
            this.validateUniqueInDBSingle(boGroupFields, filedName, mapGroupDyData, serviceHelper, errorMessageListMap);
        } else {
            this.validateUniqueInDBMore(boGroupFields, mapGroupDyData, serviceHelper, errorMessageListMap);
        }
    }

    private void validateUniqueInDBSingle(Set<String> boGroupFields, String filedName, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, HRBaseServiceHelper serviceHelper, Map<Long, List<String>> errorMessageListMap) {
        Set<BoInitGroupKey> boInitGroupKeySet = mapGroupDyData.keySet();
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)10);
        for (BoInitGroupKey boInitGroupKey : boInitGroupKeySet) {
            Object[] objectFiledValues = boInitGroupKey.getFieldValues();
            if (objectFiledValues == null || objectFiledValues.length != 1) continue;
            Object objectFiledValue = objectFiledValues[0];
            valueList.add(objectFiledValue);
        }
        QFilter qFilter = new QFilter(filedName, "in", (Object)valueList);
        this.validateRepeatedInDB(boGroupFields, mapGroupDyData, serviceHelper, errorMessageListMap, new QFilter[]{qFilter}, filedName);
    }

    private void validateUniqueInDBMore(Set<String> boGroupFields, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, HRBaseServiceHelper serviceHelper, Map<Long, List<String>> errorMessageListMap) {
        QFilter[] qFilters = this.buildQFilter(boGroupFields, mapGroupDyData);
        String filedNames = String.join((CharSequence)",", boGroupFields);
        this.validateRepeatedInDB(boGroupFields, mapGroupDyData, serviceHelper, errorMessageListMap, qFilters, filedNames);
    }

    private void validateRepeatedInDB(Set<String> boGroupFields, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, HRBaseServiceHelper serviceHelper, Map<Long, List<String>> errorMessageListMap, QFilter[] qFilters, String filedNames) {
        DynamicObject[] dyFromDbs = serviceHelper.query(filedNames, qFilters);
        if (dyFromDbs == null || dyFromDbs.length == 0) {
            return;
        }
        HashSet repeatIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dyFromDb : dyFromDbs) {
            for (Map.Entry<BoInitGroupKey, List<DynamicObject>> entry : mapGroupDyData.entrySet()) {
                boolean isEqual;
                BoInitGroupKey boInitGroupKey = entry.getKey();
                Object[] objectFiledValues = boInitGroupKey.getFieldValues();
                if (objectFiledValues == null || !(isEqual = this.isEqual(boGroupFields, dyFromDb, objectFiledValues))) continue;
                List<DynamicObject> dynamicObjectList = entry.getValue();
                repeatIdSet.addAll(dynamicObjectList.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)repeatIdSet)) {
            for (Long id : repeatIdSet) {
                String errorMessage = String.format(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u5b58\u5728\u3002", (String)"HisInitBoValidateService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
    }

    private boolean isEqual(Set<String> boGroupFields, DynamicObject dyFromDb, Object[] objectFiledValues) {
        int index = 0;
        for (String filedName : boGroupFields) {
            Object valueFromDb = objectFiledValues[index];
            Object value = dyFromDb.get(filedName);
            if (!HisInitCommonService.getInstance().equalsValue(valueFromDb, value)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private void validateBusinessRule(Map<Long, List<String>> errorMessageListMap, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, String entityNumber, IDataEntityType dataEntityTypes, boolean skipHisFieldValidate, boolean skipBusinessValidate) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        for (Map.Entry<BoInitGroupKey, List<DynamicObject>> entry : mapGroupDyData.entrySet()) {
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
            if (!skipHisFieldValidate) {
                this.validateHisField(errorMessageListMap, dynamicObjectList);
            }
            if (skipBusinessValidate) continue;
            this.validateBusinessField(errorMessageListMap, dynamicObjectList, dataEntityTypes, isBaseDataCtrl);
        }
    }

    private void validateHisField(Map<Long, List<String>> errorMessageListMap, List<DynamicObject> dynamicObjectList) {
        boolean needValidateMore = this.validateEffDataNullAndRepeat(errorMessageListMap, dynamicObjectList);
        if (!needValidateMore) {
            return;
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
        SortingDyEffDateWithNoTipsService.getInstance().quickSort(dynamicObjectList.toArray(dynamicObjects));
        Date firstEffStartDate = dynamicObjects[0].getDate("bsed");
        Date today = HRDateTimeUtils.getSysTimeZoneToday();
        if (firstEffStartDate.getTime() > today.getTime()) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u6700\u65e9\u751f\u6548\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"HisInitBoValidateService_12", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            Long id = dynamicObjects[0].getLong("id");
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
        }
    }

    private void validateBusinessField(Map<Long, List<String>> errorMessageListMap, List<DynamicObject> dynamicObjectList, IDataEntityType dataEntityTypes, boolean isBaseDataCtrl) {
        Long id;
        String errorMessage;
        boolean hasCreateOrg = dataEntityTypes.getProperties().containsKey((Object)"createorg");
        boolean hasCtrlStrategy = dataEntityTypes.getProperties().containsKey((Object)"ctrlstrategy");
        boolean hasStatus = dataEntityTypes.getProperties().containsKey((Object)"status");
        boolean hasEnable = dataEntityTypes.getProperties().containsKey((Object)"enable");
        HashSet createOrgSet = Sets.newHashSetWithExpectedSize((int)dynamicObjectList.size());
        HashSet strategySet = Sets.newHashSetWithExpectedSize((int)dynamicObjectList.size());
        for (DynamicObject dynamicObject : dynamicObjectList) {
            String enable;
            String errorMessage2;
            String status;
            DynamicObject createOrg;
            Long id2 = dynamicObject.getLong("id");
            if (isBaseDataCtrl && hasCreateOrg && (createOrg = dynamicObject.getDynamicObject("createorg")) != null) {
                Long createOrgId = createOrg.getLong("id");
                createOrgSet.add(createOrgId);
            }
            if (isBaseDataCtrl && hasCtrlStrategy) {
                String ctrlStrategy = dynamicObject.getString("createorg");
                if (ctrlStrategy == null) {
                    ctrlStrategy = "";
                }
                strategySet.add(ctrlStrategy);
            }
            if (hasStatus && StringUtils.isNotEmpty((String)(status = dynamicObject.getString("status"))) && !"C".equals(status)) {
                errorMessage2 = String.format(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u53ea\u80fd\u586b\u5199\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"HisInitBoValidateService_13", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                this.buildErrorMessage(errorMessageListMap, id2, errorMessage2);
            }
            if (!hasEnable || !StringUtils.isNotEmpty((String)(enable = dynamicObject.getString("enable"))) || "1".equals(enable) || "disable".equals(enable)) continue;
            errorMessage2 = String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u53ea\u80fd\u586b\u5199\u201c\u542f\u7528\u201d\u6216\u201c\u7981\u7528\u201d\u3002", (String)"HisInitBoValidateService_14", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id2, errorMessage2);
        }
        if (createOrgSet.size() > 1) {
            errorMessage = String.format(ResManager.loadKDString((String)"\u540c\u4e00BO\u6240\u6709\u7248\u672c\u7684\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u5b57\u6bb5\u503c\u5fc5\u987b\u76f8\u540c\u3002", (String)"HisInitBoValidateService_15", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            for (DynamicObject dynamicObject : dynamicObjectList) {
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
        if (strategySet.size() > 1) {
            errorMessage = String.format(ResManager.loadKDString((String)"\u540c\u4e00BO\u6240\u6709\u7248\u672c\u7684\u201c\u63a7\u5236\u7b56\u7565\u201d\u5b57\u6bb5\u503c\u5fc5\u987b\u76f8\u540c\u3002", (String)"HisInitBoValidateService_16", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            for (DynamicObject dynamicObject : dynamicObjectList) {
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
    }

    private boolean validateEffDataNullAndRepeat(Map<Long, List<String>> errorMessageListMap, List<DynamicObject> dynamicObjectList) {
        HashSet effDateSet = Sets.newHashSetWithExpectedSize((int)16);
        boolean needValidateMore = true;
        for (DynamicObject dynamicObject : dynamicObjectList) {
            Date endDate;
            String errorMessage;
            Long id = dynamicObject.getLong("id");
            Date startDate = dynamicObject.getDate("bsed");
            if (startDate == null) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisInitBoValidateService_9", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
                needValidateMore = false;
            } else if (effDateSet.contains(startDate.getTime())) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"HisInitBoValidateService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
                needValidateMore = false;
            } else {
                effDateSet.add(startDate.getTime());
            }
            if ((endDate = dynamicObject.getDate("bsled")) == null) continue;
            String errorMessage2 = String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u586b\u5199\u5931\u6548\u65e5\u671f\u3002", (String)"HisInitBoValidateService_11", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage2);
            needValidateMore = false;
        }
        return needValidateMore;
    }

    private void buildErrorMessage(Map<Long, List<String>> errorMessageListMap, Long id, String errorMessage) {
        ArrayList errorMessageList = errorMessageListMap.get(id);
        if (errorMessageList == null) {
            errorMessageList = Lists.newArrayListWithExpectedSize((int)10);
            errorMessageListMap.put(id, errorMessageList);
        }
        errorMessageList.add(errorMessage);
    }

    private QFilter[] buildQFilter(Set<String> boGroupFields, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData) {
        Set<BoInitGroupKey> keys = mapGroupDyData.keySet();
        HashMap mapFiledNameAndValues = Maps.newHashMapWithExpectedSize((int)boGroupFields.size());
        for (BoInitGroupKey boInitGroupKey : keys) {
            Object[] fieldValues = boInitGroupKey.getFieldValues();
            if (fieldValues == null || boGroupFields.size() != fieldValues.length) continue;
            int i = 0;
            for (String filedName : boGroupFields) {
                List filedValueList = (List)mapFiledNameAndValues.get(filedName);
                if (filedValueList == null) {
                    filedValueList = Lists.newArrayListWithCapacity((int)mapGroupDyData.size());
                    mapFiledNameAndValues.put(filedName, filedValueList);
                }
                filedValueList.add(fieldValues[i]);
                ++i;
            }
        }
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)boGroupFields.size());
        for (Map.Entry entry : mapFiledNameAndValues.entrySet()) {
            QFilter qFilter = new QFilter((String)entry.getKey(), "in", entry.getValue());
            qFilterList.add(qFilter);
        }
        return qFilterList.toArray(new QFilter[qFilterList.size()]);
    }
}

