/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisInitVersionApiParam;
import kd.hr.hbp.business.domain.model.newhismodel.init.HisInitVersionValidateDataAndError;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.BoInitGroupKey;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.HisInitVersionValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.SortingDyEffDateWithNoTipsService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HisInitVersionSaveService {
    private static volatile HisInitVersionSaveService service = null;

    private HisInitVersionSaveService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisInitVersionSaveService getInstance() {
        if (service != null) return service;
        Class<HisInitVersionSaveService> clazz = HisInitVersionSaveService.class;
        synchronized (HisInitVersionSaveService.class) {
            if (service != null) return service;
            service = new HisInitVersionSaveService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public HisInitVersionValidateDataAndError initVersionSave(HisInitVersionApiParam hisInitVersionApiParam) {
        HisInitVersionValidateDataAndError hisInitVersionValidateDataAndError = HisInitVersionValidateService.getInstance().initVersionValidate(hisInitVersionApiParam);
        if (hisInitVersionValidateDataAndError == null || hisInitVersionValidateDataAndError.getBaseValidateResult() != null) {
            return hisInitVersionValidateDataAndError;
        }
        Map<BoInitGroupKey, List<DynamicObject>> boInitGroupKeyListMap = hisInitVersionValidateDataAndError.getData();
        Map<Long, List<String>> errorMessageListMap = hisInitVersionValidateDataAndError.getErrorMessageListMap();
        Map<BoInitGroupKey, DynamicObject> mapCurrentVersion = hisInitVersionValidateDataAndError.getMapCurrentVersion();
        DynamicObject[] dynamicObjects = mapCurrentVersion.values().toArray(new DynamicObject[0]);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return hisInitVersionValidateDataAndError;
        }
        IDataEntityType dataEntityTypes = dynamicObjects[0].getDataEntityType();
        String entityNumber = dataEntityTypes.getName();
        boolean hasInitStatusFiled = HisCommonService.getInstance().hasInitStatusFiled(dataEntityTypes, entityNumber);
        Map<BoInitGroupKey, List<DynamicObject>> correctBoGroupData = this.rebuildDataAndErrorMsg(errorMessageListMap, boInitGroupKeyListMap);
        if (MapUtils.isEmpty(correctBoGroupData)) {
            return hisInitVersionValidateDataAndError;
        }
        this.saveData(correctBoGroupData, mapCurrentVersion, entityNumber, hasInitStatusFiled);
        hisInitVersionValidateDataAndError.setCorrectBoGroupData(correctBoGroupData);
        return hisInitVersionValidateDataAndError;
    }

    public Map<BoInitGroupKey, List<DynamicObject>> rebuildDataAndErrorMsg(Map<Long, List<String>> errorMessageListMap, Map<BoInitGroupKey, List<DynamicObject>> boInitGroupKeyListMap) {
        if (MapUtils.isEmpty(errorMessageListMap) || MapUtils.isEmpty(boInitGroupKeyListMap)) {
            return boInitGroupKeyListMap;
        }
        Set<Long> errorIdSet = errorMessageListMap.keySet();
        LinkedHashMap realBoGroupData = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry<BoInitGroupKey, List<DynamicObject>> entry : boInitGroupKeyListMap.entrySet()) {
            Long id;
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList)) {
                boInitGroupKeyListMap.remove(entry.getKey());
            }
            boolean boHasErrorRow = false;
            for (DynamicObject dynamicObject : dynamicObjectList) {
                id = dynamicObject.getLong("id");
                if (id != null && id != 0L && !errorIdSet.contains(id)) continue;
                boHasErrorRow = true;
                break;
            }
            if (boHasErrorRow) {
                for (DynamicObject dynamicObject : dynamicObjectList) {
                    ArrayList errorMsgList;
                    id = dynamicObject.getLong("id");
                    if (id == null || id == 0L || !CollectionUtils.isEmpty(errorMsgList = errorMessageListMap.get(id))) continue;
                    errorMsgList = Lists.newArrayListWithExpectedSize((int)dynamicObjectList.size());
                    errorMessageListMap.put(id, errorMsgList);
                    String errorMessage = String.format(ResManager.loadKDString((String)"\u672c\u5206\u7ec4\u5185\u6709\u5176\u4ed6\u7248\u672c\u6570\u636e\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"HisInitBoService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                    errorMsgList.add(errorMessage);
                }
                continue;
            }
            realBoGroupData.put(entry.getKey(), dynamicObjectList);
        }
        return realBoGroupData;
    }

    private void saveData(Map<BoInitGroupKey, List<DynamicObject>> correctBoGroupData, Map<BoInitGroupKey, DynamicObject> mapCurrentVersion, String entityNumber, boolean hasInitStatusFiled) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (MapUtils.isEmpty(mapCurrentVersion) || MapUtils.isEmpty(correctBoGroupData)) {
            return;
        }
        ArrayList allData = Lists.newArrayListWithExpectedSize((int)10);
        HashMap mapBoIdGroupData = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<BoInitGroupKey, DynamicObject> entry : mapCurrentVersion.entrySet()) {
            BoInitGroupKey boInitGroupKey = entry.getKey();
            DynamicObject dyCurrent = entry.getValue();
            List<DynamicObject> dynamicObjectList = correctBoGroupData.get(boInitGroupKey);
            if (dyCurrent == null || CollectionUtils.isEmpty(dynamicObjectList)) continue;
            Object[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
            SortingDyEffDateWithNoTipsService.getInstance().quickSort(dynamicObjects);
            Long boId = dyCurrent.getLong("boid");
            for (Object dynamicObject : dynamicObjects) {
                Date startDate = dynamicObject.getDate("bsed");
                Date endDate = dynamicObject.getDate("bsled");
                String dataStatus = HisEffDateCommonService.getInstance().calcDataStatus(startDate, endDate);
                this.setVersion((DynamicObject)dynamicObject, boId, dataStatus, hasInitStatusFiled);
            }
            mapBoIdGroupData.put(boId, dynamicObjectList);
            allData.addAll(dynamicObjectList);
        }
        if (MapUtils.isEmpty((Map)mapBoIdGroupData)) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)allData)) {
            serviceHelper.save(allData.toArray(new DynamicObject[allData.size()]));
        }
    }

    private void setVersion(DynamicObject dynamicObject, Long boId, String dataStatus, boolean hasInitStatusFiled) {
        dynamicObject.set("datastatus", (Object)dataStatus);
        dynamicObject.set("iscurrentversion", (Object)false);
        dynamicObject.set("boid", (Object)boId);
        DynamicObjectCommonService.getInstance().setMastId(dynamicObject);
        DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dynamicObject);
        if (hasInitStatusFiled) {
            dynamicObject.set("initstatus", (Object)"0");
        }
    }

    private Set<Long> buildBoIdSet(Map<BoInitGroupKey, DynamicObject> mapCurrentVersion) {
        HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)mapCurrentVersion.size());
        for (Map.Entry<BoInitGroupKey, DynamicObject> entry : mapCurrentVersion.entrySet()) {
            DynamicObject dyCurrent = entry.getValue();
            Long boId = dyCurrent.getLong("boid");
            boIdSet.add(boId);
        }
        return boIdSet;
    }
}

