/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.domain.model.newhismodel.calc.api.HisInitVersionApiParam;
import kd.hr.hbp.business.domain.model.newhismodel.init.HisInitVersionValidateDataAndError;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.BoInitGroupKey;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.HisInitCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.init.SortingDyEffDateWithNoTipsService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import org.apache.commons.collections.MapUtils;

public class HisInitVersionValidateService {
    private static volatile HisInitVersionValidateService service = null;

    private HisInitVersionValidateService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisInitVersionValidateService getInstance() {
        if (service != null) return service;
        Class<HisInitVersionValidateService> clazz = HisInitVersionValidateService.class;
        synchronized (HisInitVersionValidateService.class) {
            if (service != null) return service;
            service = new HisInitVersionValidateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public HisInitVersionValidateDataAndError initVersionValidate(HisInitVersionApiParam hisInitVersionApiParam) {
        String baseValidateResult = this.initBaseValidate(hisInitVersionApiParam);
        if (baseValidateResult != null) {
            HisInitVersionValidateDataAndError hisInitVersionValidateDataAndError = new HisInitVersionValidateDataAndError();
            hisInitVersionValidateDataAndError.setBaseValidateResult(baseValidateResult);
            return hisInitVersionValidateDataAndError;
        }
        LinkedHashSet<String> boGroupFields = hisInitVersionApiParam.getBoGroupFields();
        DynamicObject[] dynamicObjects = hisInitVersionApiParam.getDynamicObjects();
        boolean skipHisFieldValidate = hisInitVersionApiParam.isSkipHisFieldValidate();
        boolean skipBusinessValidate = hisInitVersionApiParam.isSkipBusinessValidate();
        return this.buildBoGroupDataAndValidate(dynamicObjects, boGroupFields, skipHisFieldValidate, skipBusinessValidate, hisInitVersionApiParam.isEffImmediately());
    }

    private String initBaseValidate(HisInitVersionApiParam hisInitVersionApiParam) {
        if (hisInitVersionApiParam == null) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        LinkedHashSet<String> boGroupFields = hisInitVersionApiParam.getBoGroupFields();
        if (CollectionUtils.isEmpty(boGroupFields)) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u201cBO\u5206\u7ec4\u5b57\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        DynamicObject[] dynamicObjects = hisInitVersionApiParam.getDynamicObjects();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u201c\u52a8\u6001\u5bf9\u8c61\u6570\u7ec4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        }
        for (String field : boGroupFields) {
            if (dynamicObjects[0].getDynamicObjectType().getProperties().containsKey((Object)field)) continue;
            return String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201cBO\u5206\u7ec4\u5b57\u6bb5\uff1a\u201d%s\uff0c\u5728\u8be5\u5143\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"HisInitVersionValidateService_4", (String)"hrmp-hbp-business", (Object[])new Object[]{field}), new Object[0]);
        }
        return null;
    }

    private HisInitVersionValidateDataAndError buildBoGroupDataAndValidate(DynamicObject[] dynamicObjects, Set<String> boGroupFields, boolean skipHisFieldValidate, boolean skipBusinessValidate, boolean effImmediately) {
        HashMap mapGroupDyData = Maps.newHashMapWithExpectedSize((int)16);
        LinkedHashMap errorMessageListMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        IDataEntityType dataEntityTypes = dynamicObjects[0].getDataEntityType();
        String entityNumber = dataEntityTypes.getName();
        boolean hasInitStatusFiled = HisCommonService.getInstance().hasInitStatusFiled(dataEntityTypes, entityNumber);
        this.commonValidateAndBuildData(mapGroupDyData, errorMessageListMap, dynamicObjects, boGroupFields);
        Map<BoInitGroupKey, DynamicObject> mapCurrentVersion = this.validateExistBoInDb(errorMessageListMap, mapGroupDyData, boGroupFields, entityNumber, hasInitStatusFiled, effImmediately);
        this.validateBusinessRule(errorMessageListMap, mapGroupDyData, entityNumber, dataEntityTypes, mapCurrentVersion, skipHisFieldValidate, skipBusinessValidate);
        HisInitVersionValidateDataAndError hisInitVersionValidateDataAndError = new HisInitVersionValidateDataAndError();
        if (!errorMessageListMap.isEmpty()) {
            hisInitVersionValidateDataAndError.setErrorMessageListMap(errorMessageListMap);
        }
        hisInitVersionValidateDataAndError.setData(mapGroupDyData);
        hisInitVersionValidateDataAndError.setMapCurrentVersion(mapCurrentVersion);
        return hisInitVersionValidateDataAndError;
    }

    private void commonValidateAndBuildData(Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, Map<Long, List<String>> errorMessageListMap, DynamicObject[] dynamicObjects, Set<String> boGroupFields) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject == null) continue;
            int step = 0;
            Object[] fieldValues = new Object[boGroupFields.size()];
            Long id = dynamicObject.getLong("id");
            if (!this.validateIdNull(id, errorMessageListMap)) continue;
            for (String fieldName : boGroupFields) {
                Object fieldValue = dynamicObject.get(fieldName);
                this.validateNullAndFieldType(id, fieldName, fieldValue, errorMessageListMap);
                fieldValues[step] = fieldValue;
                ++step;
            }
            BoInitGroupKey boInitGroupKey = new BoInitGroupKey(fieldValues);
            ArrayList groupList = mapGroupDyData.get(boInitGroupKey);
            if (groupList == null) {
                groupList = Lists.newArrayListWithExpectedSize((int)10);
                mapGroupDyData.put(boInitGroupKey, groupList);
            }
            groupList.add(dynamicObject);
        }
    }

    private boolean validateIdNull(Long id, Map<Long, List<String>> errorMessageListMap) {
        boolean validateResult = true;
        if (id == null || id == 0L) {
            String errorMessage = String.format(ResManager.loadKDString((String)"ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            ArrayList errorMessageList = errorMessageListMap.get(id);
            if (errorMessageList == null) {
                errorMessageList = Lists.newArrayListWithExpectedSize((int)10);
                errorMessageListMap.put(id, errorMessageList);
            }
            errorMessageList.add(errorMessage);
            validateResult = false;
        }
        return validateResult;
    }

    private boolean validateNullAndFieldType(Long id, String fieldName, Object fieldValue, Map<Long, List<String>> errorMessageListMap) {
        String errorMessage;
        boolean validateResult = true;
        if (id == null || id == 0L) {
            errorMessage = String.format(ResManager.loadKDString((String)"ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_5", (String)"hrmp-hbp-business", (Object[])new Object[]{fieldName}), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            validateResult = false;
        }
        if (this.fieldValueIsNull(fieldValue)) {
            errorMessage = String.format(ResManager.loadKDString((String)"BO\u5206\u7ec4\u5b57\u6bb5\u201c%s\u201d\u7684\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_6", (String)"hrmp-hbp-business", (Object[])new Object[]{fieldName}), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            validateResult = false;
        }
        if (fieldValue instanceof ILocaleString) {
            errorMessage = String.format(ResManager.loadKDString((String)"BO\u5206\u7ec4\u5b57\u6bb5\u4e0d\u652f\u6301\u591a\u8bed\u8a00\u5b57\u6bb5\u3002", (String)"HisInitVersionValidateService_7", (String)"hrmp-hbp-business", (Object[])new Object[]{fieldName}), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            validateResult = false;
        }
        return validateResult;
    }

    private void buildErrorMessage(Map<Long, List<String>> errorMessageListMap, Long id, String errorMessage) {
        ArrayList errorMessageList = errorMessageListMap.get(id);
        if (errorMessageList == null) {
            errorMessageList = Lists.newArrayListWithExpectedSize((int)10);
            errorMessageListMap.put(id, errorMessageList);
        }
        errorMessageList.add(errorMessage);
    }

    private boolean fieldValueIsNull(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        return fieldValue instanceof String && StringUtils.isEmpty((String)((String)fieldValue));
    }

    private Map<BoInitGroupKey, DynamicObject> validateExistBoInDb(Map<Long, List<String>> errorMessageListMap, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, Set<String> boGroupFields, String entityNumber, boolean hasInitStatusFiled, boolean effImmediately) {
        if (MapUtils.isEmpty(mapGroupDyData)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (boGroupFields.size() == 1) {
            String filedName = boGroupFields.iterator().next();
            return this.validateExistBoInDbSingle(boGroupFields, filedName, mapGroupDyData, serviceHelper, errorMessageListMap, hasInitStatusFiled, effImmediately);
        }
        return this.validateExistBoInDbMore(boGroupFields, mapGroupDyData, serviceHelper, errorMessageListMap, hasInitStatusFiled, effImmediately);
    }

    private Map<BoInitGroupKey, DynamicObject> validateExistBoInDbSingle(Set<String> boGroupFields, String filedName, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, HRBaseServiceHelper serviceHelper, Map<Long, List<String>> errorMessageListMap, boolean hasInitStatusFiled, boolean effImmediately) {
        Set<BoInitGroupKey> boInitGroupKeySet = mapGroupDyData.keySet();
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)10);
        for (BoInitGroupKey boInitGroupKey : boInitGroupKeySet) {
            Object[] objectFiledValues = boInitGroupKey.getFieldValues();
            if (objectFiledValues == null || objectFiledValues.length != 1) continue;
            Object objectFiledValue = objectFiledValues[0];
            valueList.add(objectFiledValue);
        }
        QFilter qFilter = new QFilter(filedName, "in", (Object)valueList);
        QFilter qFilterCurrent = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        return this.validateExistBoInDb(boGroupFields, mapGroupDyData, serviceHelper, errorMessageListMap, new QFilter[]{qFilter, qFilterCurrent, statusFilter}, hasInitStatusFiled, effImmediately);
    }

    private Map<BoInitGroupKey, DynamicObject> validateExistBoInDbMore(Set<String> boGroupFields, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, HRBaseServiceHelper serviceHelper, Map<Long, List<String>> errorMessageListMap, boolean hasInitStatusFiled, boolean effImmediately) {
        QFilter[] qFilters = this.buildQFilter(boGroupFields, mapGroupDyData);
        return this.validateExistBoInDb(boGroupFields, mapGroupDyData, serviceHelper, errorMessageListMap, qFilters, hasInitStatusFiled, effImmediately);
    }

    private QFilter[] buildQFilter(Set<String> boGroupFields, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData) {
        Set<BoInitGroupKey> keys = mapGroupDyData.keySet();
        HashMap mapFiledNameAndValues = Maps.newHashMapWithExpectedSize((int)boGroupFields.size());
        for (BoInitGroupKey boInitGroupKey : keys) {
            Object[] objectArray = boInitGroupKey.getFieldValues();
            if (objectArray == null || boGroupFields.size() != objectArray.length) continue;
            int index = 0;
            for (String filedName : boGroupFields) {
                List filedValueList = (List)mapFiledNameAndValues.get(filedName);
                if (filedValueList == null) {
                    filedValueList = Lists.newArrayListWithCapacity((int)mapGroupDyData.size());
                    mapFiledNameAndValues.put(filedName, filedValueList);
                }
                filedValueList.add(objectArray[index]);
                ++index;
            }
        }
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)boGroupFields.size());
        for (Map.Entry entry : mapFiledNameAndValues.entrySet()) {
            QFilter qFilter = new QFilter((String)entry.getKey(), "in", entry.getValue());
            qFilterList.add(qFilter);
        }
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        qFilterList.add(qFilter);
        QFilter qFilter2 = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        qFilterList.add(qFilter2);
        return qFilterList.toArray(new QFilter[qFilterList.size()]);
    }

    private Map<BoInitGroupKey, DynamicObject> validateExistBoInDb(Set<String> boGroupFields, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, HRBaseServiceHelper serviceHelper, Map<Long, List<String>> errorMessageListMap, QFilter[] qFilters, boolean hasInitStatusFiled, boolean effImmediately) {
        HashMap mapCurrentVersion = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] dyFromDbs = serviceHelper.loadDynamicObjectArray(qFilters);
        if (dyFromDbs == null || dyFromDbs.length == 0) {
            return null;
        }
        for (Map.Entry<BoInitGroupKey, List<DynamicObject>> entry : mapGroupDyData.entrySet()) {
            BoInitGroupKey boInitGroupKey = entry.getKey();
            List<DynamicObject> dynamicObjectList = entry.getValue();
            Object[] objectFiledValues = boInitGroupKey.getFieldValues();
            if (objectFiledValues == null) continue;
            boolean isEqual = false;
            DynamicObject matchedDyCurrent = null;
            for (DynamicObject dyFromDb : dyFromDbs) {
                if (dyFromDb == null) continue;
                int i = 0;
                for (String filedName : boGroupFields) {
                    Object valueFromDb = objectFiledValues[i];
                    Object value = dyFromDb.get(filedName);
                    isEqual = HisInitCommonService.getInstance().equalsValue(valueFromDb, value);
                    if (!isEqual) break;
                    ++i;
                }
                if (!isEqual) continue;
                matchedDyCurrent = dyFromDb;
                break;
            }
            if (matchedDyCurrent != null) {
                if (hasInitStatusFiled) {
                    String initstatus = matchedDyCurrent.getString("initstatus");
                    if (effImmediately) {
                        mapCurrentVersion.put(boInitGroupKey, matchedDyCurrent);
                        continue;
                    }
                    if (!"2".equals(initstatus) && StringUtils.isNotEmpty((String)initstatus)) {
                        this.buildBoInitNoCompletedError(dynamicObjectList, errorMessageListMap);
                        continue;
                    }
                    mapCurrentVersion.put(boInitGroupKey, matchedDyCurrent);
                    continue;
                }
                mapCurrentVersion.put(boInitGroupKey, matchedDyCurrent);
                continue;
            }
            this.buildUnMatchedBoError(dynamicObjectList, errorMessageListMap);
        }
        if (hasInitStatusFiled && !effImmediately) {
            this.validateVersionInitNoCompleted(mapGroupDyData, mapCurrentVersion, errorMessageListMap, serviceHelper);
        }
        return mapCurrentVersion;
    }

    private void validateVersionInitNoCompleted(Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, Map<BoInitGroupKey, DynamicObject> mapCurrentVersion, Map<Long, List<String>> errorMessageListMap, HRBaseServiceHelper serviceHelper) {
        QFilter qFilterIsCurrent;
        QFilter qFilterInitStatus;
        if (MapUtils.isEmpty(mapCurrentVersion) || MapUtils.isEmpty(mapGroupDyData)) {
            return;
        }
        DynamicObject[] dyCurrents = mapCurrentVersion.values().toArray(new DynamicObject[mapCurrentVersion.size()]);
        if (dyCurrents == null || dyCurrents.length == 0) {
            return;
        }
        Set currentIdSet = Arrays.stream(dyCurrents).map(x -> x.getLong("id")).collect(Collectors.toSet());
        QFilter qFilterBoId = new QFilter("boid", "in", currentIdSet);
        DynamicObject[] dyFromDbs = serviceHelper.query("id,boid", new QFilter[]{qFilterBoId, qFilterInitStatus = new QFilter("initstatus", "in", (Object)new String[]{"0", "1"}), qFilterIsCurrent = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'))});
        if (dyFromDbs == null || dyFromDbs.length == 0) {
            return;
        }
        Set versionInitNoCompletedSet = Arrays.stream(dyFromDbs).map(x -> x.getLong("boid")).collect(Collectors.toSet());
        if (versionInitNoCompletedSet == null || versionInitNoCompletedSet.size() == 0) {
            return;
        }
        for (Map.Entry<BoInitGroupKey, DynamicObject> entry : mapCurrentVersion.entrySet()) {
            List<DynamicObject> dynamicObjectList;
            Long boId;
            DynamicObject dyCurrent = entry.getValue();
            if (dyCurrent == null || (boId = Long.valueOf(dyCurrent.getLong("boid"))) == null || boId == 0L || !versionInitNoCompletedSet.contains(boId) || !CollectionUtils.isNotEmpty(dynamicObjectList = mapGroupDyData.get(entry.getKey()))) continue;
            this.buildVersionInitNoCompletedError(dynamicObjectList, errorMessageListMap);
        }
    }

    private void buildVersionInitNoCompletedError(List<DynamicObject> dynamicObjectList, Map<Long, List<String>> errorMessageListMap) {
        String errorMessage = String.format(ResManager.loadKDString((String)"\u5339\u914d\u7684BO\u6570\u636e\u5305\u542b\u521d\u59cb\u5316\u672a\u5b8c\u6210\u7684\u6570\u636e\u7248\u672c\u3002", (String)"HisInitVersionValidateService_21", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            this.buildErrorMessage(errorMessageListMap, dynamicObject.getLong("id"), errorMessage);
        }
    }

    private void buildUnMatchedBoError(List<DynamicObject> dynamicObjectList, Map<Long, List<String>> errorMessageListMap) {
        String errorMessage = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230BO\u6570\u636e\u3002", (String)"HisInitVersionValidateService_8", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            this.buildErrorMessage(errorMessageListMap, dynamicObject.getLong("id"), errorMessage);
        }
    }

    private void buildBoInitNoCompletedError(List<DynamicObject> dynamicObjectList, Map<Long, List<String>> errorMessageListMap) {
        String errorMessage = String.format(ResManager.loadKDString((String)"\u5339\u914d\u7684BO\u6570\u636e\u4e3a\u521d\u59cb\u5316\u672a\u5b8c\u6210\u7684\u6570\u636e\u3002", (String)"HisInitVersionValidateService_20", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            this.buildErrorMessage(errorMessageListMap, dynamicObject.getLong("id"), errorMessage);
        }
    }

    private void validateBusinessRule(Map<Long, List<String>> errorMessageListMap, Map<BoInitGroupKey, List<DynamicObject>> mapGroupDyData, String entityNumber, IDataEntityType dataEntityTypes, Map<BoInitGroupKey, DynamicObject> mapCurrentVersion, boolean skipHisFieldValidate, boolean skipBusinessValidate) {
        if (MapUtils.isEmpty(mapCurrentVersion)) {
            return;
        }
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        for (Map.Entry<BoInitGroupKey, List<DynamicObject>> entry : mapGroupDyData.entrySet()) {
            BoInitGroupKey boInitGroupKey = entry.getKey();
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
            if (!skipHisFieldValidate) {
                this.validateHisField(errorMessageListMap, dynamicObjectList, boInitGroupKey, mapCurrentVersion);
            }
            if (skipBusinessValidate) continue;
            this.validateBusinessField(errorMessageListMap, dynamicObjectList, dataEntityTypes, isBaseDataCtrl);
        }
    }

    private void validateHisField(Map<Long, List<String>> errorMessageListMap, List<DynamicObject> dynamicObjectList, BoInitGroupKey boInitGroupKey, Map<BoInitGroupKey, DynamicObject> mapCurrentVersion) {
        boolean needValidateMore = this.validateEffDataNullAndRepeat(errorMessageListMap, dynamicObjectList);
        if (!needValidateMore) {
            return;
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
        if (dynamicObjects == null) {
            return;
        }
        DynamicObject dyCurrent = mapCurrentVersion.get(boInitGroupKey);
        if (dyCurrent != null) {
            this.validateEffDate(dynamicObjects, dyCurrent, errorMessageListMap);
        }
    }

    private void validateEffDate(DynamicObject[] dynamicObjects, DynamicObject dyCurrent, Map<Long, List<String>> errorMessageListMap) {
        Long id;
        String errorMessage;
        SortingDyEffDateWithNoTipsService.getInstance().quickSort(dynamicObjects);
        Date firstEffDate = dyCurrent.getDate("firstbsed");
        boolean isDisConnect = false;
        boolean isIntersect = false;
        Date nextStartDate = null;
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            Date startDate = dynamicObject.getDate("bsed");
            Date endDate = dynamicObject.getDate("bsled");
            if (startDate == null || endDate == null) continue;
            if (endDate.getTime() < startDate.getTime()) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"HisInitVersionValidateService_9", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
            if (startDate.getTime() >= firstEffDate.getTime()) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6570\u636e\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff1a%1$s\u3002", (String)"HisInitVersionValidateService_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), HRDateTimeUtils.formatUserSettingFromDate((Date)firstEffDate));
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
            if (nextStartDate != null) {
                if (nextStartDate.getTime() > startDate.getTime() && !isIntersect) {
                    isIntersect = true;
                } else if (nextStartDate.getTime() < startDate.getTime() && !isDisConnect) {
                    isDisConnect = true;
                }
            }
            if (i == dynamicObjects.length) {
                Date lastEndDate = HRDateTimeUtils.addDays((int)1, (Date)endDate);
                if (lastEndDate.getTime() > firstEffDate.getTime()) {
                    isIntersect = true;
                } else if (lastEndDate.getTime() < firstEffDate.getTime()) {
                    isDisConnect = true;
                }
            }
            nextStartDate = HRDateTimeUtils.addDays((int)1, (Date)endDate);
        }
        if (isDisConnect) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u5404\u7248\u672c\u751f\u5931\u6548\u65e5\u671f\u5b58\u5728\u65ad\u70b9\u3002", (String)"HisInitVersionValidateService_11", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
        if (isIntersect) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u5404\u7248\u672c\u751f\u5931\u6548\u65e5\u671f\u5b58\u5728\u4ea4\u96c6\u3002", (String)"HisInitVersionValidateService_12", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
    }

    private boolean validateEffDataNullAndRepeat(Map<Long, List<String>> errorMessageListMap, List<DynamicObject> dynamicObjectList) {
        Long id;
        HashSet effDateSet = Sets.newHashSetWithExpectedSize((int)16);
        boolean needValidateMore = true;
        boolean isEffStartDateEqual = false;
        for (DynamicObject dynamicObject : dynamicObjectList) {
            Date endDate;
            id = dynamicObject.getLong("id");
            Date startDate = dynamicObject.getDate("bsed");
            if (startDate == null) {
                String errorMessage = String.format(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_13", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
                needValidateMore = false;
            } else if (effDateSet.contains(startDate.getTime())) {
                isEffStartDateEqual = true;
                needValidateMore = false;
            } else {
                effDateSet.add(startDate.getTime());
            }
            if ((endDate = dynamicObject.getDate("bsled")) != null) continue;
            String errorMessage = String.format(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HisInitVersionValidateService_15", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            needValidateMore = false;
        }
        if (isEffStartDateEqual) {
            for (DynamicObject dynamicObject : dynamicObjectList) {
                id = dynamicObject.getLong("id");
                String errorMessage = String.format(ResManager.loadKDString((String)"\u5404\u7248\u672c\u751f\u5931\u6548\u65e5\u671f\u5b58\u5728\u4ea4\u96c6\u3002", (String)"HisInitVersionValidateService_12", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
        return needValidateMore;
    }

    private void validateBusinessField(Map<Long, List<String>> errorMessageListMap, List<DynamicObject> dynamicObjects, IDataEntityType dataEntityTypes, boolean isBaseDataCtrl) {
        Long id;
        String errorMessage;
        boolean hasCreateOrg = dataEntityTypes.getProperties().containsKey((Object)"createorg");
        boolean hasCtrlStrategy = dataEntityTypes.getProperties().containsKey((Object)"ctrlstrategy");
        boolean hasStatus = dataEntityTypes.getProperties().containsKey((Object)"status");
        boolean hasEnable = dataEntityTypes.getProperties().containsKey((Object)"enable");
        HashSet createOrgSet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.size());
        HashSet strategySet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            String enable;
            String errorMessage2;
            String status;
            DynamicObject createOrg;
            Long id2 = dynamicObject.getLong("id");
            if (isBaseDataCtrl && hasCreateOrg && (createOrg = dynamicObject.getDynamicObject("createorg")) != null) {
                Long createOrgId = createOrg.getLong("id");
                createOrgSet.add(createOrgId);
            }
            if (isBaseDataCtrl && hasCtrlStrategy) {
                String ctrlStrategy = dynamicObject.getString("createorg");
                if (ctrlStrategy == null) {
                    ctrlStrategy = "";
                }
                strategySet.add(ctrlStrategy);
            }
            if (hasStatus && StringUtils.isNotEmpty((String)(status = dynamicObject.getString("status"))) && !"C".equals(status)) {
                errorMessage2 = String.format(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u53ea\u80fd\u586b\u5199\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"HisInitVersionValidateService_16", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
                this.buildErrorMessage(errorMessageListMap, id2, errorMessage2);
            }
            if (!hasEnable || !StringUtils.isNotEmpty((String)(enable = dynamicObject.getString("enable"))) || "1".equals(enable) || "disable".equals(enable)) continue;
            errorMessage2 = String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u53ea\u80fd\u586b\u5199\u201c\u542f\u7528\u201d\u6216\u201c\u7981\u7528\u201d\u3002", (String)"HisInitVersionValidateService_17", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            this.buildErrorMessage(errorMessageListMap, id2, errorMessage2);
        }
        if (createOrgSet.size() > 1) {
            errorMessage = String.format(ResManager.loadKDString((String)"\u540c\u4e00BO\u6240\u6709\u7248\u672c\u7684\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u5b57\u6bb5\u503c\u5fc5\u987b\u76f8\u540c\u3002", (String)"HisInitVersionValidateService_18", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            for (DynamicObject dynamicObject : dynamicObjects) {
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
        if (strategySet.size() > 1) {
            errorMessage = String.format(ResManager.loadKDString((String)"\u540c\u4e00BO\u6240\u6709\u7248\u672c\u7684\u201c\u63a7\u5236\u7b56\u7565\u201d\u5b57\u6bb5\u503c\u5fc5\u987b\u76f8\u540c\u3002", (String)"HisInitVersionValidateService_19", (String)"hrmp-hbp-business", (Object[])new Object[0]), new Object[0]);
            for (DynamicObject dynamicObject : dynamicObjects) {
                id = dynamicObject.getLong("id");
                this.buildErrorMessage(errorMessageListMap, id, errorMessage);
            }
        }
    }
}

