/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.personal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HisPersonalCommonService {
    private static volatile HisPersonalCommonService hisPersonalCommonService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisPersonalCommonService getInstance() {
        if (hisPersonalCommonService != null) return hisPersonalCommonService;
        Class<HisPersonalCommonService> clazz = HisPersonalCommonService.class;
        synchronized (HisPersonalCommonService.class) {
            if (hisPersonalCommonService != null) return hisPersonalCommonService;
            hisPersonalCommonService = new HisPersonalCommonService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisPersonalCommonService;
        }
    }

    public Long getMasterCurrentDyOrgId(String entityNumber, Long masterId) {
        DynamicObject originalData = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)entityNumber);
        if (originalData != null && originalData.getDynamicObject("createOrg") != null) {
            DynamicObject org = originalData.getDynamicObject("createOrg");
            return org.getLong("id");
        }
        return 0L;
    }

    public Set<String> getValidFieldSet(DataEntityPropertyCollection dataEntityProperties, Map<String, Boolean> mapUpdate) {
        HashSet<String> validField = new HashSet<String>(16);
        for (int i = 0; i < dataEntityProperties.size(); ++i) {
            Boolean isUpdate;
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dataEntityProperties.get(i);
            String fieldName = dataEntityProperty.getName();
            if (HRStringUtils.isEmpty((String)fieldName) || (isUpdate = mapUpdate.get(fieldName)) == null || Boolean.TRUE.equals(isUpdate)) continue;
            validField.add(fieldName);
        }
        return validField;
    }

    public Set<String> getValidFieldSetNew(DataEntityPropertyCollection dataEntityProperties, Map<String, Boolean> mapUpdate, Map<String, Boolean> mapShare) {
        HashSet<String> validField = new HashSet<String>(16);
        for (int i = 0; i < dataEntityProperties.size(); ++i) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dataEntityProperties.get(i);
            String fieldName = dataEntityProperty.getName();
            if (HRStringUtils.isEmpty((String)fieldName)) continue;
            Boolean isShare = mapShare.get(fieldName);
            Boolean isUpdate = mapUpdate.get(fieldName);
            if (isShare == null || !Boolean.TRUE.equals(isShare) || Boolean.TRUE.equals(isUpdate)) continue;
            validField.add(fieldName);
        }
        return validField;
    }

    public boolean isDiff(DynamicObject dynamicObjectA, DynamicObject dynamicObjectB, Map<String, Boolean> mapUpdate) {
        if (MapUtils.isEmpty(mapUpdate)) {
            return false;
        }
        DataEntityPropertyCollection dataEntityProperties = dynamicObjectA.getDataEntityType().getProperties();
        Set<String> validField = this.getValidFieldSet(dataEntityProperties, mapUpdate);
        return this.isDiff(dynamicObjectA, dynamicObjectB, validField);
    }

    public boolean isDiff(DynamicObject dynamicObjectA, DynamicObject dynamicObjectB, Set<String> validField) {
        for (String field : validField) {
            Object filedA = dynamicObjectA.get(field);
            Object filedB = dynamicObjectB.get(field);
            if (HisCommonService.getInstance().equalsValue(filedA, filedB, true, true)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getBaseIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>(16);
        ignoreKeys.add("id");
        ignoreKeys.add("masterid");
        ignoreKeys.add("createtime");
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        ignoreKeys.add("modifytime");
        ignoreKeys.add("modifier");
        ignoreKeys.add("modifier_id");
        return ignoreKeys;
    }

    public Set<String> getSinkBaseIgnoreKeys() {
        Set<String> ignoreKeys = this.getBaseIgnoreKeys();
        ignoreKeys.add("versionsource");
        ignoreKeys.add("boid");
        ignoreKeys.add("bsed");
        ignoreKeys.add("bsled");
        ignoreKeys.add("bred");
        ignoreKeys.add("brled");
        ignoreKeys.add("sourcevid");
        ignoreKeys.add("ismodify");
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("firstbsed");
        ignoreKeys.add("datastatus");
        ignoreKeys.add("hisversion");
        ignoreKeys.add("createorg");
        ignoreKeys.add("createorg_id");
        ignoreKeys.add("useorg");
        ignoreKeys.add("useorg_id");
        ignoreKeys.add("org");
        ignoreKeys.add("org_id");
        return ignoreKeys;
    }

    private Set<String> getDefaultNoSyncFields() {
        HashSet<String> ignoreKeys = new HashSet<String>(30);
        ignoreKeys.add("id");
        ignoreKeys.add("datastatus");
        ignoreKeys.add("masterid");
        ignoreKeys.add("boid");
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("auditstatus");
        ignoreKeys.add("status");
        ignoreKeys.add("bsed");
        ignoreKeys.add("bsled");
        ignoreKeys.add("changedescription");
        ignoreKeys.add("createorg");
        ignoreKeys.add("createorg_id");
        ignoreKeys.add("useorg");
        ignoreKeys.add("useorg_id");
        ignoreKeys.add("org");
        ignoreKeys.add("org_id");
        ignoreKeys.add("createtime");
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        ignoreKeys.add("modifytime");
        ignoreKeys.add("modifier");
        ignoreKeys.add("modifier_id");
        return ignoreKeys;
    }

    public Set<String> getDiffSet(DynamicObject dynamicObject, Set<String> noIgnoreSet) {
        Set<String> diffSet = this.getBaseIgnoreKeys();
        DataEntityPropertyCollection dataEntityProperties = dynamicObject.getDynamicObjectType().getProperties();
        for (IDataEntityProperty entryDtProp : dataEntityProperties) {
            String filedName = entryDtProp.getName();
            if (noIgnoreSet.contains(filedName)) continue;
            diffSet.add(filedName);
        }
        return diffSet;
    }

    public Date queryPersonalDate(String entityNumber, Object boId) {
        if (boId == null || !(boId instanceof Long)) {
            return null;
        }
        Long lBoId = (Long)boId;
        if (lBoId == 0L) {
            return null;
        }
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter[] qFilters = new QFilter[]{new QFilter("boid", "=", boId), new QFilter("versionsource", "!=", (Object)EnumHisVersionSource.ORIGIN_DATA_SINK.getType()), new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()))};
        DynamicObject[] dynamicObjects = helper.query("bsed,masterid,iscurrentversion", qFilters, "bsed");
        if (dynamicObjects == null || dynamicObjects.length == 1) {
            return null;
        }
        Date personalDate = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            boolean isCurrentVersion = dynamicObject.getBoolean("iscurrentversion");
            Long masterId = dynamicObject.getLong("masterid");
            if (isCurrentVersion) {
                if (masterId == null || lBoId.longValue() != masterId.longValue()) continue;
                return null;
            }
            if (personalDate != null) continue;
            personalDate = dynamicObject.getDate("bsed");
        }
        return personalDate;
    }

    public Map<Long, Date> batchQueryPersonalDate(String entityNumber, Set<Long> boIdSet) {
        HashMap mapBoIdFirstDate = null;
        if (entityNumber == null || CollectionUtils.isEmpty(boIdSet)) {
            return null;
        }
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter[] qFilters = new QFilter[]{new QFilter("boid", "in", boIdSet), new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')), new QFilter("versionsource", "!=", (Object)EnumHisVersionSource.ORIGIN_DATA_SINK.getType()), new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()))};
        DynamicObject[] dynamicObjects = helper.query("bsed,boid", qFilters, "bsed");
        if (dynamicObjects == null || dynamicObjects.length == 1) {
            return null;
        }
        Date personalDate = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long boId = dynamicObject.getLong("boid");
            if (mapBoIdFirstDate == null) {
                mapBoIdFirstDate = Maps.newHashMapWithExpectedSize((int)16);
            }
            if ((personalDate = (Date)mapBoIdFirstDate.get(boId)) == null) {
                personalDate = dynamicObject.getDate("bsed");
                mapBoIdFirstDate.put(boId, personalDate);
                continue;
            }
            Date startDate = dynamicObject.getDate("bsed");
            if (startDate != null && startDate.getTime() >= personalDate.getTime()) continue;
        }
        return mapBoIdFirstDate;
    }
}

