/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.revocation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationListBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisEventEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class EventGroupService {
    private static volatile EventGroupService eventGroupService = null;
    private static final Log LOGGER = LogFactory.getLog(EventGroupService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventGroupService getInstance() {
        if (eventGroupService != null) return eventGroupService;
        Class<EventGroupService> clazz = EventGroupService.class;
        synchronized (EventGroupService.class) {
            if (eventGroupService != null) return eventGroupService;
            eventGroupService = new EventGroupService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return eventGroupService;
        }
    }

    public DynamicObject getEventTableByNumber(HisTransRevocationListBo hisTransRevocationListBo) {
        Long eventId = hisTransRevocationListBo.getEventId();
        if (eventId != null && eventId != 0L) {
            DynamicObject dyAppEvent;
            String eventGroupNumber = hisTransRevocationListBo.getEventGroupNumber();
            if (eventGroupNumber != null) {
                return HisEventEntityRepository.getEventTableByNumber(eventGroupNumber);
            }
            String entityNumber = hisTransRevocationListBo.getResisterEventGroupEntityNumber();
            if (entityNumber != null) {
                return HisModelEventDataService.getInstance().getEventGroupDyByEntity(entityNumber);
            }
            String appId = hisTransRevocationListBo.getResisterEventGroupAppId();
            if (appId != null && !HRObjectUtils.isEmpty((Object)(dyAppEvent = HisCommonEntityRepository.getAppDefaultEventDy(appId)))) {
                DynamicObject eventTableConfigDy = dyAppEvent.getDynamicObject("evententity");
                return eventTableConfigDy;
            }
        } else {
            List<HisTransRevocationBo> hisTransRevocationBoList = hisTransRevocationListBo.getListHisTransRevocationBo();
            if (CollectionUtils.isEmpty(hisTransRevocationBoList)) {
                return null;
            }
            HisTransRevocationBo hisTransRevocationBo = hisTransRevocationBoList.get(0);
            return HisModelEventDataService.getInstance().getEventGroupDyByEntity(hisTransRevocationBo.getEntityNumber());
        }
        return null;
    }

    public Long getEventId(HisTransRevocationListBo hisTransRevocationListBo) {
        Long eventId = hisTransRevocationListBo.getEventId();
        if (eventId != null && eventId != 0L) {
            return eventId;
        }
        List<HisTransRevocationBo> hisTransRevocationBoList = hisTransRevocationListBo.getListHisTransRevocationBo();
        if (CollectionUtils.isEmpty(hisTransRevocationBoList)) {
            return null;
        }
        return hisTransRevocationBoList.get(0).getEventId();
    }

    public boolean isPartRevocation(HRBaseServiceHelper busiEventHelper, Long eventId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("event", "=", (Object)eventId), new QFilter("status", "!=", (Object)EventOperateEnums.EVENT_STATUS_ALREADY_EXEC.getValue())};
        return busiEventHelper.isExists(qFilters);
    }

    public Map<String, DynamicObject> getEntityToEventMap(List<String> entityNumberList) {
        DynamicObject[] hisModelRegDys = HisCommonEntityRepository.getEntityToEventDys(entityNumberList);
        return this.filterHisModelRegDys(hisModelRegDys);
    }

    public Map<String, String> getEntityToAppMap(List<String> entityNumberList) {
        DynamicObject[] entityToAppDys;
        for (DynamicObject entityToAppDy : entityToAppDys = HisCommonEntityRepository.getEntityToAppDys(entityNumberList)) {
            LOGGER.info("hismodelImport_getEntityToAppMap entityToAppDy: {}", (Object)entityToAppDy.getString("bizappid.id"));
        }
        Map<String, String> map = this.filterEntityToAppDys(entityToAppDys);
        LOGGER.info("hismodelImport_getEntityToAppMap entityNumberList: {}, filterEntityToAppDys: {}", entityNumberList, map);
        return map;
    }

    public Map<String, DynamicObject> getAppDefaultEventMap(Map<String, String> entityToAppMap) {
        DynamicObject[] appDefaultEventDys = HisCommonEntityRepository.getAppDefaultEventDys(entityToAppMap.values().toArray(new String[0]));
        return this.filterAppDefaultEventDys(appDefaultEventDys);
    }

    private Map<String, DynamicObject> filterHisModelRegDys(DynamicObject[] hisModelRegDys) {
        List filterHisModelRegDys = Stream.of(hisModelRegDys).filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("entity.id")) && !HRObjectUtils.isEmpty((Object)dy.getDynamicObject("evententity"))).collect(Collectors.toList());
        return filterHisModelRegDys.stream().collect(Collectors.toMap(entityDy -> entityDy.getString("entity.id"), evententityDy -> evententityDy.getDynamicObject("evententity"), (pre, next) -> pre));
    }

    private Map<String, String> filterEntityToAppDys(DynamicObject[] entityToAppDys) {
        List filterEntityDys = Stream.of(entityToAppDys).filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("id")) && HRStringUtils.isNotEmpty((String)dy.getString("bizappid.id"))).collect(Collectors.toList());
        return filterEntityDys.stream().collect(Collectors.toMap(entityDy -> entityDy.getString("id"), appDy -> appDy.getString("bizappid.id")));
    }

    private Map<String, DynamicObject> filterAppDefaultEventDys(DynamicObject[] appDefaultEventDys) {
        List filterAppDefaultEventDys = Stream.of(appDefaultEventDys).filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("actionapp.id")) && !HRObjectUtils.isEmpty((Object)dy.getDynamicObject("evententity"))).collect(Collectors.toList());
        return filterAppDefaultEventDys.stream().collect(Collectors.toMap(dy -> dy.getString("actionapp.id"), evententityreDy -> evententityreDy.getDynamicObject("evententity")));
    }
}

