/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.service.impl.newhismodel.writeback;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.writeback.HisWriteBackCurrentBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.SortingDynamicObjectEffDateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.timezone.HisTimeZoneService;
import kd.hr.hbp.business.domain.service.newhismodel.writeback.IHisWriteBackCurrentService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import org.apache.commons.collections.MapUtils;

public class HisWriteBackCurrentService
implements IHisWriteBackCurrentService {
    private static volatile HisWriteBackCurrentService hisWriteBackCurrentService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisWriteBackCurrentService getInstance() {
        if (hisWriteBackCurrentService != null) return hisWriteBackCurrentService;
        Class<HisWriteBackCurrentService> clazz = HisWriteBackCurrentService.class;
        synchronized (HisWriteBackCurrentService.class) {
            if (hisWriteBackCurrentService != null) return hisWriteBackCurrentService;
            hisWriteBackCurrentService = new HisWriteBackCurrentService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisWriteBackCurrentService;
        }
    }

    @Override
    public void WriteBackCurrentVersion(HisWriteBackCurrentBo hisWriteBackCurrentBo) {
        this.WriteBackCurrentVersion(hisWriteBackCurrentBo, true);
    }

    @Override
    public List<DynamicObject> WriteBackCurrentVersion(HisWriteBackCurrentBo hisWriteBackCurrentBo, boolean isSave) {
        ArrayList updateStatusVersionList = Lists.newArrayListWithExpectedSize((int)10);
        String entityNumber = hisWriteBackCurrentBo.getEntityNumber();
        Map<Long, List<DynamicObject>> mapBoIdGroupAllVersion = hisWriteBackCurrentBo.getMapBoIdGroupAllVersion();
        List<DynamicObject> currentDynamicObjectList = hisWriteBackCurrentBo.getCurrentDynamicObjectList();
        Set<String> ignoreField = hisWriteBackCurrentBo.getIgnoreField();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        if (mapBoIdGroupAllVersion.isEmpty()) {
            return null;
        }
        Set<Long> boIdSet = mapBoIdGroupAllVersion.keySet();
        if (boIdSet.isEmpty()) {
            return null;
        }
        Set<Long> existSboId = HisCommonEntityRepository.getExistsBoId(serviceHelper, boIdSet);
        HashSet<Long> differenceSet = new HashSet<Long>(16);
        HashSet<Long> oldBoIdSet = new HashSet<Long>(16);
        HashMap<Object, DynamicObject> mapBoIdGroup = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject dynamicObject : currentDynamicObjectList) {
            Long boId = dynamicObject.getLong("boid");
            oldBoIdSet.add(boId);
            mapBoIdGroup.put(boId, dynamicObject);
        }
        differenceSet.addAll(existSboId);
        differenceSet.removeAll(oldBoIdSet);
        if (differenceSet != null && differenceSet.size() > 0) {
            DynamicObject[] differenceDys;
            for (DynamicObject dynamicObject : differenceDys = serviceHelper.loadDynamicObjectArray(differenceSet.toArray())) {
                Long boId = dynamicObject.getLong("boid");
                currentDynamicObjectList.add(dynamicObject);
                mapBoIdGroup.put(boId, dynamicObject);
            }
        }
        Date dateNow = new Date();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)(mapBoIdGroupAllVersion.size() * 2));
        for (Map.Entry<Long, List<DynamicObject>> entry : mapBoIdGroupAllVersion.entrySet()) {
            List<DynamicObject> allDynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(allDynamicObjectList)) continue;
            for (DynamicObject dynamicObject : allDynamicObjectList) {
                Long id;
                if (dynamicObject == null || (id = Long.valueOf(dynamicObject.getLong("id"))) == null || id == 0L) continue;
                arrayList.add(id);
            }
        }
        Set<Long> boIdHasRestTemp = HisCommonEntityRepository.getRestTempData(serviceHelper, arrayList, boIdSet);
        Set<String> allIgnoreKeys = this.getAllIgnoreKeys(entityNumber);
        if (ignoreField != null && ignoreField.size() != 0) {
            allIgnoreKeys.addAll(ignoreField);
        }
        block4: for (Map.Entry<Long, List<DynamicObject>> entry : mapBoIdGroupAllVersion.entrySet()) {
            DynamicObject dynamicObjectCurrent;
            Long boId = entry.getKey();
            List<DynamicObject> allDynamicObjectList = entry.getValue();
            if (CollectionUtils.isEmpty(allDynamicObjectList) || (dynamicObjectCurrent = (DynamicObject)mapBoIdGroup.get(boId)) == null) continue;
            if (existSboId.contains(boId)) {
                Object[] dynamicObjects = allDynamicObjectList.toArray(new DynamicObject[allDynamicObjectList.size()]);
                SortingDynamicObjectEffDateService.getInstance().quickSort(dynamicObjects);
                Date firstBsed = dynamicObjects[0].getDate("bsed");
                updateStatusVersionList.addAll(HisEffDateCommonService.getInstance().reBuildDataStatusBySortedArray((DynamicObject[])dynamicObjects));
                for (Object dynamicObject : dynamicObjects) {
                    String dataStatus = dynamicObject.getString("datastatus");
                    if (!EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus) && !EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dataStatus)) continue;
                    HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dynamicObjectCurrent, allIgnoreKeys, (boolean)true);
                    dynamicObjectCurrent.set("sourcevid", (Object)dynamicObject.getLong("id"));
                    DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dynamicObjectCurrent);
                    if (boIdHasRestTemp.contains(boId)) {
                        dynamicObjectCurrent.set("ismodify", (Object)"1");
                    } else {
                        dynamicObjectCurrent.set("ismodify", (Object)"0");
                    }
                    dynamicObjectCurrent.set("firstbsed", (Object)firstBsed);
                    DynamicObjectCommonService.getInstance().setSimpleModifyInfo(dynamicObjectCurrent);
                    dynamicObjectCurrent.set("iscurrentversion", (Object)Character.valueOf('1'));
                    if (!EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus)) continue block4;
                    dynamicObjectCurrent.set("bred", (Object)dateNow);
                    dynamicObject.set("bred", (Object)dateNow);
                    continue block4;
                }
                continue;
            }
            DynamicObject newDynamicObject = allDynamicObjectList.get(0);
            HisTimeZoneService.getInstance().firstInitPlanBsedAndStatus(newDynamicObject);
            Long oldBoId = dynamicObjectCurrent.getLong("boid");
            Long id = dynamicObjectCurrent.getLong("id");
            if (oldBoId.longValue() != boId.longValue() && id.longValue() != boId.longValue()) continue;
            this.copyFirstCurrentVersion(dynamicObjectCurrent, newDynamicObject, dateNow);
        }
        if (isSave && CollectionUtils.isNotEmpty((Collection)updateStatusVersionList)) {
            serviceHelper.save(updateStatusVersionList.toArray(new DynamicObject[updateStatusVersionList.size()]));
            return null;
        }
        return updateStatusVersionList;
    }

    public void copyFirstCurrentVersion(DynamicObject dynamicObjectCurrent, DynamicObject newDynamicObject, Date dateNow) {
        dynamicObjectCurrent.set("iscurrentversion", (Object)Character.valueOf('1'));
        dynamicObjectCurrent.set("sourcevid", (Object)newDynamicObject.getLong("id"));
        dynamicObjectCurrent.set("firstbsed", (Object)newDynamicObject.getDate("bsed"));
        boolean hasPlanBsedField = dynamicObjectCurrent.getDynamicObjectType().getProperties().containsKey((Object)"changebsed");
        if (hasPlanBsedField) {
            dynamicObjectCurrent.set("changebsed", (Object)newDynamicObject.getDate("changebsed"));
        }
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(dynamicObjectCurrent);
        DynamicObjectCommonService.getInstance().setMastId(dynamicObjectCurrent);
        String dataStatus = newDynamicObject.getString("datastatus");
        dynamicObjectCurrent.set("datastatus", (Object)dataStatus);
        if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dataStatus)) {
            dynamicObjectCurrent.set("bred", (Object)dateNow);
            newDynamicObject.set("bred", (Object)dateNow);
        }
    }

    public Set<String> getBaseIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("id");
        ignoreKeys.add("masterid");
        ignoreKeys.add("boid");
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("auditstatus");
        ignoreKeys.add("status");
        ignoreKeys.add("createtime");
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        ignoreKeys.add("versionsource");
        ignoreKeys.add("hisversion");
        return ignoreKeys;
    }

    @Override
    public Set<String> getAllIgnoreKeys(String entityNumber) {
        String[] ignorefields;
        String ignorefield;
        Set<String> ignoreKeys = this.getBaseIgnoreKeys();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityevent");
        QFilter qFilter = new QFilter("entity", "=", (Object)entityNumber);
        DynamicObject dy = serviceHelper.queryOriginalOne("ignorefield", qFilter.toArray());
        if (dy != null && StringUtils.isNotEmpty((String)(ignorefield = dy.getString("ignorefield"))) && (ignorefields = ignorefield.split(",")) != null) {
            for (String filed : ignorefields) {
                if (!StringUtils.isNotEmpty((String)filed)) continue;
                ignoreKeys.add(filed);
            }
        }
        return ignoreKeys;
    }

    @Override
    public void updateOldVersion(HRBaseServiceHelper serviceHelper, List<DynamicObject> updateDateVersionList, List<DynamicObject> updateStatusVersionList, Set<Long> oldVersionIdSet) {
        ArrayList newUpdateList = Lists.newArrayListWithExpectedSize((int)10);
        Map<Long, DynamicObject> mapOldVersion = this.mergeVersionListData(updateDateVersionList, updateStatusVersionList);
        if (MapUtils.isEmpty(mapOldVersion) || CollectionUtils.isEmpty(oldVersionIdSet)) {
            return;
        }
        Date effDate = new Date();
        for (Map.Entry<Long, DynamicObject> entry : mapOldVersion.entrySet()) {
            Long id = entry.getKey();
            if (id == null || !oldVersionIdSet.contains(id)) continue;
            DynamicObject dynamicObject = entry.getValue();
            String dataStatus = dynamicObject.getString("datastatus");
            Date realEffEndDate = dynamicObject.getDate("brled");
            if (EnumHisDataVersionStatus.INVALIDED.getStatus().equals(dataStatus) && realEffEndDate == null) {
                dynamicObject.set("brled", (Object)effDate);
            }
            newUpdateList.add(dynamicObject);
        }
        serviceHelper.save(newUpdateList.toArray(new DynamicObject[newUpdateList.size()]));
    }

    public Map<Long, DynamicObject> mergeVersionListData(List<DynamicObject> updateDateVersionList, List<DynamicObject> updateStatusVersionList) {
        HashMap mapOldVersion;
        block5: {
            block4: {
                mapOldVersion = Maps.newHashMapWithExpectedSize((int)16);
                if (!CollectionUtils.isNotEmpty(updateDateVersionList)) break block4;
                for (DynamicObject dy : updateDateVersionList) {
                    Long id = dy.getLong("id");
                    mapOldVersion.put(id, dy);
                }
                if (!CollectionUtils.isNotEmpty(updateStatusVersionList)) break block5;
                for (DynamicObject dyOldVersion : updateStatusVersionList) {
                    mapOldVersion.put(dyOldVersion.getLong("id"), dyOldVersion);
                }
                break block5;
            }
            if (CollectionUtils.isNotEmpty(updateStatusVersionList)) {
                for (DynamicObject dy : updateStatusVersionList) {
                    Long id = dy.getLong("id");
                    mapOldVersion.put(id, dy);
                }
            }
        }
        return mapOldVersion;
    }
}

