/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisPersonalDataType;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisLineOpUtil {
    public static DynamicObject copyTempVersionDy(String entityNum, DynamicObject copyData, Set<String> ignoreFields) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        DynamicObject dyNewVersion = helper.generateEmptyDynamicObject();
        Set ignoreFieldsAll = Stream.concat(ignoreFields.stream(), Stream.of("id", "masterid", "versionsource", "iscurrentversion", "datastatus", "creator", "creator_id")).collect(Collectors.toSet());
        HRDynamicObjectUtils.copy((DynamicObject)copyData, (DynamicObject)dyNewVersion, ignoreFieldsAll, (boolean)true);
        DynamicObjectCommonService.getInstance().setSimpleNewInfo(dyNewVersion);
        dyNewVersion.set("iscurrentversion", (Object)Boolean.FALSE);
        dyNewVersion.set("datastatus", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue());
        if (dyNewVersion.getDataEntityType().getProperties().containsKey((Object)"status")) {
            dyNewVersion.set("status", (Object)"A");
        }
        return dyNewVersion;
    }

    public static HisVersionParamBo saveEffect(DynamicObject[] dataCol, OperateOption operateOption) {
        String dataEntityType = dataCol[0].getDataEntityType().getName();
        long idCount = Arrays.stream(dataCol).filter(data -> data.getLong("id") == 0L).count();
        long[] ids = new long[]{};
        if (idCount > 0L) {
            ids = ORM.create().genLongIds(dataEntityType, (int)idCount);
        }
        int idIndex = 0;
        for (DynamicObject dynamicObject : dataCol) {
            long id = dynamicObject.getLong("id");
            if (id != 0L) continue;
            id = ids[idIndex++];
            dynamicObject.set("id", (Object)id);
            HisLineOpUtil.setDyMasterId(dataEntityType, dynamicObject);
        }
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setHisDyns(dataCol);
        hisVersionParamBo.setEntityNumber(dataEntityType);
        hisVersionParamBo.setNeedValidateDate(false);
        if (operateOption != null) {
            String jsonString;
            Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos;
            if (operateOption.containsVariable("ispersonalizedata") && "1".equals(operateOption.getVariableValue("ispersonalizedata"))) {
                hisVersionParamBo.setPersonalDataType(EnumHisPersonalDataType.PERSONAL_DATA_SAVE.getType());
            }
            if ((mapHisAttachmentBos = HisAttachmentService.buildHisAttachmentBoList(jsonString = operateOption.getVariableValue("opHisAttachments", null))) != null) {
                hisVersionParamBo.setMapHisAttachmentBos(mapHisAttachmentBos);
            }
        }
        return hisVersionParamBo;
    }

    public static void handleImportEventBefore(boolean isImport, HisVersionParamBo hisVersionParamBo) {
        if (!isImport) {
            return;
        }
        String entityId = hisVersionParamBo.getEntityNumber();
        Long userId = RequestContext.get().getCurrUserId();
        IHRAppCache appCache = HRAppCache.get((String)"hbp");
        String importLogIdCacheKey = String.format("HisImportLogId_%s_%s", entityId, HisModelImportUtil.getImportCacheKeySuffix());
        String lastHisImportLogKey = String.format("HismodelImportLogId_%s_%s", entityId, HisModelImportUtil.getImportCacheKeySuffix());
        String importLogId = (String)appCache.get(importLogIdCacheKey, String.class);
        String lastHisImportLog = (String)appCache.get(lastHisImportLogKey, String.class);
        hisVersionParamBo.setAtomicTrans(false);
        if (lastHisImportLog == null) {
            appCache.put(lastHisImportLogKey, (Object)importLogId);
            return;
        }
        if (HRStringUtils.equals((String)importLogId, (String)lastHisImportLog)) {
            String eventIdKey = String.format("HismodelEventId_%s_%s", entityId, HisModelImportUtil.getImportCacheKeySuffix());
            Long lastEventId = (Long)appCache.get(eventIdKey, Long.class);
            hisVersionParamBo.setEventId(lastEventId);
        }
    }

    public static void handleImportEventAfter(boolean isImport, HisVersionParamBo hisVersionParamBo) {
        if (!isImport) {
            return;
        }
        IHRAppCache appCache = HRAppCache.get((String)"hbp");
        String eventIdKey = String.format("HismodelEventId_%s_%s", hisVersionParamBo.getEntityNumber(), HisModelImportUtil.getImportCacheKeySuffix());
        appCache.put(eventIdKey, (Object)hisVersionParamBo.getEventId());
    }

    public static Long getEventIdForImport(String entityKey) {
        IHRAppCache appCache = HRAppCache.get((String)"hbp");
        String eventIdKey = String.format("HismodelEventId_%s_%s", entityKey, HisModelImportUtil.getImportCacheKeySuffix());
        return (Long)appCache.get(eventIdKey, Long.class);
    }

    private static void setDyMasterId(String entityNumber, DynamicObject dy) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        Map allFields = dataEntityType.getAllFields();
        if (allFields.containsKey("masterid")) {
            dy.set("masterid", (Object)dy.getLong("id"));
        }
    }
}

