/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.domain.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HisModelImportUtil {
    private HisModelImportUtil() {
    }

    public static boolean isImport(OperateOption option) {
        return option.containsVariable("importtype");
    }

    public static boolean isNew(String importType) {
        return HRStringUtils.equals((String)"new", (String)importType);
    }

    public static boolean isDelete(String importType) {
        return HRStringUtils.equals((String)"delete", (String)importType);
    }

    public static boolean isOverride(String importType) {
        return HRStringUtils.equals((String)"override", (String)importType);
    }

    public static boolean isOverrideNew(String importType) {
        return HRStringUtils.equals((String)"overridenew", (String)importType);
    }

    public static String getImportCacheKeySuffix() {
        return "_" + RequestContext.get().getCurrUserId() + "_" + RequestContext.get().getRequestId();
    }

    public static Pair<Map<Object, String>, Map<Object, String>> getDbEnableAndStatus(boolean hasStatus, boolean hasEnable, HRBaseServiceHelper serviceHelper, Supplier<Set<Object>> ids) {
        QFilter isCurrentQFilter;
        QFilter idsQFilter;
        Map<Object, Object> enableMap = new HashMap(0);
        Map<Object, Object> statusMap = new HashMap(0);
        String selectFields = hasEnable && hasStatus ? "id, enable, status" : (hasEnable ? "id, enable" : "id, status");
        DynamicObjectCollection dataCol = serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{idsQFilter = HRQFilterHelper.buildIn((String)"id", (Collection)ids.get()), isCurrentQFilter = HRQFilterHelper.buildEql((String)"iscurrentversion", (Object)Character.valueOf('1'))});
        if (CollectionUtils.isNotEmpty((Collection)dataCol)) {
            if (hasEnable) {
                enableMap = dataCol.stream().collect(Collectors.toMap(v -> v.get("id"), v -> v.getString("enable")));
            }
            if (hasStatus) {
                statusMap = dataCol.stream().collect(Collectors.toMap(v -> v.get("id"), v -> v.getString("status")));
            }
        }
        return Pair.of(enableMap, statusMap);
    }

    public static boolean hasStatus(DataEntityPropertyCollection properties) {
        boolean status = properties.containsKey((Object)"status");
        if (status) {
            status = StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)properties.get((Object)"status")).getAlias());
        }
        return status;
    }

    public static boolean hasStatus(Map<String, IDataEntityProperty> allFields) {
        boolean status = allFields.containsKey("status");
        if (status) {
            status = StringUtils.isNotBlank((CharSequence)allFields.get("status").getAlias());
        }
        return status;
    }

    public static boolean hasEnable(DataEntityPropertyCollection properties) {
        boolean enable = properties.containsKey((Object)"enable");
        if (enable) {
            enable = StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)properties.get((Object)"enable")).getAlias());
        }
        return enable;
    }

    public static boolean hasEnable(Map<String, IDataEntityProperty> allFields) {
        boolean enable = allFields.containsKey("enable");
        if (enable) {
            enable = StringUtils.isNotBlank((CharSequence)allFields.get("enable").getAlias());
        }
        return enable;
    }
}

