/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.export;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExcelWriter;
import kd.hr.hbp.business.export.Header;
import kd.hr.hbp.business.export.MultiLangHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportSXSSWbGenerateHelper
extends ExcelWriter {
    private static final Log logger = LogFactory.getLog(ExportSXSSWbGenerateHelper.class);
    private SXSSFWorkbook wb = new SXSSFWorkbook(5000);
    private SXSSFSheet ss;

    public ExportSXSSWbGenerateHelper() {
        this.wb.setCompressTempFiles(true);
        this.ss = this.wb.createSheet("sheet1");
    }

    public int createHeaderForExportTpl(List<Header> headers) {
        SXSSFRow row = this.ss.createRow(0);
        int columIndex = 0;
        for (Header header : headers) {
            SXSSFCell cell = row.createCell(columIndex);
            cell.setCellValue(header.getDisplayName());
            cell.setCellStyle(this.getHeadColumnStyle(this.wb));
            this.setColumnWidth((Sheet)this.ss, columIndex, header.getDisplayName());
            ++columIndex;
        }
        return 1;
    }

    public int createData(List<Header> headers, DynamicObjectCollection data, Set<String> canNotReadFields, int startIndex, Table<String, Long, DynamicObject> langResultTable) {
        for (int i = 0; i < data.size(); ++i) {
            SXSSFRow row = this.ss.createRow(startIndex + i);
            int columIndex = 0;
            DynamicObject exportData = null;
            String value = "";
            for (Header header : headers) {
                String headerKey = header.getKey();
                if ("multilang".equals(header.getInputType())) {
                    OrmLocaleValue ormLocaleValue;
                    String idKey = header.getName() + "." + "id";
                    exportData = (DynamicObject)langResultTable.get((Object)header.getName(), ((DynamicObject)data.get(i)).get(idKey));
                    String headerKeyProp = MultiLangHelper.getLangKeyProp(headerKey);
                    if (Objects.nonNull(exportData) && Objects.nonNull(exportData.get(headerKeyProp)) && Objects.nonNull(ormLocaleValue = (OrmLocaleValue)exportData.get(headerKeyProp))) {
                        value = ormLocaleValue.get((Object)MultiLangHelper.getLangTag(headerKey));
                    }
                } else {
                    exportData = (DynamicObject)data.get(i);
                    value = Objects.isNull(exportData) ? "" : exportData.get(headerKey);
                }
                Cell cell = row.createCell(columIndex, CellType.STRING);
                this.dealViewRight(canNotReadFields, header, value, cell);
                ++columIndex;
            }
        }
        return startIndex + data.size();
    }

    /*
     * Exception decompiling
     */
    public String writeFile(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setColumnWidth(Sheet sheet, int columIndex, String displayName) {
        int cellLength = displayName.getBytes(Charset.defaultCharset()).length;
        sheet.setColumnWidth(columIndex, cellLength * 2 * 256);
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    private static String formatTimeStr(int time) {
        if (time < 0) {
            return null;
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static void writeValue(Cell cell, Object value, String inputType, CellStyle defaultCellStyle) {
        if (value == null) {
            return;
        }
        if ("time".equals(inputType)) {
            cell.setCellValue(ExportSXSSWbGenerateHelper.formatTimeStr((Integer)value));
        } else if ("date".equals(inputType)) {
            String pat = "yyyy-MM-dd";
            cell.setCellValue(HRDateTimeUtils.format((Date)((Date)value), (String)pat, null, null));
        } else if ("datetime".equals(inputType)) {
            String pat = "yyyy-MM-dd HH:mm:ss";
            cell.setCellValue(HRDateTimeUtils.format((Date)((Date)value), (String)pat, null, null));
        } else if ("decimal".equals(inputType)) {
            if (value instanceof NumberPrecision || value instanceof Map) {
                JSONObject dataMap = (JSONObject)JSONObject.toJSON((Object)value);
                BigDecimal decimal = new BigDecimal(dataMap.getOrDefault((Object)"result", (Object)0).toString());
                if (!ExportSXSSWbGenerateHelper.isDecimalTooBig(decimal.toString())) {
                    cell.setCellValue(decimal.doubleValue());
                    value = null;
                } else if (value instanceof Map) {
                    value = decimal;
                }
            }
            if (value != null) {
                cell.setCellValue(value.toString());
            }
        } else {
            String val = value.toString();
            if (val != null && val.length() >= Short.MAX_VALUE) {
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u5355\u5143\u683c\u652f\u6301\u7684\u6700\u5927\u957f\u5ea6\u3002", (String)"HRListDataExporter_0", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                val = "ERROR:" + msg + "32767";
            }
            if (defaultCellStyle != null) {
                cell.setCellStyle(defaultCellStyle);
            }
            cell.setCellValue(val);
        }
    }

    public static boolean isDecimalTooBig(String decimalStr) {
        int length;
        int lastIndex = decimalStr.lastIndexOf(46);
        if (lastIndex >= 0) {
            for (length = decimalStr.length() - 1; length > lastIndex && decimalStr.charAt(length) == '0'; --length) {
            }
        }
        if (decimalStr.startsWith("-")) {
            --length;
        }
        return length > 11;
    }

    public static int calcColumnWidth(String caption, int defColWidth) {
        int colWidth;
        try {
            colWidth = Math.max(256 * defColWidth / 8 * 2, 256 * (caption.getBytes("GBK").length + 12));
        }
        catch (UnsupportedEncodingException var4) {
            colWidth = 51200;
        }
        return Math.min(colWidth, 51200);
    }

    private void dealViewRight(Set<String> canNotReadFields, Header header, Object value, Cell cell) {
        boolean viewRight = MultiLangHelper.isViewRight(header, canNotReadFields, cell);
        if (viewRight) {
            if (header.getKeyValues() != null) {
                if (value instanceof Boolean) {
                    value = value == Boolean.TRUE ? "1" : "0";
                }
                value = header.getKeyValues().get(value);
            }
            ExportSXSSWbGenerateHelper.writeValue(cell, value, header.getInputType(), null);
        }
    }
}

