/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.export;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.export.ExportSXSSWbGenerateHelper;
import kd.hr.hbp.business.export.HRListDataExporter;
import kd.hr.hbp.business.export.Header;
import kd.hr.hbp.business.export.MultiEntityExportEvent;
import kd.hr.hbp.business.export.MultiEntityService;
import kd.hr.hbp.business.export.MultiExParam;
import kd.hr.hbp.business.export.MultiLangHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;

public class HRBigDataMultiEntityExportTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HRBigDataMultiEntityExportTask.class);
    private List<ExportWriterFormat> formators;
    private String fileName;
    private String entitynumber;
    private String plugin;
    private Boolean fillParent;
    private Long tplId;
    private String templatetype;
    private Object[] allPKIds;
    private List<String> cusQueryAttrs;
    private Map<String, Header> tplHeaders = new HashMap<String, Header>();
    private Map<String, Header> cusHeaders = new HashMap<String, Header>();
    private Map<String, Object> noBindDbProps = new HashMap<String, Object>();
    private List<String> qFilterStr;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long start = System.currentTimeMillis();
        try {
            this.fileName = (String)map.get("fileName");
            this.plugin = (String)map.get("plugin");
            JSONArray array = (JSONArray)map.get("allPKIds");
            this.allPKIds = array.toArray();
            this.entitynumber = (String)map.get("entitynumber");
            this.tplId = (Long)map.get("tplId");
            this.templatetype = (String)map.get("templatetype");
            this.fillParent = (Boolean)map.get("fillParent");
            Class<?> aClass = MultiEntityService.getPluginClass(this.plugin);
            MultiEntityExportEvent event = (MultiEntityExportEvent)aClass.newInstance();
            this.cusQueryAttrs = event.multiCusQueryAttrs();
            this.qFilterStr = (List)map.get("qFilterStr");
            String exportUrl = this.export(event);
            event.multiAfterExportFile(new File("tempfile/", FilenameUtils.getName((String)exportUrl)));
            this.feedbackProgress(this.allPKIds.length, this.allPKIds.length);
            HashMap result = Maps.newHashMapWithExpectedSize((int)3);
            result.put("exportUrl", HRBigDataMultiEntityExportTask.getDownloadUrl(UrlService.getDomainContextUrl() + "/" + exportUrl, this.entitynumber, "4730fc9f000004ae"));
            result.put("total", this.allPKIds.length);
            result.put("complete", this.allPKIds.length);
            this.feedbackCustomdata(result);
        }
        catch (Exception e) {
            LOGGER.error("HRBigDataExportTask exception!", (Throwable)e);
            new KDBizException(e.getMessage());
        }
        StringBuilder builder = new StringBuilder("HRBigDataMultiEntityExportTask tplId=");
        builder.append(this.tplId).append(" expense time=").append(System.currentTimeMillis() - start).append(" mm");
        LOGGER.info(builder.toString());
    }

    public static String getDownloadUrl(String surl, String entityId, String permId) {
        DisposableUrlParam param = new DisposableUrlParam();
        param.setEntityNum(entityId);
        param.setPath(surl);
        param.setPermItem(permId);
        param.setPkId((Object)0L);
        return AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)param);
    }

    private String export(MultiEntityExportEvent event) throws Exception {
        this.formators = MultiEntityService.loadExportFormat(this.entitynumber, this.tplId);
        ArrayList<Header> headers = new ArrayList<Header>();
        int startIndex = this.fillParent != false ? 2 : 4;
        LOGGER.info("HRBigDataMultiEntityExportTask#export,this.templatetype:{}", (Object)this.templatetype);
        if ("EXPT".equalsIgnoreCase(this.templatetype)) {
            return this.exportExptExcel(event);
        }
        if ("IMPT".equalsIgnoreCase(this.templatetype)) {
            return this.exportImptExcel(event, headers, startIndex);
        }
        throw new KDBizException("unsport templatetype.");
    }

    private String exportImptExcel(MultiEntityExportEvent event, List<Header> headers, int startIndex) throws IOException {
        HRListDataExporter hrListDataExporter = new HRListDataExporter("sheet1", this.formators, false, headers);
        int batchSize = event.multiEditBatchSize();
        this.tplHeaders = MultiEntityService.translateMapHeader(headers);
        this.noBindDbProps = MultiEntityService.getMultiEntityNoBindDbProps(this.formators, this.tplHeaders);
        Multimap multiLangFields = MultiLangHelper.getMultiLangField(headers, this.entitynumber);
        Set<String> canNotReadFields = MultiEntityService.getFieldControlRules(this.entitynumber);
        List<List<Object>> list = MultiEntityService.splitPKIDs(this.allPKIds, batchSize);
        LOGGER.info("HRBigDataMultiEntityExportTask#exportImptExcel,entitynumber:{},list.size():{}", (Object)this.entitynumber, (Object)list.size());
        int progress = 0;
        Map<String, Boolean> adminDivisionProp = this.initAdminDivisionProp(this.entitynumber, headers);
        for (List<Object> subList : list) {
            MultiExParam multiExParam = new MultiExParam(this.tplHeaders, this.noBindDbProps, this.cusQueryAttrs, subList, this.entitynumber, MultiLangHelper.getJoinEntityKsqlId(this.entitynumber), headers);
            DynamicObjectCollection data = MultiEntityService.queryMultiEntityData(multiExParam, this.qFilterStr);
            LOGGER.info("HRBigDataMultiEntityExportTask#exportImptExcel,data.size():{}", (Object)data.size());
            MultiEntityService.addNoBindDbProps(this.noBindDbProps, data);
            Table<String, Long, DynamicObject> langResultTable = MultiLangHelper.fillLang((Multimap<String, String>)multiLangFields, data, headers);
            event.multiEditData(data);
            event.multiEditData(data, this.qFilterStr);
            event.multiEditData(data, headers, langResultTable);
            this.initAdminDivision(data, adminDivisionProp);
            startIndex = hrListDataExporter.createData(headers, data, canNotReadFields, startIndex, langResultTable);
            this.feedbackProgress(this.allPKIds.length, progress += subList.size());
        }
        return hrListDataExporter.writeFile(this.fileName);
    }

    private void initAdminDivision(DynamicObjectCollection data, Map<String, Boolean> adminDivisionProp) {
        if (data == null || adminDivisionProp == null || adminDivisionProp.size() == 0) {
            return;
        }
        Map<String, String> adminFullName = this.getAdminFullName(data, adminDivisionProp);
        for (DynamicObject obj : data) {
            adminDivisionProp.forEach((key, value) -> obj.set(key, adminFullName.get(obj.getString(key))));
        }
    }

    private Map<String, String> getAdminFullName(DynamicObjectCollection data, Map<String, Boolean> adminDivisionProp) {
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet adminIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject obj : data) {
            adminDivisionProp.forEach((key, value) -> adminIdSet.add(obj.getLong(key)));
        }
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("bd_admindivision");
        DynamicObject[] admins = adminHelper.queryOriginalArray("id,fullname,country.id", new QFilter[]{new QFilter("id", "in", (Object)adminIdSet)});
        Set countrySet = Arrays.stream(admins).map(it -> it.getLong("country.id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(countrySet)) {
            return resultMap;
        }
        HRBaseServiceHelper countryHelper = new HRBaseServiceHelper("bd_country");
        DynamicObject[] countries = countryHelper.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", countrySet)});
        Map<Long, String> countryMap = Arrays.stream(countries).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("name"), (key1, key2) -> key1));
        resultMap = Arrays.stream(admins).collect(Collectors.toMap(it -> it.getString("id"), it -> (String)countryMap.get(it.getLong("country.id")) + "/" + it.getString("fullname"), (key1, key2) -> key1));
        return resultMap;
    }

    private Map<String, Boolean> initAdminDivisionProp(String entityNumber, List<Header> headers) {
        HashMap propMap = Maps.newHashMapWithExpectedSize((int)16);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        MainEntityType mainEntityType = queryEntityType.getMainEntityType();
        List joinEntities = queryEntityType.getJoinEntitys();
        Map mainFields = mainEntityType.getAllFields();
        joinEntities.forEach(it -> {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)it.getEntityName());
            Map allSubFields = dataEntityType.getAllFields();
            mainFields.putAll(allSubFields);
        });
        mainFields.forEach((key, vale) -> {
            if (headers.stream().anyMatch(it -> it.getKey().equals(key)) && vale instanceof AdminDivisionProp) {
                propMap.put(key, Boolean.TRUE);
            }
        });
        return propMap;
    }

    private String exportExptExcel(MultiEntityExportEvent event) throws IOException {
        ExportSXSSWbGenerateHelper helper = new ExportSXSSWbGenerateHelper();
        List<Header> headers = MultiEntityService.getTplHeader(this.formators);
        this.tplHeaders = MultiEntityService.translateMapHeader(headers);
        this.noBindDbProps = MultiEntityService.getMultiEntityNoBindDbProps(this.formators, this.tplHeaders);
        Multimap multiLangFields = MultiLangHelper.getMultiLangField(headers, this.entitynumber);
        event.multiEditHeader(headers);
        Map<String, Boolean> adminDivisionProp = this.initAdminDivisionProp(this.entitynumber, headers);
        this.cusHeaders = MultiEntityService.getCustomHeader(headers, this.tplHeaders);
        int startIndex = helper.createHeaderForExportTpl(headers);
        int batchSize = event.multiEditBatchSize();
        Set<String> canNotReadFields = MultiEntityService.getFieldControlRules(this.entitynumber);
        List<List<Object>> list = MultiEntityService.splitPKIDs(this.allPKIds, batchSize);
        int progress = 0;
        for (List<Object> subList : list) {
            MultiExParam multiExParam = new MultiExParam(this.tplHeaders, this.noBindDbProps, this.cusQueryAttrs, subList, this.entitynumber, MultiLangHelper.getJoinEntityKsqlId(this.entitynumber), headers);
            DynamicObjectCollection data = MultiEntityService.queryMultiEntityData(multiExParam, this.qFilterStr);
            MultiEntityService.addCustomProp(this.cusHeaders, data);
            MultiEntityService.addNoBindDbProps(this.noBindDbProps, data);
            event.multiEditData(data);
            event.multiEditData(data, this.qFilterStr);
            this.initAdminDivision(data, adminDivisionProp);
            Table<String, Long, DynamicObject> langResultTable = MultiLangHelper.fillLang((Multimap<String, String>)multiLangFields, data, headers);
            startIndex = helper.createData(headers, data, canNotReadFields, startIndex, langResultTable);
            this.feedbackProgress(this.allPKIds.length, progress += subList.size());
        }
        return helper.writeFile(this.fileName);
    }

    private void feedbackProgress(int total, int complete) {
        HashMap custData = Maps.newHashMapWithExpectedSize((int)2);
        int progress = 0;
        if (total != 0) {
            progress = complete * 100 / total;
        }
        if (progress >= 100) {
            progress = 99;
        } else if (progress < 0) {
            progress = 0;
        }
        custData.put("total", String.valueOf(total));
        custData.put("complete", String.valueOf(complete));
        String desc = String.format(ResManager.loadKDString((String)"\u5df2\u5904\u7406 %1$s/%2$s \u5f20\u5355\u636e\u3002", (String)"HRBigDataMultiEntityExportTask_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), complete, total);
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, progress, desc, (Map)custData);
    }
}

