/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.export;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.hr.hbp.business.export.ExportSXSSWbGenerateHelper;
import kd.hr.hbp.business.export.Header;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class HRListDataExportHelper
extends ExcelWriter {
    private static final String[] SOURCES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append("Z");
            remainder = 26;
        } else {
            sb.append(SOURCES[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(SOURCES[remainder]);
        }
        return sb.reverse().toString();
    }

    public static void writeComment(SXSSFWorkbook wb, SXSSFRow commentRow, ExportWriterFormat format, ExportSheetStyle styles, Map<String, Object> property, int offset) {
        String entityDesc = (String)property.get("EntityDescription");
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            HRListDataExportHelper.createCell(wb, commentRow, format.col + offset, styles.getTitleStyle("default")).setCellValue(entityDesc);
        } else if (format.col + offset == 0) {
            HRListDataExportHelper.createCell(wb, commentRow, 0, styles.getTextHighLightStyle()).setCellValue(ResManager.loadKDString((String)"\u5c06\u9f20\u6807\u79fb\u81f3\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"HRListDataExportHelper_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    public static int splitColumn(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow nameRow, SXSSFRow titleRow, SXSSFRow commentRow, ExportSheetStyle styles, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, int titleRowIndex, Map<Integer, String> propDisplayNames, boolean mustInput, boolean fillParent, int defaultColWidth, List<Header> headers, String subEntityName, Object inputType, boolean isMainEntityType) {
        List splitCols = (List)format.flexColumn.get(fieldName);
        List splitColDisplayNames = (List)format.flexColumnDisplay.get(fieldName);
        List splitColDesc = (List)format.flexColumnDesc.get(fieldName);
        if (splitCols != null) {
            for (int j = 0; j < splitCols.size(); ++j) {
                int colIndex = format.col + offset;
                propDisplayNames.put(colIndex, (String)splitColDisplayNames.get(j));
                String caption = (j == 0 && mustInput ? "*" : "") + (String)splitColDisplayNames.get(j);
                sheet.setDefaultColumnStyle(colIndex, styles.getTitleStyle());
                if (!fillParent) {
                    StringBuilder key = new StringBuilder();
                    if (subEntityName != null) {
                        key.append(subEntityName).append(".");
                    }
                    key.append((String)splitCols.get(j));
                    headers.add(new Header(key.toString(), caption, (String)inputType, format.name, isMainEntityType));
                    HRListDataExportHelper.createCell(wb, nameRow, format.col + offset, styles.getNameStyle()).setCellValue((String)splitCols.get(j));
                }
                SXSSFCell cell = HRListDataExportHelper.createCell(wb, titleRow, colIndex, j == 0 && mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle("default"));
                cell.setCellValue(caption);
                if (j < splitColDesc.size()) {
                    HRListDataExportHelper.bindCellTip(sheet, cell, format.col + offset, titleRowIndex, (String)splitColDesc.get(j));
                }
                sheet.setColumnWidth(format.col + offset, ExportSXSSWbGenerateHelper.calcColumnWidth(caption, defaultColWidth));
                if (j == 0) {
                    HRListDataExportHelper.writeComment(wb, commentRow, format, styles, property, offset);
                }
                ++offset;
            }
        }
        return offset;
    }

    public static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (!StringUtils.isBlank((CharSequence)tip)) {
            SXSSFDrawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
            comment.setString((RichTextString)new XSSFRichTextString(tip));
            cell.setCellComment(comment);
        }
    }

    public static void createDropdownList(SXSSFSheet sheet, int currCol, List<String> items) {
        String currColLabel = HRListDataExportHelper.getColumnLabel(currCol + 1);
        String strFormula = String.format(Locale.ROOT, "dropdown_items_sheet!$%s$%d:$%s$%d", currColLabel, 1, currColLabel, items.size());
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(4, 10000, currCol, currCol);
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static CellStyle getColumnStyle(Object inputType, ExportSheetStyle styles, SXSSFWorkbook wb) {
        if ("date".equals(inputType)) {
            return styles.getDateStyle();
        }
        if ("datetime".equals(inputType)) {
            return styles.getDatetimeStyle();
        }
        if ("decimal".equals(inputType)) {
            return styles.getDecimalStyle(wb, (Map)null);
        }
        return styles.getTitleStyle();
    }

    public static int getDefaultColWidth(Object inputType) {
        if ("date".equals(inputType)) {
            return 60;
        }
        if ("datetime".equals(inputType)) {
            return 80;
        }
        return 0;
    }

    protected static SXSSFCell createCell(SXSSFWorkbook wb, SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    public static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportSheetStyle styles, ExportWriterFormat format, Map<Integer, String> propDisplayNames, int preOffset, boolean fillParent, List<Header> headers, boolean isMainEntityType) {
        SXSSFRow entityRow = HRListDataExportHelper.getRow((SXSSFSheet)sheet, (int)0);
        SXSSFRow commentRow = HRListDataExportHelper.getRow((SXSSFSheet)sheet, (int)1);
        SXSSFRow nameRow = HRListDataExportHelper.getRow((SXSSFSheet)sheet, (int)2);
        int titleRowIndex = fillParent ? 0 : 3;
        SXSSFRow titleRow = HRListDataExportHelper.getRow((SXSSFSheet)sheet, (int)titleRowIndex);
        String subEntityName = isMainEntityType ? null : format.name;
        CellStyle cellStyle = format.displayName != null && format.displayName.startsWith("*") ? styles.getTextHighLightStyle() : styles.getTitleStyle();
        HRListDataExportHelper.createCell(wb, entityRow, format.col + preOffset, cellStyle).setCellValue(format.displayName + " # " + format.name);
        int offset = preOffset;
        offset = HRListDataExportHelper.writeExcelHeader(wb, sheet, dropdownSheet, offset, commentRow, nameRow, titleRow, subEntityName, styles, format, propDisplayNames, titleRowIndex, fillParent, headers, isMainEntityType);
        List subExportWriterFormats = format.next;
        if (!CollectionUtils.isEmpty((Collection)subExportWriterFormats)) {
            for (ExportWriterFormat subExportWriterFormat : subExportWriterFormats) {
                offset += HRListDataExportHelper.writeHeader(wb, sheet, dropdownSheet, styles, subExportWriterFormat, propDisplayNames, preOffset, fillParent, headers, isMainEntityType);
            }
        }
        return offset;
    }

    private static int writeExcelHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, int offset, SXSSFRow commentRow, SXSSFRow nameRow, SXSSFRow titleRow, String subEntityName, ExportSheetStyle styles, ExportWriterFormat format, Map<Integer, String> propDisplayNames, int titleRowIndex, boolean fillParent, List<Header> headers, boolean isMainEntityType) {
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            boolean mustInput = false;
            Object inputType = null;
            int defaultColWidth = 0;
            if (property != null) {
                mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                inputType = property.get("InputType");
                if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                    offset = HRListDataExportHelper.splitColumn(wb, sheet, nameRow, titleRow, commentRow, styles, format, property, fieldName, offset, titleRowIndex, propDisplayNames, mustInput, fillParent, defaultColWidth, headers, subEntityName, inputType, isMainEntityType);
                    continue;
                }
                if (inputType instanceof JSONArray) {
                    HRListDataExportHelper.handleMulComboProp(inputType, property, format, offset, dropdownSheet, sheet);
                } else if (!"id".equals(inputType) && !"pid".equals(inputType)) {
                    CellStyle columnStyle = HRListDataExportHelper.getColumnStyle(inputType, styles, wb);
                    defaultColWidth = HRListDataExportHelper.getDefaultColWidth(inputType);
                    sheet.setDefaultColumnStyle(format.col + offset, columnStyle);
                } else {
                    fieldName = fieldName.replace('.', '_');
                }
                HRListDataExportHelper.writeComment(wb, commentRow, format, styles, property, offset);
            }
            offset = HRListDataExportHelper.createHeader(wb, sheet, mustInput, offset, property, nameRow, titleRow, subEntityName, styles, format, fieldName, defaultColWidth, titleRowIndex, fillParent, headers, inputType, isMainEntityType);
        }
        return offset;
    }

    private static int createHeader(SXSSFWorkbook wb, SXSSFSheet sheet, boolean mustInput, int offset, Map<String, Object> property, SXSSFRow nameRow, SXSSFRow titleRow, String subEntityName, ExportSheetStyle styles, ExportWriterFormat format, String fieldName, int defaultColWidth, int titleRowIndex, boolean fillParent, List<Header> headers, Object inputType, boolean isMainEntityType) {
        String caption = "";
        if (property != null) {
            caption = (mustInput ? "*" : "") + property.get("DisplayName");
        }
        if (!fillParent) {
            HRListDataExportHelper.createCell(wb, nameRow, format.col + offset, styles.getTitleStyle()).setCellValue(fieldName);
        }
        SXSSFCell cell = HRListDataExportHelper.createCell(wb, titleRow, format.col + offset, mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle("default"));
        cell.setCellValue(caption);
        sheet.setColumnWidth(format.col + offset, ExportSXSSWbGenerateHelper.calcColumnWidth(caption, defaultColWidth));
        if (property != null && property.containsKey("InputDesc")) {
            String tip = (String)property.getOrDefault("InputDesc", "");
            HRListDataExportHelper.bindCellTip(sheet, cell, format.col + offset, titleRowIndex, tip);
        }
        StringBuilder key = new StringBuilder();
        if (subEntityName != null) {
            key.append(subEntityName).append(".");
        }
        key.append(fieldName);
        if (inputType instanceof JSONArray) {
            HRListDataExportHelper.parseEnumHeader(inputType, key, headers, caption, format.name, isMainEntityType);
        } else {
            headers.add(new Header(key.toString(), caption, (String)inputType, format.name, isMainEntityType));
        }
        return ++offset;
    }

    private static void handleMulComboProp(Object inputType, Map<String, Object> property, ExportWriterFormat format, int offset, SXSSFSheet dropdownSheet, SXSSFSheet sheet) {
        ArrayList<String> items = new ArrayList<String>();
        ((JSONArray)inputType).forEach(obj -> items.add(obj.toString().split(" # ", -1)[0]));
        if (!items.isEmpty() && !"MulComboProp".equals(property.get("PropType"))) {
            int currCol = format.col + offset;
            for (int j = 0; j < items.size(); ++j) {
                HRListDataExportHelper.getRow((SXSSFSheet)dropdownSheet, (int)j).createCell(currCol).setCellValue((String)items.get(j));
            }
            HRListDataExportHelper.createDropdownList(sheet, currCol, items);
        }
    }

    private static void parseEnumHeader(Object inputType, StringBuilder key, List<Header> headers, String caption, String name, boolean isMainEntityType) {
        HashMap<String, String> keyValue = new HashMap<String, String>(3);
        JSONArray arrayInputType = (JSONArray)inputType;
        for (int i = 0; i < arrayInputType.size(); ++i) {
            String temp = (String)arrayInputType.get(i);
            String[] split = temp.split("#");
            if (split.length == 2) {
                keyValue.put(StringUtils.trim((String)split[1]), StringUtils.trim((String)split[0]));
                continue;
            }
            keyValue.put(i == 0 ? "1" : "0", StringUtils.trim((String)split[0]));
        }
        Header header = new Header(key.toString(), caption, "JSONArray", name, isMainEntityType);
        header.setKeyValues(keyValue);
        headers.add(header);
    }
}

