/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.export;

import com.google.common.collect.Table;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.hr.hbp.business.export.ExportSXSSWbGenerateHelper;
import kd.hr.hbp.business.export.HRListDataExportHelper;
import kd.hr.hbp.business.export.Header;
import kd.hr.hbp.business.export.MultiLangHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class HRListDataExporter
extends ExcelWriter {
    private SXSSFSheet sheet;
    private SXSSFSheet dropdownSheet;
    private ExportSheetStyle styles;
    private int headerOffset = 0;

    public HRListDataExporter(String sheetName, List<ExportWriterFormat> formats, boolean fillParent, List<Header> headers) {
        int dropdownItemsSheetIndex;
        this.wb = new SXSSFWorkbook(5000);
        this.wb.setCompressTempFiles(true);
        this.styles = new ExportSheetStyle(this.wb);
        this.sheet = this.wb.createSheet(sheetName);
        this.dropdownSheet = this.wb.createSheet("dropdown_items_sheet");
        HashMap<Integer, String> propDisplayNames = new HashMap<Integer, String>();
        boolean isMainEntityType = true;
        for (ExportWriterFormat writerFormat : formats) {
            this.headerOffset = HRListDataExportHelper.writeHeader(this.wb, this.sheet, this.dropdownSheet, this.styles, writerFormat, propDisplayNames, this.headerOffset, fillParent, headers, isMainEntityType);
            isMainEntityType = false;
        }
        if (this.styles.getEntities() == null || this.styles.getFieldnames() == null) {
            this.styles.reference(HRListDataExporter.getRow((SXSSFSheet)this.sheet, (int)(fillParent ? 2 : 0)), HRListDataExporter.getRow((SXSSFSheet)this.sheet, (int)(fillParent ? 0 : 2)));
        }
        if ((dropdownItemsSheetIndex = this.wb.getSheetIndex("dropdown_items_sheet")) >= 0) {
            this.wb.setSheetHidden(dropdownItemsSheetIndex, true);
        }
        if (fillParent) {
            this.sheet.removeRow((Row)this.sheet.getRow(1));
            this.sheet.removeRow((Row)this.sheet.getRow(2));
        }
    }

    public int createData(List<Header> headers, DynamicObjectCollection data, Set<String> canNotReadFields, int startIndex, Table<String, Long, DynamicObject> langResultTable) {
        for (int i = 0; i < data.size(); ++i) {
            SXSSFRow row = this.sheet.createRow(startIndex + i);
            int columnIndex = 0;
            for (Header header : headers) {
                DynamicObject exportData = null;
                if ("multilang".equals(header.getInputType())) {
                    String idKey = header.getName() + "." + "id";
                    exportData = (DynamicObject)langResultTable.get((Object)header.getName(), ((DynamicObject)data.get(i)).get(idKey));
                } else {
                    exportData = (DynamicObject)data.get(i);
                }
                this.writeData(header, exportData, columnIndex, canNotReadFields, (Row)row);
                ++columnIndex;
            }
        }
        return startIndex + data.size();
    }

    private void writeData(Header header, DynamicObject exportData, int columnIndex, Set<String> canNotReadFields, Row row) {
        String headerKey = header.getKey();
        String value = null;
        if ("multilang".equals(header.getInputType())) {
            OrmLocaleValue ormLocaleValue;
            String headerKeyProp = MultiLangHelper.getLangKeyProp(headerKey);
            if (Objects.nonNull(exportData) && Objects.nonNull(exportData.get(headerKeyProp)) && Objects.nonNull(ormLocaleValue = (OrmLocaleValue)exportData.get(headerKeyProp))) {
                value = ormLocaleValue.get((Object)MultiLangHelper.getLangTag(headerKey));
            }
        } else {
            value = Objects.isNull(exportData) ? "" : exportData.get(headerKey);
        }
        Cell cell = row.createCell(columnIndex);
        this.dealViewRight(header, canNotReadFields, value, cell);
    }

    private void dealViewRight(Header header, Set<String> canNotReadFields, Object value, Cell cell) {
        boolean viewRight = MultiLangHelper.isViewRight(header, canNotReadFields, cell);
        if (viewRight) {
            if (header.getKeyValues() != null) {
                if (value instanceof Boolean) {
                    value = value == Boolean.TRUE ? "1" : "0";
                }
                value = header.getKeyValues().get(value);
            }
            ExportSXSSWbGenerateHelper.writeValue(cell, value, header.getInputType(), this.styles.getTextStyle());
        }
    }

    /*
     * Exception decompiling
     */
    public String writeFile(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

