/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.flow.job;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.upgrade.ClassManager;
import kd.hr.hbp.business.flow.helper.FlowJobHelper;
import kd.hr.hbp.business.flow.job.HRFlowJobRequest;
import kd.hr.hbp.business.flow.job.HRFlowJobResponse;
import kd.hr.hbp.business.flow.job.IHRFlowJobHandler;
import kd.hr.hbp.business.flow.job.service.HRJobServiceRequest;
import kd.hr.hbp.business.flow.job.service.HRJobServiceResult;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.flow.FlowJobStatusEnum;
import kd.hr.hbp.common.constants.flow.ServiceResultModeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRFlowJobHandler
implements IHRFlowJobHandler {
    private static final Pattern IS_NUMBER = Pattern.compile("-?\\d+(\\.\\d+)?");
    private DynamicObject job;
    private RequestContext context;
    private DynamicObject jobAction;
    private long jobId;

    public HRFlowJobHandler() {
    }

    public HRFlowJobHandler(DynamicObject job, RequestContext context) {
        if (Objects.isNull(job)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e1a\u5b9e\u4f8b\u52a8\u6001\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRFlowJobHandler_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        this.job = job;
        this.context = context;
        this.jobId = job.getLong("id");
    }

    @Override
    public void setJob(DynamicObject job, RequestContext context) {
        if (Objects.isNull(job)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e1a\u5b9e\u4f8b\u52a8\u6001\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRFlowJobHandler_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        this.job = job;
        this.context = context;
        this.jobId = job.getLong("id");
    }

    @Override
    public void beforeExecute(HRFlowJobRequest rq) throws KDException {
        if (Objects.isNull(this.job)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e1a\u5b9e\u4f8b\u52a8\u6001\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRFlowJobHandler_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        this.updateJobStatus(FlowJobStatusEnum.STATUS_RUNNING.getStatus(), false, null);
        this.checkRequestParam(rq);
    }

    @Override
    public HRFlowJobResponse execute(HRFlowJobRequest rq) throws KDException {
        try {
            this.beforeExecute(rq);
            DynamicObject sysAbility = this.jobAction.getDynamicObject("syscapability");
            String capAbilityType = sysAbility.getString("capabilitytype");
            HRJobServiceResult result = "1".equals(capAbilityType) ? this.invokePluginMethod(rq, sysAbility, "executeService") : this.invokeBizService(rq, sysAbility, "executeService");
            return this.afterExecute(this.getHrFlowJobResponse(result));
        }
        catch (Exception exception) {
            String errorMsg = MessageFormat.format("execute_job_error_jobId_is:{0}_error_is:{1}", this.jobId, CommonUtil.getStackTrace((Exception)exception));
            this.updateJobStatus(FlowJobStatusEnum.STATUS_RUN_FAIL.getStatus(), true, errorMsg);
            return HRFlowJobResponse.fail(errorMsg, ServiceResultModeEnum.MODE_SYN);
        }
    }

    @Override
    public HRFlowJobResponse afterExecute(HRFlowJobResponse response) throws KDException {
        try {
            this.updateJobStatus(response.getJobStatus().getStatus(), true, response.getMessage());
            return response;
        }
        catch (Exception exception) {
            String errorMsg = MessageFormat.format("afterExecute_job_error_jobId_is:{0}_error_is:{1}", this.jobId, CommonUtil.getStackTrace((Exception)exception));
            this.updateJobStatus(FlowJobStatusEnum.STATUS_RUN_FAIL.getStatus(), true, errorMsg);
            return HRFlowJobResponse.fail(errorMsg, ServiceResultModeEnum.MODE_SYN);
        }
    }

    @Override
    public HRFlowJobResponse query(HRFlowJobRequest rq) throws KDException {
        this.checkRequestParam(rq);
        DynamicObject sysAbility = this.jobAction.getDynamicObject("syscapability");
        HRJobServiceResult result = this.invokeBizService(rq, sysAbility, "query");
        return this.getHrFlowJobResponse(result);
    }

    private HRJobServiceRequest buildRequest(HRFlowJobRequest rq) {
        HRJobServiceRequest request = new HRJobServiceRequest();
        request.setRootFlowId(String.valueOf(this.job.get("rootjobflowinsid")));
        request.setJobId(String.valueOf(this.job.get("id")));
        request.setJobInsMetaNumber(this.job.getDataEntityType().getName());
        request.setRequestData(new HashMap<String, Object>(rq.getRequestData()));
        return request;
    }

    private void checkInParam(DynamicObject action, HRFlowJobRequest rq) {
        IDataEntityType dataEntityType = action.getDataEntityType();
        IDataEntityProperty sysAbilityProp = (IDataEntityProperty)dataEntityType.getProperties().get((Object)"syscapability");
        DynamicObject sysAbility = action.getDynamicObject(sysAbilityProp);
        if (Objects.isNull(sysAbility)) {
            IDataEntityProperty actionTypeProp = (IDataEntityProperty)dataEntityType.getProperties().get((Object)"actiontype");
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u5bf9\u5e94\u7684{2}\u4e3a\u7a7a", (String)"HRFlowJobHandler_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), actionTypeProp.getDisplayName().getLocaleValue(), action.getString(actionTypeProp), sysAbilityProp.getDisplayName().getLocaleValue()));
        }
        this.checkDynamicPropIsNull("bizcloud", sysAbility);
        this.checkDynamicPropIsNull("bizapp", sysAbility);
        this.checkDynamicPropIsNull("capabilitytype", sysAbility);
        this.checkDynamicPropIsNull("serviceorpluginname", sysAbility);
        DynamicObjectCollection inParams = action.getDynamicObjectCollection("inparam");
        Map<String, Object> requestData = rq.getRequestData();
        DynamicObjectType inParamsDyObjType = inParams.getDynamicObjectType();
        DynamicProperty inParamProp = inParamsDyObjType.getProperty("inparamname");
        for (DynamicObject inParam : inParams) {
            String paramName = inParam.getString((IDataEntityProperty)inParamProp);
            String isMust = inParam.getString("inismust");
            Object value = requestData.get(paramName);
            if (HRStringUtils.equals((String)"1", (String)isMust)) {
                if (Objects.isNull(value) || HRStringUtils.isEmpty((String)String.valueOf(value))) {
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{0}]\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRFlowJobHandler_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamProp.getDisplayName().getLocaleValue(), paramName));
                }
            } else if (Objects.isNull(value) || HRStringUtils.isEmpty((String)String.valueOf(value))) continue;
            this.checkParamType(inParam, paramName, value);
        }
    }

    private void checkParamType(DynamicObject inParam, String paramName, Object value) {
        String paramType;
        if (Objects.isNull(value)) {
            return;
        }
        DataEntityPropertyCollection properties = inParam.getDataEntityType().getProperties();
        IDataEntityProperty inParamNameProp = (IDataEntityProperty)properties.get((Object)"inparamname");
        IDataEntityProperty inParamTypeProp = (IDataEntityProperty)properties.get((Object)"inparamtype");
        switch (paramType = inParam.getString(inParamTypeProp)) {
            case "bizObject": {
                DynamicObject metaDy = inParam.getDynamicObject("inparambizobject");
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDy.getString("number"));
                ISimpleProperty primaryKey = mainEntityType.getPrimaryKey();
                if (value instanceof DynamicObject) {
                    String objectMetaName = ((DynamicObject)value).getDataEntityType().getName();
                    if (mainEntityType.getName().equals(objectMetaName)) break;
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u9700\u8981[{2}]\u7684\u5143\u6570\u636e\u52a8\u6001\u5bf9\u8c61,\u800c\u4e0d\u662f[{2}]\u7684\u5143\u6570\u636e\u52a8\u6001\u5bf9\u8c61", (String)"HRFlowJobHandler_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName, mainEntityType.getName(), objectMetaName));
                }
                if (value instanceof Long) {
                    if (primaryKey instanceof LongProp) break;
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u4e0d\u80fd\u4e3a\u957f\u6574\u6570", (String)"HRFlowJobHandler_4", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
                }
                if (value instanceof String) {
                    if (primaryKey instanceof VarcharProp) break;
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u4e0d\u80fd\u4e3a\u5b57\u7b26\u4e32", (String)"HRFlowJobHandler_5", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
                }
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u4e3a\u52a8\u6001\u5bf9\u8c61\u6216\u5bf9\u5e94\u4e3b\u952e\u7c7b\u578b\u7684\u503c", (String)"HRFlowJobHandler_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName, inParamTypeProp.getDisplayName().getLocaleValue()));
            }
            case "date": {
                if (value instanceof String) {
                    try {
                        HRDateTimeUtils.parseDate((String)String.valueOf(value));
                        break;
                    }
                    catch (ParseException e) {
                        throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u9700\u8981\u7684\u503c\u7c7b\u578b\u4e3a\u65e5\u671f,\u5b57\u7b26\u4e32\u503c\u8f6c\u6362\u65e5\u671f\u5931\u8d25", (String)"HRFlowJobHandler_7", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
                    }
                }
                if (value instanceof Date) break;
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u65e5\u671f\u7c7b\u578b\u7684\u503c", (String)"HRFlowJobHandler_8", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
            }
            case "number": {
                if (!(value instanceof String ? !IS_NUMBER.matcher(String.valueOf(value)).matches() : !(value instanceof Number))) break;
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u6570\u503c\u7c7b\u578b\u7684\u503c", (String)"HRFlowJobHandler_9", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
            }
            case "boolean": {
                if (value instanceof String) {
                    String booleanValue;
                    String string = "1".equals(value) ? "true" : (booleanValue = "0".equals(value) ? "false" : String.valueOf(value));
                    if ("true".equals(booleanValue) || "false".equals(booleanValue)) break;
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u5e03\u5c14\u7c7b\u578b\u7684\u503c", (String)"HRFlowJobHandler_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
                }
                if (value instanceof Boolean) break;
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u5e03\u5c14\u7c7b\u578b\u7684\u503c", (String)"HRFlowJobHandler_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
            }
            default: {
                if (value instanceof String) break;
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}[{1}]\u4f20\u5165\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u503c", (String)"HRFlowJobHandler_11", (String)"hrmp-hbp-business", (Object[])new Object[0]), inParamNameProp.getDisplayName().getLocaleValue(), paramName));
            }
        }
    }

    private void checkDynamicPropIsNull(String propertyName, DynamicObject dy) {
        IDataEntityType dataEntityType;
        IDataEntityProperty entityProperty;
        if (Objects.isNull(dy) || HRStringUtils.isEmpty((String)propertyName)) {
            return;
        }
        String property = propertyName;
        if (propertyName.contains(".")) {
            property = propertyName.split("//.")[0];
        }
        if (Objects.isNull(entityProperty = (IDataEntityProperty)(dataEntityType = dy.getDataEntityType()).getProperties().get((Object)property))) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[{0}]\u4e0d\u5b58\u5728\u5b57\u6bb5[{1}]", (String)"HRFlowJobHandler_12", (String)"hrmp-hbp-business", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), property));
        }
        if (entityProperty instanceof EntryProp) {
            DynamicObjectCollection entryDys = dy.getDynamicObjectCollection(entityProperty);
            for (DynamicObject entry : entryDys) {
                this.checkDynamicPropIsNull(propertyName.replace(property + ".", ""), entry);
            }
        } else if (entityProperty instanceof BasedataProp) {
            DynamicObject baseDataDy = dy.getDynamicObject(entityProperty);
            if (Objects.isNull(baseDataDy)) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u5b57\u6bb5[{1}]\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRFlowJobHandler_13", (String)"hrmp-hbp-business", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), propertyName));
            }
            if (HRStringUtils.isEmpty((String)propertyName.replace(property, ""))) {
                return;
            }
            this.checkDynamicPropIsNull(propertyName.replace(property + ".", ""), baseDataDy);
        } else {
            boolean isNull = entityProperty instanceof LongProp ? dy.getLong(entityProperty) == 0L : (entityProperty instanceof VarcharProp ? HRStringUtils.isEmpty((String)dy.getString(entityProperty)) : Objects.isNull(dy.get(entityProperty)));
            if (isNull) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u5b57\u6bb5[{1}]\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRFlowJobHandler_13", (String)"hrmp-hbp-business", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), property));
            }
        }
    }

    public DynamicObject getJob() {
        return this.job;
    }

    public RequestContext getContext() {
        return this.context;
    }

    private HRFlowJobResponse getHrFlowJobResponse(HRJobServiceResult result) {
        HRFlowJobResponse response;
        if (Objects.isNull(result)) {
            response = HRFlowJobResponse.empty();
        } else {
            response = new HRFlowJobResponse(result.getReturnData(), result.getReturnCode(), result.getMessage(), result.getServiceMode());
            if (result.isSuccess()) {
                if (result.isEnd()) {
                    response.setJobStatus(FlowJobStatusEnum.STATUS_RUN_SUCCESS);
                } else {
                    response.setJobStatus(FlowJobStatusEnum.STATUS_RUNNING);
                }
            } else {
                response.setJobStatus(FlowJobStatusEnum.STATUS_RUN_FAIL);
            }
        }
        return response;
    }

    private HRJobServiceResult invokePluginMethod(HRFlowJobRequest rq, DynamicObject sysAbility, String pluginMethod) {
        String pluginPath = sysAbility.getString("serviceorpluginname");
        try {
            Class clazz = ClassManager.forName((String)pluginPath);
            Object pluginObj = clazz.newInstance();
            Method method = clazz.getMethod(pluginMethod, HRJobServiceRequest.class);
            HRJobServiceRequest request = this.buildRequest(rq);
            return (HRJobServiceResult)method.invoke(pluginObj, request);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8def\u5f84[{0}]class\u5bf9\u8c61\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25", (String)"HRFlowJobHandler_14", (String)"hrmp-hbp-business", (Object[])new Object[0]), pluginPath));
        }
        catch (NoSuchMethodException e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8def\u5f84[{0}]class\u5bf9\u8c61\u83b7\u53d6\u63d2\u4ef6\u65b9\u6cd5[{1}]\u5bf9\u8c61\u5931\u8d25", (String)"HRFlowJobHandler_15", (String)"hrmp-hbp-business", (Object[])new Object[0]), pluginPath, pluginMethod));
        }
        catch (InvocationTargetException e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8def\u5f84[{0}]class\u5bf9\u8c61\u6267\u884c\u63d2\u4ef6\u65b9\u6cd5[{1}]\u5931\u8d25", (String)"HRFlowJobHandler_16", (String)"hrmp-hbp-business", (Object[])new Object[0]), pluginPath, pluginMethod));
        }
    }

    private HRJobServiceResult invokeBizService(HRFlowJobRequest rq, DynamicObject sysAbility, String serviceMethod) {
        String cloudNumber = sysAbility.getDynamicObject("bizcloud").getString("number").toLowerCase(Locale.ROOT);
        String appNumber = sysAbility.getDynamicObject("bizapp").getString("number").toLowerCase(Locale.ROOT);
        String serviceName = sysAbility.getString("serviceorpluginname");
        HRJobServiceRequest request = this.buildRequest(rq);
        return (HRJobServiceResult)HRMServiceHelper.invokeBizService(cloudNumber, appNumber, serviceName, serviceMethod, request);
    }

    private void checkRequestParam(HRFlowJobRequest rq) {
        List<DynamicObject> dys;
        if (Objects.isNull(rq)) {
            throw new KDBizException(ResManager.loadKDString((String)"HRFlowJobRequest\u4e3a\u7a7a", (String)"HRFlowJobHandler_17", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String jobActionType = rq.getJobActionType();
        Long flowJobEntryId = rq.getFlowJobEntryId();
        if (HRStringUtils.isEmpty((String)jobActionType) && Objects.isNull(flowJobEntryId)) {
            throw new KDBizException(ResManager.loadKDString((String)"[jobActionType]\u6216[flowJobEntryId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a", (String)"HRFlowJobHandler_18", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        this.checkDynamicPropIsNull("id", this.job);
        this.checkDynamicPropIsNull("curjobflowinsid", this.job);
        DynamicObjectCollection jobActionDys = this.job.getDynamicObjectCollection("jobaction");
        Map<String, List<DynamicObject>> actionTypeToJobActionDyMap = jobActionDys.stream().collect(Collectors.groupingBy(dy -> dy.getString("actiontype")));
        Map<Long, List<DynamicObject>> idToJobActionDyMap = jobActionDys.stream().collect(Collectors.groupingBy(dy -> dy.getLong("id")));
        if (HRStringUtils.isNotEmpty((String)jobActionType)) {
            dys = actionTypeToJobActionDyMap.get(jobActionType);
            if (Objects.nonNull(dys) && dys.size() > 0) {
                this.jobAction = dys.get(0);
            }
        } else if (Objects.nonNull(flowJobEntryId) && Objects.nonNull(dys = idToJobActionDyMap.get(flowJobEntryId)) && dys.size() > 0) {
            this.jobAction = dys.get(0);
        }
        if (Objects.isNull(this.jobAction)) {
            DynamicProperty actionTypeProp = jobActionDys.getDynamicObjectType().getProperty("actiontype");
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6839\u636e[{0}]\u6216\u5206\u5f55\u884cid\u83b7\u53d6\u5bf9\u5e94\u7684\u5206\u5f55\u52a8\u6001\u5bf9\u8c61\u4e3a\u7a7a", (String)"HRFlowJobHandler_19", (String)"hrmp-hbp-business", (Object[])new Object[0]), actionTypeProp.getDisplayName().getLocaleValue()));
        }
        this.checkInParam(this.jobAction, rq);
    }

    private void updateJobStatus(String jobStatus, boolean isEnd, String errorMsg) {
        if (Objects.nonNull(this.job)) {
            this.job.set("jobstatus", (Object)jobStatus);
            if (isEnd) {
                this.job.set("endtime", (Object)new Date());
            } else {
                this.job.set("starttime", (Object)new Date());
            }
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                LargeTextProp property = (LargeTextProp)this.job.getDataEntityType().getProperties().get((Object)"errormsg");
                int maxLength = property.getMaxLength();
                this.job.set("errormsg", (Object)errorMsg.substring(0, Math.min(errorMsg.length(), maxLength)));
                this.job.set("errormsg_tag", (Object)errorMsg);
            }
            FlowJobHelper.updateFlowJobStatus(this.job);
        }
    }
}

